'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    cardCSSVars: function() {
        return cardCSSVars;
    },
    cardClassNames: function() {
        return cardClassNames;
    },
    useCardStyles_unstable: function() {
        return useCardStyles_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _react1 = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const cardClassNames = {
    root: 'fui-Card',
    floatingAction: 'fui-Card__floatingAction',
    checkbox: 'fui-Card__checkbox'
};
const cardCSSVars = {
    cardSizeVar: '--fui-Card--size',
    cardBorderRadiusVar: '--fui-Card--border-radius'
};
const focusOutlineStyle = {
    outlineRadius: `var(${cardCSSVars.cardBorderRadiusVar})`,
    outlineWidth: _reacttheme.tokens.strokeWidthThick,
    outlineOffset: '-2px'
};
const useCardResetStyles = /*#__PURE__*/ (0, _react1.__resetStyles)("rfxo2k2", "rgle7w9", [
    ".rfxo2k2{overflow:hidden;border-radius:var(--fui-Card--border-radius);padding:var(--fui-Card--size);gap:var(--fui-Card--size);display:flex;position:relative;box-sizing:border-box;color:var(--colorNeutralForeground1);}",
    ".rfxo2k2::after{position:absolute;top:0;left:0;right:0;bottom:0;content:\"\";pointer-events:none;border-top-style:solid;border-right-style:solid;border-bottom-style:solid;border-left-style:solid;border-top-width:var(--strokeWidthThin);border-right-width:var(--strokeWidthThin);border-bottom-width:var(--strokeWidthThin);border-left-width:var(--strokeWidthThin);border-radius:var(--fui-Card--border-radius);}",
    ".rfxo2k2>.fui-CardHeader,.rfxo2k2>.fui-CardFooter{flex-shrink:0;}",
    ".rgle7w9{overflow:hidden;border-radius:var(--fui-Card--border-radius);padding:var(--fui-Card--size);gap:var(--fui-Card--size);display:flex;position:relative;box-sizing:border-box;color:var(--colorNeutralForeground1);}",
    ".rgle7w9::after{position:absolute;top:0;right:0;left:0;bottom:0;content:\"\";pointer-events:none;border-top-style:solid;border-left-style:solid;border-bottom-style:solid;border-right-style:solid;border-top-width:var(--strokeWidthThin);border-left-width:var(--strokeWidthThin);border-bottom-width:var(--strokeWidthThin);border-right-width:var(--strokeWidthThin);border-radius:var(--fui-Card--border-radius);}",
    ".rgle7w9>.fui-CardHeader,.rgle7w9>.fui-CardFooter{flex-shrink:0;}"
]);
const disabledStyles = {
    cursor: 'not-allowed',
    userSelect: 'none',
    color: _reacttheme.tokens.colorNeutralForegroundDisabled,
    backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
    boxShadow: _reacttheme.tokens.shadow2,
    .../*#__PURE__*/ _react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
    '::before': {
        content: '""',
        position: 'absolute',
        inset: 0,
        zIndex: `calc(${_reacttheme.tokens.zIndexContent} + 1)`
    },
    '::after': {
        .../*#__PURE__*/ _react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
    }
};
const useCardStyles = /*#__PURE__*/ (0, _react1.__styles)({
    focused: {
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        B8q5s1w: "f8hki3x",
        Bci5o5g: [
            "f1d2448m",
            "ffh67wi"
        ],
        n8qw10: "f1bjia2o",
        Bdrgwmp: [
            "ffh67wi",
            "f1d2448m"
        ],
        Bb7d1vk: "f226i61",
        zhwhgb: [
            "f13kzufm",
            "fsx75g8"
        ],
        dhy2o1: "flujwa2",
        Gfyso: [
            "fsx75g8",
            "f13kzufm"
        ],
        Bm4h7ae: "f15bsgw9",
        B7ys5i9: "f14e48fq",
        Busjfv9: "f18yb2kv",
        Bhk32uz: "fd6o370",
        f6g5ot: 0,
        Boxcth7: 0,
        Bhdgwq3: 0,
        hgwjuy: 0,
        Bshpdp8: 0,
        Bsom6fd: 0,
        Blkhhs4: 0,
        Bonggc9: 0,
        Ddfuxk: 0,
        i03rao: 0,
        kclons: 0,
        clg4pj: 0,
        Bpqj9nj: 0,
        B6dhp37: 0,
        Bf4ptjt: 0,
        Bqtpl0w: 0,
        i4rwgc: "fpqizxz",
        Dah5zi: 0,
        B1tsrr9: 0,
        qqdqy8: 0,
        Bkh64rk: 0,
        e3fwne: "fnd8nzh",
        J0r882: "f15fr7a0",
        Bule8hv: [
            "fwsq40z",
            "fy0y4wt"
        ],
        Bjwuhne: "f34ld9f",
        Ghsupd: [
            "fy0y4wt",
            "fwsq40z"
        ]
    },
    selectableFocused: {
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        Bssx7fj: "f1b1k54r",
        uh7if5: [
            "f4ne723",
            "fqqcjud"
        ],
        clntm0: "fh7aioi",
        Dlk2r6: [
            "fqqcjud",
            "f4ne723"
        ],
        Bm3wd5j: "f1k55ka9",
        Bbrhkcr: [
            "fgclinu",
            "f16pcs8n"
        ],
        f1oku: "fycbxed",
        aywvf2: [
            "f16pcs8n",
            "fgclinu"
        ],
        B2j2mmj: "ffht0p2",
        wigs8: "f1p0ul1q",
        pbfy6t: "f1c901ms",
        B0v4ure: "f1alokd7",
        Byrf0fs: 0,
        Bsiemmq: 0,
        Bwckmig: 0,
        skfxo0: 0,
        Iidy0u: 0,
        B98u21t: 0,
        Bvwlmkc: 0,
        jo1ztg: 0,
        Ba1iezr: 0,
        Blmvk6g: 0,
        B24cy0v: 0,
        Bil7v7r: 0,
        Br3gin4: 0,
        nr063g: 0,
        ghq09: 0,
        Bbgo44z: 0,
        Bseh09z: "f1i978nd",
        az1dzo: 0,
        Ba3ybja: 0,
        B6352mv: 0,
        vppk2z: 0,
        Biaj6j7: "f1nh8hsq",
        B2pnrqr: "f1amxum7",
        B29w5g4: [
            "f1cec8w7",
            "f554mv0"
        ],
        Bhhzhcn: "f1sj6kbr",
        Bec0n69: [
            "f554mv0",
            "f1cec8w7"
        ]
    },
    orientationHorizontal: {
        Beiy3e4: "f1063pyq",
        Bt984gj: "f122n59",
        Binpb3b: "ftrw7vg",
        qrt8p2: "f18opajm",
        k6ws3r: [
            "f13002it",
            "fqo182t"
        ],
        Btcwela: [
            "f18yna97",
            "f1kd6wh7"
        ],
        Fer9m8: "f4i4759"
    },
    orientationVertical: {
        Beiy3e4: "f1vx9l62",
        B5nvv7i: [
            "f14k419y",
            "f1fgo9fz"
        ],
        Baxg94k: [
            "f1fgo9fz",
            "f14k419y"
        ],
        tn21ii: "fvqmfsm",
        B0ud6bj: "f3am6yf",
        Bgdo4j: "f1r5wgso"
    },
    sizeSmall: {
        B7balbw: "f1pi9uxy",
        B1h88n7: "f1h1zgly"
    },
    sizeMedium: {
        B7balbw: "frsmuga",
        B1h88n7: "fuldkky"
    },
    sizeLarge: {
        B7balbw: "f1qua4xo",
        B1h88n7: "fimkt6v"
    },
    interactive: {
        rhjd8f: "f1epqm3e"
    },
    filled: {
        De3pzq: "fxugw4r",
        E5pizo: "f1whvlc6",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ]
    },
    filledInteractive: {
        Bceei9c: "f1k6fduh",
        De3pzq: "fxugw4r",
        E5pizo: "f1whvlc6",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ],
        Bi91k9c: "feu1g3u",
        Jwef8y: "f1knas48",
        Bvxd0ez: "f1m145df",
        ecr2s2: "fb40n2d"
    },
    filledInteractiveSelected: {
        De3pzq: "f1nfm20t",
        B0n5ga8: "f16eln5f",
        s924m2: [
            "fa2okxs",
            "fg4zq3l"
        ],
        B1q35kw: "ff6932p",
        Gp14am: [
            "fg4zq3l",
            "fa2okxs"
        ],
        Bi91k9c: "fx9teim",
        Jwef8y: "f1kz6goq"
    },
    filledAlternative: {
        De3pzq: "f1dmdbja",
        E5pizo: "f1whvlc6",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ]
    },
    filledAlternativeInteractive: {
        Bceei9c: "f1k6fduh",
        De3pzq: "f1dmdbja",
        E5pizo: "f1whvlc6",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ],
        Bi91k9c: "fnwyq0v",
        Jwef8y: "f1uvynv3",
        Bvxd0ez: "f1m145df",
        ecr2s2: "f1yhgkbh"
    },
    filledAlternativeInteractiveSelected: {
        De3pzq: "fjxa0vh",
        B0n5ga8: "f16eln5f",
        s924m2: [
            "fa2okxs",
            "fg4zq3l"
        ],
        B1q35kw: "ff6932p",
        Gp14am: [
            "fg4zq3l",
            "fa2okxs"
        ],
        Bi91k9c: "f1luvkty",
        Jwef8y: "fehi0vp"
    },
    outline: {
        De3pzq: "f1c21dwh",
        E5pizo: "f1couhl3",
        B0n5ga8: "ft83z1f",
        s924m2: [
            "f1g4150c",
            "f192dr6e"
        ],
        B1q35kw: "f1qnawh6",
        Gp14am: [
            "f192dr6e",
            "f1g4150c"
        ]
    },
    outlineInteractive: {
        Bceei9c: "f1k6fduh",
        De3pzq: "f1c21dwh",
        E5pizo: "f1couhl3",
        B0n5ga8: "ft83z1f",
        s924m2: [
            "f1g4150c",
            "f192dr6e"
        ],
        B1q35kw: "f1qnawh6",
        Gp14am: [
            "f192dr6e",
            "f1g4150c"
        ],
        Bi91k9c: "feu1g3u",
        Jwef8y: "fjxutwb",
        Be0v6ae: "f1llr77y",
        B5kxglz: [
            "fzk0khw",
            "fjj8tog"
        ],
        B3pwyw6: "fb1u8ub",
        Bymgtzf: [
            "fjj8tog",
            "fzk0khw"
        ],
        ecr2s2: "fophhak",
        dmfk: "f1uohb70",
        B4ofi8: [
            "f1jm7v1n",
            "f1bus3rq"
        ],
        jgq6uv: "f1fbu7rr",
        Baxewws: [
            "f1bus3rq",
            "f1jm7v1n"
        ]
    },
    outlineInteractiveSelected: {
        De3pzq: "f1q9pm1r",
        B0n5ga8: "f16eln5f",
        s924m2: [
            "fa2okxs",
            "fg4zq3l"
        ],
        B1q35kw: "ff6932p",
        Gp14am: [
            "fg4zq3l",
            "fa2okxs"
        ],
        Bi91k9c: "fx9teim",
        Jwef8y: "fg59vm4"
    },
    outlineDisabled: {
        De3pzq: "f1c21dwh",
        E5pizo: "f1couhl3",
        g2u3we: "f1jj8ep1",
        h3c5rm: [
            "f15xbau",
            "fy0fskl"
        ],
        B9xav0g: "f4ikngz",
        zhjwy3: [
            "fy0fskl",
            "f15xbau"
        ],
        ezxybo: "f1ls5moo",
        wc7uws: "f1qiza15",
        B0n5ga8: "f13dj02",
        s924m2: [
            "f9wngki",
            "f17v59j0"
        ],
        B1q35kw: "f1vxzwsp",
        Gp14am: [
            "f17v59j0",
            "f9wngki"
        ]
    },
    subtle: {
        De3pzq: "fhovq9v",
        E5pizo: "f1couhl3",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ]
    },
    subtleInteractive: {
        Bceei9c: "f1k6fduh",
        De3pzq: "fhovq9v",
        E5pizo: "f1couhl3",
        B0n5ga8: "f16gxe2i",
        s924m2: [
            "fpgykix",
            "fzybk4o"
        ],
        B1q35kw: "f1osi826",
        Gp14am: [
            "fzybk4o",
            "fpgykix"
        ],
        Bi91k9c: "feu1g3u",
        Jwef8y: "f1t94bn6",
        ecr2s2: "f1wfn5kd"
    },
    subtleInteractiveSelected: {
        De3pzq: "fq5gl1p",
        B0n5ga8: "f16eln5f",
        s924m2: [
            "fa2okxs",
            "fg4zq3l"
        ],
        B1q35kw: "ff6932p",
        Gp14am: [
            "fg4zq3l",
            "fa2okxs"
        ],
        Bi91k9c: "fx9teim",
        Jwef8y: "f1uqaxdt"
    },
    highContrastSelected: {
        ycbfsm: "fkc42ay",
        Bsw6fvg: "f1rirnrt",
        Bbusuzp: "f1lkg8j3",
        xgfqdd: "f1nkj0oa",
        Bmmdzwq: "fey3rwa",
        zkpvhj: [
            "f5jhx11",
            "fff9uym"
        ],
        B20bydw: "fm7n0jy",
        Bwwwggl: [
            "fff9uym",
            "f5jhx11"
        ]
    },
    highContrastInteractive: {
        h1vhog: "fpfvv3l",
        kslmdy: "f1oamsm6",
        Baaf6ca: "f1il21bs",
        x9zz3d: "fnn5dk0",
        Bmmdzwq: "fey3rwa",
        zkpvhj: [
            "f5jhx11",
            "fff9uym"
        ],
        B20bydw: "fm7n0jy",
        Bwwwggl: [
            "fff9uym",
            "f5jhx11"
        ]
    },
    select: {
        qhf8xq: "f1euv43f",
        Bhzewxz: "fqclxi7",
        j35jbq: [
            "fiv86kb",
            "f36uhnt"
        ],
        Bj3rh1h: "fom9my7"
    },
    hiddenCheckbox: {
        B68tc82: 0,
        Bmxbyg5: 0,
        Bpg54ce: "f1a3p1vp",
        a9b677: "frkrog8",
        Bqenvij: "f1mpe4l3",
        qhf8xq: "f1euv43f",
        Bh84pgu: "fmf1zke",
        Bgl5zvf: "f1wch0ki",
        Huce71: "fz5stix"
    },
    disabled: {
        Bceei9c: "fdrzuqr",
        famaaq: "f1xqy1su",
        sj55zd: "f1s2aq7o",
        De3pzq: "f1bg9a2p",
        E5pizo: "fyed02w",
        g2u3we: "f1jj8ep1",
        h3c5rm: [
            "f15xbau",
            "fy0fskl"
        ],
        B9xav0g: "f4ikngz",
        zhjwy3: [
            "fy0fskl",
            "f15xbau"
        ],
        Ftih45: "f1wl9k8s",
        Brfgrao: "f1j7ml58",
        lawp4y: 0,
        Fbdkly: 0,
        mdwyqc: 0,
        Bciustq: 0,
        gc50h5: "f13vvzas",
        Ehzi8l: "f198lalb",
        B0n5ga8: "f13dj02",
        s924m2: [
            "f9wngki",
            "f17v59j0"
        ],
        B1q35kw: "f1vxzwsp",
        Gp14am: [
            "f17v59j0",
            "f9wngki"
        ],
        Bikrtoi: "f11og98d",
        G8qf51: "f1rg3h4v",
        Brxh4y7: "fbm2y3b",
        ezxybo: "f4yodeu",
        wc7uws: "fcwfbwp",
        gp3uxg: "f1repx37",
        Fohawp: [
            "f1ybi8ct",
            "f1h4eg6q"
        ],
        Bxulg6k: "f18mejnb",
        vcjq4m: [
            "f1h4eg6q",
            "f1ybi8ct"
        ],
        Bsqkqe9: "f1nift3m",
        fskg1g: "f1wu3i8x",
        iwiei9: 0,
        Effecx: 0,
        Bkt1b9m: 0,
        jfmxvr: 0,
        orauir: "f6v4vfa",
        B2yd9ot: "folrdqs",
        Fn9tzk: "f168z5yf",
        Bv0wker: [
            "fpor7gj",
            "fzextn6"
        ],
        Bp2dl5b: "f1yaw79v",
        pzn0iz: [
            "fzextn6",
            "fpor7gj"
        ]
    }
}, {
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ],
    i: [
        ".f2hkw1w:focus-visible{outline-style:none;}"
    ],
    d: [
        ".f8hki3x[data-fui-focus-visible]{border-top-color:transparent;}",
        ".f1d2448m[data-fui-focus-visible]{border-right-color:transparent;}",
        ".ffh67wi[data-fui-focus-visible]{border-left-color:transparent;}",
        ".f1bjia2o[data-fui-focus-visible]{border-bottom-color:transparent;}",
        ".f15bsgw9[data-fui-focus-visible]::after{content:\"\";}",
        ".f14e48fq[data-fui-focus-visible]::after{position:absolute;}",
        ".f18yb2kv[data-fui-focus-visible]::after{pointer-events:none;}",
        ".fd6o370[data-fui-focus-visible]::after{z-index:1;}",
        [
            ".fpqizxz[data-fui-focus-visible]::after{border:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".fnd8nzh[data-fui-focus-visible]::after{border-radius:var(--fui-Card--border-radius);}",
            {
                p: -1
            }
        ],
        ".f15fr7a0[data-fui-focus-visible]::after{top:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".fwsq40z[data-fui-focus-visible]::after{right:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".fy0y4wt[data-fui-focus-visible]::after{left:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f34ld9f[data-fui-focus-visible]::after{bottom:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f1b1k54r[data-fui-focus-within]:focus-within{border-top-color:transparent;}",
        ".f4ne723[data-fui-focus-within]:focus-within{border-right-color:transparent;}",
        ".fqqcjud[data-fui-focus-within]:focus-within{border-left-color:transparent;}",
        ".fh7aioi[data-fui-focus-within]:focus-within{border-bottom-color:transparent;}",
        ".ffht0p2[data-fui-focus-within]:focus-within::after{content:\"\";}",
        ".f1p0ul1q[data-fui-focus-within]:focus-within::after{position:absolute;}",
        ".f1c901ms[data-fui-focus-within]:focus-within::after{pointer-events:none;}",
        ".f1alokd7[data-fui-focus-within]:focus-within::after{z-index:1;}",
        [
            ".f1i978nd[data-fui-focus-within]:focus-within::after{border:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".f1nh8hsq[data-fui-focus-within]:focus-within::after{border-radius:var(--fui-Card--border-radius);}",
            {
                p: -1
            }
        ],
        ".f1amxum7[data-fui-focus-within]:focus-within::after{top:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f1cec8w7[data-fui-focus-within]:focus-within::after{right:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f554mv0[data-fui-focus-within]:focus-within::after{left:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f1sj6kbr[data-fui-focus-within]:focus-within::after{bottom:calc(0px - var(--strokeWidthThick) - -2px);}",
        ".f1063pyq{flex-direction:row;}",
        ".f122n59{align-items:center;}",
        ".ftrw7vg>.fui-CardPreview{margin-top:calc(var(--fui-Card--size) * -1);}",
        ".f18opajm>.fui-CardPreview{margin-bottom:calc(var(--fui-Card--size) * -1);}",
        ".f13002it>:not([aria-hidden=\"true\"]).fui-CardPreview:first-of-type{margin-left:calc(var(--fui-Card--size) * -1);}",
        ".fqo182t>:not([aria-hidden=\"true\"]).fui-CardPreview:first-of-type{margin-right:calc(var(--fui-Card--size) * -1);}",
        ".f18yna97>:not([aria-hidden=\"true\"]).fui-CardPreview:last-of-type{margin-right:calc(var(--fui-Card--size) * -1);}",
        ".f1kd6wh7>:not([aria-hidden=\"true\"]).fui-CardPreview:last-of-type{margin-left:calc(var(--fui-Card--size) * -1);}",
        ".f4i4759>.fui-CardHeader:last-of-type,.f4i4759>.fui-CardFooter:last-of-type{flex-grow:1;}",
        ".f1vx9l62{flex-direction:column;}",
        ".f14k419y>.fui-CardPreview{margin-left:calc(var(--fui-Card--size) * -1);}",
        ".f1fgo9fz>.fui-CardPreview{margin-right:calc(var(--fui-Card--size) * -1);}",
        ".fvqmfsm>:not([aria-hidden=\"true\"]).fui-CardPreview:first-of-type{margin-top:calc(var(--fui-Card--size) * -1);}",
        ".f3am6yf>.fui-Card__floatingAction+.fui-CardPreview{margin-top:calc(var(--fui-Card--size) * -1);}",
        ".f1r5wgso>:not([aria-hidden=\"true\"]).fui-CardPreview:last-of-type{margin-bottom:calc(var(--fui-Card--size) * -1);}",
        ".f1pi9uxy{--fui-Card--size:8px;}",
        ".f1h1zgly{--fui-Card--border-radius:var(--borderRadiusSmall);}",
        ".frsmuga{--fui-Card--size:12px;}",
        ".fuldkky{--fui-Card--border-radius:var(--borderRadiusMedium);}",
        ".f1qua4xo{--fui-Card--size:16px;}",
        ".fimkt6v{--fui-Card--border-radius:var(--borderRadiusLarge);}",
        ".f1epqm3e .fui-Text{color:currentColor;}",
        ".fxugw4r{background-color:var(--colorNeutralBackground1);}",
        ".f1whvlc6{box-shadow:var(--shadow4);}",
        ".f16gxe2i::after{border-top-color:var(--colorTransparentStroke);}",
        ".fpgykix::after{border-right-color:var(--colorTransparentStroke);}",
        ".fzybk4o::after{border-left-color:var(--colorTransparentStroke);}",
        ".f1osi826::after{border-bottom-color:var(--colorTransparentStroke);}",
        ".f1k6fduh{cursor:pointer;}",
        ".f1nfm20t{background-color:var(--colorNeutralBackground1Selected);}",
        ".f16eln5f::after{border-top-color:var(--colorNeutralStroke1Selected);}",
        ".fa2okxs::after{border-right-color:var(--colorNeutralStroke1Selected);}",
        ".fg4zq3l::after{border-left-color:var(--colorNeutralStroke1Selected);}",
        ".ff6932p::after{border-bottom-color:var(--colorNeutralStroke1Selected);}",
        ".f1dmdbja{background-color:var(--colorNeutralBackground2);}",
        ".fjxa0vh{background-color:var(--colorNeutralBackground2Selected);}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        ".f1couhl3{box-shadow:none;}",
        ".ft83z1f::after{border-top-color:var(--colorNeutralStroke1);}",
        ".f1g4150c::after{border-right-color:var(--colorNeutralStroke1);}",
        ".f192dr6e::after{border-left-color:var(--colorNeutralStroke1);}",
        ".f1qnawh6::after{border-bottom-color:var(--colorNeutralStroke1);}",
        ".f1q9pm1r{background-color:var(--colorTransparentBackgroundSelected);}",
        ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
        ".f13dj02::after{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f9wngki::after{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".f17v59j0::after{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f1vxzwsp::after{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
        ".fhovq9v{background-color:var(--colorSubtleBackground);}",
        ".fq5gl1p{background-color:var(--colorSubtleBackgroundSelected);}",
        ".f1euv43f{position:absolute;}",
        ".fqclxi7{top:4px;}",
        ".fiv86kb{right:4px;}",
        ".f36uhnt{left:4px;}",
        ".fom9my7{z-index:var(--zIndexContent, 1);}",
        [
            ".f1a3p1vp{overflow:hidden;}",
            {
                p: -1
            }
        ],
        ".frkrog8{width:1px;}",
        ".f1mpe4l3{height:1px;}",
        ".fmf1zke{clip:rect(0 0 0 0);}",
        ".f1wch0ki{clip-path:inset(50%);}",
        ".fz5stix{white-space:nowrap;}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".f1xqy1su{-webkit-user-select:none;-moz-user-select:none;user-select:none;}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".f1bg9a2p{background-color:var(--colorNeutralBackgroundDisabled);}",
        ".fyed02w{box-shadow:var(--shadow2);}",
        ".f1wl9k8s::before{content:\"\";}",
        ".f1j7ml58::before{position:absolute;}",
        [
            ".f13vvzas::before{inset:0;}",
            {
                p: -1
            }
        ],
        ".f198lalb::before{z-index:calc(var(--zIndexContent, 1) + 1);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f226i61[data-fui-focus-visible]::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f13kzufm[data-fui-focus-visible]::after{border-right-color:Highlight;}.fsx75g8[data-fui-focus-visible]::after{border-left-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.flujwa2[data-fui-focus-visible]::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1k55ka9[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f16pcs8n[data-fui-focus-within]:focus-within::after{border-left-color:Highlight;}.fgclinu[data-fui-focus-within]:focus-within::after{border-right-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fycbxed[data-fui-focus-within]:focus-within::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fkc42ay{forced-color-adjust:none;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1rirnrt{background-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1lkg8j3{color:HighlightText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1nkj0oa .fui-CardPreview,.f1nkj0oa .fui-CardFooter{forced-color-adjust:auto;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fey3rwa::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f5jhx11::after{border-right-color:Highlight;}.fff9uym::after{border-left-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fm7n0jy::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fpfvv3l:hover,.fpfvv3l :active{forced-color-adjust:none;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1oamsm6:hover,.f1oamsm6 :active{background-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1il21bs:hover,.f1il21bs :active{color:HighlightText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fnn5dk0:hover .fui-CardPreview,.fnn5dk0 :active .fui-CardPreview,.fnn5dk0:hover .fui-CardFooter,.fnn5dk0 :active .fui-CardFooter{forced-color-adjust:auto;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    h: [
        ".feu1g3u:hover{color:var(--colorNeutralForeground1Hover);}",
        ".f1knas48:hover{background-color:var(--colorNeutralBackground1Hover);}",
        ".f1m145df:hover{box-shadow:var(--shadow8);}",
        ".fx9teim:hover{color:var(--colorNeutralForeground1Selected);}",
        ".f1kz6goq:hover{background-color:var(--colorNeutralBackground1Selected);}",
        ".fnwyq0v:hover{color:var(--colorNeutralForeground2Hover);}",
        ".f1uvynv3:hover{background-color:var(--colorNeutralBackground2Hover);}",
        ".f1luvkty:hover{color:var(--colorNeutralForeground2Selected);}",
        ".fehi0vp:hover{background-color:var(--colorNeutralBackground2Selected);}",
        ".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}",
        ".f1llr77y:hover::after{border-top-color:var(--colorNeutralStroke1Hover);}",
        ".fzk0khw:hover::after{border-right-color:var(--colorNeutralStroke1Hover);}",
        ".fjj8tog:hover::after{border-left-color:var(--colorNeutralStroke1Hover);}",
        ".fb1u8ub:hover::after{border-bottom-color:var(--colorNeutralStroke1Hover);}",
        ".fg59vm4:hover{background-color:var(--colorTransparentBackgroundSelected);}",
        ".f1ls5moo:hover,.f1ls5moo:active{background-color:var(--colorTransparentBackground);}",
        ".f1qiza15:hover,.f1qiza15:active{box-shadow:none;}",
        ".f1t94bn6:hover{background-color:var(--colorSubtleBackgroundHover);}",
        ".f1uqaxdt:hover{background-color:var(--colorSubtleBackgroundSelected);}",
        ".f11og98d:hover,.f11og98d:active{cursor:not-allowed;}",
        ".f1rg3h4v:hover,.f1rg3h4v:active{-webkit-user-select:none;-moz-user-select:none;user-select:none;}",
        ".fbm2y3b:hover,.fbm2y3b:active{color:var(--colorNeutralForegroundDisabled);}",
        ".f4yodeu:hover,.f4yodeu:active{background-color:var(--colorNeutralBackgroundDisabled);}",
        ".fcwfbwp:hover,.fcwfbwp:active{box-shadow:var(--shadow2);}",
        ".f1repx37:hover,.f1repx37:active{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f1ybi8ct:hover,.f1ybi8ct:active{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".f1h4eg6q:hover,.f1h4eg6q:active{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f18mejnb:hover,.f18mejnb:active{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
        ".f1nift3m:hover::before,.f1nift3m:active::before{content:\"\";}",
        ".f1wu3i8x:hover::before,.f1wu3i8x:active::before{position:absolute;}",
        [
            ".f6v4vfa:hover::before,.f6v4vfa:active::before{inset:0;}",
            {
                p: -1
            }
        ],
        ".folrdqs:hover::before,.folrdqs:active::before{z-index:calc(var(--zIndexContent, 1) + 1);}",
        ".f168z5yf:hover::after,.f168z5yf:active::after{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".fpor7gj:hover::after,.fpor7gj:active::after{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".fzextn6:hover::after,.fzextn6:active::after{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f1yaw79v:hover::after,.f1yaw79v:active::after{border-bottom-color:var(--colorNeutralStrokeDisabled);}"
    ],
    a: [
        ".fb40n2d:active{background-color:var(--colorNeutralBackground1Pressed);}",
        ".f1yhgkbh:active{background-color:var(--colorNeutralBackground2Pressed);}",
        ".fophhak:active{background-color:var(--colorTransparentBackgroundPressed);}",
        ".f1uohb70:active::after{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".f1jm7v1n:active::after{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".f1bus3rq:active::after{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1fbu7rr:active::after{border-bottom-color:var(--colorNeutralStroke1Pressed);}",
        ".f1wfn5kd:active{background-color:var(--colorSubtleBackgroundPressed);}"
    ]
});
const useCardStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useCardResetStyles();
    const styles = useCardStyles();
    const orientationMap = {
        horizontal: styles.orientationHorizontal,
        vertical: styles.orientationVertical
    };
    const sizeMap = {
        small: styles.sizeSmall,
        medium: styles.sizeMedium,
        large: styles.sizeLarge
    };
    const appearanceMap = {
        filled: styles.filled,
        'filled-alternative': styles.filledAlternative,
        outline: styles.outline,
        subtle: styles.subtle
    };
    const selectedMap = {
        filled: styles.filledInteractiveSelected,
        'filled-alternative': styles.filledAlternativeInteractiveSelected,
        outline: styles.outlineInteractiveSelected,
        subtle: styles.subtleInteractiveSelected
    };
    const interactiveMap = {
        filled: styles.filledInteractive,
        'filled-alternative': styles.filledAlternativeInteractive,
        outline: styles.outlineInteractive,
        subtle: styles.subtleInteractive
    };
    const isSelectableOrInteractive = !state.disabled && (state.interactive || state.selectable);
    const focusedClassName = _react.useMemo(()=>{
        if (state.disabled) {
            return '';
        }
        if (state.selectable) {
            if (state.selectFocused) {
                return styles.selectableFocused;
            }
            return '';
        }
        return styles.focused;
    }, [
        state.disabled,
        state.selectFocused,
        state.selectable,
        styles.focused,
        styles.selectableFocused
    ]);
    state.root.className = (0, _react1.mergeClasses)(cardClassNames.root, resetStyles, orientationMap[state.orientation], sizeMap[state.size], appearanceMap[state.appearance], isSelectableOrInteractive && styles.interactive, isSelectableOrInteractive && interactiveMap[state.appearance], state.selected && selectedMap[state.appearance], focusedClassName, isSelectableOrInteractive && styles.highContrastInteractive, state.selected && styles.highContrastSelected, state.disabled && styles.disabled, state.disabled && state.appearance === 'outline' && styles.outlineDisabled, state.root.className);
    if (state.floatingAction) {
        state.floatingAction.className = (0, _react1.mergeClasses)(cardClassNames.floatingAction, styles.select, state.floatingAction.className);
    }
    if (state.checkbox) {
        state.checkbox.className = (0, _react1.mergeClasses)(cardClassNames.checkbox, styles.hiddenCheckbox, state.checkbox.className);
    }
    return state;
};
