'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCardSelectable", {
    enumerable: true,
    get: function() {
        return useCardSelectable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reacttabster = require("@fluentui/react-tabster");
const useCardSelectable = (props, { referenceLabel, referenceId }, cardRef)=>{
    const { checkbox = {}, onSelectionChange, floatingAction, onClick, onKeyDown, disabled } = props;
    const { findAllFocusable } = (0, _reacttabster.useFocusFinders)();
    const checkboxRef = _react.useRef(null);
    const [selected, setSelected] = (0, _reactutilities.useControllableState)({
        state: props.selected,
        defaultState: props.defaultSelected,
        initialState: false
    });
    const selectable = [
        props.selected,
        props.defaultSelected,
        onSelectionChange
    ].some((prop)=>typeof prop !== 'undefined');
    const [selectFocused, setSelectFocused] = _react.useState(false);
    const shouldRestrictTriggerAction = _react.useCallback((event)=>{
        if (!cardRef.current) {
            return false;
        }
        const focusableElements = findAllFocusable(cardRef.current);
        const target = event.target;
        const isElementInFocusableGroup = focusableElements.some((element)=>element.contains(target));
        const isCheckboxSlot = (checkboxRef === null || checkboxRef === void 0 ? void 0 : checkboxRef.current) === target;
        return isElementInFocusableGroup && !isCheckboxSlot;
    }, [
        cardRef,
        findAllFocusable
    ]);
    const onChangeHandler = _react.useCallback((event)=>{
        if (disabled || shouldRestrictTriggerAction(event)) {
            return;
        }
        const newCheckedValue = !selected;
        setSelected(newCheckedValue);
        if (onSelectionChange) {
            onSelectionChange(event, {
                selected: newCheckedValue
            });
        }
    }, [
        disabled,
        onSelectionChange,
        selected,
        setSelected,
        shouldRestrictTriggerAction
    ]);
    const onKeyDownHandler = _react.useCallback((event)=>{
        if ([
            _keyboardkeys.Enter
        ].includes(event.key)) {
            event.preventDefault();
            onChangeHandler(event);
        }
    }, [
        onChangeHandler
    ]);
    const checkboxSlot = _react.useMemo(()=>{
        if (!selectable || floatingAction) {
            return;
        }
        const selectableCheckboxProps = {};
        if (referenceId) {
            selectableCheckboxProps['aria-labelledby'] = referenceId;
        } else if (referenceLabel) {
            selectableCheckboxProps['aria-label'] = referenceLabel;
        }
        return _reactutilities.slot.optional(checkbox, {
            defaultProps: {
                ref: checkboxRef,
                type: 'checkbox',
                checked: selected,
                disabled,
                onChange: (event)=>onChangeHandler(event),
                onFocus: ()=>setSelectFocused(true),
                onBlur: ()=>setSelectFocused(false),
                ...selectableCheckboxProps
            },
            elementType: 'input'
        });
    }, [
        checkbox,
        disabled,
        floatingAction,
        selected,
        selectable,
        onChangeHandler,
        referenceId,
        referenceLabel
    ]);
    const floatingActionSlot = _react.useMemo(()=>{
        if (!floatingAction) {
            return;
        }
        return _reactutilities.slot.optional(floatingAction, {
            defaultProps: {
                ref: checkboxRef
            },
            elementType: 'div'
        });
    }, [
        floatingAction
    ]);
    const selectableCardProps = _react.useMemo(()=>{
        if (!selectable) {
            return null;
        }
        return {
            onClick: (0, _reactutilities.mergeCallbacks)(onClick, onChangeHandler),
            onKeyDown: (0, _reactutilities.mergeCallbacks)(onKeyDown, onKeyDownHandler)
        };
    }, [
        selectable,
        onChangeHandler,
        onClick,
        onKeyDown,
        onKeyDownHandler
    ]);
    return {
        selected,
        selectable,
        selectFocused,
        selectableCardProps,
        checkboxSlot,
        floatingActionSlot
    };
};
