import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * A card provides scaffolding for hosting actions and content for a single topic.
 */
export declare const Card: ForwardRefComponent<CardProps>;

/**
 * Static CSS class names used internally for the component slots.
 */
export declare const cardClassNames: SlotClassNames<CardSlots>;

/**
 * Data shared between card components
 */
export declare interface CardContextValue {
    selectableA11yProps: {
        referenceId?: string;
        setReferenceId: (referenceId: string) => void;
        referenceLabel?: string;
        setReferenceLabel: (referenceLabel: string) => void;
    };
}

/**
 * CSS variable names used internally for uniform styling in Card.
 */
export declare const cardCSSVars: {
    cardSizeVar: string;
    cardBorderRadiusVar: string;
};

/**
 * Component to render Button actions in a Card component.
 */
export declare const CardFooter: ForwardRefComponent<CardFooterProps>;

/**
 * Static CSS class names used internally for the component slots.
 */
export declare const cardFooterClassNames: SlotClassNames<CardFooterSlots>;

/**
 * CardFooter component props.
 */
export declare type CardFooterProps = ComponentProps<CardFooterSlots>;

/**
 * Slots available in the CardFooter component.
 */
export declare type CardFooterSlots = {
    /**
     * Root element of the component.
     */
    root: Slot<'div'>;
    /**
     * Container that renders on the far end of the footer, used for action buttons.
     */
    action?: Slot<'div'>;
};

/**
 * State used in rendering CardFooter.
 */
export declare type CardFooterState = ComponentState<CardFooterSlots>;

/**
 * Component to render an image, text and an action in a Card component.
 */
export declare const CardHeader: ForwardRefComponent<CardHeaderProps>;

/**
 * Static CSS class names used internally for the component slots.
 */
export declare const cardHeaderClassNames: SlotClassNames<CardHeaderSlots>;

/**
 * CSS variable names used internally for uniform styling in CardHeader.
 */
export declare const cardHeaderCSSVars: {
    cardHeaderGapVar: string;
};

/**
 * CardHeader component props.
 */
export declare type CardHeaderProps = ComponentProps<Partial<CardHeaderSlots>>;

/**
 * Slots available in the CardHeader component.
 */
export declare type CardHeaderSlots = {
    /**
     * Root element of the component.
     */
    root: Slot<'div'>;
    /**
     * Element used to render an image or avatar related to the card.
     */
    image: Slot<'div', 'img'>;
    /**
     * Element used to render the main header title.
     */
    header: Slot<'div'>;
    /**
     * Element used to render short descriptions related to the title.
     */
    description: Slot<'div'>;
    /**
     * Container that renders on the far end of the footer, used for action buttons.
     */
    action?: Slot<'div'>;
};

/**
 * State used in rendering CardHeader.
 */
export declare type CardHeaderState = ComponentState<CardHeaderSlots>;

/**
 * Data sent from the selection events on a selectable card.
 */
declare type CardOnSelectData = {
    selected: boolean;
};

/**
 * Card selected event type
 *
 * This event is fired when a selectable card changes its selection state.
 */
export declare type CardOnSelectionChangeEvent = React_2.MouseEvent | React_2.KeyboardEvent | React_2.ChangeEvent;

/**
 * Component to render image previews of documents or articles in a Card component.
 */
export declare const CardPreview: ForwardRefComponent<CardPreviewProps>;

/**
 * Static CSS class names used internally for the component slots.
 */
export declare const cardPreviewClassNames: SlotClassNames<CardPreviewSlots>;

/**
 * CardPreview component props.
 */
export declare type CardPreviewProps = ComponentProps<CardPreviewSlots>;

/**
 * Slots available in the Card component.
 */
export declare type CardPreviewSlots = {
    /**
     * Root element of the component.
     */
    root: Slot<'div'>;
    /**
     * Container that holds a logo related to the image preview provided.
     */
    logo?: Slot<'div', 'img'>;
};

/**
 * State used in rendering CardPreview.
 */
export declare type CardPreviewState = ComponentState<CardPreviewSlots>;

/**
 * Card component props.
 */
export declare type CardProps = ComponentProps<CardSlots> & {
    /**
     * Sets the appearance of the card.
     *
     * `filled`
     * The card will have a shadow, border and background color.
     *
     * `filled-alternative`
     * This appearance is similar to `filled`, but the background color will be a little darker.
     *
     * `outline`
     * This appearance is similar to `filled`, but the background color will be transparent and no shadow applied.
     *
     * `subtle`
     * This appearance is similar to `filled-alternative`, but no border is applied.
     *
     * @default 'filled'
     */
    appearance?: 'filled' | 'filled-alternative' | 'outline' | 'subtle';
    /**
     * Sets the focus behavior for the card.
     *
     * `off`
     * The card will not focusable.
     *
     * `no-tab`
     * This behaviour traps the focus inside of the Card when pressing the Enter key and will only release focus when
     * pressing the Escape key.
     *
     * `tab-exit`
     * This behaviour traps the focus inside of the Card when pressing the Enter key but will release focus when pressing
     * the Tab key on the last inner element.
     *
     * `tab-only`
     * This behaviour will cycle through all elements inside of the Card when pressing the Tab key and then release focus
     * after the last inner element.
     *
     * @default 'off'
     */
    focusMode?: 'off' | 'no-tab' | 'tab-exit' | 'tab-only';
    /**
     * Defines the orientation of the card.
     *
     * @default 'vertical'
     */
    orientation?: 'horizontal' | 'vertical';
    /**
     * Controls the card's border radius and padding between inner elements.
     *
     * @default 'medium'
     */
    size?: 'small' | 'medium' | 'large';
    /**
     * Defines the controlled selected state of the card.
     *
     * @default false
     */
    selected?: boolean;
    /**
     * Defines whether the card is initially in a selected state when rendered.
     *
     * @default false
     */
    defaultSelected?: boolean;
    /**
     * Callback to be called when the selected state value changes.
     */
    onSelectionChange?: (event: CardOnSelectionChangeEvent, data: CardOnSelectData) => void;
    /**
     * Makes the card and card selection disabled (not propagated to children).
     *
     * @default false
     */
    disabled?: boolean;
};

/**
 * @internal
 */
export declare const CardProvider: React_2.Provider<CardContextValue | undefined>;

/**
 * Slots available in the Card component.
 */
export declare type CardSlots = {
    /**
     * Root element of the component.
     */
    root: Slot<'div'>;
    /**
     * Floating action that can be rendered on the top-right of a card. Often used together with
     * `selected`, `defaultSelected`, and `onSelectionChange` props
     */
    floatingAction?: Slot<'div'>;
    /**
     * The internal checkbox element that renders when the card is selectable.
     */
    checkbox?: Slot<'input'>;
};

/**
 * State used in rendering Card.
 */
export declare type CardState = ComponentState<CardSlots> & CardContextValue & Required<Pick<CardProps, 'appearance' | 'orientation' | 'size'> & {
    /**
     * Represents a card that contains interactive events (MouseEvents) or is a button/a tag.
     *
     * @default false
     */
    interactive: boolean;
    /**
     * Represents a selectable card.
     *
     * @default false
     */
    selectable: boolean;
    /**
     * Defines whether the card is currently selected.
     *
     * @default false
     */
    selected: boolean;
    /**
     * Defines whether the card internal checkbox is currently focused.
     *
     * @default false
     */
    selectFocused: boolean;
    /**
     * Defines whether the card is disabled.
     *
     * @default false
     */
    disabled: boolean;
}>;

/**
 * Render the final JSX of Card.
 */
export declare const renderCard_unstable: (state: CardState, cardContextValue: CardContextValue) => JSXElement;

/**
 * Render the final JSX of CardFooter.
 */
export declare const renderCardFooter_unstable: (state: CardFooterState) => JSXElement;

/**
 * Render the final JSX of CardHeader.
 */
export declare const renderCardHeader_unstable: (state: CardHeaderState) => JSXElement;

/**
 * Render the final JSX of CardPreview.
 */
export declare const renderCardPreview_unstable: (state: CardPreviewState) => JSXElement;

/**
 * Create the state required to render Card.
 *
 * The returned state can be modified with hooks such as useCardStyles_unstable,
 * before being passed to renderCard_unstable.
 *
 * @param props - props from this instance of Card
 * @param ref - reference to the root element of Card
 */
export declare const useCard_unstable: (props: CardProps, ref: React_2.Ref<HTMLDivElement>) => CardState;

/**
 * @internal
 */
export declare const useCardContext_unstable: () => CardContextValue;

/**
 * Create the state required to render CardFooter.
 *
 * The returned state can be modified with hooks such as useCardFooterStyles_unstable,
 * before being passed to renderCardFooter_unstable.
 *
 * @param props - props from this instance of CardFooter
 * @param ref - reference to root HTMLElement of CardFooter
 */
export declare const useCardFooter_unstable: (props: CardFooterProps, ref: React_2.Ref<HTMLElement>) => CardFooterState;

/**
 * Apply styling to the CardFooter slots based on the state.
 */
export declare const useCardFooterStyles_unstable: (state: CardFooterState) => CardFooterState;

/**
 * Create the state required to render CardHeader.
 *
 * The returned state can be modified with hooks such as useCardHeaderStyles_unstable,
 * before being passed to renderCardHeader_unstable.
 *
 * @param props - props from this instance of CardHeader
 * @param ref - reference to root HTMLElement of CardHeader
 */
export declare const useCardHeader_unstable: (props: CardHeaderProps, ref: React_2.Ref<HTMLElement>) => CardHeaderState;

/**
 * Apply styling to the CardHeader slots based on the state.
 */
export declare const useCardHeaderStyles_unstable: (state: CardHeaderState) => CardHeaderState;

/**
 * Create the state required to render CardPreview.
 *
 * The returned state can be modified with hooks such as useCardPreviewStyles_unstable,
 * before being passed to renderCardPreview_unstable.
 *
 * @param props - props from this instance of CardPreview
 * @param ref - reference to root HTMLElement of CardPreview
 */
export declare const useCardPreview_unstable: (props: CardPreviewProps, ref: React_2.Ref<HTMLElement>) => CardPreviewState;

/**
 * Apply styling to the CardPreview slots based on the state.
 */
export declare const useCardPreviewStyles_unstable: (state: CardPreviewState) => CardPreviewState;

/**
 * Apply styling to the Card slots based on the state.
 */
export declare const useCardStyles_unstable: (state: CardState) => CardState;

export { }
