'use client';
import * as React from 'react';
import { mergeCallbacks, useControllableState, useEventCallback } from '@fluentui/react-utilities';
export function useToggleState(props, state) {
    const { checked, defaultChecked, disabled, disabledFocusable } = props;
    const { onClick, role } = state.root;
    const [checkedValue, setCheckedValue] = useControllableState({
        state: checked,
        defaultState: defaultChecked,
        initialState: false
    });
    const isCheckboxTypeRole = role === 'menuitemcheckbox' || role === 'checkbox';
    const onToggleClick = React.useCallback((ev)=>{
        if (!disabled && !disabledFocusable) {
            if (ev.defaultPrevented) {
                return;
            }
            setCheckedValue(!checkedValue);
        }
    }, [
        checkedValue,
        disabled,
        disabledFocusable,
        setCheckedValue
    ]);
    return {
        ...state,
        checked: checkedValue,
        root: {
            ...state.root,
            [isCheckboxTypeRole ? 'aria-checked' : 'aria-pressed']: checkedValue,
            onClick: useEventCallback(mergeCallbacks(onClick, onToggleClick))
        }
    };
}
