'use client';
import * as React from 'react';
import { renderToggleButton_unstable } from './renderToggleButton';
import { useToggleButton_unstable } from './useToggleButton';
import { useToggleButtonStyles_unstable } from './useToggleButtonStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * ToggleButtons are buttons that toggle between two defined states when triggered.
 */ export const ToggleButton = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useToggleButton_unstable(props, ref);
    useToggleButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useToggleButtonStyles_unstable')(state);
    return renderToggleButton_unstable(state);
// Casting is required due to lack of distributive union to support unions on @types/react
});
ToggleButton.displayName = 'ToggleButton';
