'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
import { tokens } from '@fluentui/react-theme';
export const splitButtonClassNames = {
  root: 'fui-SplitButton',
  menuButton: 'fui-SplitButton__menuButton',
  primaryActionButton: 'fui-SplitButton__primaryActionButton'
};
// WCAG minimum target size for pointer targets that are immediately adjacent to other targets:
// https://w3c.github.io/wcag/guidelines/22/#target-size-minimum
const MIN_TARGET_SIZE = '24px';
const useFocusStyles = /*#__PURE__*/__styles({
  primaryActionButton: {
    B6xbmo0: ["f1x37qnr", "f1um7c6d"],
    kdpuga: ["fn4c73s", "f6pwzcr"]
  },
  menuButton: {
    lbo84a: ["frrbwxo", "f1rgcpbv"],
    dm238s: ["f1um7c6d", "f1x37qnr"],
    Bw81rd7: ["f6pwzcr", "fn4c73s"]
  }
}, {
  d: [".f1x37qnr[data-fui-focus-visible]{border-top-right-radius:0;}", ".f1um7c6d[data-fui-focus-visible]{border-top-left-radius:0;}", ".fn4c73s[data-fui-focus-visible]{border-bottom-right-radius:0;}", ".f6pwzcr[data-fui-focus-visible]{border-bottom-left-radius:0;}", ".frrbwxo[data-fui-focus-visible]{border-left-width:0;}", ".f1rgcpbv[data-fui-focus-visible]{border-right-width:0;}"]
});
const useRootStyles = /*#__PURE__*/__styles({
  base: {
    mc9l5x: "ftuwxu6",
    Brf1p80: "fsxf2b5",
    qhf8xq: "f10pi13n",
    ha4doy: "fmrv4ls",
    kn2xc0: ["f14uur2j", "fc1btbj"],
    Bs76p8a: ["fye5tvs", "fc597qq"],
    cuxpm9: ["f1e8brtx", "fr36rk3"],
    Biffepf: ["fxp12j1", "f1m6nt2y"],
    Defnvf: ["fr7y8no", "f1dn0c6m"],
    z0pv9t: "f1b65x5h"
  },
  outline: {},
  primary: {
    B1l9wao: ["f4rm5b0", "f1tuwo13"],
    lcnrd8: ["fdwdeeo", "f1ezdslh"],
    Brbpp8k: ["fckzjn8", "f8ohr2i"],
    B3s9tpx: ["f2z0mmn", "f12iqdwp"],
    rfylfo: ["f1btorfl", "fxofj4p"],
    J07ivo: ["fj21086", "f1niwlx5"]
  },
  secondary: {},
  subtle: {
    B1l9wao: ["f16kf41h", "fxiafvi"],
    lcnrd8: ["ffl6mx9", "f1t5sw6t"],
    Brbpp8k: ["f1t42bc8", "fsw5hli"]
  },
  transparent: {
    B1l9wao: ["f16kf41h", "fxiafvi"],
    lcnrd8: ["ffl6mx9", "f1t5sw6t"],
    Brbpp8k: ["f1t42bc8", "fsw5hli"]
  },
  circular: {},
  rounded: {},
  square: {},
  disabled: {
    B1l9wao: ["f10xrnr8", "f15nylwb"],
    lcnrd8: ["f11fwhjz", "f18vtcsx"],
    Brbpp8k: ["f31btwb", "fzgm9gq"]
  },
  disabledHighContrast: {
    B3s9tpx: ["fslo9ob", "ftovg2z"],
    rfylfo: ["f1fuq5cn", "f168zpha"],
    J07ivo: ["f1ork8n9", "foo39dt"]
  }
}, {
  d: [".ftuwxu6{display:inline-flex;}", ".fsxf2b5{justify-content:stretch;}", ".f10pi13n{position:relative;}", ".fmrv4ls{vertical-align:middle;}", ".f14uur2j .fui-SplitButton__primaryActionButton{border-top-right-radius:0;}", ".fc1btbj .fui-SplitButton__primaryActionButton{border-top-left-radius:0;}", ".fye5tvs .fui-SplitButton__primaryActionButton{border-bottom-right-radius:0;}", ".fc597qq .fui-SplitButton__primaryActionButton{border-bottom-left-radius:0;}", ".f1e8brtx .fui-SplitButton__menuButton{border-left-width:0;}", ".fr36rk3 .fui-SplitButton__menuButton{border-right-width:0;}", ".fxp12j1 .fui-SplitButton__menuButton{border-top-left-radius:0;}", ".f1m6nt2y .fui-SplitButton__menuButton{border-top-right-radius:0;}", ".fr7y8no .fui-SplitButton__menuButton{border-bottom-left-radius:0;}", ".f1dn0c6m .fui-SplitButton__menuButton{border-bottom-right-radius:0;}", ".f1b65x5h .fui-SplitButton__menuButton{min-width:24px;}", ".f4rm5b0 .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeOnBrand);}", ".f1tuwo13 .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeOnBrand);}", ".f16kf41h .fui-SplitButton__primaryActionButton{border-right-color:var(--colorTransparentBackground);}", ".fxiafvi .fui-SplitButton__primaryActionButton{border-left-color:var(--colorTransparentBackground);}", ".f10xrnr8 .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeDisabled);}", ".f15nylwb .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeDisabled);}"],
  h: [".fdwdeeo:hover .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeOnBrand);}", ".f1ezdslh:hover .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeOnBrand);}", ".fckzjn8:hover:active .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeOnBrand);}", ".f8ohr2i:hover:active .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeOnBrand);}", ".ffl6mx9:hover .fui-SplitButton__primaryActionButton{border-right-color:var(--colorTransparentBackgroundHover);}", ".f1t5sw6t:hover .fui-SplitButton__primaryActionButton{border-left-color:var(--colorTransparentBackgroundHover);}", ".f1t42bc8:hover:active .fui-SplitButton__primaryActionButton{border-right-color:var(--colorTransparentBackgroundPressed);}", ".fsw5hli:hover:active .fui-SplitButton__primaryActionButton{border-left-color:var(--colorTransparentBackgroundPressed);}", ".f11fwhjz:hover .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeDisabled);}", ".f18vtcsx:hover .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeDisabled);}", ".f31btwb:hover:active .fui-SplitButton__primaryActionButton{border-right-color:var(--colorNeutralStrokeDisabled);}", ".fzgm9gq:hover:active .fui-SplitButton__primaryActionButton{border-left-color:var(--colorNeutralStrokeDisabled);}"],
  m: [["@media (forced-colors: active){.f12iqdwp .fui-SplitButton__primaryActionButton{border-left-color:HighlightText;}.f2z0mmn .fui-SplitButton__primaryActionButton{border-right-color:HighlightText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1btorfl:hover .fui-SplitButton__primaryActionButton{border-right-color:Highlight;}.fxofj4p:hover .fui-SplitButton__primaryActionButton{border-left-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1niwlx5:hover:active .fui-SplitButton__primaryActionButton{border-left-color:Highlight;}.fj21086:hover:active .fui-SplitButton__primaryActionButton{border-right-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fslo9ob .fui-SplitButton__primaryActionButton{border-right-color:GrayText;}.ftovg2z .fui-SplitButton__primaryActionButton{border-left-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f168zpha:hover .fui-SplitButton__primaryActionButton{border-left-color:GrayText;}.f1fuq5cn:hover .fui-SplitButton__primaryActionButton{border-right-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1ork8n9:hover:active .fui-SplitButton__primaryActionButton{border-right-color:GrayText;}.foo39dt:hover:active .fui-SplitButton__primaryActionButton{border-left-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }]]
});
export const useSplitButtonStyles_unstable = state => {
  'use no memo';

  const rootStyles = useRootStyles();
  const focusStyles = useFocusStyles();
  const {
    appearance,
    disabled,
    disabledFocusable
  } = state;
  state.root.className = mergeClasses(splitButtonClassNames.root, rootStyles.base, appearance && rootStyles[appearance], (disabled || disabledFocusable) && rootStyles.disabled, (disabled || disabledFocusable) && rootStyles.disabledHighContrast, state.root.className);
  if (state.menuButton) {
    state.menuButton.className = mergeClasses(splitButtonClassNames.menuButton, focusStyles.menuButton, state.menuButton.className);
  }
  if (state.primaryActionButton) {
    state.primaryActionButton.className = mergeClasses(splitButtonClassNames.primaryActionButton, focusStyles.primaryActionButton, state.primaryActionButton.className);
  }
  return state;
};