'use client';
import * as React from 'react';
import { ChevronDownRegular } from '@fluentui/react-icons';
import { slot } from '@fluentui/react-utilities';
import { useButton_unstable } from '../Button/index';
/**
 * Given user props, returns the final state for a MenuButton.
 */ export const useMenuButton_unstable = ({ menuIcon, ...props }, ref)=>{
    'use no memo';
    const buttonState = useButton_unstable(props, ref);
    // force aria-expanded to be a boolean, not a string
    buttonState.root['aria-expanded'] = props['aria-expanded'] ? props['aria-expanded'] === 'true' || props['aria-expanded'] === true : false;
    return {
        // Button state
        ...buttonState,
        // State calculated from a set of props
        iconOnly: Boolean(!props.children),
        // Slots definition
        components: {
            root: 'button',
            icon: 'span',
            menuIcon: 'span'
        },
        menuIcon: slot.optional(menuIcon, {
            defaultProps: {
                children: /*#__PURE__*/ React.createElement(ChevronDownRegular, null)
            },
            renderByDefault: true,
            elementType: 'span'
        })
    };
};
