'use client';
import * as React from 'react';
import { renderButton_unstable } from './renderButton';
import { useButton_unstable } from './useButton';
import { useButtonStyles_unstable } from './useButtonStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * Buttons give people a way to trigger an action.
 */ export const Button = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useButton_unstable(props, ref);
    useButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useButtonStyles_unstable')(state);
    return renderButton_unstable(state);
// Casting is required due to lack of distributive union to support unions on @types/react
});
Button.displayName = 'Button';
