'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToggleState", {
    enumerable: true,
    get: function() {
        return useToggleState;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
function useToggleState(props, state) {
    const { checked, defaultChecked, disabled, disabledFocusable } = props;
    const { onClick, role } = state.root;
    const [checkedValue, setCheckedValue] = (0, _reactutilities.useControllableState)({
        state: checked,
        defaultState: defaultChecked,
        initialState: false
    });
    const isCheckboxTypeRole = role === 'menuitemcheckbox' || role === 'checkbox';
    const onToggleClick = _react.useCallback((ev)=>{
        if (!disabled && !disabledFocusable) {
            if (ev.defaultPrevented) {
                return;
            }
            setCheckedValue(!checkedValue);
        }
    }, [
        checkedValue,
        disabled,
        disabledFocusable,
        setCheckedValue
    ]);
    return {
        ...state,
        checked: checkedValue,
        root: {
            ...state.root,
            [isCheckboxTypeRole ? 'aria-checked' : 'aria-pressed']: checkedValue,
            onClick: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onClick, onToggleClick))
        }
    };
}
