'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    splitButtonClassNames: function() {
        return splitButtonClassNames;
    },
    useSplitButtonStyles_unstable: function() {
        return useSplitButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const splitButtonClassNames = {
    root: 'fui-SplitButton',
    menuButton: 'fui-SplitButton__menuButton',
    primaryActionButton: 'fui-SplitButton__primaryActionButton'
};
// WCAG minimum target size for pointer targets that are immediately adjacent to other targets:
// https://w3c.github.io/wcag/guidelines/22/#target-size-minimum
const MIN_TARGET_SIZE = '24px';
const useFocusStyles = (0, _react.makeStyles)({
    primaryActionButton: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
    }),
    menuButton: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderLeftWidth: 0,
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0
    })
});
const useRootStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        display: 'inline-flex',
        justifyContent: 'stretch',
        position: 'relative',
        verticalAlign: 'middle',
        [`& .${splitButtonClassNames.primaryActionButton}`]: {
            borderTopRightRadius: 0,
            borderBottomRightRadius: 0
        },
        [`& .${splitButtonClassNames.menuButton}`]: {
            borderLeftWidth: 0,
            borderTopLeftRadius: 0,
            borderBottomLeftRadius: 0,
            minWidth: MIN_TARGET_SIZE
        }
    },
    // Appearance variations
    outline: {},
    primary: {
        [`& .${splitButtonClassNames.primaryActionButton}`]: {
            borderRightColor: _reacttheme.tokens.colorNeutralStrokeOnBrand
        },
        ':hover': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorNeutralStrokeOnBrand
            }
        },
        ':hover:active': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorNeutralStrokeOnBrand
            }
        },
        '@media (forced-colors: active)': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: 'HighlightText'
            },
            ':hover': {
                [`& .${splitButtonClassNames.primaryActionButton}`]: {
                    borderRightColor: 'Highlight'
                }
            },
            ':hover:active': {
                [`& .${splitButtonClassNames.primaryActionButton}`]: {
                    borderRightColor: 'Highlight'
                }
            }
        }
    },
    secondary: {},
    subtle: {
        [`& .${splitButtonClassNames.primaryActionButton}`]: {
            borderRightColor: _reacttheme.tokens.colorTransparentBackground
        },
        ':hover': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorTransparentBackgroundHover
            }
        },
        ':hover:active': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorTransparentBackgroundPressed
            }
        }
    },
    transparent: {
        [`& .${splitButtonClassNames.primaryActionButton}`]: {
            borderRightColor: _reacttheme.tokens.colorTransparentBackground
        },
        ':hover': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorTransparentBackgroundHover
            }
        },
        ':hover:active': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorTransparentBackgroundPressed
            }
        }
    },
    // Shape variations
    circular: {},
    rounded: {},
    square: {},
    // Disabled styles
    disabled: {
        [`& .${splitButtonClassNames.primaryActionButton}`]: {
            borderRightColor: _reacttheme.tokens.colorNeutralStrokeDisabled
        },
        ':hover': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorNeutralStrokeDisabled
            }
        },
        ':hover:active': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: _reacttheme.tokens.colorNeutralStrokeDisabled
            }
        }
    },
    // Disabled high contrast styles
    disabledHighContrast: {
        '@media (forced-colors: active)': {
            [`& .${splitButtonClassNames.primaryActionButton}`]: {
                borderRightColor: 'GrayText'
            },
            ':hover': {
                [`& .${splitButtonClassNames.primaryActionButton}`]: {
                    borderRightColor: 'GrayText'
                }
            },
            ':hover:active': {
                [`& .${splitButtonClassNames.primaryActionButton}`]: {
                    borderRightColor: 'GrayText'
                }
            }
        }
    }
});
const useSplitButtonStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const focusStyles = useFocusStyles();
    const { appearance, disabled, disabledFocusable } = state;
    state.root.className = (0, _react.mergeClasses)(splitButtonClassNames.root, rootStyles.base, appearance && rootStyles[appearance], (disabled || disabledFocusable) && rootStyles.disabled, (disabled || disabledFocusable) && rootStyles.disabledHighContrast, state.root.className);
    if (state.menuButton) {
        state.menuButton.className = (0, _react.mergeClasses)(splitButtonClassNames.menuButton, focusStyles.menuButton, state.menuButton.className);
    }
    if (state.primaryActionButton) {
        state.primaryActionButton.className = (0, _react.mergeClasses)(splitButtonClassNames.primaryActionButton, focusStyles.primaryActionButton, state.primaryActionButton.className);
    }
    return state;
};
