'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuButtonClassNames: function() {
        return menuButtonClassNames;
    },
    useMenuButtonStyles_unstable: function() {
        return useMenuButtonStyles_unstable;
    }
});
const _reacticons = require("@fluentui/react-icons");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const _useButtonStylesstyles = require("../Button/useButtonStyles.styles");
const menuButtonClassNames = {
    root: 'fui-MenuButton',
    icon: 'fui-MenuButton__icon',
    menuIcon: 'fui-MenuButton__menuIcon'
};
const useRootExpandedStyles = (0, _react.makeStyles)({
    base: {
        [`& .${_reacticons.iconFilledClassName}`]: {
            display: 'inline'
        },
        [`& .${_reacticons.iconRegularClassName}`]: {
            display: 'none'
        }
    },
    // Appearance variations
    outline: {
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected),
        ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThicker),
        color: _reacttheme.tokens.colorNeutralForeground1Selected
    },
    primary: {
        backgroundColor: _reacttheme.tokens.colorBrandBackgroundSelected
    },
    secondary: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Selected,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected),
        color: _reacttheme.tokens.colorNeutralForeground1Selected
    },
    subtle: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected,
        color: _reacttheme.tokens.colorNeutralForeground2Selected
    },
    transparent: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackgroundSelected,
        color: _reacttheme.tokens.colorNeutralForeground2BrandSelected
    }
});
const useIconExpandedStyles = (0, _react.makeStyles)({
    // Appearance variations
    outline: {
        color: _reacttheme.tokens.colorNeutralForeground1Selected
    },
    primary: {},
    secondary: {
        color: _reacttheme.tokens.colorNeutralForeground1Selected
    },
    subtle: {
        color: _reacttheme.tokens.colorNeutralForeground2BrandSelected
    },
    transparent: {
        color: _reacttheme.tokens.colorNeutralForeground2BrandSelected
    },
    highContrast: {
        // High contrast styles
        '@media (forced-colors: active)': {
            ':hover': {
                color: 'Highlight'
            }
        }
    }
});
const useMenuIconStyles = (0, _react.makeStyles)({
    base: {
        lineHeight: 0
    },
    // Size appearance
    small: {
        fontSize: '12px',
        height: '12px',
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        width: '12px'
    },
    medium: {
        fontSize: '12px',
        height: '12px',
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        width: '12px'
    },
    large: {
        fontSize: '16px',
        height: '16px',
        lineHeight: _reacttheme.tokens.lineHeightBase400,
        width: '16px'
    },
    // Not-icon only
    notIconOnly: {
        marginLeft: _reacttheme.tokens.spacingHorizontalXS
    }
});
const useMenuButtonStyles_unstable = (state)=>{
    'use no memo';
    const rootExpandedStyles = useRootExpandedStyles();
    const iconExpandedStyles = useIconExpandedStyles();
    const menuIconStyles = useMenuIconStyles();
    state.root.className = (0, _react.mergeClasses)(menuButtonClassNames.root, state.root['aria-expanded'] && rootExpandedStyles.base, state.root['aria-expanded'] && rootExpandedStyles[state.appearance], state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuButtonClassNames.icon, state.root['aria-expanded'] && iconExpandedStyles[state.appearance] && iconExpandedStyles.highContrast, state.icon.className);
    }
    if (state.menuIcon) {
        state.menuIcon.className = (0, _react.mergeClasses)(menuButtonClassNames.menuIcon, menuIconStyles.base, menuIconStyles[state.size], !state.iconOnly && menuIconStyles.notIconOnly, state.menuIcon.className);
    }
    (0, _useButtonStylesstyles.useButtonStyles_unstable)({
        ...state,
        iconPosition: 'before'
    });
    return state;
};
