'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    menuButtonClassNames: function() {
        return menuButtonClassNames;
    },
    useMenuButtonStyles_unstable: function() {
        return useMenuButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _useButtonStylesstyles = require("../Button/useButtonStyles.styles");
const menuButtonClassNames = {
    root: 'fui-MenuButton',
    icon: 'fui-MenuButton__icon',
    menuIcon: 'fui-MenuButton__menuIcon'
};
const useRootExpandedStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        D0sxk3: "fxoiby5",
        t6yez3: "f15q0o9g"
    },
    outline: {
        g2u3we: "f1ly1fcm",
        h3c5rm: [
            "fi8bssc",
            "fj6btzu"
        ],
        B9xav0g: "f1s9tnsa",
        zhjwy3: [
            "fj6btzu",
            "fi8bssc"
        ],
        B4j52fo: "fgx37oo",
        Bekrc4i: [
            "f130t4y6",
            "f1efpmoh"
        ],
        Bn0qgzm: "fv51ejd",
        ibv6hh: [
            "f1efpmoh",
            "f130t4y6"
        ],
        sj55zd: "f14nttnl"
    },
    primary: {
        De3pzq: "f8w4g0q"
    },
    secondary: {
        De3pzq: "f1nfm20t",
        g2u3we: "f1ly1fcm",
        h3c5rm: [
            "fi8bssc",
            "fj6btzu"
        ],
        B9xav0g: "f1s9tnsa",
        zhjwy3: [
            "fj6btzu",
            "fi8bssc"
        ],
        sj55zd: "f14nttnl"
    },
    subtle: {
        De3pzq: "fq5gl1p",
        sj55zd: "f1eryozh"
    },
    transparent: {
        De3pzq: "f1q9pm1r",
        sj55zd: "f1qj7y59"
    }
}, {
    d: [
        ".fxoiby5 .fui-Icon-filled{display:inline;}",
        ".f15q0o9g .fui-Icon-regular{display:none;}",
        ".f1ly1fcm{border-top-color:var(--colorNeutralStroke1Selected);}",
        ".fi8bssc{border-right-color:var(--colorNeutralStroke1Selected);}",
        ".fj6btzu{border-left-color:var(--colorNeutralStroke1Selected);}",
        ".f1s9tnsa{border-bottom-color:var(--colorNeutralStroke1Selected);}",
        ".fgx37oo{border-top-width:var(--strokeWidthThicker);}",
        ".f130t4y6{border-right-width:var(--strokeWidthThicker);}",
        ".f1efpmoh{border-left-width:var(--strokeWidthThicker);}",
        ".fv51ejd{border-bottom-width:var(--strokeWidthThicker);}",
        ".f14nttnl{color:var(--colorNeutralForeground1Selected);}",
        ".f8w4g0q{background-color:var(--colorBrandBackgroundSelected);}",
        ".f1nfm20t{background-color:var(--colorNeutralBackground1Selected);}",
        ".fq5gl1p{background-color:var(--colorSubtleBackgroundSelected);}",
        ".f1eryozh{color:var(--colorNeutralForeground2Selected);}",
        ".f1q9pm1r{background-color:var(--colorTransparentBackgroundSelected);}",
        ".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}"
    ]
});
const useIconExpandedStyles = /*#__PURE__*/ (0, _react.__styles)({
    outline: {
        sj55zd: "f14nttnl"
    },
    primary: {},
    secondary: {
        sj55zd: "f14nttnl"
    },
    subtle: {
        sj55zd: "f1qj7y59"
    },
    transparent: {
        sj55zd: "f1qj7y59"
    },
    highContrast: {
        Bahaeuw: "f1v3eptx"
    }
}, {
    d: [
        ".f14nttnl{color:var(--colorNeutralForeground1Selected);}",
        ".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1v3eptx:hover{color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useMenuIconStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        Bg96gwp: "fez10in"
    },
    small: {
        Be2twd7: "f1ugzwwg",
        Bqenvij: "fvblgha",
        Bg96gwp: "fwrc4pm",
        a9b677: "frx94fk"
    },
    medium: {
        Be2twd7: "f1ugzwwg",
        Bqenvij: "fvblgha",
        Bg96gwp: "fwrc4pm",
        a9b677: "frx94fk"
    },
    large: {
        Be2twd7: "f4ybsrx",
        Bqenvij: "fd461yt",
        Bg96gwp: "faaz57k",
        a9b677: "fjw5fx7"
    },
    notIconOnly: {
        Frg6f3: [
            "fbyavb5",
            "fm0x6gh"
        ]
    }
}, {
    d: [
        ".fez10in{line-height:0;}",
        ".f1ugzwwg{font-size:12px;}",
        ".fvblgha{height:12px;}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        ".frx94fk{width:12px;}",
        ".f4ybsrx{font-size:16px;}",
        ".fd461yt{height:16px;}",
        ".faaz57k{line-height:var(--lineHeightBase400);}",
        ".fjw5fx7{width:16px;}",
        ".fbyavb5{margin-left:var(--spacingHorizontalXS);}",
        ".fm0x6gh{margin-right:var(--spacingHorizontalXS);}"
    ]
});
const useMenuButtonStyles_unstable = (state)=>{
    'use no memo';
    const rootExpandedStyles = useRootExpandedStyles();
    const iconExpandedStyles = useIconExpandedStyles();
    const menuIconStyles = useMenuIconStyles();
    state.root.className = (0, _react.mergeClasses)(menuButtonClassNames.root, state.root['aria-expanded'] && rootExpandedStyles.base, state.root['aria-expanded'] && rootExpandedStyles[state.appearance], state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(menuButtonClassNames.icon, state.root['aria-expanded'] && iconExpandedStyles[state.appearance] && iconExpandedStyles.highContrast, state.icon.className);
    }
    if (state.menuIcon) {
        state.menuIcon.className = (0, _react.mergeClasses)(menuButtonClassNames.menuIcon, menuIconStyles.base, menuIconStyles[state.size], !state.iconOnly && menuIconStyles.notIconOnly, state.menuIcon.className);
    }
    (0, _useButtonStylesstyles.useButtonStyles_unstable)({
        ...state,
        iconPosition: 'before'
    });
    return state;
};
