'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    compoundButtonClassNames: function() {
        return compoundButtonClassNames;
    },
    useCompoundButtonStyles_unstable: function() {
        return useCompoundButtonStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const _useButtonStylesstyles = require("../Button/useButtonStyles.styles");
const compoundButtonClassNames = {
    root: 'fui-CompoundButton',
    icon: 'fui-CompoundButton__icon',
    contentContainer: 'fui-CompoundButton__contentContainer',
    secondaryContent: 'fui-CompoundButton__secondaryContent'
};
const useRootStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        height: 'auto',
        [`& .${compoundButtonClassNames.secondaryContent}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        ':hover': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2Hover
            }
        },
        ':hover:active': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2Pressed
            }
        }
    },
    // High contrast styles
    highContrast: {
        '@media (forced-colors: active)': {
            ':hover': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'Highlight'
                }
            },
            ':hover:active': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'Highlight'
                }
            }
        }
    },
    // Appearance variations
    outline: {},
    primary: {
        [`& .${compoundButtonClassNames.secondaryContent}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        ':hover': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundOnBrand
            }
        },
        ':hover:active': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundOnBrand
            }
        },
        '@media (forced-colors: active)': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: 'HighlightText'
            }
        }
    },
    secondary: {},
    subtle: {
        [`& .${compoundButtonClassNames.secondaryContent}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        ':hover': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2Hover
            }
        },
        ':hover:active': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2Pressed
            }
        },
        '@media (forced-colors: active)': {
            ':hover': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'Canvas'
                }
            },
            ':hover:active': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'Canvas'
                }
            }
        }
    },
    transparent: {
        [`& .${compoundButtonClassNames.secondaryContent}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        ':hover': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2BrandHover
            }
        },
        ':hover:active': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2BrandPressed
            }
        }
    },
    // Size variations
    small: {
        padding: `${_reacttheme.tokens.spacingHorizontalS} ${_reacttheme.tokens.spacingHorizontalS} ${_reacttheme.tokens.spacingHorizontalMNudge} ${_reacttheme.tokens.spacingHorizontalS}`,
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300
    },
    medium: {
        padding: `14px ${_reacttheme.tokens.spacingHorizontalM} ${_reacttheme.tokens.spacingHorizontalL} ${_reacttheme.tokens.spacingHorizontalM}`,
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300
    },
    large: {
        padding: `18px ${_reacttheme.tokens.spacingHorizontalL} ${_reacttheme.tokens.spacingHorizontalXL} ${_reacttheme.tokens.spacingHorizontalL}`,
        fontSize: _reacttheme.tokens.fontSizeBase400,
        lineHeight: _reacttheme.tokens.lineHeightBase400
    },
    // Disabled styles
    disabled: {
        [`& .${compoundButtonClassNames.secondaryContent}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        ':hover': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        },
        ':hover:active': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        }
    },
    // Disabled high contrast styles
    disabledHighContrast: {
        '@media (forced-colors: active)': {
            [`& .${compoundButtonClassNames.secondaryContent}`]: {
                color: 'GrayText'
            },
            ':hover': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'GrayText'
                }
            },
            ':hover:active': {
                [`& .${compoundButtonClassNames.secondaryContent}`]: {
                    color: 'GrayText'
                }
            }
        }
    }
});
const useRootIconOnlyStyles = (0, _react.makeStyles)({
    // Size variations
    small: {
        padding: _reacttheme.tokens.spacingHorizontalXS,
        maxWidth: '48px',
        minWidth: '48px'
    },
    medium: {
        padding: _reacttheme.tokens.spacingHorizontalSNudge,
        maxWidth: '52px',
        minWidth: '52px'
    },
    large: {
        padding: _reacttheme.tokens.spacingHorizontalS,
        maxWidth: '56px',
        minWidth: '56px'
    }
});
const useIconStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        fontSize: '40px',
        height: '40px',
        width: '40px'
    },
    // Icon position variations
    before: {
        marginRight: _reacttheme.tokens.spacingHorizontalM
    },
    after: {
        marginLeft: _reacttheme.tokens.spacingHorizontalM
    }
});
const useContentContainerStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        display: 'flex',
        flexDirection: 'column',
        textAlign: 'left'
    }
});
const useSecondaryContentStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        lineHeight: '100%',
        fontWeight: _reacttheme.tokens.fontWeightRegular
    },
    // Size variations
    small: {
        fontSize: _reacttheme.tokens.fontSizeBase200
    },
    medium: {
        fontSize: _reacttheme.tokens.fontSizeBase200
    },
    large: {
        fontSize: _reacttheme.tokens.fontSizeBase300
    }
});
const useCompoundButtonStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const rootIconOnlyStyles = useRootIconOnlyStyles();
    const iconStyles = useIconStyles();
    const contentContainerStyles = useContentContainerStyles();
    const secondaryContentStyles = useSecondaryContentStyles();
    const { appearance, disabled, disabledFocusable, iconOnly, iconPosition, size } = state;
    state.root.className = (0, _react.mergeClasses)(compoundButtonClassNames.root, rootStyles.base, rootStyles.highContrast, appearance && rootStyles[appearance], rootStyles[size], (disabled || disabledFocusable) && rootStyles.disabled, (disabled || disabledFocusable) && rootStyles.disabledHighContrast, iconOnly && rootIconOnlyStyles[size], state.root.className);
    state.contentContainer.className = (0, _react.mergeClasses)(compoundButtonClassNames.contentContainer, contentContainerStyles.base, state.contentContainer.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(compoundButtonClassNames.icon, iconStyles.base, state.root.children !== undefined && state.root.children !== null && iconStyles[iconPosition], state.icon.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(compoundButtonClassNames.secondaryContent, secondaryContentStyles.base, secondaryContentStyles[size], state.secondaryContent.className);
    }
    (0, _useButtonStylesstyles.useButtonStyles_unstable)(state);
    return state;
};
