'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCompoundButton_unstable", {
    enumerable: true,
    get: function() {
        return useCompoundButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _index = require("../Button/index");
const useCompoundButton_unstable = ({ contentContainer, secondaryContent, ...props }, ref)=>{
    var _state_icon, _state_secondaryContent;
    const state = {
        // Button state
        ...(0, _index.useButton_unstable)(props, ref),
        // Slots definition
        components: {
            root: 'button',
            icon: 'span',
            contentContainer: 'span',
            secondaryContent: 'span'
        },
        contentContainer: _reactutilities.slot.always(contentContainer, {
            elementType: 'span'
        }),
        secondaryContent: _reactutilities.slot.optional(secondaryContent, {
            elementType: 'span'
        })
    };
    // Recalculate iconOnly to take into account secondaryContent.
    state.iconOnly = Boolean(((_state_icon = state.icon) === null || _state_icon === void 0 ? void 0 : _state_icon.children) && !props.children && !((_state_secondaryContent = state.secondaryContent) === null || _state_secondaryContent === void 0 ? void 0 : _state_secondaryContent.children));
    return state;
};
