'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buttonClassNames: function() {
        return buttonClassNames;
    },
    useButtonStyles_unstable: function() {
        return useButtonStyles_unstable;
    }
});
const _reacticons = require("@fluentui/react-icons");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const buttonClassNames = {
    root: 'fui-Button',
    icon: 'fui-Button__icon'
};
const iconSpacingVar = '--fui-Button__icon--spacing';
const buttonSpacingSmall = '3px';
const buttonSpacingSmallWithIcon = '1px';
const buttonSpacingMedium = '5px';
const buttonSpacingLarge = '8px';
const buttonSpacingLargeWithIcon = '7px';
/* Firefox has box shadow sizing issue at some zoom levels
 * this will ensure the inset boxShadow is always uniform
 * without affecting other browser platforms
 */ const boxShadowStrokeWidthThinMoz = `calc(${_reacttheme.tokens.strokeWidthThin} + 0.25px)`;
const useRootBaseClassName = (0, _react.makeResetStyles)({
    alignItems: 'center',
    boxSizing: 'border-box',
    display: 'inline-flex',
    justifyContent: 'center',
    textDecorationLine: 'none',
    verticalAlign: 'middle',
    margin: 0,
    overflow: 'hidden',
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
    color: _reacttheme.tokens.colorNeutralForeground1,
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
    fontFamily: _reacttheme.tokens.fontFamilyBase,
    outlineStyle: 'none',
    ':hover': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Hover,
        borderColor: _reacttheme.tokens.colorNeutralStroke1Hover,
        color: _reacttheme.tokens.colorNeutralForeground1Hover,
        cursor: 'pointer'
    },
    ':hover:active': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Pressed,
        borderColor: _reacttheme.tokens.colorNeutralStroke1Pressed,
        color: _reacttheme.tokens.colorNeutralForeground1Pressed,
        outlineStyle: 'none'
    },
    padding: `${buttonSpacingMedium} ${_reacttheme.tokens.spacingHorizontalM}`,
    minWidth: '96px',
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    fontSize: _reacttheme.tokens.fontSizeBase300,
    fontWeight: _reacttheme.tokens.fontWeightSemibold,
    lineHeight: _reacttheme.tokens.lineHeightBase300,
    // Transition styles
    transitionDuration: _reacttheme.tokens.durationFaster,
    transitionProperty: 'background, border, color',
    transitionTimingFunction: _reacttheme.tokens.curveEasyEase,
    '@media screen and (prefers-reduced-motion: reduce)': {
        transitionDuration: '0.01ms'
    },
    // High contrast styles
    '@media (forced-colors: active)': {
        ':focus': {
            borderColor: 'ButtonText'
        },
        ':hover': {
            backgroundColor: 'HighlightText',
            borderColor: 'Highlight',
            color: 'Highlight',
            forcedColorAdjust: 'none'
        },
        ':hover:active': {
            backgroundColor: 'HighlightText',
            borderColor: 'Highlight',
            color: 'Highlight',
            forcedColorAdjust: 'none'
        }
    },
    // Focus styles
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderColor: _reacttheme.tokens.colorStrokeFocus2,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        borderWidth: '1px',
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        boxShadow: `0 0 0 ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorStrokeFocus2}
      inset
    `,
        zIndex: 1
    }),
    // BUGFIX: Mozilla specific styles (Mozilla BugID: 1857642)
    '@supports (-moz-appearance:button)': {
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            boxShadow: `0 0 0 ${boxShadowStrokeWidthThinMoz} ${_reacttheme.tokens.colorStrokeFocus2}
      inset
    `
        })
    }
});
const useIconBaseClassName = (0, _react.makeResetStyles)({
    alignItems: 'center',
    display: 'inline-flex',
    justifyContent: 'center',
    fontSize: '20px',
    height: '20px',
    width: '20px',
    [iconSpacingVar]: _reacttheme.tokens.spacingHorizontalSNudge
});
const useRootStyles = (0, _react.makeStyles)({
    // Appearance variations
    outline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundHover
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundPressed
        }
    },
    primary: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground,
        ..._react.shorthands.borderColor('transparent'),
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundHover,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundPressed,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        '@media (forced-colors: active)': {
            backgroundColor: 'Highlight',
            ..._react.shorthands.borderColor('HighlightText'),
            color: 'HighlightText',
            forcedColorAdjust: 'none',
            ':hover': {
                backgroundColor: 'HighlightText',
                ..._react.shorthands.borderColor('Highlight'),
                color: 'Highlight'
            },
            ':hover:active': {
                backgroundColor: 'HighlightText',
                ..._react.shorthands.borderColor('Highlight'),
                color: 'Highlight'
            }
        }
    },
    secondary: {},
    subtle: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        ..._react.shorthands.borderColor('transparent'),
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForeground2Hover,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            },
            [`& .${buttonClassNames.icon}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2BrandHover
            }
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForeground2Pressed,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            },
            [`& .${buttonClassNames.icon}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2BrandPressed
            }
        },
        '@media (forced-colors: active)': {
            ':hover': {
                color: 'Highlight',
                [`& .${buttonClassNames.icon}`]: {
                    color: 'Highlight'
                }
            },
            ':hover:active': {
                color: 'Highlight',
                [`& .${buttonClassNames.icon}`]: {
                    color: 'Highlight'
                }
            }
        }
    },
    transparent: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor('transparent'),
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundHover,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForeground2BrandHover,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            }
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundPressed,
            ..._react.shorthands.borderColor('transparent'),
            color: _reacttheme.tokens.colorNeutralForeground2BrandPressed,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            }
        },
        '@media (forced-colors: active)': {
            ':hover': {
                backgroundColor: _reacttheme.tokens.colorTransparentBackground,
                color: 'Highlight'
            },
            ':hover:active': {
                backgroundColor: _reacttheme.tokens.colorTransparentBackground,
                color: 'Highlight'
            }
        }
    },
    // Shape variations
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular
    },
    rounded: {},
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone
    },
    // Size variations
    small: {
        minWidth: '64px',
        padding: `${buttonSpacingSmall} ${_reacttheme.tokens.spacingHorizontalS}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        fontSize: _reacttheme.tokens.fontSizeBase200,
        fontWeight: _reacttheme.tokens.fontWeightRegular,
        lineHeight: _reacttheme.tokens.lineHeightBase200
    },
    smallWithIcon: {
        paddingBottom: buttonSpacingSmallWithIcon,
        paddingTop: buttonSpacingSmallWithIcon
    },
    medium: {},
    large: {
        minWidth: '96px',
        padding: `${buttonSpacingLarge} ${_reacttheme.tokens.spacingHorizontalL}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        fontSize: _reacttheme.tokens.fontSizeBase400,
        fontWeight: _reacttheme.tokens.fontWeightSemibold,
        lineHeight: _reacttheme.tokens.lineHeightBase400
    },
    largeWithIcon: {
        paddingBottom: buttonSpacingLargeWithIcon,
        paddingTop: buttonSpacingLargeWithIcon
    }
});
const useRootDisabledStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed',
        [`& .${buttonClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            cursor: 'not-allowed',
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'none'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'inline'
            },
            [`& .${buttonClassNames.icon}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            cursor: 'not-allowed',
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'none'
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'inline'
            },
            [`& .${buttonClassNames.icon}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundDisabled
            }
        }
    },
    // High contrast styles
    highContrast: {
        '@media (forced-colors: active)': {
            backgroundColor: 'ButtonFace',
            ..._react.shorthands.borderColor('GrayText'),
            color: 'GrayText',
            [`& .${buttonClassNames.icon}`]: {
                color: 'GrayText'
            },
            ':focus': {
                ..._react.shorthands.borderColor('GrayText')
            },
            ':hover': {
                backgroundColor: 'ButtonFace',
                ..._react.shorthands.borderColor('GrayText'),
                color: 'GrayText',
                [`& .${buttonClassNames.icon}`]: {
                    color: 'GrayText'
                }
            },
            ':hover:active': {
                backgroundColor: 'ButtonFace',
                ..._react.shorthands.borderColor('GrayText'),
                color: 'GrayText',
                [`& .${buttonClassNames.icon}`]: {
                    color: 'GrayText'
                }
            }
        }
    },
    // Appearance variations
    outline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground
        }
    },
    primary: {
        ..._react.shorthands.borderColor('transparent'),
        ':hover': {
            ..._react.shorthands.borderColor('transparent')
        },
        ':hover:active': {
            ..._react.shorthands.borderColor('transparent')
        }
    },
    secondary: {},
    subtle: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor('transparent'),
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            ..._react.shorthands.borderColor('transparent')
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            ..._react.shorthands.borderColor('transparent')
        }
    },
    transparent: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor('transparent'),
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            ..._react.shorthands.borderColor('transparent')
        },
        ':hover:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            ..._react.shorthands.borderColor('transparent')
        }
    }
});
const useRootFocusStyles = (0, _react.makeStyles)({
    // Shape variations
    circular: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusCircular
    }),
    rounded: {},
    square: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusNone
    }),
    // Primary styles
    primary: {
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorStrokeFocus2),
            boxShadow: `${_reacttheme.tokens.shadow2}, 0 0 0 ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorStrokeFocus2} inset,  0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorNeutralForegroundOnBrand} inset`,
            ':hover': {
                boxShadow: `${_reacttheme.tokens.shadow2}, 0 0 0 ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorStrokeFocus2} inset`,
                ..._react.shorthands.borderColor(_reacttheme.tokens.colorStrokeFocus2)
            }
        }),
        // BUGFIX: Mozilla specific styles (Mozilla BugID: 1857642)
        '@supports (-moz-appearance:button)': {
            ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
                boxShadow: `${_reacttheme.tokens.shadow2}, 0 0 0 ${boxShadowStrokeWidthThinMoz} ${_reacttheme.tokens.colorStrokeFocus2} inset,  0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorNeutralForegroundOnBrand} inset`,
                ':hover': {
                    boxShadow: `${_reacttheme.tokens.shadow2}, 0 0 0 ${boxShadowStrokeWidthThinMoz} ${_reacttheme.tokens.colorStrokeFocus2} inset`
                }
            })
        }
    },
    // Size variations
    small: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusSmall
    }),
    medium: {},
    large: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusLarge
    })
});
const useRootIconOnlyStyles = (0, _react.makeStyles)({
    // Size variations
    small: {
        padding: buttonSpacingSmallWithIcon,
        minWidth: '24px',
        maxWidth: '24px'
    },
    medium: {
        padding: buttonSpacingMedium,
        minWidth: '32px',
        maxWidth: '32px'
    },
    large: {
        padding: buttonSpacingLargeWithIcon,
        minWidth: '40px',
        maxWidth: '40px'
    }
});
const useIconStyles = (0, _react.makeStyles)({
    // Size variations
    small: {
        fontSize: '20px',
        height: '20px',
        width: '20px',
        [iconSpacingVar]: _reacttheme.tokens.spacingHorizontalXS
    },
    medium: {},
    large: {
        fontSize: '24px',
        height: '24px',
        width: '24px',
        [iconSpacingVar]: _reacttheme.tokens.spacingHorizontalSNudge
    },
    // Icon position variations
    before: {
        marginRight: `var(${iconSpacingVar})`
    },
    after: {
        marginLeft: `var(${iconSpacingVar})`
    }
});
const useButtonStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const iconBaseClassName = useIconBaseClassName();
    const rootStyles = useRootStyles();
    const rootDisabledStyles = useRootDisabledStyles();
    const rootFocusStyles = useRootFocusStyles();
    const rootIconOnlyStyles = useRootIconOnlyStyles();
    const iconStyles = useIconStyles();
    const { appearance, disabled, disabledFocusable, icon, iconOnly, iconPosition, shape, size } = state;
    state.root.className = (0, _react.mergeClasses)(buttonClassNames.root, rootBaseClassName, appearance && rootStyles[appearance], rootStyles[size], icon && size === 'small' && rootStyles.smallWithIcon, icon && size === 'large' && rootStyles.largeWithIcon, rootStyles[shape], (disabled || disabledFocusable) && rootDisabledStyles.base, (disabled || disabledFocusable) && rootDisabledStyles.highContrast, appearance && (disabled || disabledFocusable) && rootDisabledStyles[appearance], appearance === 'primary' && rootFocusStyles.primary, rootFocusStyles[size], rootFocusStyles[shape], iconOnly && rootIconOnlyStyles[size], state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(buttonClassNames.icon, iconBaseClassName, !!state.root.children && iconStyles[iconPosition], iconStyles[size], state.icon.className);
    }
    return state;
};
