'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useButton_unstable", {
    enumerable: true,
    get: function() {
        return useButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactaria = require("@fluentui/react-aria");
const _reactutilities = require("@fluentui/react-utilities");
const _ButtonContext = require("../../contexts/ButtonContext");
const useButton_unstable = (props, ref)=>{
    const { size: contextSize } = (0, _ButtonContext.useButtonContext)();
    const { appearance = 'secondary', as = 'button', disabled = false, disabledFocusable = false, icon, iconPosition = 'before', shape = 'rounded', size = contextSize !== null && contextSize !== void 0 ? contextSize : 'medium' } = props;
    const iconShorthand = _reactutilities.slot.optional(icon, {
        elementType: 'span'
    });
    return {
        // Props passed at the top-level
        appearance,
        disabled,
        disabledFocusable,
        iconPosition,
        shape,
        size,
        iconOnly: Boolean((iconShorthand === null || iconShorthand === void 0 ? void 0 : iconShorthand.children) && !props.children),
        components: {
            root: 'button',
            icon: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(as, (0, _reactaria.useARIAButtonProps)(props.as, props)), {
            elementType: 'button',
            defaultProps: {
                ref: ref,
                type: as === 'button' ? 'button' : undefined
            }
        }),
        icon: iconShorthand
    };
};
