'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot } from '@fluentui/react-utilities';
import { useBreadcrumbContext_unstable } from '../Breadcrumb/BreadcrumbContext';
/**
 * Create the state required to render BreadcrumbItem.
 *
 * The returned state can be modified with hooks such as useBreadcrumbItemStyles_unstable,
 * before being passed to renderBreadcrumbItem_unstable.
 *
 * @param props - props from this instance of BreadcrumbItem
 * @param ref - reference to root HTMLElement of BreadcrumbItem
 */ export const useBreadcrumbItem_unstable = (props, ref)=>{
    const { size } = useBreadcrumbContext_unstable();
    return {
        components: {
            root: 'li'
        },
        root: slot.always(getIntrinsicElementProps('li', {
            ref,
            ...props
        }), {
            elementType: 'li'
        }),
        size
    };
};
