'use client';

import { __styles, __resetStyles, mergeClasses } from '@griffel/react';
export const breadcrumbDividerClassNames = {
  root: 'fui-BreadcrumbDivider'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__resetStyles("rk008qs", null, [".rk008qs{display:flex;}"]);
const useIconStyles = /*#__PURE__*/__styles({
  small: {
    Be2twd7: "f1ugzwwg"
  },
  medium: {
    Be2twd7: "f4ybsrx"
  },
  large: {
    Be2twd7: "fe5j1ua"
  }
}, {
  d: [".f1ugzwwg{font-size:12px;}", ".f4ybsrx{font-size:16px;}", ".fe5j1ua{font-size:20px;}"]
});
/**
 * Apply styling to the BreadcrumbDivider slots based on the state
 */
export const useBreadcrumbDividerStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const iconStyles = useIconStyles();
  const {
    size = 'medium'
  } = state;
  state.root.className = mergeClasses(breadcrumbDividerClassNames.root, styles, iconStyles[size], state.root.className);
  return state;
};