'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { useButtonStyles_unstable, buttonClassNames } from '@fluentui/react-button';
import { tokens, typographyStyles } from '@fluentui/react-theme';
import { iconFilledClassName, iconRegularClassName } from '@fluentui/react-icons';
/**
 * Static CSS class names used internally for the component slots.
 */
export const breadcrumbButtonClassNames = {
  root: 'fui-BreadcrumbButton',
  icon: 'fui-BreadcrumbButton__icon'
};
/**
 * CSS variable names used internally for styling in the Breadcrumb.
 */
const breadcrumbCSSVars = {
  breadcrumbIconSizeVar: '--fui-Breadcrumb--icon-size',
  breadcrumbIconLineHeightVar: '--fui-Breadcrumb--icon-line-height'
};
const useIconStyles = /*#__PURE__*/__styles({
  base: {
    Be2twd7: "fsj74e5",
    Bqenvij: "f1qfv4wv",
    Bg96gwp: "f15xapk4",
    a9b677: "f17j33op",
    t21cq0: ["fm0x6gh", "fbyavb5"]
  },
  small: {
    u3h8gg: "f1qfi7kw",
    Biu6dll: "f1876atl"
  },
  medium: {
    u3h8gg: "f1h9446d",
    Biu6dll: "f10xfswh"
  },
  large: {
    u3h8gg: "f5hcofs",
    Biu6dll: "f1a6v6zl"
  }
}, {
  d: [".fsj74e5{font-size:var(--fui-Breadcrumb--icon-size);}", ".f1qfv4wv{height:var(--fui-Breadcrumb--icon-size);}", ".f15xapk4{line-height:var(--fui-Breadcrumb--icon-line-height);}", ".f17j33op{width:var(--fui-Breadcrumb--icon-size);}", ".fm0x6gh{margin-right:var(--spacingHorizontalXS);}", ".fbyavb5{margin-left:var(--spacingHorizontalXS);}", ".f1qfi7kw{--fui-Breadcrumb--icon-size:12px;}", ".f1876atl{--fui-Breadcrumb--icon-line-height:var(--lineHeightBase200);}", ".f1h9446d{--fui-Breadcrumb--icon-size:16px;}", ".f10xfswh{--fui-Breadcrumb--icon-line-height:var(--lineHeightBase400);}", ".f5hcofs{--fui-Breadcrumb--icon-size:20px;}", ".f1a6v6zl{--fui-Breadcrumb--icon-line-height:var(--lineHeightBase600);}"]
});
const defaultButtonStyles = {
  backgroundColor: tokens.colorTransparentBackground,
  color: tokens.colorNeutralForeground2,
  cursor: 'auto'
};
const currentIconStyles = {
  ...defaultButtonStyles,
  [`& .${buttonClassNames.icon}`]: {
    color: 'unset'
  },
  [`& .${iconFilledClassName}`]: {
    display: 'none'
  },
  [`& .${iconRegularClassName}`]: {
    display: 'inline'
  }
};
const useStyles = /*#__PURE__*/__styles({
  root: {
    Bf4jedk: "f18p0k4z",
    j4b8c3: "fv6wr3j"
  },
  small: {
    Bqenvij: "frvgh55",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bhrd7zp: "figsok6",
    Bg96gwp: "fwrc4pm",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1r1wyb6"
  },
  medium: {
    Bqenvij: "f1d2rq10",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "figsok6",
    Bg96gwp: "f1i3iumi",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1r1wyb6"
  },
  large: {
    Bqenvij: "fbhnoac",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "figsok6",
    Bg96gwp: "faaz57k",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1bnz8pu"
  },
  current: {
    Jwef8y: "f9ql6rf",
    Bi91k9c: "f3p8bqa",
    eoavqd: "f14w7a5u",
    Bbdnnc7: "f1irjp3o",
    Bk3fhr4: "f19vpps7",
    Bmfj8id: "fv5swzo",
    iro3zm: "f3h1zc4",
    B2d53fq: "f1xkgyln",
    c3iz72: "f17wbbfx",
    x3br3k: "fofxw0a",
    em6i61: "f1ol4fw6",
    vm6p8p: "f1q1lw4e",
    Bszkowt: "ff24m",
    Dyrjrp: "ft5r8e9",
    ezr58z: "f1cbpfqp",
    nhk3du: "f1motppv",
    Bfrek18: "fi9vkhg",
    G209fr: "f1fg3nnv"
  },
  currentSmall: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "fwrc4pm"
  },
  currentMedium: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "f1i3iumi"
  },
  currentLarge: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "faaz57k"
  }
}, {
  d: [".f18p0k4z{min-width:unset;}", ".fv6wr3j{text-wrap:nowrap;}", ".frvgh55{height:24px;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fy9rknc{font-size:var(--fontSizeBase200);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".fwrc4pm{line-height:var(--lineHeightBase200);}", [".f1r1wyb6{padding:var(--spacingHorizontalSNudge);}", {
    p: -1
  }], ".f1d2rq10{height:32px;}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", [".f1r1wyb6{padding:var(--spacingHorizontalSNudge);}", {
    p: -1
  }], ".fbhnoac{height:40px;}", ".fod5ikn{font-size:var(--fontSizeBase400);}", ".faaz57k{line-height:var(--lineHeightBase400);}", [".f1bnz8pu{padding:var(--spacingHorizontalS);}", {
    p: -1
  }], ".ff24m:disabled{background-color:var(--colorTransparentBackground);}", ".ft5r8e9:disabled{color:var(--colorNeutralForeground2);}", ".f1cbpfqp:disabled{cursor:auto;}", ".f1motppv:disabled .fui-Button__icon{color:unset;}", ".fi9vkhg:disabled .fui-Icon-filled{display:none;}", ".f1fg3nnv:disabled .fui-Icon-regular{display:inline;}", ".fl43uef{font-weight:var(--fontWeightSemibold);}"],
  h: [".f9ql6rf:hover{background-color:var(--colorTransparentBackground);}", ".f3p8bqa:hover{color:var(--colorNeutralForeground2);}", ".f14w7a5u:hover{cursor:auto;}", ".f1irjp3o:hover .fui-Button__icon{color:unset;}", ".f19vpps7:hover .fui-Icon-filled{display:none;}", ".fv5swzo:hover .fui-Icon-regular{display:inline;}", ".f3h1zc4:hover:active{background-color:var(--colorTransparentBackground);}", ".f1xkgyln:hover:active{color:var(--colorNeutralForeground2);}", ".f17wbbfx:hover:active{cursor:auto;}", ".fofxw0a:hover:active .fui-Button__icon{color:unset;}", ".f1ol4fw6:hover:active .fui-Icon-filled{display:none;}", ".f1q1lw4e:hover:active .fui-Icon-regular{display:inline;}"]
});
/**
 * Apply styling to the BreadcrumbButton slots based on the state
 */
export const useBreadcrumbButtonStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const iconStyles = useIconStyles();
  const currentSizeMap = {
    small: styles.currentSmall,
    medium: styles.currentMedium,
    large: styles.currentLarge
  };
  state.root.className = mergeClasses(breadcrumbButtonClassNames.root, styles[state.size], styles.root, state.current && currentSizeMap[state.size], state.current && styles.current, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(iconStyles.base, iconStyles[state.size], state.icon.className);
  }
  useButtonStyles_unstable(state);
  return state;
};