'use client';
import * as React from 'react';
import { useButton_unstable } from '@fluentui/react-button';
import { useBreadcrumbContext_unstable } from '../Breadcrumb/BreadcrumbContext';
/**
 * Create the state required to render BreadcrumbButton.
 *
 * The returned state can be modified with hooks such as useBreadcrumbButtonStyles_unstable,
 * before being passed to renderBreadcrumbButton_unstable.
 *
 * @param props - props from this instance of BreadcrumbButton
 * @param ref - reference to root HTMLElement of BreadcrumbButton
 */ export const useBreadcrumbButton_unstable = (props, ref)=>{
    const { size } = useBreadcrumbContext_unstable();
    const { current = false, as, ...rest } = props;
    const controlType = (as !== null && as !== void 0 ? as : props.href) ? 'a' : 'button';
    var _props_ariacurrent, _props_ariadisabled;
    return {
        ...useButton_unstable({
            appearance: 'subtle',
            role: undefined,
            type: undefined,
            as: controlType,
            iconPosition: 'before',
            'aria-current': current ? (_props_ariacurrent = props['aria-current']) !== null && _props_ariacurrent !== void 0 ? _props_ariacurrent : 'page' : undefined,
            'aria-disabled': current ? (_props_ariadisabled = props['aria-disabled']) !== null && _props_ariadisabled !== void 0 ? _props_ariadisabled : true : undefined,
            ...rest
        }, ref),
        current,
        size
    };
};
