'use client';
import * as React from 'react';
import { useBreadcrumbButton_unstable } from './useBreadcrumbButton';
import { renderBreadcrumbButton_unstable } from './renderBreadcrumbButton';
import { useBreadcrumbButtonStyles_unstable } from './useBreadcrumbButtonStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * A button component which is used inside the Breadcrumb.
 */ export const BreadcrumbButton = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useBreadcrumbButton_unstable(props, ref);
    useBreadcrumbButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useBreadcrumbButtonStyles_unstable')(state);
    return renderBreadcrumbButton_unstable(state);
});
BreadcrumbButton.displayName = 'BreadcrumbButton';
