'use client';

import { __resetStyles, mergeClasses } from '@griffel/react';
export const breadcrumbClassNames = {
  root: 'fui-Breadcrumb',
  list: 'fui-Breadcrumb__list'
};
const useListClassName = /*#__PURE__*/__resetStyles("rc5rb6b", null, [".rc5rb6b{list-style-type:none;display:flex;align-items:center;margin:0;padding:0;}"]);
/**
 * Apply styling to the Breadcrumb slots based on the state
 */
export const useBreadcrumbStyles_unstable = state => {
  'use no memo';

  const listBaseClassName = useListClassName();
  state.root.className = mergeClasses(breadcrumbClassNames.root, state.root.className);
  if (state.list) {
    state.list.className = mergeClasses(listBaseClassName, breadcrumbClassNames.list, state.list.className);
  }
  return state;
};