"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    isTruncatableBreadcrumbContent: function() {
        return isTruncatableBreadcrumbContent;
    },
    truncateBreadcrumLongTooltip: function() {
        return truncateBreadcrumLongTooltip;
    },
    truncateBreadcrumbLongName: function() {
        return truncateBreadcrumbLongName;
    }
});
const MAX_NAME_LENGTH = 30;
const MAX_TOOLTIP_LENGTH = 80;
const truncateBreadcrumb = (content, maxLength)=>{
    return isTruncatableBreadcrumbContent(content, maxLength) ? content.trim().slice(0, maxLength).concat('...') : content;
};
const isTruncatableBreadcrumbContent = (content, maxLength)=>{
    return content.length > maxLength;
};
const truncateBreadcrumbLongName = (content, maxLength)=>{
    const truncateLength = maxLength || MAX_NAME_LENGTH;
    return truncateBreadcrumb(content, truncateLength);
};
const truncateBreadcrumLongTooltip = (content, maxLength)=>{
    const truncateLength = maxLength || MAX_TOOLTIP_LENGTH;
    return truncateBreadcrumb(content, truncateLength);
};
