'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    breadcrumbDividerClassNames: function() {
        return breadcrumbDividerClassNames;
    },
    useBreadcrumbDividerStyles_unstable: function() {
        return useBreadcrumbDividerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const breadcrumbDividerClassNames = {
    root: 'fui-BreadcrumbDivider'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    display: 'flex'
});
const useIconStyles = (0, _react.makeStyles)({
    small: {
        fontSize: '12px'
    },
    medium: {
        fontSize: '16px'
    },
    large: {
        fontSize: '20px'
    }
});
const useBreadcrumbDividerStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const { size = 'medium' } = state;
    state.root.className = (0, _react.mergeClasses)(breadcrumbDividerClassNames.root, styles, iconStyles[size], state.root.className);
    return state;
};
