'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useBreadcrumbDivider_unstable", {
    enumerable: true,
    get: function() {
        return useBreadcrumbDivider_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacticons = require("@fluentui/react-icons");
const _BreadcrumbContext = require("../Breadcrumb/BreadcrumbContext");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const useBreadcrumbDivider_unstable = (props, ref)=>{
    const { size } = (0, _BreadcrumbContext.useBreadcrumbContext_unstable)();
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const icon = getDividerIcon(dir);
    return {
        components: {
            root: 'li'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('li', {
            ref,
            'aria-hidden': true,
            children: icon,
            ...props
        }), {
            elementType: 'li'
        }),
        size
    };
};
/**
 * Get icon of the divider
 *
 * @param dir - RTL or LTR
 */ function getDividerIcon(dir) {
    return dir === 'rtl' ? /*#__PURE__*/ _react.createElement(_reacticons.ChevronLeftRegular, null) : /*#__PURE__*/ _react.createElement(_reacticons.ChevronRightRegular, null);
}
