'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    breadcrumbButtonClassNames: function() {
        return breadcrumbButtonClassNames;
    },
    useBreadcrumbButtonStyles_unstable: function() {
        return useBreadcrumbButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactbutton = require("@fluentui/react-button");
const _reacttheme = require("@fluentui/react-theme");
const _reacticons = require("@fluentui/react-icons");
const breadcrumbButtonClassNames = {
    root: 'fui-BreadcrumbButton',
    icon: 'fui-BreadcrumbButton__icon'
};
/**
 * CSS variable names used internally for styling in the Breadcrumb.
 */ const breadcrumbCSSVars = {
    breadcrumbIconSizeVar: '--fui-Breadcrumb--icon-size',
    breadcrumbIconLineHeightVar: '--fui-Breadcrumb--icon-line-height'
};
const useIconStyles = (0, _react.makeStyles)({
    base: {
        fontSize: `var(${breadcrumbCSSVars.breadcrumbIconSizeVar})`,
        height: `var(${breadcrumbCSSVars.breadcrumbIconSizeVar})`,
        lineHeight: `var(${breadcrumbCSSVars.breadcrumbIconLineHeightVar})`,
        width: `var(${breadcrumbCSSVars.breadcrumbIconSizeVar})`,
        marginRight: _reacttheme.tokens.spacingHorizontalXS
    },
    small: {
        [breadcrumbCSSVars.breadcrumbIconSizeVar]: '12px',
        [breadcrumbCSSVars.breadcrumbIconLineHeightVar]: _reacttheme.tokens.lineHeightBase200
    },
    medium: {
        [breadcrumbCSSVars.breadcrumbIconSizeVar]: '16px',
        [breadcrumbCSSVars.breadcrumbIconLineHeightVar]: _reacttheme.tokens.lineHeightBase400
    },
    large: {
        [breadcrumbCSSVars.breadcrumbIconSizeVar]: '20px',
        [breadcrumbCSSVars.breadcrumbIconLineHeightVar]: _reacttheme.tokens.lineHeightBase600
    }
});
const defaultButtonStyles = {
    backgroundColor: _reacttheme.tokens.colorTransparentBackground,
    color: _reacttheme.tokens.colorNeutralForeground2,
    cursor: 'auto'
};
const currentIconStyles = {
    ...defaultButtonStyles,
    [`& .${_reactbutton.buttonClassNames.icon}`]: {
        color: 'unset'
    },
    [`& .${_reacticons.iconFilledClassName}`]: {
        display: 'none'
    },
    [`& .${_reacticons.iconRegularClassName}`]: {
        display: 'inline'
    }
};
const useStyles = (0, _react.makeStyles)({
    root: {
        minWidth: 'unset',
        textWrap: 'nowrap'
    },
    small: {
        height: '24px',
        ..._reacttheme.typographyStyles.caption1,
        padding: _reacttheme.tokens.spacingHorizontalSNudge
    },
    medium: {
        height: '32px',
        ..._reacttheme.typographyStyles.body1,
        padding: _reacttheme.tokens.spacingHorizontalSNudge
    },
    large: {
        height: '40px',
        ..._reacttheme.typographyStyles.body2,
        padding: _reacttheme.tokens.spacingHorizontalS
    },
    current: {
        ':hover': {
            ...currentIconStyles
        },
        ':hover:active': {
            ...currentIconStyles
        },
        ':disabled': {
            ...currentIconStyles
        }
    },
    currentSmall: {
        ..._reacttheme.typographyStyles.caption1Strong
    },
    currentMedium: {
        ..._reacttheme.typographyStyles.body1Strong
    },
    currentLarge: {
        ..._reacttheme.typographyStyles.subtitle2
    }
});
const useBreadcrumbButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const currentSizeMap = {
        small: styles.currentSmall,
        medium: styles.currentMedium,
        large: styles.currentLarge
    };
    state.root.className = (0, _react.mergeClasses)(breadcrumbButtonClassNames.root, styles[state.size], styles.root, state.current && currentSizeMap[state.size], state.current && styles.current, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(iconStyles.base, iconStyles[state.size], state.icon.className);
    }
    (0, _reactbutton.useButtonStyles_unstable)(state);
    return state;
};
