'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useBreadcrumb_unstable", {
    enumerable: true,
    get: function() {
        return useBreadcrumb_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const useBreadcrumb_unstable = (props, ref)=>{
    const { focusMode = 'tab', size = 'medium', list, ...rest } = props;
    const focusAttributes = (0, _reacttabster.useArrowNavigationGroup)({
        circular: true,
        axis: 'horizontal',
        memorizeCurrent: true
    });
    var _props_arialabel;
    return {
        components: {
            root: 'nav',
            list: 'ol'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('nav', {
            ref,
            'aria-label': (_props_arialabel = props['aria-label']) !== null && _props_arialabel !== void 0 ? _props_arialabel : 'breadcrumb',
            ...focusMode === 'arrow' ? focusAttributes : {},
            ...rest
        }), {
            elementType: 'nav'
        }),
        list: _reactutilities.slot.optional(list, {
            renderByDefault: true,
            defaultProps: {
                role: 'list'
            },
            elementType: 'ol'
        }),
        size
    };
};
