'use client';
import * as React from 'react';
import { useBadge_unstable } from '../Badge/index';
/**
 * Returns the props and state required to render the component
 */ export const useCounterBadge_unstable = (props, ref)=>{
    const { shape = 'circular', appearance = 'filled', showZero = false, overflowCount = 99, count = 0, dot = false } = props;
    const state = {
        ...useBadge_unstable(props, ref),
        shape,
        appearance,
        showZero,
        count,
        dot
    };
    if ((count !== 0 || showZero) && !dot && !state.root.children) {
        state.root.children = count > overflowCount ? `${overflowCount}+` : `${count}`;
    }
    return state;
};
