'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    presenceBadgeClassNames: function() {
        return presenceBadgeClassNames;
    },
    usePresenceBadgeStyles_unstable: function() {
        return usePresenceBadgeStyles_unstable;
    }
});
const _react = require("@griffel/react");
const presenceBadgeClassNames = {
    root: 'fui-PresenceBadge',
    icon: 'fui-PresenceBadge__icon'
};
const getIsBusy = (status)=>{
    if (status === 'busy' || status === 'do-not-disturb' || status === 'blocked') {
        return true;
    }
    return false;
};
const useRootClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r832ydo", null, [
    ".r832ydo{display:inline-flex;box-sizing:border-box;align-items:center;justify-content:center;border-radius:var(--borderRadiusCircular);background-color:var(--colorNeutralBackground1);padding:1px;background-clip:content-box;}"
]);
const useIconClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r11ag4qr", null, [
    ".r11ag4qr{display:flex;margin:-1px;}"
]);
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    statusBusy: {
        sj55zd: "fvi85wt"
    },
    statusAway: {
        sj55zd: "f14k8a89"
    },
    statusAvailable: {
        sj55zd: "fqa5hgp"
    },
    statusOffline: {
        sj55zd: "f11d4kpn"
    },
    statusOutOfOffice: {
        sj55zd: "fdce8r3"
    },
    statusUnknown: {
        sj55zd: "f11d4kpn"
    },
    outOfOffice: {
        sj55zd: "fr0bkrk"
    },
    outOfOfficeAvailable: {
        sj55zd: "fqa5hgp"
    },
    outOfOfficeBusy: {
        sj55zd: "fvi85wt"
    },
    outOfOfficeUnknown: {
        sj55zd: "f11d4kpn"
    },
    tiny: {
        Bubjx69: "f9ikmtg",
        a9b677: "f16dn6v3",
        B2eet1l: "f1w2irj7",
        B5pe6w7: "fab5kbq",
        p4uzdd: "f1ms1d91"
    },
    large: {
        Bubjx69: "f9ikmtg",
        a9b677: "f64fuq3",
        B5pe6w7: "f1vfi1yj",
        p4uzdd: "f15s34gz"
    },
    extraLarge: {
        Bubjx69: "f9ikmtg",
        a9b677: "f1w9dchk",
        B5pe6w7: "f14efy9b",
        p4uzdd: "fhipgdu"
    }
}, {
    d: [
        ".fvi85wt{color:var(--colorPaletteRedBackground3);}",
        ".f14k8a89{color:var(--colorPaletteMarigoldBackground3);}",
        ".fqa5hgp{color:var(--colorPaletteLightGreenForeground3);}",
        ".f11d4kpn{color:var(--colorNeutralForeground3);}",
        ".fdce8r3{color:var(--colorPaletteBerryForeground3);}",
        ".fr0bkrk{color:var(--colorNeutralBackground1);}",
        ".f9ikmtg{aspect-ratio:1;}",
        ".f16dn6v3{width:6px;}",
        ".f1w2irj7{background-clip:unset;}",
        ".fab5kbq svg{width:6px!important;}",
        ".f1ms1d91 svg{height:6px!important;}",
        ".f64fuq3{width:20px;}",
        ".f1vfi1yj svg{width:20px!important;}",
        ".f15s34gz svg{height:20px!important;}",
        ".f1w9dchk{width:28px;}",
        ".f14efy9b svg{width:28px!important;}",
        ".fhipgdu svg{height:28px!important;}"
    ]
});
const usePresenceBadgeStyles_unstable = (state)=>{
    'use no memo';
    const rootClassName = useRootClassName();
    const iconClassName = useIconClassName();
    const styles = useStyles();
    const isBusy = getIsBusy(state.status);
    state.root.className = (0, _react.mergeClasses)(presenceBadgeClassNames.root, rootClassName, isBusy && styles.statusBusy, state.status === 'away' && styles.statusAway, state.status === 'available' && styles.statusAvailable, state.status === 'offline' && styles.statusOffline, state.status === 'out-of-office' && styles.statusOutOfOffice, state.status === 'unknown' && styles.statusUnknown, state.outOfOffice && styles.outOfOffice, state.outOfOffice && state.status === 'available' && styles.outOfOfficeAvailable, state.outOfOffice && isBusy && styles.outOfOfficeBusy, state.outOfOffice && (state.status === 'out-of-office' || state.status === 'away' || state.status === 'offline') && styles.statusOutOfOffice, state.outOfOffice && state.status === 'unknown' && styles.outOfOfficeUnknown, state.size === 'tiny' && styles.tiny, state.size === 'large' && styles.large, state.size === 'extra-large' && styles.extraLarge, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(presenceBadgeClassNames.icon, iconClassName, state.icon.className);
    }
    return state;
};
