'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usePresenceBadge_unstable", {
    enumerable: true,
    get: function() {
        return usePresenceBadge_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _presenceIcons = require("./presenceIcons");
const _index = require("../Badge/index");
const iconMap = (status, outOfOffice, size)=>{
    switch(status){
        case 'available':
            return outOfOffice ? _presenceIcons.presenceAvailableRegular[size] : _presenceIcons.presenceAvailableFilled[size];
        case 'away':
            return outOfOffice ? _presenceIcons.presenceOofRegular[size] : _presenceIcons.presenceAwayFilled[size];
        case 'blocked':
            return _presenceIcons.presenceBlockedRegular[size];
        case 'busy':
            return outOfOffice ? _presenceIcons.presenceUnknownRegular[size] : _presenceIcons.presenceBusyFilled[size];
        case 'do-not-disturb':
            return outOfOffice ? _presenceIcons.presenceDndRegular[size] : _presenceIcons.presenceDndFilled[size];
        case 'offline':
            return outOfOffice ? _presenceIcons.presenceOofRegular[size] : _presenceIcons.presenceOfflineRegular[size];
        case 'out-of-office':
            return _presenceIcons.presenceOofRegular[size];
        case 'unknown':
            return _presenceIcons.presenceUnknownRegular[size];
    }
};
const DEFAULT_STRINGS = {
    busy: 'busy',
    'out-of-office': 'out of office',
    away: 'away',
    available: 'available',
    offline: 'offline',
    'do-not-disturb': 'do not disturb',
    unknown: 'unknown',
    blocked: 'blocked'
};
const usePresenceBadge_unstable = (props, ref)=>{
    const { size = 'medium', status = 'available', outOfOffice = false } = props;
    const statusText = DEFAULT_STRINGS[status];
    const oofText = props.outOfOffice && props.status !== 'out-of-office' ? ` ${DEFAULT_STRINGS['out-of-office']}` : '';
    const IconElement = iconMap(status, outOfOffice, size);
    const state = {
        ...(0, _index.useBadge_unstable)({
            'aria-label': statusText + oofText,
            role: 'img',
            ...props,
            size,
            icon: _reactutilities.slot.optional(props.icon, {
                defaultProps: {
                    children: IconElement ? /*#__PURE__*/ _react.createElement(IconElement, null) : null
                },
                renderByDefault: true,
                elementType: 'span'
            })
        }, ref),
        status,
        outOfOffice
    };
    return state;
};
