'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    badgeClassNames: function() {
        return badgeClassNames;
    },
    useBadgeStyles_unstable: function() {
        return useBadgeStyles_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _react1 = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const badgeClassNames = {
    root: 'fui-Badge',
    icon: 'fui-Badge__icon'
};
// The text content of the badge has additional horizontal padding, but there is no `text` slot to add that padding to.
// Instead, add extra padding to the root, and a negative margin on the icon to "remove" the extra padding on the icon.
const textPadding = _reacttheme.tokens.spacingHorizontalXXS;
const useRootClassName = (0, _react1.makeResetStyles)({
    display: 'inline-flex',
    boxSizing: 'border-box',
    alignItems: 'center',
    justifyContent: 'center',
    position: 'relative',
    ..._reacttheme.typographyStyles.caption1Strong,
    height: '20px',
    minWidth: '20px',
    padding: `0 calc(${_reacttheme.tokens.spacingHorizontalXS} + ${textPadding})`,
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    // Use a transparent stroke (rather than no border) so the border is visible in high contrast
    borderColor: _reacttheme.tokens.colorTransparentStroke,
    '::after': {
        content: '""',
        position: 'absolute',
        top: 0,
        left: 0,
        bottom: 0,
        right: 0,
        borderStyle: 'solid',
        borderColor: 'inherit',
        borderWidth: _reacttheme.tokens.strokeWidthThin,
        borderRadius: 'inherit'
    }
});
const useRootStyles = (0, _react1.makeStyles)({
    fontSmallToTiny: {
        ..._reacttheme.typographyStyles.caption2Strong
    },
    // size
    tiny: {
        width: '6px',
        height: '6px',
        fontSize: '4px',
        lineHeight: '4px',
        minWidth: 'unset',
        padding: 'unset'
    },
    'extra-small': {
        width: '10px',
        height: '10px',
        fontSize: '6px',
        lineHeight: '6px',
        minWidth: 'unset',
        padding: 'unset'
    },
    small: {
        minWidth: '16px',
        height: '16px',
        padding: `0 calc(${_reacttheme.tokens.spacingHorizontalXXS} + ${textPadding})`
    },
    medium: {},
    large: {
        minWidth: '24px',
        height: '24px',
        padding: `0 calc(${_reacttheme.tokens.spacingHorizontalXS} + ${textPadding})`
    },
    'extra-large': {
        minWidth: '32px',
        height: '32px',
        padding: `0 calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${textPadding})`
    },
    // shape
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone
    },
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    roundedSmallToTiny: {
        borderRadius: _reacttheme.tokens.borderRadiusSmall
    },
    circular: {},
    // hide the boder when appearance is "ghost"
    borderGhost: {
        // The border is applied in an ::after pseudo-element because it should not affect layout.
        // The padding and size of the badge should be the same regardless of whether or not it has a border.
        '::after': {
            display: 'none'
        }
    },
    // appearance: filled
    filled: {},
    'filled-brand': {
        backgroundColor: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    'filled-danger': {
        backgroundColor: _reacttheme.tokens.colorPaletteRedBackground3,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    'filled-important': {
        backgroundColor: _reacttheme.tokens.colorNeutralForeground1,
        color: _reacttheme.tokens.colorNeutralBackground1
    },
    'filled-informative': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground5,
        color: _reacttheme.tokens.colorNeutralForeground3
    },
    'filled-severe': {
        backgroundColor: _reacttheme.tokens.colorPaletteDarkOrangeBackground3,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    'filled-subtle': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        color: _reacttheme.tokens.colorNeutralForeground1
    },
    'filled-success': {
        backgroundColor: _reacttheme.tokens.colorPaletteGreenBackground3,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    'filled-warning': {
        backgroundColor: _reacttheme.tokens.colorPaletteYellowBackground3,
        color: _reacttheme.tokens.colorNeutralForeground1Static
    },
    // appearance: ghost
    ghost: {},
    'ghost-brand': {
        color: _reacttheme.tokens.colorBrandForeground1
    },
    'ghost-danger': {
        color: _reacttheme.tokens.colorPaletteRedForeground3
    },
    'ghost-important': {
        color: _reacttheme.tokens.colorNeutralForeground1
    },
    'ghost-informative': {
        color: _reacttheme.tokens.colorNeutralForeground3
    },
    'ghost-severe': {
        color: _reacttheme.tokens.colorPaletteDarkOrangeForeground3
    },
    'ghost-subtle': {
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted
    },
    'ghost-success': {
        color: _reacttheme.tokens.colorPaletteGreenForeground3
    },
    'ghost-warning': {
        color: _reacttheme.tokens.colorPaletteYellowForeground2
    },
    // appearance: outline
    outline: {
        ..._react1.shorthands.borderColor('currentColor')
    },
    'outline-brand': {
        color: _reacttheme.tokens.colorBrandForeground1
    },
    'outline-danger': {
        color: _reacttheme.tokens.colorPaletteRedForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
    },
    'outline-important': {
        color: _reacttheme.tokens.colorNeutralForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeAccessible)
    },
    'outline-informative': {
        color: _reacttheme.tokens.colorNeutralForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke2)
    },
    'outline-severe': {
        color: _reacttheme.tokens.colorPaletteDarkOrangeForeground3
    },
    'outline-subtle': {
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted
    },
    'outline-success': {
        color: _reacttheme.tokens.colorPaletteGreenForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteGreenBorder2)
    },
    'outline-warning': {
        color: _reacttheme.tokens.colorPaletteYellowForeground2
    },
    // appearance: tint
    tint: {},
    'tint-brand': {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        color: _reacttheme.tokens.colorBrandForeground2,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke2)
    },
    'tint-danger': {
        backgroundColor: _reacttheme.tokens.colorPaletteRedBackground1,
        color: _reacttheme.tokens.colorPaletteRedForeground1,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder1)
    },
    'tint-important': {
        backgroundColor: _reacttheme.tokens.colorNeutralForeground3,
        color: _reacttheme.tokens.colorNeutralBackground1,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
    },
    'tint-informative': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground4,
        color: _reacttheme.tokens.colorNeutralForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke2)
    },
    'tint-severe': {
        backgroundColor: _reacttheme.tokens.colorPaletteDarkOrangeBackground1,
        color: _reacttheme.tokens.colorPaletteDarkOrangeForeground1,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteDarkOrangeBorder1)
    },
    'tint-subtle': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        color: _reacttheme.tokens.colorNeutralForeground3,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke2)
    },
    'tint-success': {
        backgroundColor: _reacttheme.tokens.colorPaletteGreenBackground1,
        color: _reacttheme.tokens.colorPaletteGreenForeground1,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteGreenBorder1)
    },
    'tint-warning': {
        backgroundColor: _reacttheme.tokens.colorPaletteYellowBackground1,
        color: _reacttheme.tokens.colorPaletteYellowForeground1,
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorPaletteYellowBorder1)
    }
});
const useIconRootClassName = (0, _react1.makeResetStyles)({
    display: 'flex',
    lineHeight: '1',
    margin: `0 calc(-1 * ${textPadding})`,
    fontSize: '12px'
});
const useIconStyles = (0, _react1.makeStyles)({
    beforeText: {
        marginRight: `calc(${_reacttheme.tokens.spacingHorizontalXXS} + ${textPadding})`
    },
    afterText: {
        marginLeft: `calc(${_reacttheme.tokens.spacingHorizontalXXS} + ${textPadding})`
    },
    beforeTextXL: {
        marginRight: `calc(${_reacttheme.tokens.spacingHorizontalXS} + ${textPadding})`
    },
    afterTextXL: {
        marginLeft: `calc(${_reacttheme.tokens.spacingHorizontalXS} + ${textPadding})`
    },
    // size
    tiny: {
        fontSize: '6px'
    },
    'extra-small': {
        fontSize: '10px'
    },
    small: {
        fontSize: '12px'
    },
    medium: {},
    large: {
        fontSize: '16px'
    },
    'extra-large': {
        fontSize: '20px'
    }
});
const useBadgeStyles_unstable = (state)=>{
    'use no memo';
    const rootClassName = useRootClassName();
    const rootStyles = useRootStyles();
    const smallToTiny = state.size === 'small' || state.size === 'extra-small' || state.size === 'tiny';
    state.root.className = (0, _react1.mergeClasses)(badgeClassNames.root, rootClassName, smallToTiny && rootStyles.fontSmallToTiny, rootStyles[state.size], rootStyles[state.shape], state.shape === 'rounded' && smallToTiny && rootStyles.roundedSmallToTiny, state.appearance === 'ghost' && rootStyles.borderGhost, rootStyles[state.appearance], rootStyles[`${state.appearance}-${state.color}`], state.root.className);
    const iconRootClassName = useIconRootClassName();
    const iconStyles = useIconStyles();
    if (state.icon) {
        let iconPositionClass;
        // Handle the edge case where children is 0 (a falsy value that should still render text and have margin)
        if (_react.Children.toArray(state.root.children).length > 0) {
            if (state.size === 'extra-large') {
                iconPositionClass = state.iconPosition === 'after' ? iconStyles.afterTextXL : iconStyles.beforeTextXL;
            } else {
                iconPositionClass = state.iconPosition === 'after' ? iconStyles.afterText : iconStyles.beforeText;
            }
        }
        state.icon.className = (0, _react1.mergeClasses)(badgeClassNames.icon, iconRootClassName, iconPositionClass, iconStyles[state.size], state.icon.className);
    }
    return state;
};
