'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    avatarGroupPopoverClassNames: function() {
        return avatarGroupPopoverClassNames;
    },
    useAvatarGroupPopoverStyles_unstable: function() {
        return useAvatarGroupPopoverStyles_unstable;
    }
});
const _reacttabster = require("@fluentui/react-tabster");
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useAvatarGroupItemStylesstyles = require("../AvatarGroupItem/useAvatarGroupItemStyles.styles");
const _useAvatarStylesstyles = require("../Avatar/useAvatarStyles.styles");
const avatarGroupPopoverClassNames = {
    root: 'fui-AvatarGroupPopover',
    content: 'fui-AvatarGroupPopover__content',
    popoverSurface: 'fui-AvatarGroupPopover__popoverSurface',
    tooltip: 'fui-AvatarGroupPopover__tooltip',
    triggerButton: 'fui-AvatarGroupPopover__triggerButton'
};
/**
 * Styles for the content slot.
 */ const useContentStyles = (0, _react.makeStyles)({
    base: {
        listStyleType: 'none',
        margin: '0',
        padding: '0',
        display: 'flex',
        flexDirection: 'column'
    }
});
/**
 * Styles for the popoverSurface slot.
 */ const usePopoverSurfaceStyles = (0, _react.makeStyles)({
    base: {
        maxHeight: '220px',
        minHeight: '80px',
        overflow: 'hidden scroll',
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS}`,
        width: '220px'
    }
});
/**
 * Styles for the triggerButton slot.
 */ const useTriggerButtonStyles = (0, _react.makeStyles)({
    base: {
        display: 'inline-flex',
        position: 'relative',
        flexShrink: 0,
        justifyContent: 'center',
        alignItems: 'center',
        color: _reacttheme.tokens.colorNeutralForeground1,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1),
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        ..._react.shorthands.borderStyle('solid'),
        padding: '0',
        // Match color to Avatar's outline color.
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('CanvasText')
        }
    },
    pie: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke),
        color: 'transparent'
    },
    focusIndicator: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        border: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
        outlineStyle: 'none'
    }),
    states: {
        '&:hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Hover,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover)
        },
        '&:active': {
            color: _reacttheme.tokens.colorNeutralForeground1Pressed,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Pressed,
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed)
        }
    },
    selected: {
        color: _reacttheme.tokens.colorNeutralForeground1Selected,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Selected,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected)
    },
    icon12: {
        fontSize: '12px'
    },
    icon16: {
        fontSize: '16px'
    },
    icon20: {
        fontSize: '20px'
    },
    icon24: {
        fontSize: '24px'
    },
    icon28: {
        fontSize: '28px'
    },
    icon32: {
        fontSize: '32px'
    },
    icon48: {
        fontSize: '48px'
    },
    caption2Strong: {
        ..._reacttheme.typographyStyles.caption2Strong
    },
    caption1Strong: {
        ..._reacttheme.typographyStyles.caption1Strong
    },
    body1Strong: {
        ..._reacttheme.typographyStyles.body1Strong
    },
    subtitle2: {
        ..._reacttheme.typographyStyles.subtitle2
    },
    subtitle1: {
        ..._reacttheme.typographyStyles.subtitle1
    },
    title3: {
        ..._reacttheme.typographyStyles.title3
    },
    borderThin: {
        ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThin)
    },
    borderThick: {
        ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThick)
    },
    borderThicker: {
        ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThicker)
    },
    borderThickest: {
        ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThickest)
    }
});
const useAvatarGroupPopoverStyles_unstable = (state)=>{
    'use no memo';
    const { indicator, size, layout, popoverOpen } = state;
    const sizeStyles = (0, _useAvatarStylesstyles.useSizeStyles)();
    const triggerButtonStyles = useTriggerButtonStyles();
    const contentStyles = useContentStyles();
    const popoverSurfaceStyles = usePopoverSurfaceStyles();
    const groupChildClassName = (0, _useAvatarGroupItemStylesstyles.useGroupChildClassName)(layout, size);
    const triggerButtonClasses = [];
    if (size < 36) {
        triggerButtonClasses.push(triggerButtonStyles.borderThin);
    } else if (size < 56) {
        triggerButtonClasses.push(triggerButtonStyles.borderThick);
    } else if (size < 72) {
        triggerButtonClasses.push(triggerButtonStyles.borderThicker);
    } else {
        triggerButtonClasses.push(triggerButtonStyles.borderThickest);
    }
    if (indicator === 'count') {
        if (size <= 24) {
            triggerButtonClasses.push(triggerButtonStyles.caption2Strong);
        } else if (size <= 28) {
            triggerButtonClasses.push(triggerButtonStyles.caption1Strong);
        } else if (size <= 40) {
            triggerButtonClasses.push(triggerButtonStyles.body1Strong);
        } else if (size <= 56) {
            triggerButtonClasses.push(triggerButtonStyles.subtitle2);
        } else if (size <= 96) {
            triggerButtonClasses.push(triggerButtonStyles.subtitle1);
        } else {
            triggerButtonClasses.push(triggerButtonStyles.title3);
        }
    } else {
        if (size <= 16) {
            triggerButtonClasses.push(triggerButtonStyles.icon12);
        } else if (size <= 24) {
            triggerButtonClasses.push(triggerButtonStyles.icon16);
        } else if (size <= 40) {
            triggerButtonClasses.push(triggerButtonStyles.icon20);
        } else if (size <= 48) {
            triggerButtonClasses.push(triggerButtonStyles.icon24);
        } else if (size <= 56) {
            triggerButtonClasses.push(triggerButtonStyles.icon28);
        } else if (size <= 72) {
            triggerButtonClasses.push(triggerButtonStyles.icon32);
        } else {
            triggerButtonClasses.push(triggerButtonStyles.icon48);
        }
    }
    state.triggerButton.className = (0, _react.mergeClasses)(avatarGroupPopoverClassNames.triggerButton, groupChildClassName, sizeStyles[size], triggerButtonStyles.base, layout === 'pie' && triggerButtonStyles.pie, triggerButtonStyles.focusIndicator, layout !== 'pie' && triggerButtonStyles.states, layout !== 'pie' && popoverOpen && triggerButtonStyles.selected, ...triggerButtonClasses, state.triggerButton.className);
    state.content.className = (0, _react.mergeClasses)(avatarGroupPopoverClassNames.content, contentStyles.base, state.content.className);
    state.popoverSurface.className = (0, _react.mergeClasses)(avatarGroupPopoverClassNames.popoverSurface, popoverSurfaceStyles.base, state.popoverSurface.className);
    return state;
};
