'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    avatarGroupClassNames: function() {
        return avatarGroupClassNames;
    },
    useAvatarGroupStyles_unstable: function() {
        return useAvatarGroupStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useAvatarStylesstyles = require("../Avatar/useAvatarStyles.styles");
const avatarGroupClassNames = {
    root: 'fui-AvatarGroup'
};
/**
 * Styles for the root slot.
 */ const useStyles = (0, _react.makeStyles)({
    base: {
        display: 'inline-flex',
        position: 'relative'
    },
    pie: {
        clipPath: 'circle(50%)',
        backgroundColor: _reacttheme.tokens.colorTransparentStroke,
        '@media (forced-colors: active)': {
            backgroundColor: 'CanvasText'
        }
    }
});
const useAvatarGroupStyles_unstable = (state)=>{
    'use no memo';
    const { layout, size } = state;
    const styles = useStyles();
    const sizeStyles = (0, _useAvatarStylesstyles.useSizeStyles)();
    state.root.className = (0, _react.mergeClasses)(avatarGroupClassNames.root, styles.base, layout === 'pie' && sizeStyles[size], layout === 'pie' && styles.pie, state.root.className);
    return state;
};
