'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    avatarClassNames: function() {
        return avatarClassNames;
    },
    useAvatarStyles_unstable: function() {
        return useAvatarStyles_unstable;
    },
    useSizeStyles: function() {
        return useSizeStyles;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const avatarClassNames = {
    root: 'fui-Avatar',
    image: 'fui-Avatar__image',
    initials: 'fui-Avatar__initials',
    icon: 'fui-Avatar__icon',
    badge: 'fui-Avatar__badge'
};
// CSS variables used internally in Avatar's styles
const vars = {
    badgeRadius: '--fui-Avatar-badgeRadius',
    badgeGap: '--fui-Avatar-badgeGap',
    badgeAlign: '--fui-Avatar-badgeAlign',
    ringWidth: '--fui-Avatar-ringWidth'
};
const useRootClassName = (0, _react.makeResetStyles)({
    display: 'inline-block',
    flexShrink: 0,
    position: 'relative',
    verticalAlign: 'middle',
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    fontFamily: _reacttheme.tokens.fontFamilyBase,
    fontWeight: _reacttheme.tokens.fontWeightSemibold,
    fontSize: _reacttheme.tokens.fontSizeBase300,
    width: '32px',
    height: '32px',
    // ::before is the ring, and ::after is the shadow.
    // These are not displayed by default; the ring and shadow clases set content: "" to display them when appropriate.
    '::before,::after': {
        position: 'absolute',
        top: 0,
        left: 0,
        bottom: 0,
        right: 0,
        zIndex: -1,
        margin: `calc(-2 * var(${vars.ringWidth}, 0px))`,
        borderRadius: 'inherit',
        transitionProperty: 'margin, opacity',
        transitionTimingFunction: `${_reacttheme.tokens.curveEasyEaseMax}, ${_reacttheme.tokens.curveLinear}`,
        transitionDuration: `${_reacttheme.tokens.durationUltraSlow}, ${_reacttheme.tokens.durationSlower}`,
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms'
        }
    },
    '::before': {
        borderStyle: 'solid',
        borderWidth: `var(${vars.ringWidth})`
    }
});
const useImageClassName = (0, _react.makeResetStyles)({
    position: 'absolute',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    borderRadius: 'inherit',
    objectFit: 'cover',
    verticalAlign: 'top'
});
const useIconInitialsClassName = (0, _react.makeResetStyles)({
    position: 'absolute',
    boxSizing: 'border-box',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    lineHeight: '1',
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    verticalAlign: 'center',
    textAlign: 'center',
    userSelect: 'none',
    borderRadius: 'inherit'
});
/**
 * Helper to create a maskImage that punches out a circle larger than the badge by `badgeGap`.
 * This creates a transparent gap between the badge and Avatar.
 *
 * Used by the icon, initials, and image slots, as well as the ring ::before pseudo-element.
 */ const badgeMask = (margin)=>{
    // Center the cutout at the badge's radius away from the edge.
    // The ring (::before) also has a 2 * ringWidth margin that also needs to be offset.
    const centerOffset = margin ? `calc(var(${vars.badgeRadius}) + ${margin})` : `var(${vars.badgeRadius})`;
    // radial-gradient does not have anti-aliasing, so the transparent and opaque gradient stops are offset by +/- 0.25px
    // to "fade" from transparent to opaque over a half-pixel and ease the transition.
    const innerRadius = `calc(var(${vars.badgeRadius}) + var(${vars.badgeGap}) - 0.25px)`;
    const outerRadius = `calc(var(${vars.badgeRadius}) + var(${vars.badgeGap}) + 0.25px)`;
    return `radial-gradient(circle at bottom ${centerOffset} var(${vars.badgeAlign}) ${centerOffset}, ` + `transparent ${innerRadius}, white ${outerRadius})`;
};
const useStyles = (0, _react.makeStyles)({
    textCaption2Strong: {
        fontSize: _reacttheme.tokens.fontSizeBase100
    },
    textCaption1Strong: {
        fontSize: _reacttheme.tokens.fontSizeBase200
    },
    textSubtitle2: {
        fontSize: _reacttheme.tokens.fontSizeBase400
    },
    textSubtitle1: {
        fontSize: _reacttheme.tokens.fontSizeBase500
    },
    textTitle3: {
        fontSize: _reacttheme.tokens.fontSizeBase600
    },
    squareSmall: {
        borderRadius: _reacttheme.tokens.borderRadiusSmall
    },
    squareMedium: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    squareLarge: {
        borderRadius: _reacttheme.tokens.borderRadiusLarge
    },
    squareXLarge: {
        borderRadius: _reacttheme.tokens.borderRadiusXLarge
    },
    activeOrInactive: {
        transform: 'perspective(1px)',
        transitionProperty: 'transform, opacity',
        transitionDuration: `${_reacttheme.tokens.durationUltraSlow}, ${_reacttheme.tokens.durationFaster}`,
        transitionTimingFunction: `${_reacttheme.tokens.curveEasyEaseMax}, ${_reacttheme.tokens.curveLinear}`,
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms'
        }
    },
    ring: {
        // Show the ::before pseudo-element, which is the ring
        '::before': {
            content: '""'
        }
    },
    ringBadgeCutout: {
        '::before': {
            maskImage: badgeMask(/*margin =*/ `2 * var(${vars.ringWidth})`)
        }
    },
    ringThick: {
        [vars.ringWidth]: _reacttheme.tokens.strokeWidthThick
    },
    ringThicker: {
        [vars.ringWidth]: _reacttheme.tokens.strokeWidthThicker
    },
    ringThickest: {
        [vars.ringWidth]: _reacttheme.tokens.strokeWidthThickest
    },
    shadow: {
        // Show the ::after pseudo-element, which is the shadow
        '::after': {
            content: '""'
        }
    },
    shadow4: {
        '::after': {
            boxShadow: _reacttheme.tokens.shadow4
        }
    },
    shadow8: {
        '::after': {
            boxShadow: _reacttheme.tokens.shadow8
        }
    },
    shadow16: {
        '::after': {
            boxShadow: _reacttheme.tokens.shadow16
        }
    },
    shadow28: {
        '::after': {
            boxShadow: _reacttheme.tokens.shadow28
        }
    },
    inactive: {
        opacity: '0.8',
        transform: 'scale(0.875)',
        transitionTimingFunction: `${_reacttheme.tokens.curveDecelerateMin}, ${_reacttheme.tokens.curveLinear}`,
        '::before,::after': {
            margin: 0,
            opacity: 0,
            transitionTimingFunction: `${_reacttheme.tokens.curveDecelerateMin}, ${_reacttheme.tokens.curveLinear}`
        }
    },
    // Applied to the badge slot
    badge: {
        position: 'absolute',
        bottom: 0,
        right: 0
    },
    // Applied to the image, initials, or icon slot when there is a badge
    badgeCutout: {
        maskImage: badgeMask()
    },
    // Applied to the root when there is a badge
    badgeAlign: {
        // Griffel won't auto-flip the "right" alignment to "left" in RTL if it is inline in the maskImage,
        // so split it out into a css variable that will auto-flip.
        [vars.badgeAlign]: 'right'
    },
    // Badge size: applied to root when there is a badge
    tiny: {
        [vars.badgeRadius]: '3px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThin
    },
    'extra-small': {
        [vars.badgeRadius]: '5px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThin
    },
    small: {
        [vars.badgeRadius]: '6px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThin
    },
    medium: {
        [vars.badgeRadius]: '8px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThin
    },
    large: {
        [vars.badgeRadius]: '10px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThick
    },
    'extra-large': {
        [vars.badgeRadius]: '14px',
        [vars.badgeGap]: _reacttheme.tokens.strokeWidthThick
    },
    icon12: {
        fontSize: '12px'
    },
    icon16: {
        fontSize: '16px'
    },
    icon20: {
        fontSize: '20px'
    },
    icon24: {
        fontSize: '24px'
    },
    icon28: {
        fontSize: '28px'
    },
    icon32: {
        fontSize: '32px'
    },
    icon48: {
        fontSize: '48px'
    }
});
const useSizeStyles = (0, _react.makeStyles)({
    16: {
        width: '16px',
        height: '16px'
    },
    20: {
        width: '20px',
        height: '20px'
    },
    24: {
        width: '24px',
        height: '24px'
    },
    28: {
        width: '28px',
        height: '28px'
    },
    32: {
        width: '32px',
        height: '32px'
    },
    36: {
        width: '36px',
        height: '36px'
    },
    40: {
        width: '40px',
        height: '40px'
    },
    48: {
        width: '48px',
        height: '48px'
    },
    56: {
        width: '56px',
        height: '56px'
    },
    64: {
        width: '64px',
        height: '64px'
    },
    72: {
        width: '72px',
        height: '72px'
    },
    96: {
        width: '96px',
        height: '96px'
    },
    120: {
        width: '120px',
        height: '120px'
    },
    128: {
        width: '128px',
        height: '128px'
    }
});
const useColorStyles = (0, _react.makeStyles)({
    neutral: {
        color: _reacttheme.tokens.colorNeutralForeground3,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground6
    },
    brand: {
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted,
        backgroundColor: _reacttheme.tokens.colorBrandBackgroundStatic
    },
    'dark-red': {
        color: _reacttheme.tokens.colorPaletteDarkRedForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteDarkRedBackground2
    },
    cranberry: {
        color: _reacttheme.tokens.colorPaletteCranberryForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteCranberryBackground2
    },
    red: {
        color: _reacttheme.tokens.colorPaletteRedForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteRedBackground2
    },
    pumpkin: {
        color: _reacttheme.tokens.colorPalettePumpkinForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePumpkinBackground2
    },
    peach: {
        color: _reacttheme.tokens.colorPalettePeachForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePeachBackground2
    },
    marigold: {
        color: _reacttheme.tokens.colorPaletteMarigoldForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteMarigoldBackground2
    },
    gold: {
        color: _reacttheme.tokens.colorPaletteGoldForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteGoldBackground2
    },
    brass: {
        color: _reacttheme.tokens.colorPaletteBrassForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteBrassBackground2
    },
    brown: {
        color: _reacttheme.tokens.colorPaletteBrownForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteBrownBackground2
    },
    forest: {
        color: _reacttheme.tokens.colorPaletteForestForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteForestBackground2
    },
    seafoam: {
        color: _reacttheme.tokens.colorPaletteSeafoamForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteSeafoamBackground2
    },
    'dark-green': {
        color: _reacttheme.tokens.colorPaletteDarkGreenForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteDarkGreenBackground2
    },
    'light-teal': {
        color: _reacttheme.tokens.colorPaletteLightTealForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteLightTealBackground2
    },
    teal: {
        color: _reacttheme.tokens.colorPaletteTealForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteTealBackground2
    },
    steel: {
        color: _reacttheme.tokens.colorPaletteSteelForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteSteelBackground2
    },
    blue: {
        color: _reacttheme.tokens.colorPaletteBlueForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteBlueBackground2
    },
    'royal-blue': {
        color: _reacttheme.tokens.colorPaletteRoyalBlueForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteRoyalBlueBackground2
    },
    cornflower: {
        color: _reacttheme.tokens.colorPaletteCornflowerForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteCornflowerBackground2
    },
    navy: {
        color: _reacttheme.tokens.colorPaletteNavyForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteNavyBackground2
    },
    lavender: {
        color: _reacttheme.tokens.colorPaletteLavenderForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteLavenderBackground2
    },
    purple: {
        color: _reacttheme.tokens.colorPalettePurpleForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePurpleBackground2
    },
    grape: {
        color: _reacttheme.tokens.colorPaletteGrapeForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteGrapeBackground2
    },
    lilac: {
        color: _reacttheme.tokens.colorPaletteLilacForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteLilacBackground2
    },
    pink: {
        color: _reacttheme.tokens.colorPalettePinkForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePinkBackground2
    },
    magenta: {
        color: _reacttheme.tokens.colorPaletteMagentaForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteMagentaBackground2
    },
    plum: {
        color: _reacttheme.tokens.colorPalettePlumForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePlumBackground2
    },
    beige: {
        color: _reacttheme.tokens.colorPaletteBeigeForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteBeigeBackground2
    },
    mink: {
        color: _reacttheme.tokens.colorPaletteMinkForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteMinkBackground2
    },
    platinum: {
        color: _reacttheme.tokens.colorPalettePlatinumForeground2,
        backgroundColor: _reacttheme.tokens.colorPalettePlatinumBackground2
    },
    anchor: {
        color: _reacttheme.tokens.colorPaletteAnchorForeground2,
        backgroundColor: _reacttheme.tokens.colorPaletteAnchorBackground2
    }
});
const useRingColorStyles = (0, _react.makeStyles)({
    neutral: {
        '::before': {
            color: _reacttheme.tokens.colorBrandStroke1
        }
    },
    brand: {
        '::before': {
            color: _reacttheme.tokens.colorBrandStroke1
        }
    },
    'dark-red': {
        '::before': {
            color: _reacttheme.tokens.colorPaletteDarkRedBorderActive
        }
    },
    cranberry: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteCranberryBorderActive
        }
    },
    red: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteRedBorderActive
        }
    },
    pumpkin: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePumpkinBorderActive
        }
    },
    peach: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePeachBorderActive
        }
    },
    marigold: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteMarigoldBorderActive
        }
    },
    gold: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteGoldBorderActive
        }
    },
    brass: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteBrassBorderActive
        }
    },
    brown: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteBrownBorderActive
        }
    },
    forest: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteForestBorderActive
        }
    },
    seafoam: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteSeafoamBorderActive
        }
    },
    'dark-green': {
        '::before': {
            color: _reacttheme.tokens.colorPaletteDarkGreenBorderActive
        }
    },
    'light-teal': {
        '::before': {
            color: _reacttheme.tokens.colorPaletteLightTealBorderActive
        }
    },
    teal: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteTealBorderActive
        }
    },
    steel: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteSteelBorderActive
        }
    },
    blue: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteBlueBorderActive
        }
    },
    'royal-blue': {
        '::before': {
            color: _reacttheme.tokens.colorPaletteRoyalBlueBorderActive
        }
    },
    cornflower: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteCornflowerBorderActive
        }
    },
    navy: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteNavyBorderActive
        }
    },
    lavender: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteLavenderBorderActive
        }
    },
    purple: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePurpleBorderActive
        }
    },
    grape: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteGrapeBorderActive
        }
    },
    lilac: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteLilacBorderActive
        }
    },
    pink: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePinkBorderActive
        }
    },
    magenta: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteMagentaBorderActive
        }
    },
    plum: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePlumBorderActive
        }
    },
    beige: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteBeigeBorderActive
        }
    },
    mink: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteMinkBorderActive
        }
    },
    platinum: {
        '::before': {
            color: _reacttheme.tokens.colorPalettePlatinumBorderActive
        }
    },
    anchor: {
        '::before': {
            color: _reacttheme.tokens.colorPaletteAnchorBorderActive
        }
    }
});
const useAvatarStyles_unstable = (state)=>{
    'use no memo';
    const { size, shape, active, activeAppearance, color } = state;
    const rootClassName = useRootClassName();
    const imageClassName = useImageClassName();
    const iconInitialsClassName = useIconInitialsClassName();
    const styles = useStyles();
    const sizeStyles = useSizeStyles();
    const colorStyles = useColorStyles();
    const ringColorStyles = useRingColorStyles();
    const rootClasses = [
        rootClassName,
        size !== 32 && sizeStyles[size]
    ];
    if (state.badge) {
        rootClasses.push(styles.badgeAlign, styles[state.badge.size || 'medium']);
    }
    if (size <= 24) {
        rootClasses.push(styles.textCaption2Strong);
    } else if (size <= 28) {
        rootClasses.push(styles.textCaption1Strong);
    } else if (size <= 40) {
    // Default text size included in useRootClassName
    } else if (size <= 56) {
        rootClasses.push(styles.textSubtitle2);
    } else if (size <= 96) {
        rootClasses.push(styles.textSubtitle1);
    } else {
        rootClasses.push(styles.textTitle3);
    }
    if (shape === 'square') {
        if (size <= 24) {
            rootClasses.push(styles.squareSmall);
        } else if (size <= 48) {
            rootClasses.push(styles.squareMedium);
        } else if (size <= 72) {
            rootClasses.push(styles.squareLarge);
        } else {
            rootClasses.push(styles.squareXLarge);
        }
    }
    if (active === 'active' || active === 'inactive') {
        rootClasses.push(styles.activeOrInactive);
        if (activeAppearance === 'ring' || activeAppearance === 'ring-shadow') {
            rootClasses.push(styles.ring, ringColorStyles[color]);
            if (state.badge) {
                rootClasses.push(styles.ringBadgeCutout);
            }
            if (size <= 48) {
                rootClasses.push(styles.ringThick);
            } else if (size <= 64) {
                rootClasses.push(styles.ringThicker);
            } else {
                rootClasses.push(styles.ringThickest);
            }
        }
        if (activeAppearance === 'shadow' || activeAppearance === 'ring-shadow') {
            rootClasses.push(styles.shadow);
            if (size <= 28) {
                rootClasses.push(styles.shadow4);
            } else if (size <= 48) {
                rootClasses.push(styles.shadow8);
            } else if (size <= 64) {
                rootClasses.push(styles.shadow16);
            } else {
                rootClasses.push(styles.shadow28);
            }
        }
        // Note: The inactive style overrides some of the activeAppearance styles and must be applied after them
        if (active === 'inactive') {
            rootClasses.push(styles.inactive);
        }
    }
    state.root.className = (0, _react.mergeClasses)(avatarClassNames.root, ...rootClasses, state.root.className);
    if (state.badge) {
        state.badge.className = (0, _react.mergeClasses)(avatarClassNames.badge, styles.badge, state.badge.className);
    }
    if (state.image) {
        state.image.className = (0, _react.mergeClasses)(avatarClassNames.image, imageClassName, colorStyles[color], state.badge && styles.badgeCutout, state.image.className);
    }
    if (state.initials) {
        state.initials.className = (0, _react.mergeClasses)(avatarClassNames.initials, iconInitialsClassName, colorStyles[color], state.badge && styles.badgeCutout, state.initials.className);
    }
    if (state.icon) {
        let iconSizeClass;
        if (size <= 16) {
            iconSizeClass = styles.icon12;
        } else if (size <= 24) {
            iconSizeClass = styles.icon16;
        } else if (size <= 40) {
            iconSizeClass = styles.icon20;
        } else if (size <= 48) {
            iconSizeClass = styles.icon24;
        } else if (size <= 56) {
            iconSizeClass = styles.icon28;
        } else if (size <= 72) {
            iconSizeClass = styles.icon32;
        } else {
            iconSizeClass = styles.icon48;
        }
        state.icon.className = (0, _react.mergeClasses)(avatarClassNames.icon, iconInitialsClassName, iconSizeClass, colorStyles[color], state.badge && styles.badgeCutout, state.icon.className);
    }
    return state;
};
