'use client';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import * as React from 'react';
/* INTERNAL: implementation of the announcer using the ariaNotify API */ export const useAriaNotifyAnnounce_unstable = ()=>{
    const { targetDocument } = useFluent();
    const announce = React.useCallback((message, options = {})=>{
        if (!targetDocument) {
            return;
        }
        const { alert = false, polite } = options;
        // default priority to 0 if polite, 2 if alert, and 1 by default
        // used to set both ariaNotify's priority and interrupt
        const defaultPriority = polite ? 0 : alert ? 2 : 1;
        var _options_priority;
        const priority = (_options_priority = options.priority) !== null && _options_priority !== void 0 ? _options_priority : defaultPriority;
        // map fluent announce options to ariaNotify options
        const ariaNotifyOptions = {
            priority: priority > 1 ? 'high' : 'normal'
        };
        targetDocument.ariaNotify(message, ariaNotifyOptions);
    }, [
        targetDocument
    ]);
    return announce;
};
