'use client';
import * as React from 'react';
import { useAccordionPanel_unstable } from './useAccordionPanel';
import { renderAccordionPanel_unstable } from './renderAccordionPanel';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useAccordionPanelStyles_unstable } from './useAccordionPanelStyles.styles';
/**
 * Define a styled AccordionPanel, using the `useAccordionPanel_unstable` and `useAccordionPanelStyles_unstable` hooks.
 */ export const AccordionPanel = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useAccordionPanel_unstable(props, ref);
    useAccordionPanelStyles_unstable(state);
    useCustomStyleHook_unstable('useAccordionPanelStyles_unstable')(state);
    return renderAccordionPanel_unstable(state);
});
AccordionPanel.displayName = 'AccordionPanel';
