'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAccordionPanel_unstable", {
    enumerable: true,
    get: function() {
        return useAccordionPanel_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _reactmotion = require("@fluentui/react-motion");
const _reactmotioncomponentspreview = require("@fluentui/react-motion-components-preview");
const _accordion = require("../../contexts/accordion");
const _accordionItem = require("../../contexts/accordionItem");
const useAccordionPanel_unstable = (props, ref)=>{
    const { open } = (0, _accordionItem.useAccordionItemContext_unstable)();
    const focusableProps = (0, _reacttabster.useTabsterAttributes)({
        focusable: {
            excludeFromMover: true
        }
    });
    const navigation = (0, _accordion.useAccordionContext_unstable)((ctx)=>ctx.navigation);
    return {
        open,
        components: {
            root: 'div',
            collapseMotion: _reactmotioncomponentspreview.Collapse
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            ...props,
            ...navigation && focusableProps
        }), {
            elementType: 'div'
        }),
        collapseMotion: (0, _reactmotion.presenceMotionSlot)(props.collapseMotion, {
            elementType: _reactmotioncomponentspreview.Collapse,
            defaultProps: {
                visible: open,
                unmountOnExit: true
            }
        })
    };
};
