'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAccordionItem_unstable", {
    enumerable: true,
    get: function() {
        return useAccordionItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _accordion = require("../../contexts/accordion");
const useAccordionItem_unstable = (props, ref)=>{
    const { value, disabled = false } = props;
    const requestToggle = (0, _accordion.useAccordionContext_unstable)((ctx)=>ctx.requestToggle);
    const open = (0, _accordion.useAccordionContext_unstable)((ctx)=>ctx.openItems.includes(value));
    const onAccordionHeaderClick = (0, _reactutilities.useEventCallback)((event)=>requestToggle({
            event,
            value
        }));
    return {
        open,
        value,
        disabled,
        onHeaderClick: onAccordionHeaderClick,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            ...props
        }), {
            elementType: 'div'
        })
    };
};
