'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    accordionHeaderClassNames: function() {
        return accordionHeaderClassNames;
    },
    useAccordionHeaderStyles_unstable: function() {
        return useAccordionHeaderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const accordionHeaderClassNames = {
    root: 'fui-AccordionHeader',
    button: 'fui-AccordionHeader__button',
    expandIcon: 'fui-AccordionHeader__expandIcon',
    icon: 'fui-AccordionHeader__icon'
};
const useStyles = (0, _react.makeStyles)({
    // TODO: this should be extracted to another package
    resetButton: {
        boxSizing: 'content-box',
        backgroundColor: 'inherit',
        color: 'inherit',
        fontFamily: 'inherit',
        fontSize: 'inherit',
        lineHeight: 'normal',
        overflow: 'visible',
        padding: '0',
        WebkitAppearance: 'button',
        textAlign: 'unset'
    },
    focusIndicator: (0, _reacttabster.createFocusOutlineStyle)(),
    root: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        margin: '0',
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    rootDisabled: {
        backgroundImage: 'none',
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    rootInline: {
        display: 'inline-block'
    },
    button: {
        position: 'relative',
        width: '100%',
        ..._react.shorthands.borderWidth('0'),
        padding: `0 ${_reacttheme.tokens.spacingHorizontalM} 0 ${_reacttheme.tokens.spacingHorizontalMNudge}`,
        minHeight: '44px',
        display: 'flex',
        alignItems: 'center',
        cursor: 'pointer',
        ..._reacttheme.typographyStyles.body1,
        boxSizing: 'border-box'
    },
    buttonSmall: {
        minHeight: '32px',
        fontSize: _reacttheme.tokens.fontSizeBase200
    },
    buttonLarge: {
        lineHeight: _reacttheme.tokens.lineHeightBase400,
        fontSize: _reacttheme.tokens.fontSizeBase400
    },
    buttonExtraLarge: {
        lineHeight: _reacttheme.tokens.lineHeightBase500,
        fontSize: _reacttheme.tokens.fontSizeBase500
    },
    buttonInline: {
        display: 'inline-flex'
    },
    buttonExpandIconEndNoIcon: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalM
    },
    buttonExpandIconEnd: {
        paddingRight: _reacttheme.tokens.spacingHorizontalMNudge
    },
    buttonDisabled: {
        cursor: 'not-allowed'
    },
    expandIcon: {
        height: '100%',
        display: 'flex',
        alignItems: 'center',
        lineHeight: _reacttheme.tokens.lineHeightBase500,
        fontSize: _reacttheme.tokens.fontSizeBase500
    },
    expandIconStart: {
        paddingRight: _reacttheme.tokens.spacingHorizontalS
    },
    expandIconEnd: {
        flexGrow: 1,
        flexShrink: 1,
        flexBasis: '0%',
        display: 'flex',
        justifyContent: 'flex-end',
        paddingLeft: _reacttheme.tokens.spacingHorizontalS
    },
    icon: {
        height: '100%',
        display: 'flex',
        alignItems: 'center',
        paddingRight: _reacttheme.tokens.spacingHorizontalS,
        lineHeight: _reacttheme.tokens.lineHeightBase500,
        fontSize: _reacttheme.tokens.fontSizeBase500
    }
});
const useAccordionHeaderStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(accordionHeaderClassNames.root, styles.root, state.inline && styles.rootInline, state.disabled && styles.rootDisabled, state.root.className);
    state.button.className = (0, _react.mergeClasses)(accordionHeaderClassNames.button, styles.resetButton, styles.button, styles.focusIndicator, state.expandIconPosition === 'end' && !state.icon && styles.buttonExpandIconEndNoIcon, state.expandIconPosition === 'end' && styles.buttonExpandIconEnd, state.inline && styles.buttonInline, state.size === 'small' && styles.buttonSmall, state.size === 'large' && styles.buttonLarge, state.size === 'extra-large' && styles.buttonExtraLarge, state.disabled && styles.buttonDisabled, state.button.className);
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(accordionHeaderClassNames.expandIcon, styles.expandIcon, state.expandIconPosition === 'start' && styles.expandIconStart, state.expandIconPosition === 'end' && styles.expandIconEnd, state.expandIcon.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(accordionHeaderClassNames.icon, styles.icon, state.icon.className);
    }
    return state;
};
