'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAccordionHeader_unstable", {
    enumerable: true,
    get: function() {
        return useAccordionHeader_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactaria = require("@fluentui/react-aria");
const _accordion = require("../../contexts/accordion");
const _reacticons = require("@fluentui/react-icons");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _accordionItem = require("../../contexts/accordionItem");
const _reactmotion = require("@fluentui/react-motion");
const useAccordionHeader_unstable = (props, ref)=>{
    const { icon, button, expandIcon, inline = false, size = 'medium', expandIconPosition = 'start' } = props;
    const { value, disabled, open } = (0, _accordionItem.useAccordionItemContext_unstable)();
    const requestToggle = (0, _accordion.useAccordionContext_unstable)((ctx)=>ctx.requestToggle);
    /**
   * force disabled state on button if accordion isn't collapsible
   * and this is the only item opened
   */ const disabledFocusable = (0, _accordion.useAccordionContext_unstable)((ctx)=>!ctx.collapsible && ctx.openItems.length === 1 && open);
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    // Calculate how to rotate the expand icon [>] (ChevronRightRegular)
    let expandIconRotation;
    if (expandIconPosition === 'end') {
        // If expand icon is at the end, the chevron points up [^] when open, and down [v] when closed
        expandIconRotation = open ? -90 : 90;
    } else {
        // Otherwise, the chevron points down [v] when open, and right [>] (or left [<] in RTL) when closed
        expandIconRotation = open ? 90 : dir !== 'rtl' ? 0 : 180;
    }
    const buttonSlot = _reactutilities.slot.always(button, {
        elementType: 'button',
        defaultProps: {
            disabled,
            disabledFocusable,
            'aria-expanded': open,
            type: 'button'
        }
    });
    buttonSlot.onClick = (0, _reactutilities.useEventCallback)((event)=>{
        if ((0, _reactutilities.isResolvedShorthand)(button)) {
            var _button_onClick;
            (_button_onClick = button.onClick) === null || _button_onClick === void 0 ? void 0 : _button_onClick.call(button, event);
        }
        if (!event.defaultPrevented) {
            requestToggle({
                value,
                event
            });
        }
    });
    return {
        disabled,
        open,
        size,
        inline,
        expandIconPosition,
        components: {
            root: 'div',
            button: 'button',
            expandIcon: 'span',
            icon: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            ...props
        }), {
            elementType: 'div'
        }),
        icon: _reactutilities.slot.optional(icon, {
            elementType: 'div'
        }),
        expandIcon: _reactutilities.slot.optional(expandIcon, {
            renderByDefault: true,
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronRightRegular, {
                    style: {
                        transform: `rotate(${expandIconRotation}deg)`,
                        transition: `transform ${_reactmotion.motionTokens.durationNormal}ms ease-out`
                    }
                }),
                'aria-hidden': true
            },
            elementType: 'span'
        }),
        button: (0, _reactaria.useARIAButtonProps)(buttonSlot.as, buttonSlot)
    };
};
