import { __commonJS, __export, __toESM } from "./chunk-DbKvDyjX.js";
import { require_react } from "./react-Dzmm40ca.js";
import { ChevronLeftRegular, ChevronRightRegular, PauseCircleRegular, PlayCircleRegular, __resetStyles as __resetStyles$1, __styles, insertionFactory, mergeClasses, useRenderer, useTextDirection } from "./lib-Ck-rBeye.js";
import { require_scheduler } from "./scheduler-qxjPUv9n.js";
import { require_react_dom } from "./react-dom-CrF_OpLL.js";

//#region node_modules/@griffel/react/__resetStyles.esm.js
/**
* A version of makeResetStyles() that accepts build output as an input and skips all runtime transforms.
*
* @internal
*/
function __resetStyles(ltrClassName, rtlClassName, cssRules) {
	const getStyles = __resetStyles$1(ltrClassName, rtlClassName, cssRules, insertionFactory);
	return function useClasses() {
		const dir = useTextDirection();
		const renderer = useRenderer();
		return getStyles({
			dir,
			renderer
		});
	};
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/compose/constants.js
/**
* @internal
* Internal reference for the render function
*/ const SLOT_RENDER_FUNCTION_SYMBOL = Symbol.for("fui.slotRenderFunction");
/**
* @internal
* Internal reference for the render function
*/ const SLOT_ELEMENT_TYPE_SYMBOL = Symbol.for("fui.slotElementType");
/**
* @internal
* Internal cache of the original className prop for the slot, before being modified by the useStyles hook.
*/ const SLOT_CLASS_NAME_PROP_SYMBOL = Symbol.for("fui.slotClassNameProp");

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/compose/slot.js
var slot_exports = /* @__PURE__ */ __export({
	always: () => always,
	optional: () => optional,
	resolveShorthand: () => resolveShorthand
});
var import_react = /* @__PURE__ */ __toESM(require_react());
/**
* Creates a slot from a slot shorthand or properties (`props.SLOT_NAME` or `props` itself)
* @param value - the value of the slot, it can be a slot shorthand, a slot component or a slot properties
* @param options - values you can pass to alter the signature of a slot, those values are:
*
* * `elementType` - the base element type of a slot, defaults to `'div'`
* * `defaultProps` - similar to a React component declaration, you can provide a slot default properties to be merged with the shorthand/properties provided.
*/ function always(value, options) {
	const { defaultProps, elementType } = options;
	const props = resolveShorthand(value);
	/**
	* Casting is required here as SlotComponentType is a function, not an object.
	* Although SlotComponentType has a function signature, it is still just an object.
	* This is required to make a slot callable (JSX compatible), this is the exact same approach
	* that is used on `@types/react` components
	*/ const propsWithMetadata = {
		...defaultProps,
		...props,
		[SLOT_ELEMENT_TYPE_SYMBOL]: elementType,
		[SLOT_CLASS_NAME_PROP_SYMBOL]: props === null || props === void 0 ? void 0 : props.className
	};
	if (props && typeof props.children === "function") {
		propsWithMetadata[SLOT_RENDER_FUNCTION_SYMBOL] = props.children;
		propsWithMetadata.children = defaultProps === null || defaultProps === void 0 ? void 0 : defaultProps.children;
	}
	return propsWithMetadata;
}
/**
* Creates a slot from a slot shorthand or properties (`props.SLOT_NAME` or `props` itself)
* @param value - the value of the slot, it can be a slot shorthand, a slot component or a slot properties
* @param options - values you can pass to alter the signature of a slot, those values are:
*
* * `elementType` - the base element type of a slot, defaults to `'div'`
* * `defaultProps` - similar to a React component declaration, you can provide a slot default properties to be merged with the shorthand/properties provided
* * `renderByDefault` - a boolean that indicates if a slot will be rendered even if it's base value is `undefined`.
* By default if `props.SLOT_NAME` is `undefined` then `state.SLOT_NAME` becomes `undefined`
* and nothing will be rendered, but if `renderByDefault = true` then `state.SLOT_NAME` becomes an object
* with the values provided by `options.defaultProps` (or `{}`). This is useful for cases such as providing a default content
* in case no shorthand is provided, like the case of the `expandIcon` slot for the `AccordionHeader`
*/ function optional(value, options) {
	if (value === null || value === void 0 && !options.renderByDefault) return;
	return always(value, options);
}
/**
* Helper function that converts a slot shorthand or properties to a slot properties object
* The main difference between this function and `slot` is that this function does not return the metadata required for a slot to be considered a properly renderable slot, it only converts the value to a slot properties object
* @param value - the value of the slot, it can be a slot shorthand or a slot properties object
*/ function resolveShorthand(value) {
	if (typeof value === "string" || typeof value === "number" || isIterable(value) || import_react.isValidElement(value)) return { children: value };
	if (value && typeof value !== "object" && true) console.error(`@fluentui/react-utilities [slot.${resolveShorthand.name}]:
A slot got an invalid value "${value}" (${typeof value}).
A valid value for a slot is a slot shorthand or slot properties object.
Slot shorthands can be strings, numbers, arrays or JSX elements`);
	return value;
}
var isIterable = (value) => typeof value === "object" && value !== null && Symbol.iterator in value;

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/compose/isSlot.js
/**
* Guard method to ensure a given element is a slot.
* This is mainly used internally to ensure a slot is being used as a component.
*/ function isSlot(element) {
	return Boolean(element === null || element === void 0 ? void 0 : element.hasOwnProperty(SLOT_ELEMENT_TYPE_SYMBOL));
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/compose/assertSlots.js
/**
* @internal
* Assertion method to ensure state slots properties are properly declared.
* A properly declared slot must be declared by using the `slot` method.
*
* @example
* ```tsx
* export const renderInput_unstable  = (state: InputState): JSXElement => {
assertSlots<InputSlots>(state);
return (
<state.root>
{state.contentBefore && <state.contentBefore />}
<state.input />
{state.contentAfter && <state.contentAfter />}
</state.root>
);
};
* ```
*/ function assertSlots(state) {
	{
		const typedState = state;
		for (const slotName of Object.keys(typedState.components)) {
			const slotElement = typedState[slotName];
			if (slotElement === void 0) continue;
			if (!isSlot(slotElement)) {
				typedState[slotName] = always(slotElement, { elementType: typedState.components[slotName] });
				console.warn(`@fluentui/react-utilities [${assertSlots.name}]:
"state.${slotName}" is not a slot!
Be sure to create slots properly by using "slot.always" or "slot.optional".`);
			} else {
				const { [SLOT_ELEMENT_TYPE_SYMBOL]: elementType } = slotElement;
				if (elementType !== typedState.components[slotName]) {
					slotElement[SLOT_ELEMENT_TYPE_SYMBOL] = typedState.components[slotName];
					console.warn(`@fluentui/react-utilities [${assertSlots.name}]:
"state.${slotName}" element type differs from "state.components.${slotName}",
${elementType} !== ${typedState.components[slotName]}.
Be sure to create slots properly by using "slot.always" or "slot.optional" with the correct elementType.`);
				}
			}
		}
	}
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/utils/properties.js
var toObjectMap = (...items) => {
	const result = {};
	for (const item of items) {
		const keys = Array.isArray(item) ? item : Object.keys(item);
		for (const key of keys) result[key] = 1;
	}
	return result;
};
/**
* An array of events that are allowed on every html element type.
*
* @public
*/ const baseElementEvents = toObjectMap([
	"onAuxClick",
	"onAnimationEnd",
	"onAnimationStart",
	"onCopy",
	"onCut",
	"onPaste",
	"onCompositionEnd",
	"onCompositionStart",
	"onCompositionUpdate",
	"onFocus",
	"onFocusCapture",
	"onBlur",
	"onBlurCapture",
	"onChange",
	"onInput",
	"onSubmit",
	"onLoad",
	"onError",
	"onKeyDown",
	"onKeyDownCapture",
	"onKeyPress",
	"onKeyUp",
	"onAbort",
	"onCanPlay",
	"onCanPlayThrough",
	"onDurationChange",
	"onEmptied",
	"onEncrypted",
	"onEnded",
	"onLoadedData",
	"onLoadedMetadata",
	"onLoadStart",
	"onPause",
	"onPlay",
	"onPlaying",
	"onProgress",
	"onRateChange",
	"onSeeked",
	"onSeeking",
	"onStalled",
	"onSuspend",
	"onTimeUpdate",
	"onVolumeChange",
	"onWaiting",
	"onClick",
	"onClickCapture",
	"onContextMenu",
	"onDoubleClick",
	"onDrag",
	"onDragEnd",
	"onDragEnter",
	"onDragExit",
	"onDragLeave",
	"onDragOver",
	"onDragStart",
	"onDrop",
	"onMouseDown",
	"onMouseDownCapture",
	"onMouseEnter",
	"onMouseLeave",
	"onMouseMove",
	"onMouseOut",
	"onMouseOver",
	"onMouseUp",
	"onMouseUpCapture",
	"onSelect",
	"onTouchCancel",
	"onTouchEnd",
	"onTouchMove",
	"onTouchStart",
	"onScroll",
	"onWheel",
	"onPointerCancel",
	"onPointerDown",
	"onPointerEnter",
	"onPointerLeave",
	"onPointerMove",
	"onPointerOut",
	"onPointerOver",
	"onPointerUp",
	"onGotPointerCapture",
	"onLostPointerCapture"
]);
/**
* An array of element attributes which are allowed on every html element type.
*
* @public
*/ const baseElementProperties = toObjectMap([
	"accessKey",
	"children",
	"className",
	"contentEditable",
	"dir",
	"draggable",
	"hidden",
	"htmlFor",
	"id",
	"lang",
	"ref",
	"role",
	"style",
	"tabIndex",
	"title",
	"translate",
	"spellCheck",
	"name"
]);
/**
* An array of microdata attributes that are allowed on every html element type.
*
* @public
*/ const microdataProperties = toObjectMap([
	"itemID",
	"itemProp",
	"itemRef",
	"itemScope",
	"itemType"
]);
/**
* An array of HTML element properties and events.
*
* @public
*/ const htmlElementProperties = toObjectMap(baseElementProperties, baseElementEvents, microdataProperties);
/**
* An array of LABEL tag properties and events.
*
* @public
*/ const labelProperties = toObjectMap(htmlElementProperties, ["form"]);
/**
* An array of AUDIO tag properties and events.

* @public
*/ const audioProperties = toObjectMap(htmlElementProperties, [
	"height",
	"loop",
	"muted",
	"preload",
	"src",
	"width"
]);
/**
* An array of VIDEO tag properties and events.
*
* @public
*/ const videoProperties = toObjectMap(audioProperties, ["poster"]);
/**
* An array of OL tag properties and events.
*
* @public
*/ const olProperties = toObjectMap(htmlElementProperties, ["start"]);
/**
* An array of LI tag properties and events.
*
* @public
*/ const liProperties = toObjectMap(htmlElementProperties, ["value"]);
/**
* An array of A tag properties and events.
*
* @public
*/ const anchorProperties = toObjectMap(htmlElementProperties, [
	"download",
	"href",
	"hrefLang",
	"media",
	"referrerPolicy",
	"rel",
	"target",
	"type"
]);
/**
* An array of TIME tag properties and events.
*
* @public
*/ const timeProperties = toObjectMap(htmlElementProperties, ["dateTime"]);
/**
* An array of BUTTON tag properties and events.
*
* @public
*/ const buttonProperties = toObjectMap(htmlElementProperties, [
	"autoFocus",
	"disabled",
	"form",
	"formAction",
	"formEncType",
	"formMethod",
	"formNoValidate",
	"formTarget",
	"type",
	"value"
]);
/**
* An array of INPUT tag properties and events.
*
* @public
*/ const inputProperties = toObjectMap(buttonProperties, [
	"accept",
	"alt",
	"autoCorrect",
	"autoCapitalize",
	"autoComplete",
	"checked",
	"dirname",
	"form",
	"height",
	"inputMode",
	"list",
	"max",
	"maxLength",
	"min",
	"minLength",
	"multiple",
	"pattern",
	"placeholder",
	"readOnly",
	"required",
	"src",
	"step",
	"size",
	"type",
	"value",
	"width"
]);
/**
* An array of TEXTAREA tag properties and events.
*
* @public
*/ const textAreaProperties = toObjectMap(buttonProperties, [
	"autoCapitalize",
	"cols",
	"dirname",
	"form",
	"maxLength",
	"placeholder",
	"readOnly",
	"required",
	"rows",
	"wrap"
]);
/**
* An array of SELECT tag properties and events.
*
* @public
*/ const selectProperties = toObjectMap(buttonProperties, [
	"form",
	"multiple",
	"required"
]);
const optionProperties = toObjectMap(htmlElementProperties, ["selected", "value"]);
/**
* An array of TABLE tag properties and events.
*
* @public
*/ const tableProperties = toObjectMap(htmlElementProperties, ["cellPadding", "cellSpacing"]);
/**
* An array of TR tag properties and events.
*
* @public
*/ const trProperties = htmlElementProperties;
/**
* An array of TH tag properties and events.
*
* @public
*/ const thProperties = toObjectMap(htmlElementProperties, [
	"colSpan",
	"rowSpan",
	"scope"
]);
/**
* An array of TD tag properties and events.
*
* @public
*/ const tdProperties = toObjectMap(htmlElementProperties, [
	"colSpan",
	"headers",
	"rowSpan",
	"scope"
]);
const colGroupProperties = toObjectMap(htmlElementProperties, ["span"]);
const colProperties = toObjectMap(htmlElementProperties, ["span"]);
/**
* An array of FIELDSET tag properties and events.
*
* @public
*/ const fieldsetProperties = toObjectMap(htmlElementProperties, ["disabled", "form"]);
/**
* An array of FORM tag properties and events.
*
* @public
*/ const formProperties = toObjectMap(htmlElementProperties, [
	"acceptCharset",
	"action",
	"encType",
	"encType",
	"method",
	"noValidate",
	"target"
]);
/**
* An array of IFRAME tag properties and events.
*
* @public
*/ const iframeProperties = toObjectMap(htmlElementProperties, [
	"allow",
	"allowFullScreen",
	"allowPaymentRequest",
	"allowTransparency",
	"csp",
	"height",
	"importance",
	"referrerPolicy",
	"sandbox",
	"src",
	"srcDoc",
	"width"
]);
/**
* An array of IMAGE tag properties and events.
*
* @public
*/ const imgProperties = toObjectMap(htmlElementProperties, [
	"alt",
	"crossOrigin",
	"height",
	"src",
	"srcSet",
	"useMap",
	"width"
]);
/**
* An array of DIALOG tag properties and events.
*
* @public
*/ const dialogProperties = toObjectMap(htmlElementProperties, [
	"open",
	"onCancel",
	"onClose"
]);
/**
* Gets native supported props for an html element provided the allowance set. Use one of the property
* sets defined (divProperties, buttonPropertes, etc) to filter out supported properties from a given
* props set. Note that all data- and aria- prefixed attributes will be allowed.
* NOTE: getNativeProps should always be applied first when adding props to a react component. The
* non-native props should be applied second. This will prevent getNativeProps from overriding your custom props.
* For example, if props passed to getNativeProps has an onClick function and getNativeProps is added to
* the component after an onClick function is added, then the getNativeProps onClick will override it.
*
* @public
* @param props - The unfiltered input props
* @param allowedPropNames - The array or record of allowed prop names.
* @param excludedPropNames
* @returns The filtered props
*/ function getNativeProps(props, allowedPropNames, excludedPropNames) {
	const isArray = Array.isArray(allowedPropNames);
	const result = {};
	const keys = Object.keys(props);
	for (const key of keys) if ((!isArray && allowedPropNames[key] || isArray && allowedPropNames.indexOf(key) >= 0 || key.indexOf("data-") === 0 || key.indexOf("aria-") === 0) && (!excludedPropNames || (excludedPropNames === null || excludedPropNames === void 0 ? void 0 : excludedPropNames.indexOf(key)) === -1)) result[key] = props[key];
	return result;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/utils/getNativeElementProps.js
var nativeElementMap = {
	label: labelProperties,
	audio: audioProperties,
	video: videoProperties,
	ol: olProperties,
	li: liProperties,
	a: anchorProperties,
	button: buttonProperties,
	input: inputProperties,
	textarea: textAreaProperties,
	select: selectProperties,
	option: optionProperties,
	table: tableProperties,
	tr: trProperties,
	th: thProperties,
	td: tdProperties,
	colGroup: colGroupProperties,
	col: colProperties,
	fieldset: fieldsetProperties,
	form: formProperties,
	iframe: iframeProperties,
	img: imgProperties,
	time: timeProperties,
	dialog: dialogProperties
};
/**
* Given an element tagname and user props, filters the props to only allowed props for the given
* element type.
* @param tagName - Tag name (e.g. "div")
* @param props - Props object
* @param excludedPropNames - List of props to disallow
*
* @deprecated use getIntrinsicElementProps instead, it is a type-safe version of this method
*/ function getNativeElementProps(tagName, props, excludedPropNames) {
	const allowedPropNames = tagName && nativeElementMap[tagName] || htmlElementProperties;
	allowedPropNames.as = 1;
	return getNativeProps(props, allowedPropNames, excludedPropNames);
}
/**
* Splits the native props into ones that go to the `root` slot, and ones that go to the primary slot.
*
* This function is only for use with components that have a primary slot other than `root`.
* Most components should use {@link getNativeElementProps} for their root slot if it is the primary slot.
*
* @returns An object containing the native props for the `root` and primary slots.
*/ const getPartitionedNativeProps = ({ primarySlotTagName, props, excludedPropNames }) => {
	return {
		root: {
			style: props.style,
			className: props.className
		},
		primary: getNativeElementProps(primarySlotTagName, props, [
			...excludedPropNames || [],
			"style",
			"className"
		])
	};
};

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/compose/getIntrinsicElementProps.js
/**
* Given an element tagname and user props, filters the props to only allowed props for the given
* element type.
*
* Equivalent to {@link getNativeElementProps}, but more type-safe.
*
* @param tagName - The slot's default element type (e.g. 'div')
* @param props - The component's props object
* @param excludedPropNames - List of native props to exclude from the returned value
*/ const getIntrinsicElementProps = (tagName, props, excludedPropNames) => {
	var _props_as;
	return getNativeElementProps((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : tagName, props, excludedPropNames);
};

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/ThemeClassNameContext/ThemeClassNameContext.js
/**
* @internal
* Used to provide a CSS class that applies theme css variables
*
* Useful for elements in the React tree (can read context) but not in the DOM Tree. E.g. Portals
*/ var ThemeClassNameContext = import_react.createContext(void 0);
var themeClassNameContextDefaultVaue = "";
const ThemeClassNameProvider = ThemeClassNameContext.Provider;
/**
* @returns CSS class that applies css variables
*/ function useThemeClassName() {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(ThemeClassNameContext)) !== null && _React_useContext !== void 0 ? _React_useContext : themeClassNameContextDefaultVaue;
}

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/TooltipVisibilityContext/TooltipContext.js
/**
* @internal
* Context shared by all of the tooltips in the app
*/ var TooltipVisibilityContext = import_react.createContext(void 0);
var tooltipVisibilityContextDefaultValue = {};
/**
* @internal
*/ const TooltipVisibilityProvider = TooltipVisibilityContext.Provider;
function useTooltipVisibility() {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(TooltipVisibilityContext)) !== null && _React_useContext !== void 0 ? _React_useContext : tooltipVisibilityContextDefaultValue;
}

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/ProviderContext/ProviderContext.js
/**
* @internal
*/ var ProviderContext = import_react.createContext(void 0);
var providerContextDefaultValue = {
	targetDocument: typeof document === "object" ? document : void 0,
	dir: "ltr"
};
/**
* @internal
*/ const Provider = ProviderContext.Provider;
function useFluent() {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(ProviderContext)) !== null && _React_useContext !== void 0 ? _React_useContext : providerContextDefaultValue;
}

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/CustomStyleHooksContext/CustomStyleHooksContext.js
/**
* @internal
*/ const CustomStyleHooksContext = import_react.createContext(void 0);
var noop = () => {};
/**
* @internal
*/ const CustomStyleHooksProvider = CustomStyleHooksContext.Provider;
/**
* Gets a custom style hook
* @param hook - One of the hook properties in CustomStyleHooksContextValue
* @returns The corresponding hook when defined, otherwise a no-op function.
*/ const useCustomStyleHook = (hook) => {
	var _React_useContext;
	var _React_useContext_hook;
	return (_React_useContext_hook = (_React_useContext = import_react.useContext(CustomStyleHooksContext)) === null || _React_useContext === void 0 ? void 0 : _React_useContext[hook]) !== null && _React_useContext_hook !== void 0 ? _React_useContext_hook : noop;
};

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/PortalMountNodeContext.js
/**
* Provides a mount node for portals to render into.
*
* @internal
*/ var PortalMountNodeContext = import_react.createContext(void 0);
/**
* @internal
*/ const PortalMountNodeProvider = PortalMountNodeContext.Provider;
function usePortalMountNode$1() {
	return import_react.useContext(PortalMountNodeContext);
}

//#endregion
//#region node_modules/@fluentui/react-shared-contexts/lib/AnnounceContext/AnnounceContext.js
/**
* @internal
*/ var AnnounceContext = import_react.createContext(void 0);
const AnnounceProvider = AnnounceContext.Provider;
/**
* Returns a function that can be used to announce messages to screen readers.
*/ function useAnnounce() {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(AnnounceContext)) !== null && _React_useContext !== void 0 ? _React_useContext : { announce: () => void 0 };
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/useControllableState.js
function isFactoryDispatch(newState) {
	return typeof newState === "function";
}
/**
* @internal
*
* A [`useState`](https://reactjs.org/docs/hooks-reference.html#usestate)-like hook
* to manage a value that could be either `controlled` or `uncontrolled`,
* such as a checked state or text input string.
*
* @see https://react.dev/learn/sharing-state-between-components#controlled-and-uncontrolled-components for more details on `controlled`/`uncontrolled`
*
* @returns an array of the current value and an updater (dispatcher) function.
* The updater function is referentially stable (won't change during the component's lifecycle).
* It can take either a new value, or a function which is passed the previous value and returns the new value.
*
* ❗️❗️ Calls to the dispatcher will only modify the state if the state is `uncontrolled`.
* Meaning that if a state is `controlled`, calls to the dispatcher do not modify the state.
*
*/ const useControllableState = (options) => {
	"use no memo";
	if (options.state !== void 0 && options.defaultState !== void 0) console.error(`@fluentui/react-utilities [useControllableState]:
A component must be either controlled or uncontrolled (specify either the state or the defaultState, but not both).
Decide between using a controlled or uncontrolled component and remove one of this props.
More info: https://reactjs.org/link/controlled-components
${(/* @__PURE__ */ new Error()).stack}`);
	const [internalState, setInternalState] = import_react.useState(() => {
		if (options.defaultState === void 0) return options.initialState;
		return isInitializer(options.defaultState) ? options.defaultState() : options.defaultState;
	});
	const stateValueRef = import_react.useRef(options.state);
	import_react.useEffect(() => {
		stateValueRef.current = options.state;
	}, [options.state]);
	const setControlledState = import_react.useCallback((newState) => {
		if (isFactoryDispatch(newState)) newState(stateValueRef.current);
	}, []);
	return useIsControlled(options.state) ? [options.state, setControlledState] : [internalState, setInternalState];
};
function isInitializer(value) {
	return typeof value === "function";
}
/**
* Helper hook to handle previous comparison of controlled/uncontrolled
* Prints an error when isControlled value switches between subsequent renders
* @returns - whether the value is controlled
*/ var useIsControlled = (controlledValue) => {
	"use no memo";
	const [isControlled] = import_react.useState(() => controlledValue !== void 0);
	import_react.useEffect(() => {
		if (isControlled !== (controlledValue !== void 0)) {
			const error = /* @__PURE__ */ new Error();
			const controlWarning = isControlled ? "a controlled value to be uncontrolled" : "an uncontrolled value to be controlled";
			const undefinedWarning = isControlled ? "defined to an undefined" : "undefined to a defined";
			console.error(`@fluentui/react-utilities [useControllableState]:
A component is changing ${controlWarning}. This is likely caused by the value changing from ${undefinedWarning} value, which should not happen.
Decide between using a controlled or uncontrolled input element for the lifetime of the component.
More info: https://reactjs.org/link/controlled-components
${error.stack}`);
		}
	}, [isControlled, controlledValue]);
	return isControlled;
};

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/ssr/canUseDOM.js
function canUseDOM() {
	return typeof window !== "undefined" && !!(window.document && window.document.createElement);
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/ssr/SSRContext.js
/**
* Default context value to use in case there is no SSRProvider. This is fine for client-only apps.
*
* @internal
*/ const defaultSSRContextValue = { current: 0 };
const SSRContext = /* @__PURE__ */ import_react.createContext(void 0);
/**
* @internal
*/ function useSSRContext() {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(SSRContext)) !== null && _React_useContext !== void 0 ? _React_useContext : defaultSSRContextValue;
}
/**
* When using SSR with Fluent UI, applications must be wrapped in an SSRProvider. This ensures that auto generated ids
* are consistent between the client and server.
*
* @public
*/ const SSRProvider = (props) => {
	const [value] = import_react.useState(() => ({ current: 0 }));
	return /* @__PURE__ */ import_react.createElement(SSRContext.Provider, { value }, props.children);
};
/**
* Returns whether the component is currently being server side rendered or hydrated on the client. Can be used to delay
* browser-specific rendering until after hydration. May cause re-renders on a client when is used within SSRProvider.
*/ function useIsSSR() {
	const isInSSRContext = useSSRContext() !== defaultSSRContextValue;
	const [isSSR, setIsSSR] = import_react.useState(isInSSRContext);
	if (!isInSSRContext && !canUseDOM()) console.error(`@fluentui/react-components [${useIsSSR.name}]:
When server rendering, you must wrap your application in an <SSRProvider> to ensure consistent ids are generated between the client and server.


Check documentation at https://aka.ms/fluentui-ssr.`);
	if (canUseDOM() && isInSSRContext) import_react.useLayoutEffect(() => {
		setIsSSR(false);
	}, []);
	return isSSR;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/useIsomorphicLayoutEffect.js
/**
* React currently throws a warning when using useLayoutEffect on the server. To get around it, we can conditionally
* useEffect on the server (no-op) and useLayoutEffect in the browser. We occasionally need useLayoutEffect to
* ensure we don't get a render flash for certain operations, but we may also need affected components to render on
* the server.
*
* https://gist.github.com/gaearon/e7d97cdf38a2907924ea12e4ebdf3c85
* https://github.com/reduxjs/react-redux/blob/master/src/utils/useIsomorphicLayoutEffect.js
*/ const useIsomorphicLayoutEffect = canUseDOM() ? import_react.useLayoutEffect : import_react.useEffect;

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/useEventCallback.js
/**
* @internal
* https://reactjs.org/docs/hooks-faq.html#how-to-read-an-often-changing-value-from-usecallback
*
* Modified `useCallback` that can be used when dependencies change too frequently. Can occur when
* e.g. user props are dependencies which could change on every render
* e.g. volatile values (i.e. useState/useDispatch) are dependencies which could change frequently
*
* This should not be used often, but can be a useful re-render optimization since the callback is a ref and
* will not be invalidated between re-renders
*
* @param fn - The callback function that will be used
*/ const useEventCallback = (fn) => {
	const callbackRef = import_react.useRef(() => {
		throw new Error("Cannot call an event handler while rendering");
	});
	useIsomorphicLayoutEffect(() => {
		callbackRef.current = fn;
	}, [fn]);
	return import_react.useCallback((...args) => {
		const callback = callbackRef.current;
		return callback(...args);
	}, [callbackRef]);
};

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/useId.js
var IdPrefixContext = import_react.createContext(void 0);
/**
* Allows to define a prefix that will be used for all IDs generated by useId() hook. It's useful to avoid collisions
* between different bundles.
*/ const IdPrefixProvider = IdPrefixContext.Provider;
function useIdPrefix() {
	return import_react.useContext(IdPrefixContext) || "";
}
/**
* Resets generated IDs, should be used only in tests.
*/ function resetIdsForTests() {
	defaultSSRContextValue.current = 0;
}
/**
* Hook to generate a unique ID.
*
* @param prefix - Optional prefix for the ID. Defaults to 'fui-'.
* @param providedId - Optional id provided by a parent component. Defaults to the provided value if present,
*  without conditioning the hook call
* @returns The ID
*/ function useId(prefix = "fui-", providedId) {
	"use no memo";
	const contextValue = useSSRContext();
	const idPrefix = useIdPrefix();
	const _useId = import_react.useId;
	if (_useId) {
		const generatedId = _useId();
		const escapedId = import_react.useMemo(() => generatedId.replace(/:/g, ""), [generatedId]);
		return providedId || `${idPrefix}${prefix}${escapedId}`;
	}
	return import_react.useMemo(() => {
		if (providedId) return providedId;
		return `${idPrefix}${prefix}${++contextValue.current}`;
	}, [
		idPrefix,
		prefix,
		providedId,
		contextValue
	]);
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/useMergedRefs.js
/**
* React hook to merge multiple React refs (either MutableRefObjects or ref callbacks) into a single ref callback that
* updates all provided refs
* @param refs - Refs to collectively update with one ref value.
* @returns A function with an attached "current" prop, so that it can be treated like a RefObject.
*/ function useMergedRefs(...refs) {
	"use no memo";
	const mergedCallback = import_react.useCallback((value) => {
		mergedCallback.current = value;
		for (const ref of refs) {
			if (typeof ref === "string" && true) console.error(`@fluentui/react-utilities [useMergedRefs]:
This hook does not support the usage of string refs. Please use React.useRef instead.

For more info on 'React.useRef', see https://react.dev/reference/react/useRef.
For more info on string refs, see https://react.dev/blog/2024/04/25/react-19-upgrade-guide#removed-string-refs.`);
			if (typeof ref === "function") ref(value);
			else if (ref) ref.current = value;
		}
	}, [...refs]);
	return mergedCallback;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/hooks/usePrevious.js
/**
* @internal
*/ const usePrevious = (value) => {
	const ref = import_react.useRef(null);
	import_react.useEffect(() => {
		ref.current = value;
	}, [value]);
	return ref.current;
};

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/utils/getReactElementRef.js
var IS_REACT_19_OR_HIGHER = parseInt(import_react.version, 10) >= 19;
/**
* Returns a ref for the React element in a backwards-compatible way.
*
* @param element - The element to get the ref for.
* @returns The ref for the element.
*/ function getReactElementRef(element) {
	if (!element) return;
	if (IS_REACT_19_OR_HIGHER) return element.props.ref;
	return element.ref;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/utils/mergeCallbacks.js
/**
* @internal
* Combine two event callbacks into a single callback function that calls each one in order.
*
* Usage example:
* ```ts
* state.slot.onChange = mergeCallbacks(state.slot.onChange, ev => {
*   // Handle onChange
* });
* ```
*
* The primary use is to avoid the need to capture an existing callback (`state.slot.onChange` in the example) to a
* local variable before replacing with a new listener that calls the existing one. This helps avoid bugs like:
* * Infinite recursion by calling the re-assigned state.slot.onChange if it's not captured to a local variable.
* * Missing a call to the original onChange due to an early return or other conditional.
*
* If you need a callback that is stable between renders, wrap the result in {@link useEventCallback}.
*
* @param callback1 - The first callback to be called, or undefined
* @param callback2 - The second callback to be called, or undefined
*
* @returns A function that that calls the provided functions in order
*/ function mergeCallbacks(callback1, callback2) {
	return (...args) => {
		callback1 === null || callback1 === void 0 || callback1(...args);
		callback2 === null || callback2 === void 0 || callback2(...args);
	};
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/utils/isHTMLElement.js
/**
* Verifies if a given node is an HTMLElement,
* this method works seamlessly with frames and elements from different documents
*
* This is preferred over simply using `instanceof`.
* Since `instanceof` might be problematic while operating with [multiple realms](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof#instanceof_and_multiple_realms)
*
* @example
* ```ts
* isHTMLElement(event.target) && event.target.focus()
* isHTMLElement(event.target, {constructorName: 'HTMLInputElement'}) && event.target.value // some value
* ```
*
*/ function isHTMLElement(element, options) {
	var _typedElement_ownerDocument;
	const typedElement = element;
	var _options_constructorName;
	return Boolean((typedElement === null || typedElement === void 0 ? void 0 : (_typedElement_ownerDocument = typedElement.ownerDocument) === null || _typedElement_ownerDocument === void 0 ? void 0 : _typedElement_ownerDocument.defaultView) && typedElement instanceof typedElement.ownerDocument.defaultView[(_options_constructorName = options === null || options === void 0 ? void 0 : options.constructorName) !== null && _options_constructorName !== void 0 ? _options_constructorName : "HTMLElement"]);
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/trigger/isFluentTrigger.js
/**
* @internal
* Checks if a given element is a FluentUI trigger (e.g. `MenuTrigger` or `Tooltip`).
* See the {@link FluentTriggerComponent} type for more info.
*/ function isFluentTrigger(element) {
	return Boolean(element.type.isFluentTriggerComponent);
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/trigger/applyTriggerPropsToChildren.js
/**
* @internal
* resolve the trigger props to the children, either by calling the render function, or cloning with the new props.
*/ function applyTriggerPropsToChildren(children, triggerChildProps) {
	if (typeof children === "function") return children(triggerChildProps);
	else if (children) return cloneTriggerTree(children, triggerChildProps);
	return children || null;
}
/**
* Clones a React element tree, and applies the given props to the first grandchild that is not
* a FluentTriggerComponent or React Fragment (the same element returned by {@link getTriggerChild}).
*/ function cloneTriggerTree(child, triggerProps) {
	if (!import_react.isValidElement(child) || child.type === import_react.Fragment) throw new Error("A trigger element must be a single element for this component. Please ensure that you're not using React Fragments.");
	if (isFluentTrigger(child)) {
		const grandchild = cloneTriggerTree(child.props.children, triggerProps);
		return import_react.cloneElement(child, void 0, grandchild);
	} else return import_react.cloneElement(child, triggerProps);
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/trigger/getTriggerChild.js
/**
* @internal
* Gets the trigger element of a FluentTriggerComponent (such as Tooltip or MenuTrigger).
*
* In the case where the immediate child is itself a FluentTriggerComponent and/or React Fragment,
* it returns the first descendant that is _not_ a FluentTriggerComponent or Fragment.
* This allows multiple triggers to be stacked, and still apply their props to the actual trigger element.
*
* For example, the following returns `<div id="child" />`:
* ```jsx
* getTriggerChild(
*   <Tooltip>
*     <MenuTrigger>
*       <div id="child" />
*     </MenuTrigger>
*   </Tooltip>
* );
* ```
*
* In the case where the immediate child is not a valid element,
* null is returned
*/ function getTriggerChild(children) {
	if (!import_react.isValidElement(children)) return null;
	return isFluentTrigger(children) ? getTriggerChild(children.props.children) : children;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/virtualParent/isVirtualElement.js
/**
* Determines whether or not an element has the virtual hierarchy extension.
* @internal
*/ function isVirtualElement(element) {
	return element && !!element._virtual;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/virtualParent/getParent.js
/**
* Gets the virtual parent given the child element, if it exists.
* @internal
*/ function getVirtualParent(child) {
	return isVirtualElement(child) ? child._virtual.parent || null : null;
}
/**
* Gets the element which is the parent of a given element.
* This method prefers the virtual parent over real DOM parent when present.
* @internal
*/ function getParent(child, options = {}) {
	if (!child) return null;
	if (!options.skipVirtual) {
		const virtualParent = getVirtualParent(child);
		if (virtualParent) return virtualParent;
	}
	const parent = child.parentNode;
	if (parent && parent.nodeType === 11) return parent.host;
	return parent;
}

//#endregion
//#region node_modules/@fluentui/react-utilities/lib/virtualParent/setVirtualParent.js
/**
* Sets the virtual parent of an element.
*
* @internal
* @param child - Theme element to set the virtual parent
* @param parent - The virtual parent, use `undefined` to remove a virtual parent relationship
*/ function setVirtualParent(child, parent) {
	if (!child) return;
	Object.assign(child, { _virtual: { parent } });
}

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/utils/createCompatSlotComponent.js
function createCompatSlotComponent(type, props) {
	return {
		...props,
		[SLOT_ELEMENT_TYPE_SYMBOL]: type
	};
}

//#endregion
//#region node_modules/react-is/cjs/react-is.development.js
var require_react_is_development = /* @__PURE__ */ __commonJS({ "node_modules/react-is/cjs/react-is.development.js": ((exports) => {
	(function() {
		var REACT_ELEMENT_TYPE = 60103;
		var REACT_PORTAL_TYPE = 60106;
		var REACT_FRAGMENT_TYPE = 60107;
		var REACT_STRICT_MODE_TYPE = 60108;
		var REACT_PROFILER_TYPE = 60114;
		var REACT_PROVIDER_TYPE = 60109;
		var REACT_CONTEXT_TYPE = 60110;
		var REACT_FORWARD_REF_TYPE = 60112;
		var REACT_SUSPENSE_TYPE = 60113;
		var REACT_SUSPENSE_LIST_TYPE = 60120;
		var REACT_MEMO_TYPE = 60115;
		var REACT_LAZY_TYPE = 60116;
		var REACT_BLOCK_TYPE = 60121;
		var REACT_SERVER_BLOCK_TYPE = 60122;
		var REACT_FUNDAMENTAL_TYPE = 60117;
		var REACT_DEBUG_TRACING_MODE_TYPE = 60129;
		var REACT_LEGACY_HIDDEN_TYPE = 60131;
		if (typeof Symbol === "function" && Symbol.for) {
			var symbolFor = Symbol.for;
			REACT_ELEMENT_TYPE = symbolFor("react.element");
			REACT_PORTAL_TYPE = symbolFor("react.portal");
			REACT_FRAGMENT_TYPE = symbolFor("react.fragment");
			REACT_STRICT_MODE_TYPE = symbolFor("react.strict_mode");
			REACT_PROFILER_TYPE = symbolFor("react.profiler");
			REACT_PROVIDER_TYPE = symbolFor("react.provider");
			REACT_CONTEXT_TYPE = symbolFor("react.context");
			REACT_FORWARD_REF_TYPE = symbolFor("react.forward_ref");
			REACT_SUSPENSE_TYPE = symbolFor("react.suspense");
			REACT_SUSPENSE_LIST_TYPE = symbolFor("react.suspense_list");
			REACT_MEMO_TYPE = symbolFor("react.memo");
			REACT_LAZY_TYPE = symbolFor("react.lazy");
			REACT_BLOCK_TYPE = symbolFor("react.block");
			REACT_SERVER_BLOCK_TYPE = symbolFor("react.server.block");
			REACT_FUNDAMENTAL_TYPE = symbolFor("react.fundamental");
			symbolFor("react.scope");
			symbolFor("react.opaque.id");
			REACT_DEBUG_TRACING_MODE_TYPE = symbolFor("react.debug_trace_mode");
			symbolFor("react.offscreen");
			REACT_LEGACY_HIDDEN_TYPE = symbolFor("react.legacy_hidden");
		}
		var enableScopeAPI = false;
		function isValidElementType$1(type) {
			if (typeof type === "string" || typeof type === "function") return true;
			if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || type === REACT_DEBUG_TRACING_MODE_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || type === REACT_LEGACY_HIDDEN_TYPE || enableScopeAPI) return true;
			if (typeof type === "object" && type !== null) {
				if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_BLOCK_TYPE || type[0] === REACT_SERVER_BLOCK_TYPE) return true;
			}
			return false;
		}
		function typeOf(object) {
			if (typeof object === "object" && object !== null) {
				var $$typeof = object.$$typeof;
				switch ($$typeof) {
					case REACT_ELEMENT_TYPE:
						var type = object.type;
						switch (type) {
							case REACT_FRAGMENT_TYPE:
							case REACT_PROFILER_TYPE:
							case REACT_STRICT_MODE_TYPE:
							case REACT_SUSPENSE_TYPE:
							case REACT_SUSPENSE_LIST_TYPE: return type;
							default:
								var $$typeofType = type && type.$$typeof;
								switch ($$typeofType) {
									case REACT_CONTEXT_TYPE:
									case REACT_FORWARD_REF_TYPE:
									case REACT_LAZY_TYPE:
									case REACT_MEMO_TYPE:
									case REACT_PROVIDER_TYPE: return $$typeofType;
									default: return $$typeof;
								}
						}
					case REACT_PORTAL_TYPE: return $$typeof;
				}
			}
		}
		var ContextConsumer = REACT_CONTEXT_TYPE;
		var ContextProvider = REACT_PROVIDER_TYPE;
		var Element$1 = REACT_ELEMENT_TYPE;
		var ForwardRef = REACT_FORWARD_REF_TYPE;
		var Fragment$1 = REACT_FRAGMENT_TYPE;
		var Lazy = REACT_LAZY_TYPE;
		var Memo = REACT_MEMO_TYPE;
		var Portal$1 = REACT_PORTAL_TYPE;
		var Profiler = REACT_PROFILER_TYPE;
		var StrictMode = REACT_STRICT_MODE_TYPE;
		var Suspense = REACT_SUSPENSE_TYPE;
		var hasWarnedAboutDeprecatedIsAsyncMode = false;
		var hasWarnedAboutDeprecatedIsConcurrentMode = false;
		function isAsyncMode(object) {
			if (!hasWarnedAboutDeprecatedIsAsyncMode) {
				hasWarnedAboutDeprecatedIsAsyncMode = true;
				console["warn"]("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 18+.");
			}
			return false;
		}
		function isConcurrentMode(object) {
			if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
				hasWarnedAboutDeprecatedIsConcurrentMode = true;
				console["warn"]("The ReactIs.isConcurrentMode() alias has been deprecated, and will be removed in React 18+.");
			}
			return false;
		}
		function isContextConsumer(object) {
			return typeOf(object) === REACT_CONTEXT_TYPE;
		}
		function isContextProvider(object) {
			return typeOf(object) === REACT_PROVIDER_TYPE;
		}
		function isElement$1(object) {
			return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
		}
		function isForwardRef(object) {
			return typeOf(object) === REACT_FORWARD_REF_TYPE;
		}
		function isFragment(object) {
			return typeOf(object) === REACT_FRAGMENT_TYPE;
		}
		function isLazy(object) {
			return typeOf(object) === REACT_LAZY_TYPE;
		}
		function isMemo(object) {
			return typeOf(object) === REACT_MEMO_TYPE;
		}
		function isPortal(object) {
			return typeOf(object) === REACT_PORTAL_TYPE;
		}
		function isProfiler(object) {
			return typeOf(object) === REACT_PROFILER_TYPE;
		}
		function isStrictMode(object) {
			return typeOf(object) === REACT_STRICT_MODE_TYPE;
		}
		function isSuspense(object) {
			return typeOf(object) === REACT_SUSPENSE_TYPE;
		}
		exports.ContextConsumer = ContextConsumer;
		exports.ContextProvider = ContextProvider;
		exports.Element = Element$1;
		exports.ForwardRef = ForwardRef;
		exports.Fragment = Fragment$1;
		exports.Lazy = Lazy;
		exports.Memo = Memo;
		exports.Portal = Portal$1;
		exports.Profiler = Profiler;
		exports.StrictMode = StrictMode;
		exports.Suspense = Suspense;
		exports.isAsyncMode = isAsyncMode;
		exports.isConcurrentMode = isConcurrentMode;
		exports.isContextConsumer = isContextConsumer;
		exports.isContextProvider = isContextProvider;
		exports.isElement = isElement$1;
		exports.isForwardRef = isForwardRef;
		exports.isFragment = isFragment;
		exports.isLazy = isLazy;
		exports.isMemo = isMemo;
		exports.isPortal = isPortal;
		exports.isProfiler = isProfiler;
		exports.isStrictMode = isStrictMode;
		exports.isSuspense = isSuspense;
		exports.isValidElementType = isValidElementType$1;
		exports.typeOf = typeOf;
	})();
}) });

//#endregion
//#region node_modules/react-is/index.js
var require_react_is = /* @__PURE__ */ __commonJS({ "node_modules/react-is/index.js": ((exports, module) => {
	module.exports = require_react_is_development();
}) });

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/utils/warnIfElementTypeIsInvalid.js
var import_react_is = /* @__PURE__ */ __toESM(require_react_is());
function warnIfElementTypeIsInvalid(type) {
	if (typeof type === "object" && !(0, import_react_is.isValidElementType)(type)) console.error(`@fluentui/react-jsx-runtime:
Element type is invalid: expected a string (for built-in components) or a class/function (for composite components) but got: ${type}.

If this happened in a slot of Fluent UI component, you might be facing package resolution issues.
Please make sure you don't have multiple versions of "@fluentui/react-utilities" installed in your dependencies or sub-dependencies.
You can check this by searching up for matching entries in a lockfile produced by your package manager (yarn.lock, pnpm-lock.yaml or package-lock.json).`);
}

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/jsx/createJSX.js
function createJSX(runtime, slotRuntime) {
	return function jsx$1(type, overrideProps, key, source, self) {
		if (isSlot(overrideProps)) return slotRuntime(createCompatSlotComponent(type, overrideProps), null, key, source, self);
		if (isSlot(type)) return slotRuntime(type, overrideProps, key, source, self);
		warnIfElementTypeIsInvalid(type);
		return runtime(type, overrideProps, key, source, self);
	};
}

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/utils/getMetadataFromSlotComponent.js
/**
* @internal
*/ function getMetadataFromSlotComponent(type) {
	const { as, [SLOT_CLASS_NAME_PROP_SYMBOL]: _classNameProp, [SLOT_ELEMENT_TYPE_SYMBOL]: baseElementType, [SLOT_RENDER_FUNCTION_SYMBOL]: renderFunction,...propsWithoutMetadata } = type;
	const props = propsWithoutMetadata;
	const elementType = typeof baseElementType === "string" ? as !== null && as !== void 0 ? as : baseElementType : baseElementType;
	if (typeof elementType !== "string" && as) props.as = as;
	return {
		elementType,
		props,
		renderFunction
	};
}

//#endregion
//#region node_modules/react/cjs/react-jsx-runtime.development.js
var require_react_jsx_runtime_development = /* @__PURE__ */ __commonJS({ "node_modules/react/cjs/react-jsx-runtime.development.js": ((exports) => {
	(function() {
		function getComponentNameFromType(type) {
			if (null == type) return null;
			if ("function" === typeof type) return type.$$typeof === REACT_CLIENT_REFERENCE ? null : type.displayName || type.name || null;
			if ("string" === typeof type) return type;
			switch (type) {
				case REACT_FRAGMENT_TYPE: return "Fragment";
				case REACT_PROFILER_TYPE: return "Profiler";
				case REACT_STRICT_MODE_TYPE: return "StrictMode";
				case REACT_SUSPENSE_TYPE: return "Suspense";
				case REACT_SUSPENSE_LIST_TYPE: return "SuspenseList";
				case REACT_ACTIVITY_TYPE: return "Activity";
			}
			if ("object" === typeof type) switch ("number" === typeof type.tag && console.error("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."), type.$$typeof) {
				case REACT_PORTAL_TYPE: return "Portal";
				case REACT_CONTEXT_TYPE: return type.displayName || "Context";
				case REACT_CONSUMER_TYPE: return (type._context.displayName || "Context") + ".Consumer";
				case REACT_FORWARD_REF_TYPE:
					var innerType = type.render;
					type = type.displayName;
					type || (type = innerType.displayName || innerType.name || "", type = "" !== type ? "ForwardRef(" + type + ")" : "ForwardRef");
					return type;
				case REACT_MEMO_TYPE: return innerType = type.displayName || null, null !== innerType ? innerType : getComponentNameFromType(type.type) || "Memo";
				case REACT_LAZY_TYPE:
					innerType = type._payload;
					type = type._init;
					try {
						return getComponentNameFromType(type(innerType));
					} catch (x) {}
			}
			return null;
		}
		function testStringCoercion(value) {
			return "" + value;
		}
		function checkKeyStringCoercion(value) {
			try {
				testStringCoercion(value);
				var JSCompiler_inline_result = !1;
			} catch (e) {
				JSCompiler_inline_result = !0;
			}
			if (JSCompiler_inline_result) {
				JSCompiler_inline_result = console;
				var JSCompiler_temp_const = JSCompiler_inline_result.error;
				var JSCompiler_inline_result$jscomp$0 = "function" === typeof Symbol && Symbol.toStringTag && value[Symbol.toStringTag] || value.constructor.name || "Object";
				JSCompiler_temp_const.call(JSCompiler_inline_result, "The provided key is an unsupported type %s. This value must be coerced to a string before using it here.", JSCompiler_inline_result$jscomp$0);
				return testStringCoercion(value);
			}
		}
		function getTaskName(type) {
			if (type === REACT_FRAGMENT_TYPE) return "<>";
			if ("object" === typeof type && null !== type && type.$$typeof === REACT_LAZY_TYPE) return "<...>";
			try {
				var name = getComponentNameFromType(type);
				return name ? "<" + name + ">" : "<...>";
			} catch (x) {
				return "<...>";
			}
		}
		function getOwner() {
			var dispatcher = ReactSharedInternals.A;
			return null === dispatcher ? null : dispatcher.getOwner();
		}
		function UnknownOwner() {
			return Error("react-stack-top-frame");
		}
		function hasValidKey(config) {
			if (hasOwnProperty.call(config, "key")) {
				var getter = Object.getOwnPropertyDescriptor(config, "key").get;
				if (getter && getter.isReactWarning) return !1;
			}
			return void 0 !== config.key;
		}
		function defineKeyPropWarningGetter(props, displayName) {
			function warnAboutAccessingKey() {
				specialPropKeyWarningShown || (specialPropKeyWarningShown = !0, console.error("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://react.dev/link/special-props)", displayName));
			}
			warnAboutAccessingKey.isReactWarning = !0;
			Object.defineProperty(props, "key", {
				get: warnAboutAccessingKey,
				configurable: !0
			});
		}
		function elementRefGetterWithDeprecationWarning() {
			var componentName = getComponentNameFromType(this.type);
			didWarnAboutElementRef[componentName] || (didWarnAboutElementRef[componentName] = !0, console.error("Accessing element.ref was removed in React 19. ref is now a regular prop. It will be removed from the JSX Element type in a future release."));
			componentName = this.props.ref;
			return void 0 !== componentName ? componentName : null;
		}
		function ReactElement(type, key, props, owner, debugStack, debugTask) {
			var refProp = props.ref;
			type = {
				$$typeof: REACT_ELEMENT_TYPE,
				type,
				key,
				props,
				_owner: owner
			};
			null !== (void 0 !== refProp ? refProp : null) ? Object.defineProperty(type, "ref", {
				enumerable: !1,
				get: elementRefGetterWithDeprecationWarning
			}) : Object.defineProperty(type, "ref", {
				enumerable: !1,
				value: null
			});
			type._store = {};
			Object.defineProperty(type._store, "validated", {
				configurable: !1,
				enumerable: !1,
				writable: !0,
				value: 0
			});
			Object.defineProperty(type, "_debugInfo", {
				configurable: !1,
				enumerable: !1,
				writable: !0,
				value: null
			});
			Object.defineProperty(type, "_debugStack", {
				configurable: !1,
				enumerable: !1,
				writable: !0,
				value: debugStack
			});
			Object.defineProperty(type, "_debugTask", {
				configurable: !1,
				enumerable: !1,
				writable: !0,
				value: debugTask
			});
			Object.freeze && (Object.freeze(type.props), Object.freeze(type));
			return type;
		}
		function jsxDEVImpl(type, config, maybeKey, isStaticChildren, debugStack, debugTask) {
			var children = config.children;
			if (void 0 !== children) if (isStaticChildren) if (isArrayImpl(children)) {
				for (isStaticChildren = 0; isStaticChildren < children.length; isStaticChildren++) validateChildKeys(children[isStaticChildren]);
				Object.freeze && Object.freeze(children);
			} else console.error("React.jsx: Static children should always be an array. You are likely explicitly calling React.jsxs or React.jsxDEV. Use the Babel transform instead.");
			else validateChildKeys(children);
			if (hasOwnProperty.call(config, "key")) {
				children = getComponentNameFromType(type);
				var keys = Object.keys(config).filter(function(k) {
					return "key" !== k;
				});
				isStaticChildren = 0 < keys.length ? "{key: someKey, " + keys.join(": ..., ") + ": ...}" : "{key: someKey}";
				didWarnAboutKeySpread[children + isStaticChildren] || (keys = 0 < keys.length ? "{" + keys.join(": ..., ") + ": ...}" : "{}", console.error("A props object containing a \"key\" prop is being spread into JSX:\n  let props = %s;\n  <%s {...props} />\nReact keys must be passed directly to JSX without using spread:\n  let props = %s;\n  <%s key={someKey} {...props} />", isStaticChildren, children, keys, children), didWarnAboutKeySpread[children + isStaticChildren] = !0);
			}
			children = null;
			void 0 !== maybeKey && (checkKeyStringCoercion(maybeKey), children = "" + maybeKey);
			hasValidKey(config) && (checkKeyStringCoercion(config.key), children = "" + config.key);
			if ("key" in config) {
				maybeKey = {};
				for (var propName in config) "key" !== propName && (maybeKey[propName] = config[propName]);
			} else maybeKey = config;
			children && defineKeyPropWarningGetter(maybeKey, "function" === typeof type ? type.displayName || type.name || "Unknown" : type);
			return ReactElement(type, children, maybeKey, getOwner(), debugStack, debugTask);
		}
		function validateChildKeys(node) {
			isValidElement(node) ? node._store && (node._store.validated = 1) : "object" === typeof node && null !== node && node.$$typeof === REACT_LAZY_TYPE && ("fulfilled" === node._payload.status ? isValidElement(node._payload.value) && node._payload.value._store && (node._payload.value._store.validated = 1) : node._store && (node._store.validated = 1));
		}
		function isValidElement(object) {
			return "object" === typeof object && null !== object && object.$$typeof === REACT_ELEMENT_TYPE;
		}
		var React = require_react(), REACT_ELEMENT_TYPE = Symbol.for("react.transitional.element"), REACT_PORTAL_TYPE = Symbol.for("react.portal"), REACT_FRAGMENT_TYPE = Symbol.for("react.fragment"), REACT_STRICT_MODE_TYPE = Symbol.for("react.strict_mode"), REACT_PROFILER_TYPE = Symbol.for("react.profiler"), REACT_CONSUMER_TYPE = Symbol.for("react.consumer"), REACT_CONTEXT_TYPE = Symbol.for("react.context"), REACT_FORWARD_REF_TYPE = Symbol.for("react.forward_ref"), REACT_SUSPENSE_TYPE = Symbol.for("react.suspense"), REACT_SUSPENSE_LIST_TYPE = Symbol.for("react.suspense_list"), REACT_MEMO_TYPE = Symbol.for("react.memo"), REACT_LAZY_TYPE = Symbol.for("react.lazy"), REACT_ACTIVITY_TYPE = Symbol.for("react.activity"), REACT_CLIENT_REFERENCE = Symbol.for("react.client.reference"), ReactSharedInternals = React.__CLIENT_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE, hasOwnProperty = Object.prototype.hasOwnProperty, isArrayImpl = Array.isArray, createTask = console.createTask ? console.createTask : function() {
			return null;
		};
		React = { react_stack_bottom_frame: function(callStackForError) {
			return callStackForError();
		} };
		var specialPropKeyWarningShown;
		var didWarnAboutElementRef = {};
		var unknownOwnerDebugStack = React.react_stack_bottom_frame.bind(React, UnknownOwner)();
		var unknownOwnerDebugTask = createTask(getTaskName(UnknownOwner));
		var didWarnAboutKeySpread = {};
		exports.Fragment = REACT_FRAGMENT_TYPE;
		exports.jsx = function(type, config, maybeKey) {
			var trackActualOwner = 1e4 > ReactSharedInternals.recentlyCreatedOwnerStacks++;
			return jsxDEVImpl(type, config, maybeKey, !1, trackActualOwner ? Error("react-stack-top-frame") : unknownOwnerDebugStack, trackActualOwner ? createTask(getTaskName(type)) : unknownOwnerDebugTask);
		};
		exports.jsxs = function(type, config, maybeKey) {
			var trackActualOwner = 1e4 > ReactSharedInternals.recentlyCreatedOwnerStacks++;
			return jsxDEVImpl(type, config, maybeKey, !0, trackActualOwner ? Error("react-stack-top-frame") : unknownOwnerDebugStack, trackActualOwner ? createTask(getTaskName(type)) : unknownOwnerDebugTask);
		};
	})();
}) });

//#endregion
//#region node_modules/react/jsx-runtime.js
var require_jsx_runtime = /* @__PURE__ */ __commonJS({ "node_modules/react/jsx-runtime.js": ((exports, module) => {
	module.exports = require_react_jsx_runtime_development();
}) });

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/utils/Runtime.js
var import_jsx_runtime = /* @__PURE__ */ __toESM(require_jsx_runtime());
const Runtime = import_jsx_runtime;

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/jsx/jsxSlot.js
const jsxSlot = (type, overrideProps, key) => {
	const { elementType, renderFunction, props: slotProps } = getMetadataFromSlotComponent(type);
	const props = {
		...slotProps,
		...overrideProps
	};
	if (renderFunction) return Runtime.jsx(import_react.Fragment, { children: renderFunction(elementType, props) }, key);
	return Runtime.jsx(elementType, props, key);
};

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/jsx/jsxsSlot.js
const jsxsSlot = (type, overrideProps, key) => {
	const { elementType, renderFunction, props: slotProps } = getMetadataFromSlotComponent(type);
	const props = {
		...slotProps,
		...overrideProps
	};
	if (renderFunction)
 /**
	* In static runtime then children is an array and this array won't be keyed.
	* We should wrap children by a static fragment
	* as there's no way to know if renderFunction will render statically or dynamically
	*/ return Runtime.jsx(import_react.Fragment, { children: renderFunction(elementType, {
		...props,
		children: Runtime.jsxs(import_react.Fragment, { children: props.children }, void 0)
	}) }, key);
	return Runtime.jsxs(elementType, props, key);
};

//#endregion
//#region node_modules/@fluentui/react-jsx-runtime/lib/jsx-runtime.js
const jsx = createJSX(Runtime.jsx, jsxSlot);
const jsxs = createJSX(Runtime.jsxs, jsxsSlot);

//#endregion
//#region node_modules/@fluentui/react-button/lib/components/Button/renderButton.js
/**
* Renders a Button component by passing the state defined props to the appropriate slots.
*/ const renderButton_unstable = (state) => {
	assertSlots(state);
	const { iconOnly, iconPosition } = state;
	return /* @__PURE__ */ jsxs(state.root, { children: [
		iconPosition !== "after" && state.icon && /* @__PURE__ */ jsx(state.icon, {}),
		!iconOnly && state.root.children,
		iconPosition === "after" && state.icon && /* @__PURE__ */ jsx(state.icon, {})
	] });
};

//#endregion
//#region node_modules/@fluentui/keyboard-keys/lib/keys.js
const Shift = "Shift";
const Enter = "Enter";
const Space = " ";
const Tab = "Tab";
const ArrowDown = "ArrowDown";
const ArrowLeft = "ArrowLeft";
const ArrowRight = "ArrowRight";
const ArrowUp = "ArrowUp";
const End = "End";
const Home = "Home";
const PageDown = "PageDown";
const PageUp = "PageUp";
const Backspace = "Backspace";
const Delete = "Delete";
const Escape = "Escape";

//#endregion
//#region node_modules/@fluentui/react-aria/lib/button/useARIAButtonProps.js
/**
* @internal
*
* Button keyboard handling, role, disabled and tabIndex implementation that ensures ARIA spec
* for multiple scenarios of non native button elements. Ensuring 1st rule of ARIA for cases
* where no attribute addition is required.
*
* @param type - the proper scenario to be interpreted by the hook.
*  1. `button` - Minimal interference from the hook, as semantic button already supports most of the states
*  2. `a` or `div` - Proper keyboard/mouse handling plus other support to ensure ARIA behavior
* @param props - the props to be passed down the line to the desired element.
* This hook will encapsulate proper properties, such as `onClick`, `onKeyDown`, `onKeyUp`, etc,.
*
* @example
* ```tsx
* const buttonProps = useARIAButtonProps('a', {
*   href: './some-route'
*   onClick: () => console.log('this should run both on click and Space and Enter')
* })
*
* // ...
*
* return (
*  <a {...buttonProps}>This anchor will behave as a proper button</a>
* )
* ```
*/ function useARIAButtonProps(type, props) {
	const { disabled, disabledFocusable = false, ["aria-disabled"]: ariaDisabled, onClick, onKeyDown, onKeyUp,...rest } = props !== null && props !== void 0 ? props : {};
	const normalizedARIADisabled = typeof ariaDisabled === "string" ? ariaDisabled === "true" : ariaDisabled;
	const isDisabled = disabled || disabledFocusable || normalizedARIADisabled;
	const handleClick = useEventCallback((ev) => {
		if (isDisabled) {
			ev.preventDefault();
			ev.stopPropagation();
		} else onClick === null || onClick === void 0 || onClick(ev);
	});
	const handleKeyDown = useEventCallback((ev) => {
		onKeyDown === null || onKeyDown === void 0 || onKeyDown(ev);
		if (ev.isDefaultPrevented()) return;
		const key = ev.key;
		if (isDisabled && (key === Enter || key === Space)) {
			ev.preventDefault();
			ev.stopPropagation();
			return;
		}
		if (key === Space) {
			ev.preventDefault();
			return;
		} else if (key === Enter) {
			ev.preventDefault();
			ev.currentTarget.click();
		}
	});
	const handleKeyUp = useEventCallback((ev) => {
		onKeyUp === null || onKeyUp === void 0 || onKeyUp(ev);
		if (ev.isDefaultPrevented()) return;
		const key = ev.key;
		if (isDisabled && (key === Enter || key === Space)) {
			ev.preventDefault();
			ev.stopPropagation();
			return;
		}
		if (key === Space) {
			ev.preventDefault();
			ev.currentTarget.click();
		}
	});
	if (type === "button" || type === void 0) return {
		...rest,
		disabled: disabled && !disabledFocusable,
		"aria-disabled": disabledFocusable ? true : normalizedARIADisabled,
		onClick: disabledFocusable ? void 0 : handleClick,
		onKeyUp: disabledFocusable ? void 0 : onKeyUp,
		onKeyDown: disabledFocusable ? void 0 : onKeyDown
	};
	else {
		const isLink = !!rest.href;
		let roleOverride = isLink ? void 0 : "button";
		if (!roleOverride && isDisabled) roleOverride = "link";
		const resultProps = {
			role: roleOverride,
			tabIndex: disabledFocusable || !isLink && !disabled ? 0 : void 0,
			...rest,
			onClick: handleClick,
			onKeyUp: handleKeyUp,
			onKeyDown: handleKeyDown,
			"aria-disabled": isDisabled
		};
		if (type === "a" && isDisabled) resultProps.href = void 0;
		return resultProps;
	}
}

//#endregion
//#region node_modules/keyborg/dist/esm/index.js
var _canUseWeakRef = typeof WeakRef !== "undefined";
var WeakRefInstance = class {
	constructor(instance) {
		if (_canUseWeakRef && typeof instance === "object") this._weakRef = new WeakRef(instance);
		else this._instance = instance;
	}
	/**
	* @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakRef/deref}
	*/
	deref() {
		var _a, _b;
		let instance;
		if (this._weakRef) {
			instance = (_a = this._weakRef) == null ? void 0 : _a.deref();
			if (!instance) delete this._weakRef;
		} else {
			instance = this._instance;
			if ((_b = instance == null ? void 0 : instance.isDisposed) == null ? void 0 : _b.call(instance)) delete this._instance;
		}
		return instance;
	}
};
var KEYBORG_FOCUSIN = "keyborg:focusin";
var KEYBORG_FOCUSOUT = "keyborg:focusout";
function canOverrideNativeFocus(win) {
	const HTMLElement$1 = win.HTMLElement;
	const origFocus = HTMLElement$1.prototype.focus;
	let isCustomFocusCalled = false;
	HTMLElement$1.prototype.focus = function focus() {
		isCustomFocusCalled = true;
	};
	win.document.createElement("button").focus();
	HTMLElement$1.prototype.focus = origFocus;
	return isCustomFocusCalled;
}
var _canOverrideNativeFocus = false;
function nativeFocus(element) {
	const focus = element.focus;
	if (focus.__keyborgNativeFocus) focus.__keyborgNativeFocus.call(element);
	else element.focus();
}
function setupFocusEvent(win) {
	const kwin = win;
	if (!_canOverrideNativeFocus) _canOverrideNativeFocus = canOverrideNativeFocus(kwin);
	const origFocus = kwin.HTMLElement.prototype.focus;
	if (origFocus.__keyborgNativeFocus) return;
	kwin.HTMLElement.prototype.focus = focus;
	const shadowTargets = /* @__PURE__ */ new Set();
	const focusOutHandler = (e) => {
		const target = e.target;
		if (!target) return;
		const event = new CustomEvent(KEYBORG_FOCUSOUT, {
			cancelable: true,
			bubbles: true,
			composed: true,
			detail: { originalEvent: e }
		});
		target.dispatchEvent(event);
	};
	const focusInHandler = (e) => {
		const target = e.target;
		if (!target) return;
		let node = e.composedPath()[0];
		const currentShadows = /* @__PURE__ */ new Set();
		while (node) if (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {
			currentShadows.add(node);
			node = node.host;
		} else node = node.parentNode;
		for (const shadowRootWeakRef of shadowTargets) {
			const shadowRoot = shadowRootWeakRef.deref();
			if (!shadowRoot || !currentShadows.has(shadowRoot)) {
				shadowTargets.delete(shadowRootWeakRef);
				if (shadowRoot) {
					shadowRoot.removeEventListener("focusin", focusInHandler, true);
					shadowRoot.removeEventListener("focusout", focusOutHandler, true);
				}
			}
		}
		onFocusIn(target, e.relatedTarget || void 0);
	};
	const onFocusIn = (target, relatedTarget, originalEvent) => {
		var _a;
		const shadowRoot = target.shadowRoot;
		if (shadowRoot) {
			for (const shadowRootWeakRef of shadowTargets) if (shadowRootWeakRef.deref() === shadowRoot) return;
			shadowRoot.addEventListener("focusin", focusInHandler, true);
			shadowRoot.addEventListener("focusout", focusOutHandler, true);
			shadowTargets.add(new WeakRefInstance(shadowRoot));
			return;
		}
		const details = {
			relatedTarget,
			originalEvent
		};
		const event = new CustomEvent(KEYBORG_FOCUSIN, {
			cancelable: true,
			bubbles: true,
			composed: true,
			detail: details
		});
		event.details = details;
		if (_canOverrideNativeFocus || data.lastFocusedProgrammatically) {
			details.isFocusedProgrammatically = target === ((_a = data.lastFocusedProgrammatically) == null ? void 0 : _a.deref());
			data.lastFocusedProgrammatically = void 0;
		}
		target.dispatchEvent(event);
	};
	const data = kwin.__keyborgData = {
		focusInHandler,
		focusOutHandler,
		shadowTargets
	};
	kwin.document.addEventListener("focusin", kwin.__keyborgData.focusInHandler, true);
	kwin.document.addEventListener("focusout", kwin.__keyborgData.focusOutHandler, true);
	function focus() {
		const keyborgNativeFocusEvent = kwin.__keyborgData;
		if (keyborgNativeFocusEvent) keyborgNativeFocusEvent.lastFocusedProgrammatically = new WeakRefInstance(this);
		return origFocus.apply(this, arguments);
	}
	let activeElement = kwin.document.activeElement;
	while (activeElement && activeElement.shadowRoot) {
		onFocusIn(activeElement);
		activeElement = activeElement.shadowRoot.activeElement;
	}
	focus.__keyborgNativeFocus = origFocus;
}
function disposeFocusEvent(win) {
	const kwin = win;
	const proto = kwin.HTMLElement.prototype;
	const origFocus = proto.focus.__keyborgNativeFocus;
	const keyborgNativeFocusEvent = kwin.__keyborgData;
	if (keyborgNativeFocusEvent) {
		kwin.document.removeEventListener("focusin", keyborgNativeFocusEvent.focusInHandler, true);
		kwin.document.removeEventListener("focusout", keyborgNativeFocusEvent.focusOutHandler, true);
		for (const shadowRootWeakRef of keyborgNativeFocusEvent.shadowTargets) {
			const shadowRoot = shadowRootWeakRef.deref();
			if (shadowRoot) {
				shadowRoot.removeEventListener("focusin", keyborgNativeFocusEvent.focusInHandler, true);
				shadowRoot.removeEventListener("focusout", keyborgNativeFocusEvent.focusOutHandler, true);
			}
		}
		keyborgNativeFocusEvent.shadowTargets.clear();
		delete kwin.__keyborgData;
	}
	if (origFocus) proto.focus = origFocus;
}
var _dismissTimeout = 500;
var _lastId = 0;
var KeyborgCore = class {
	constructor(win, props) {
		this._isNavigatingWithKeyboard_DO_NOT_USE = false;
		this._onFocusIn = (e) => {
			if (this._isMouseOrTouchUsedTimer) return;
			if (this.isNavigatingWithKeyboard) return;
			const details = e.detail;
			if (!details.relatedTarget) return;
			if (details.isFocusedProgrammatically || details.isFocusedProgrammatically === void 0) return;
			this.isNavigatingWithKeyboard = true;
		};
		this._onMouseDown = (e) => {
			if (e.buttons === 0 || e.clientX === 0 && e.clientY === 0 && e.screenX === 0 && e.screenY === 0) return;
			this._onMouseOrTouch();
		};
		this._onMouseOrTouch = () => {
			const win$1 = this._win;
			if (win$1) {
				if (this._isMouseOrTouchUsedTimer) win$1.clearTimeout(this._isMouseOrTouchUsedTimer);
				this._isMouseOrTouchUsedTimer = win$1.setTimeout(() => {
					delete this._isMouseOrTouchUsedTimer;
				}, 1e3);
			}
			this.isNavigatingWithKeyboard = false;
		};
		this._onKeyDown = (e) => {
			if (this.isNavigatingWithKeyboard) {
				if (this._shouldDismissKeyboardNavigation(e)) this._scheduleDismiss();
			} else if (this._shouldTriggerKeyboardNavigation(e)) this.isNavigatingWithKeyboard = true;
		};
		this.id = "c" + ++_lastId;
		this._win = win;
		const doc = win.document;
		if (props) {
			const triggerKeys = props.triggerKeys;
			const dismissKeys = props.dismissKeys;
			if (triggerKeys == null ? void 0 : triggerKeys.length) this._triggerKeys = new Set(triggerKeys);
			if (dismissKeys == null ? void 0 : dismissKeys.length) this._dismissKeys = new Set(dismissKeys);
		}
		doc.addEventListener(KEYBORG_FOCUSIN, this._onFocusIn, true);
		doc.addEventListener("mousedown", this._onMouseDown, true);
		win.addEventListener("keydown", this._onKeyDown, true);
		doc.addEventListener("touchstart", this._onMouseOrTouch, true);
		doc.addEventListener("touchend", this._onMouseOrTouch, true);
		doc.addEventListener("touchcancel", this._onMouseOrTouch, true);
		setupFocusEvent(win);
	}
	get isNavigatingWithKeyboard() {
		return this._isNavigatingWithKeyboard_DO_NOT_USE;
	}
	set isNavigatingWithKeyboard(val) {
		if (this._isNavigatingWithKeyboard_DO_NOT_USE !== val) {
			this._isNavigatingWithKeyboard_DO_NOT_USE = val;
			this.update();
		}
	}
	dispose() {
		const win = this._win;
		if (win) {
			if (this._isMouseOrTouchUsedTimer) {
				win.clearTimeout(this._isMouseOrTouchUsedTimer);
				this._isMouseOrTouchUsedTimer = void 0;
			}
			if (this._dismissTimer) {
				win.clearTimeout(this._dismissTimer);
				this._dismissTimer = void 0;
			}
			disposeFocusEvent(win);
			const doc = win.document;
			doc.removeEventListener(KEYBORG_FOCUSIN, this._onFocusIn, true);
			doc.removeEventListener("mousedown", this._onMouseDown, true);
			win.removeEventListener("keydown", this._onKeyDown, true);
			doc.removeEventListener("touchstart", this._onMouseOrTouch, true);
			doc.removeEventListener("touchend", this._onMouseOrTouch, true);
			doc.removeEventListener("touchcancel", this._onMouseOrTouch, true);
			delete this._win;
		}
	}
	isDisposed() {
		return !!this._win;
	}
	/**
	* Updates all keyborg instances with the keyboard navigation state
	*/
	update() {
		var _a, _b;
		const keyborgs = (_b = (_a = this._win) == null ? void 0 : _a.__keyborg) == null ? void 0 : _b.refs;
		if (keyborgs) for (const id of Object.keys(keyborgs)) Keyborg.update(keyborgs[id], this.isNavigatingWithKeyboard);
	}
	/**
	* @returns whether the keyboard event should trigger keyboard navigation mode
	*/
	_shouldTriggerKeyboardNavigation(e) {
		var _a;
		if (e.key === "Tab") return true;
		const activeElement = (_a = this._win) == null ? void 0 : _a.document.activeElement;
		const isTriggerKey = !this._triggerKeys || this._triggerKeys.has(e.keyCode);
		const isEditable = activeElement && (activeElement.tagName === "INPUT" || activeElement.tagName === "TEXTAREA" || activeElement.isContentEditable);
		return isTriggerKey && !isEditable;
	}
	/**
	* @returns whether the keyboard event should dismiss keyboard navigation mode
	*/
	_shouldDismissKeyboardNavigation(e) {
		var _a;
		return (_a = this._dismissKeys) == null ? void 0 : _a.has(e.keyCode);
	}
	_scheduleDismiss() {
		const win = this._win;
		if (win) {
			if (this._dismissTimer) {
				win.clearTimeout(this._dismissTimer);
				this._dismissTimer = void 0;
			}
			const was = win.document.activeElement;
			this._dismissTimer = win.setTimeout(() => {
				this._dismissTimer = void 0;
				const cur = win.document.activeElement;
				if (was && cur && was === cur) this.isNavigatingWithKeyboard = false;
			}, _dismissTimeout);
		}
	}
};
var Keyborg = class _Keyborg {
	constructor(win, props) {
		this._cb = [];
		this._id = "k" + ++_lastId;
		this._win = win;
		const current = win.__keyborg;
		if (current) {
			this._core = current.core;
			current.refs[this._id] = this;
		} else {
			this._core = new KeyborgCore(win, props);
			win.__keyborg = {
				core: this._core,
				refs: { [this._id]: this }
			};
		}
	}
	static create(win, props) {
		return new _Keyborg(win, props);
	}
	static dispose(instance) {
		instance.dispose();
	}
	/**
	* Updates all subscribed callbacks with the keyboard navigation state
	*/
	static update(instance, isNavigatingWithKeyboard) {
		instance._cb.forEach((callback) => callback(isNavigatingWithKeyboard));
	}
	dispose() {
		var _a;
		const current = (_a = this._win) == null ? void 0 : _a.__keyborg;
		if (current == null ? void 0 : current.refs[this._id]) {
			delete current.refs[this._id];
			if (Object.keys(current.refs).length === 0) {
				current.core.dispose();
				delete this._win.__keyborg;
			}
		} else console.error(`Keyborg instance ${this._id} is being disposed incorrectly.`);
		this._cb = [];
		delete this._core;
		delete this._win;
	}
	/**
	* @returns Whether the user is navigating with keyboard
	*/
	isNavigatingWithKeyboard() {
		var _a;
		return !!((_a = this._core) == null ? void 0 : _a.isNavigatingWithKeyboard);
	}
	/**
	* @param callback - Called when the keyboard navigation state changes
	*/
	subscribe(callback) {
		this._cb.push(callback);
	}
	/**
	* @param callback - Registered with subscribe
	*/
	unsubscribe(callback) {
		const index = this._cb.indexOf(callback);
		if (index >= 0) this._cb.splice(index, 1);
	}
	/**
	* Manually set the keyboard navigtion state
	*/
	setVal(isNavigatingWithKeyboard) {
		if (this._core) this._core.isNavigatingWithKeyboard = isNavigatingWithKeyboard;
	}
};
function createKeyborg(win, props) {
	return Keyborg.create(win, props);
}
function disposeKeyborg(instance) {
	Keyborg.dispose(instance);
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/

//#endregion
//#region node_modules/tabster/dist/tabster.esm.js
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var TABSTER_ATTRIBUTE_NAME = "data-tabster";
var TABSTER_DUMMY_INPUT_ATTRIBUTE_NAME = "data-tabster-dummy";
var FOCUSABLE_SELECTOR = /* @__PURE__ */ [
	"a[href]",
	"button:not([disabled])",
	"input:not([disabled])",
	"select:not([disabled])",
	"textarea:not([disabled])",
	"*[tabindex]",
	"*[contenteditable]",
	"details > summary",
	"audio[controls]",
	"video[controls]"
].join(", ");
var AsyncFocusSources = {
	EscapeGroupper: 1,
	Restorer: 2,
	Deloser: 3
};
var ObservedElementAccessibilities = {
	Any: 0,
	Accessible: 1,
	Focusable: 2
};
var ObservedElementRequestStatuses = {
	Waiting: 0,
	Succeeded: 1,
	Canceled: 2,
	TimedOut: 3
};
var Visibilities = {
	Invisible: 0,
	PartiallyVisible: 1,
	Visible: 2
};
var RestorerTypes = {
	Source: 0,
	Target: 1
};
var MoverDirections = {
	Both: 0,
	Vertical: 1,
	Horizontal: 2,
	Grid: 3,
	GridLinear: 4
};
var MoverKeys = {
	ArrowUp: 1,
	ArrowDown: 2,
	ArrowLeft: 3,
	ArrowRight: 4,
	PageUp: 5,
	PageDown: 6,
	Home: 7,
	End: 8
};
var GroupperTabbabilities = {
	Unlimited: 0,
	Limited: 1,
	LimitedTrapFocus: 2
};
var GroupperMoveFocusActions = {
	Enter: 1,
	Escape: 2
};
var SysDummyInputsPositions = {
	Auto: 0,
	Inside: 1,
	Outside: 2
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
function getTabsterOnElement(tabster, element) {
	var _a;
	return (_a = tabster.storageEntry(element)) === null || _a === void 0 ? void 0 : _a.tabster;
}
function updateTabsterByAttribute(tabster, element, dispose) {
	var _a, _b;
	const newAttrValue = dispose || tabster._noop ? void 0 : element.getAttribute(TABSTER_ATTRIBUTE_NAME);
	let entry = tabster.storageEntry(element);
	let newAttr;
	if (newAttrValue) if (newAttrValue !== ((_a = entry === null || entry === void 0 ? void 0 : entry.attr) === null || _a === void 0 ? void 0 : _a.string)) try {
		const newValue = JSON.parse(newAttrValue);
		if (typeof newValue !== "object") throw new Error(`Value is not a JSON object, got '${newAttrValue}'.`);
		newAttr = {
			string: newAttrValue,
			object: newValue
		};
	} catch (e) {
		console.error(`data-tabster attribute error: ${e}`, element);
	}
	else return;
	else if (!entry) return;
	if (!entry) entry = tabster.storageEntry(element, true);
	if (!entry.tabster) entry.tabster = {};
	const tabsterOnElement = entry.tabster || {};
	const oldTabsterProps = ((_b = entry.attr) === null || _b === void 0 ? void 0 : _b.object) || {};
	const newTabsterProps = (newAttr === null || newAttr === void 0 ? void 0 : newAttr.object) || {};
	for (const key of Object.keys(oldTabsterProps)) if (!newTabsterProps[key]) {
		if (key === "root") {
			const root = tabsterOnElement[key];
			if (root) tabster.root.onRoot(root, true);
		}
		switch (key) {
			case "deloser":
			case "root":
			case "groupper":
			case "modalizer":
			case "restorer":
			case "mover":
				const part = tabsterOnElement[key];
				if (part) {
					part.dispose();
					delete tabsterOnElement[key];
				}
				break;
			case "observed":
				delete tabsterOnElement[key];
				if (tabster.observedElement) tabster.observedElement.onObservedElementUpdate(element);
				break;
			case "focusable":
			case "outline":
			case "uncontrolled":
			case "sys":
				delete tabsterOnElement[key];
				break;
		}
	}
	for (const key of Object.keys(newTabsterProps)) {
		const sys = newTabsterProps.sys;
		switch (key) {
			case "deloser":
				if (tabsterOnElement.deloser) tabsterOnElement.deloser.setProps(newTabsterProps.deloser);
				else if (tabster.deloser) tabsterOnElement.deloser = tabster.deloser.createDeloser(element, newTabsterProps.deloser);
				else console.error("Deloser API used before initialization, please call `getDeloser()`");
				break;
			case "root":
				if (tabsterOnElement.root) tabsterOnElement.root.setProps(newTabsterProps.root);
				else tabsterOnElement.root = tabster.root.createRoot(element, newTabsterProps.root, sys);
				tabster.root.onRoot(tabsterOnElement.root);
				break;
			case "modalizer":
				if (tabsterOnElement.modalizer) tabsterOnElement.modalizer.setProps(newTabsterProps.modalizer);
				else if (tabster.modalizer) tabsterOnElement.modalizer = tabster.modalizer.createModalizer(element, newTabsterProps.modalizer, sys);
				else console.error("Modalizer API used before initialization, please call `getModalizer()`");
				break;
			case "restorer":
				if (tabsterOnElement.restorer) tabsterOnElement.restorer.setProps(newTabsterProps.restorer);
				else if (tabster.restorer) {
					if (newTabsterProps.restorer) tabsterOnElement.restorer = tabster.restorer.createRestorer(element, newTabsterProps.restorer);
				} else console.error("Restorer API used before initialization, please call `getRestorer()`");
				break;
			case "focusable":
				tabsterOnElement.focusable = newTabsterProps.focusable;
				break;
			case "groupper":
				if (tabsterOnElement.groupper) tabsterOnElement.groupper.setProps(newTabsterProps.groupper);
				else if (tabster.groupper) tabsterOnElement.groupper = tabster.groupper.createGroupper(element, newTabsterProps.groupper, sys);
				else console.error("Groupper API used before initialization, please call `getGroupper()`");
				break;
			case "mover":
				if (tabsterOnElement.mover) tabsterOnElement.mover.setProps(newTabsterProps.mover);
				else if (tabster.mover) tabsterOnElement.mover = tabster.mover.createMover(element, newTabsterProps.mover, sys);
				else console.error("Mover API used before initialization, please call `getMover()`");
				break;
			case "observed":
				if (tabster.observedElement) {
					tabsterOnElement.observed = newTabsterProps.observed;
					tabster.observedElement.onObservedElementUpdate(element);
				} else console.error("ObservedElement API used before initialization, please call `getObservedElement()`");
				break;
			case "uncontrolled":
				tabsterOnElement.uncontrolled = newTabsterProps.uncontrolled;
				break;
			case "outline":
				if (tabster.outline) tabsterOnElement.outline = newTabsterProps.outline;
				else console.error("Outline API used before initialization, please call `getOutline()`");
				break;
			case "sys":
				tabsterOnElement.sys = newTabsterProps.sys;
				break;
			default: console.error(`Unknown key '${key}' in data-tabster attribute value.`);
		}
	}
	if (newAttr) entry.attr = newAttr;
	else {
		if (Object.keys(tabsterOnElement).length === 0) {
			delete entry.tabster;
			delete entry.attr;
		}
		tabster.storageEntry(element, false);
	}
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
/**
* Events sent by Tabster.
*/
var TabsterFocusInEventName = "tabster:focusin";
var TabsterFocusOutEventName = "tabster:focusout";
var TabsterMoveFocusEventName = "tabster:movefocus";
/**
* Events sent by Modalizer.
*/
var ModalizerActiveEventName = "tabster:modalizer:active";
var ModalizerInactiveEventName = "tabster:modalizer:inactive";
/**
* Events sent by Mover.
*/
var MoverStateEventName = "tabster:mover:state";
/**
* Events to be sent to Mover by the application.
*/
var MoverMoveFocusEventName = "tabster:mover:movefocus";
var MoverMemorizedElementEventName = "tabster:mover:memorized-element";
/**
* Events sent by Groupper.
*/
/**
* Events to be sent to Groupper by the application.
*/
var GroupperMoveFocusEventName = "tabster:groupper:movefocus";
/**
* Events sent by Restorer.
*/
var RestorerRestoreFocusEventName = "tabster:restorer:restore-focus";
/**
* Events sent by Root.
*/
var RootFocusEventName = "tabster:root:focus";
var RootBlurEventName = "tabster:root:blur";
var CustomEvent_ = typeof CustomEvent !== "undefined" ? CustomEvent : function() {};
var TabsterCustomEvent = class extends CustomEvent_ {
	constructor(type, detail) {
		super(type, {
			bubbles: true,
			cancelable: true,
			composed: true,
			detail
		});
		this.details = detail;
	}
};
var TabsterFocusInEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(TabsterFocusInEventName, detail);
	}
};
var TabsterFocusOutEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(TabsterFocusOutEventName, detail);
	}
};
var TabsterMoveFocusEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(TabsterMoveFocusEventName, detail);
	}
};
var MoverStateEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(MoverStateEventName, detail);
	}
};
var MoverMoveFocusEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(MoverMoveFocusEventName, detail);
	}
};
var GroupperMoveFocusEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(GroupperMoveFocusEventName, detail);
	}
};
var ModalizerActiveEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(ModalizerActiveEventName, detail);
	}
};
var ModalizerInactiveEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(ModalizerInactiveEventName, detail);
	}
};
var RestorerRestoreFocusEvent = class extends TabsterCustomEvent {
	constructor() {
		super(RestorerRestoreFocusEventName);
	}
};
var RootFocusEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(RootFocusEventName, detail);
	}
};
var RootBlurEvent = class extends TabsterCustomEvent {
	constructor(detail) {
		super(RootBlurEventName, detail);
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var _createMutationObserver = (callback) => new MutationObserver(callback);
var _createTreeWalker = (doc, root, whatToShow, filter) => doc.createTreeWalker(root, whatToShow, filter);
var _getParentNode = (node) => node ? node.parentNode : null;
var _getParentElement = (element) => element ? element.parentElement : null;
var _nodeContains = (parent, child) => !!(child && (parent === null || parent === void 0 ? void 0 : parent.contains(child)));
var _getActiveElement = (doc) => doc.activeElement;
var _querySelector = (element, selector) => element.querySelector(selector);
var _querySelectorAll = (element, selector) => Array.prototype.slice.call(element.querySelectorAll(selector), 0);
var _getElementById = (doc, id) => doc.getElementById(id);
var _getFirstChild = (node) => (node === null || node === void 0 ? void 0 : node.firstChild) || null;
var _getLastChild = (node) => (node === null || node === void 0 ? void 0 : node.lastChild) || null;
var _getNextSibling = (node) => (node === null || node === void 0 ? void 0 : node.nextSibling) || null;
var _getPreviousSibling = (node) => (node === null || node === void 0 ? void 0 : node.previousSibling) || null;
var _getFirstElementChild = (element) => (element === null || element === void 0 ? void 0 : element.firstElementChild) || null;
var _getLastElementChild = (element) => (element === null || element === void 0 ? void 0 : element.lastElementChild) || null;
var _getNextElementSibling = (element) => (element === null || element === void 0 ? void 0 : element.nextElementSibling) || null;
var _getPreviousElementSibling = (element) => (element === null || element === void 0 ? void 0 : element.previousElementSibling) || null;
var _appendChild = (parent, child) => parent.appendChild(child);
var _insertBefore = (parent, child, referenceChild) => parent.insertBefore(child, referenceChild);
var _getSelection = (ref) => {
	var _a;
	return ((_a = ref.ownerDocument) === null || _a === void 0 ? void 0 : _a.getSelection()) || null;
};
var _getElementsByName = (referenceElement, name) => referenceElement.ownerDocument.getElementsByName(name);
var dom = {
	createMutationObserver: _createMutationObserver,
	createTreeWalker: _createTreeWalker,
	getParentNode: _getParentNode,
	getParentElement: _getParentElement,
	nodeContains: _nodeContains,
	getActiveElement: _getActiveElement,
	querySelector: _querySelector,
	querySelectorAll: _querySelectorAll,
	getElementById: _getElementById,
	getFirstChild: _getFirstChild,
	getLastChild: _getLastChild,
	getNextSibling: _getNextSibling,
	getPreviousSibling: _getPreviousSibling,
	getFirstElementChild: _getFirstElementChild,
	getLastElementChild: _getLastElementChild,
	getNextElementSibling: _getNextElementSibling,
	getPreviousElementSibling: _getPreviousElementSibling,
	appendChild: _appendChild,
	insertBefore: _insertBefore,
	getSelection: _getSelection,
	getElementsByName: _getElementsByName
};
function setDOMAPI(domapi) {
	for (const key of Object.keys(domapi)) dom[key] = domapi[key];
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var _isBrokenIE11;
var _DOMRect = typeof DOMRect !== "undefined" ? DOMRect : class {
	constructor(x, y, width, height) {
		this.left = x || 0;
		this.top = y || 0;
		this.right = (x || 0) + (width || 0);
		this.bottom = (y || 0) + (height || 0);
	}
};
var _uidCounter = 0;
try {
	document.createTreeWalker(document, NodeFilter.SHOW_ELEMENT);
	_isBrokenIE11 = false;
} catch (e) {
	_isBrokenIE11 = true;
}
var _updateDummyInputsTimeout = 100;
function getInstanceContext(getWindow$1) {
	const win = getWindow$1();
	let ctx = win.__tabsterInstanceContext;
	if (!ctx) {
		ctx = {
			elementByUId: {},
			basics: {
				Promise: win.Promise || void 0,
				WeakRef: win.WeakRef || void 0
			},
			containerBoundingRectCache: {},
			lastContainerBoundingRectCacheId: 0,
			fakeWeakRefs: [],
			fakeWeakRefsStarted: false
		};
		win.__tabsterInstanceContext = ctx;
	}
	return ctx;
}
function disposeInstanceContext(win) {
	const ctx = win.__tabsterInstanceContext;
	if (ctx) {
		ctx.elementByUId = {};
		delete ctx.WeakRef;
		ctx.containerBoundingRectCache = {};
		if (ctx.containerBoundingRectCacheTimer) win.clearTimeout(ctx.containerBoundingRectCacheTimer);
		if (ctx.fakeWeakRefsTimer) win.clearTimeout(ctx.fakeWeakRefsTimer);
		ctx.fakeWeakRefs = [];
		delete win.__tabsterInstanceContext;
	}
}
function createWeakMap(win) {
	const ctx = win.__tabsterInstanceContext;
	return new ((ctx === null || ctx === void 0 ? void 0 : ctx.basics.WeakMap) || WeakMap)();
}
function hasSubFocusable(element) {
	return !!element.querySelector(FOCUSABLE_SELECTOR);
}
var FakeWeakRef = class {
	constructor(target) {
		this._target = target;
	}
	deref() {
		return this._target;
	}
	static cleanup(fwr, forceRemove) {
		if (!fwr._target) return true;
		if (forceRemove || !documentContains(fwr._target.ownerDocument, fwr._target)) {
			delete fwr._target;
			return true;
		}
		return false;
	}
};
var WeakHTMLElement = class {
	constructor(getWindow$1, element, data) {
		const context = getInstanceContext(getWindow$1);
		let ref;
		if (context.WeakRef) ref = new context.WeakRef(element);
		else {
			ref = new FakeWeakRef(element);
			context.fakeWeakRefs.push(ref);
		}
		this._ref = ref;
		this._data = data;
	}
	get() {
		const ref = this._ref;
		let element;
		if (ref) {
			element = ref.deref();
			if (!element) delete this._ref;
		}
		return element;
	}
	getData() {
		return this._data;
	}
};
function cleanupFakeWeakRefs(getWindow$1, forceRemove) {
	const context = getInstanceContext(getWindow$1);
	context.fakeWeakRefs = context.fakeWeakRefs.filter((e) => !FakeWeakRef.cleanup(e, forceRemove));
}
function startFakeWeakRefsCleanup(getWindow$1) {
	const context = getInstanceContext(getWindow$1);
	if (!context.fakeWeakRefsStarted) {
		context.fakeWeakRefsStarted = true;
		context.WeakRef = getWeakRef(context);
	}
	if (!context.fakeWeakRefsTimer) context.fakeWeakRefsTimer = getWindow$1().setTimeout(() => {
		context.fakeWeakRefsTimer = void 0;
		cleanupFakeWeakRefs(getWindow$1);
		startFakeWeakRefsCleanup(getWindow$1);
	}, 120 * 1e3);
}
function stopFakeWeakRefsCleanupAndClearStorage(getWindow$1) {
	const context = getInstanceContext(getWindow$1);
	context.fakeWeakRefsStarted = false;
	if (context.fakeWeakRefsTimer) {
		getWindow$1().clearTimeout(context.fakeWeakRefsTimer);
		context.fakeWeakRefsTimer = void 0;
		context.fakeWeakRefs = [];
	}
}
function createElementTreeWalker(doc, root, acceptNode) {
	if (root.nodeType !== Node.ELEMENT_NODE) return;
	const filter = _isBrokenIE11 ? acceptNode : { acceptNode };
	return dom.createTreeWalker(doc, root, NodeFilter.SHOW_ELEMENT, filter, false);
}
function getBoundingRect(getWindow$1, element) {
	let cacheId = element.__tabsterCacheId;
	const context = getInstanceContext(getWindow$1);
	const cached = cacheId ? context.containerBoundingRectCache[cacheId] : void 0;
	if (cached) return cached.rect;
	const scrollingElement = element.ownerDocument && element.ownerDocument.documentElement;
	if (!scrollingElement) return new _DOMRect();
	let left = 0;
	let top = 0;
	let right = scrollingElement.clientWidth;
	let bottom = scrollingElement.clientHeight;
	if (element !== scrollingElement) {
		const r = element.getBoundingClientRect();
		left = Math.max(left, r.left);
		top = Math.max(top, r.top);
		right = Math.min(right, r.right);
		bottom = Math.min(bottom, r.bottom);
	}
	const rect = new _DOMRect(left < right ? left : -1, top < bottom ? top : -1, left < right ? right - left : 0, top < bottom ? bottom - top : 0);
	if (!cacheId) {
		cacheId = "r-" + ++context.lastContainerBoundingRectCacheId;
		element.__tabsterCacheId = cacheId;
	}
	context.containerBoundingRectCache[cacheId] = {
		rect,
		element
	};
	if (!context.containerBoundingRectCacheTimer) context.containerBoundingRectCacheTimer = window.setTimeout(() => {
		context.containerBoundingRectCacheTimer = void 0;
		for (const cId of Object.keys(context.containerBoundingRectCache)) delete context.containerBoundingRectCache[cId].element.__tabsterCacheId;
		context.containerBoundingRectCache = {};
	}, 50);
	return rect;
}
function isElementVerticallyVisibleInContainer(getWindow$1, element, tolerance) {
	const container = getScrollableContainer(element);
	if (!container) return false;
	const containerRect = getBoundingRect(getWindow$1, container);
	const elementRect = element.getBoundingClientRect();
	const intersectionTolerance = elementRect.height * (1 - tolerance);
	const topIntersection = Math.max(0, containerRect.top - elementRect.top);
	const bottomIntersection = Math.max(0, elementRect.bottom - containerRect.bottom);
	const totalIntersection = topIntersection + bottomIntersection;
	return totalIntersection === 0 || totalIntersection <= intersectionTolerance;
}
function scrollIntoView(getWindow$1, element, alignToTop) {
	const container = getScrollableContainer(element);
	if (container) {
		const containerRect = getBoundingRect(getWindow$1, container);
		const elementRect = element.getBoundingClientRect();
		if (alignToTop) container.scrollTop += elementRect.top - containerRect.top;
		else container.scrollTop += elementRect.bottom - containerRect.bottom;
	}
}
function getScrollableContainer(element) {
	const doc = element.ownerDocument;
	if (doc) {
		for (let el = dom.getParentElement(element); el; el = dom.getParentElement(el)) if (el.scrollWidth > el.clientWidth || el.scrollHeight > el.clientHeight) return el;
		return doc.documentElement;
	}
	return null;
}
function makeFocusIgnored(element) {
	element.__shouldIgnoreFocus = true;
}
function shouldIgnoreFocus(element) {
	return !!element.__shouldIgnoreFocus;
}
function getUId(wnd) {
	const rnd = new Uint32Array(4);
	if (wnd.crypto && wnd.crypto.getRandomValues) wnd.crypto.getRandomValues(rnd);
	else if (wnd.msCrypto && wnd.msCrypto.getRandomValues) wnd.msCrypto.getRandomValues(rnd);
	else for (let i = 0; i < rnd.length; i++) rnd[i] = 4294967295 * Math.random();
	const srnd = [];
	for (let i = 0; i < rnd.length; i++) srnd.push(rnd[i].toString(36));
	srnd.push("|");
	srnd.push((++_uidCounter).toString(36));
	srnd.push("|");
	srnd.push(Date.now().toString(36));
	return srnd.join("");
}
function getElementUId(getWindow$1, element) {
	const context = getInstanceContext(getWindow$1);
	let uid = element.__tabsterElementUID;
	if (!uid) uid = element.__tabsterElementUID = getUId(getWindow$1());
	if (!context.elementByUId[uid] && documentContains(element.ownerDocument, element)) context.elementByUId[uid] = new WeakHTMLElement(getWindow$1, element);
	return uid;
}
function clearElementCache(getWindow$1, parent) {
	const context = getInstanceContext(getWindow$1);
	for (const key of Object.keys(context.elementByUId)) {
		const wel = context.elementByUId[key];
		const el = wel && wel.get();
		if (el && parent) {
			if (!dom.nodeContains(parent, el)) continue;
		}
		delete context.elementByUId[key];
	}
}
function documentContains(doc, element) {
	return dom.nodeContains(doc === null || doc === void 0 ? void 0 : doc.body, element);
}
function matchesSelector(element, selector) {
	const matches = element.matches || element.matchesSelector || element.msMatchesSelector || element.webkitMatchesSelector;
	return matches && matches.call(element, selector);
}
function getPromise(getWindow$1) {
	const context = getInstanceContext(getWindow$1);
	if (context.basics.Promise) return context.basics.Promise;
	throw new Error("No Promise defined.");
}
function getWeakRef(context) {
	return context.basics.WeakRef;
}
var _lastTabsterPartId = 0;
var TabsterPart = class {
	constructor(tabster, element, props) {
		const getWindow$1 = tabster.getWindow;
		this._tabster = tabster;
		this._element = new WeakHTMLElement(getWindow$1, element);
		this._props = { ...props };
		this.id = "i" + ++_lastTabsterPartId;
	}
	getElement() {
		return this._element.get();
	}
	getProps() {
		return this._props;
	}
	setProps(props) {
		this._props = { ...props };
	}
};
/**
* Dummy HTML elements that are used as focus sentinels for the DOM enclosed within them
*/
var DummyInput = class {
	constructor(getWindow$1, isOutside, props, element, fixedTarget) {
		var _a;
		this._focusIn = (e) => {
			if (this._fixedTarget) {
				const target = this._fixedTarget.get();
				if (target) nativeFocus(target);
				return;
			}
			const input$1 = this.input;
			if (this.onFocusIn && input$1) {
				const relatedTarget = e.relatedTarget;
				this.onFocusIn(this, this._isBackward(true, input$1, relatedTarget), relatedTarget);
			}
		};
		this._focusOut = (e) => {
			if (this._fixedTarget) return;
			this.useDefaultAction = false;
			const input$1 = this.input;
			if (this.onFocusOut && input$1) {
				const relatedTarget = e.relatedTarget;
				this.onFocusOut(this, this._isBackward(false, input$1, relatedTarget), relatedTarget);
			}
		};
		const win = getWindow$1();
		const input = win.document.createElement("i");
		input.tabIndex = 0;
		input.setAttribute("role", "none");
		input.setAttribute(TABSTER_DUMMY_INPUT_ATTRIBUTE_NAME, "");
		input.setAttribute("aria-hidden", "true");
		const style = input.style;
		style.position = "fixed";
		style.width = style.height = "1px";
		style.opacity = "0.001";
		style.zIndex = "-1";
		style.setProperty("content-visibility", "hidden");
		makeFocusIgnored(input);
		this.input = input;
		this.isFirst = props.isFirst;
		this.isOutside = isOutside;
		this._isPhantom = (_a = props.isPhantom) !== null && _a !== void 0 ? _a : false;
		this._fixedTarget = fixedTarget;
		input.addEventListener("focusin", this._focusIn);
		input.addEventListener("focusout", this._focusOut);
		input.__tabsterDummyContainer = element;
		if (this._isPhantom) {
			this._disposeTimer = win.setTimeout(() => {
				delete this._disposeTimer;
				this.dispose();
			}, 0);
			this._clearDisposeTimeout = () => {
				if (this._disposeTimer) {
					win.clearTimeout(this._disposeTimer);
					delete this._disposeTimer;
				}
				delete this._clearDisposeTimeout;
			};
		}
	}
	dispose() {
		var _a;
		if (this._clearDisposeTimeout) this._clearDisposeTimeout();
		const input = this.input;
		if (!input) return;
		delete this._fixedTarget;
		delete this.onFocusIn;
		delete this.onFocusOut;
		delete this.input;
		input.removeEventListener("focusin", this._focusIn);
		input.removeEventListener("focusout", this._focusOut);
		delete input.__tabsterDummyContainer;
		(_a = dom.getParentNode(input)) === null || _a === void 0 || _a.removeChild(input);
	}
	setTopLeft(top, left) {
		var _a;
		const style = (_a = this.input) === null || _a === void 0 ? void 0 : _a.style;
		if (style) {
			style.top = `${top}px`;
			style.left = `${left}px`;
		}
	}
	_isBackward(isIn, current, previous) {
		return isIn && !previous ? !this.isFirst : !!(previous && current.compareDocumentPosition(previous) & Node.DOCUMENT_POSITION_FOLLOWING);
	}
};
var DummyInputManagerPriorities = {
	Root: 1,
	Modalizer: 2,
	Mover: 3,
	Groupper: 4
};
var DummyInputManager = class {
	constructor(tabster, element, priority, sys, outsideByDefault, callForDefaultAction) {
		this._element = element;
		this._instance = new DummyInputManagerCore(tabster, element, this, priority, sys, outsideByDefault, callForDefaultAction);
	}
	_setHandlers(onFocusIn, onFocusOut) {
		this._onFocusIn = onFocusIn;
		this._onFocusOut = onFocusOut;
	}
	moveOut(backwards) {
		var _a;
		(_a = this._instance) === null || _a === void 0 || _a.moveOut(backwards);
	}
	moveOutWithDefaultAction(backwards, relatedEvent) {
		var _a;
		(_a = this._instance) === null || _a === void 0 || _a.moveOutWithDefaultAction(backwards, relatedEvent);
	}
	getHandler(isIn) {
		return isIn ? this._onFocusIn : this._onFocusOut;
	}
	setTabbable(tabbable) {
		var _a;
		(_a = this._instance) === null || _a === void 0 || _a.setTabbable(this, tabbable);
	}
	dispose() {
		if (this._instance) {
			this._instance.dispose(this);
			delete this._instance;
		}
		delete this._onFocusIn;
		delete this._onFocusOut;
	}
	static moveWithPhantomDummy(tabster, element, moveOutOfElement, isBackward, relatedEvent) {
		const input = new DummyInput(tabster.getWindow, true, {
			isPhantom: true,
			isFirst: true
		}).input;
		if (input) {
			let parent;
			let insertBefore;
			if (element.tagName === "BODY") {
				parent = element;
				insertBefore = moveOutOfElement && isBackward || !moveOutOfElement && !isBackward ? dom.getFirstElementChild(element) : null;
			} else {
				if (moveOutOfElement && (!isBackward || isBackward && !tabster.focusable.isFocusable(element, false, true, true))) {
					parent = element;
					insertBefore = isBackward ? element.firstElementChild : null;
				} else {
					parent = dom.getParentElement(element);
					insertBefore = moveOutOfElement && isBackward || !moveOutOfElement && !isBackward ? element : dom.getNextElementSibling(element);
				}
				let potentialDummy;
				let dummyFor;
				do {
					potentialDummy = moveOutOfElement && isBackward || !moveOutOfElement && !isBackward ? dom.getPreviousElementSibling(insertBefore) : insertBefore;
					dummyFor = getDummyInputContainer(potentialDummy);
					if (dummyFor === element) insertBefore = moveOutOfElement && isBackward || !moveOutOfElement && !isBackward ? potentialDummy : dom.getNextElementSibling(potentialDummy);
					else dummyFor = null;
				} while (dummyFor);
			}
			if (parent === null || parent === void 0 ? void 0 : parent.dispatchEvent(new TabsterMoveFocusEvent({
				by: "root",
				owner: parent,
				next: null,
				relatedEvent
			}))) {
				dom.insertBefore(parent, input, insertBefore);
				nativeFocus(input);
			}
		}
	}
	static addPhantomDummyWithTarget(tabster, sourceElement, isBackward, targetElement) {
		const input = new DummyInput(tabster.getWindow, true, {
			isPhantom: true,
			isFirst: true
		}, void 0, new WeakHTMLElement(tabster.getWindow, targetElement)).input;
		if (input) {
			let dummyParent;
			let insertBefore;
			if (hasSubFocusable(sourceElement) && !isBackward) {
				dummyParent = sourceElement;
				insertBefore = dom.getFirstElementChild(sourceElement);
			} else {
				dummyParent = dom.getParentElement(sourceElement);
				insertBefore = isBackward ? sourceElement : dom.getNextElementSibling(sourceElement);
			}
			if (dummyParent) dom.insertBefore(dummyParent, input, insertBefore);
		}
	}
};
function setDummyInputDebugValue(dummy, wrappers) {
	var _a;
	const what = {
		1: "Root",
		2: "Modalizer",
		3: "Mover",
		4: "Groupper"
	};
	(_a = dummy.input) === null || _a === void 0 || _a.setAttribute(TABSTER_DUMMY_INPUT_ATTRIBUTE_NAME, [
		`isFirst=${dummy.isFirst}`,
		`isOutside=${dummy.isOutside}`,
		...wrappers.map((w) => `(${what[w.priority]}, tabbable=${w.tabbable})`)
	].join(", "));
}
var DummyInputObserver = class {
	constructor(win) {
		this._updateQueue = /* @__PURE__ */ new Set();
		this._lastUpdateQueueTime = 0;
		this._changedParents = /* @__PURE__ */ new WeakSet();
		this._dummyElements = [];
		this._dummyCallbacks = /* @__PURE__ */ new WeakMap();
		this._domChanged = (parent) => {
			var _a;
			if (this._changedParents.has(parent)) return;
			this._changedParents.add(parent);
			if (this._updateDummyInputsTimer) return;
			this._updateDummyInputsTimer = (_a = this._win) === null || _a === void 0 ? void 0 : _a.call(this).setTimeout(() => {
				delete this._updateDummyInputsTimer;
				for (const ref of this._dummyElements) {
					const dummyElement = ref.get();
					if (dummyElement) {
						const callback = this._dummyCallbacks.get(dummyElement);
						if (callback) {
							const dummyParent = dom.getParentNode(dummyElement);
							if (!dummyParent || this._changedParents.has(dummyParent)) callback();
						}
					}
				}
				this._changedParents = /* @__PURE__ */ new WeakSet();
			}, _updateDummyInputsTimeout);
		};
		this._win = win;
	}
	add(dummy, callback) {
		if (!this._dummyCallbacks.has(dummy) && this._win) {
			this._dummyElements.push(new WeakHTMLElement(this._win, dummy));
			this._dummyCallbacks.set(dummy, callback);
			this.domChanged = this._domChanged;
		}
	}
	remove(dummy) {
		this._dummyElements = this._dummyElements.filter((ref) => {
			const element = ref.get();
			return element && element !== dummy;
		});
		this._dummyCallbacks.delete(dummy);
		if (this._dummyElements.length === 0) delete this.domChanged;
	}
	dispose() {
		var _a;
		const win = (_a = this._win) === null || _a === void 0 ? void 0 : _a.call(this);
		if (this._updateTimer) {
			win === null || win === void 0 || win.clearTimeout(this._updateTimer);
			delete this._updateTimer;
		}
		if (this._updateDummyInputsTimer) {
			win === null || win === void 0 || win.clearTimeout(this._updateDummyInputsTimer);
			delete this._updateDummyInputsTimer;
		}
		this._changedParents = /* @__PURE__ */ new WeakSet();
		this._dummyCallbacks = /* @__PURE__ */ new WeakMap();
		this._dummyElements = [];
		this._updateQueue.clear();
		delete this.domChanged;
		delete this._win;
	}
	updatePositions(compute) {
		if (!this._win) return;
		this._updateQueue.add(compute);
		this._lastUpdateQueueTime = Date.now();
		this._scheduledUpdatePositions();
	}
	_scheduledUpdatePositions() {
		var _a;
		if (this._updateTimer) return;
		this._updateTimer = (_a = this._win) === null || _a === void 0 ? void 0 : _a.call(this).setTimeout(() => {
			delete this._updateTimer;
			if (this._lastUpdateQueueTime + _updateDummyInputsTimeout <= Date.now()) {
				const scrollTopLeftCache = /* @__PURE__ */ new Map();
				const setTopLeftCallbacks = [];
				for (const compute of this._updateQueue) setTopLeftCallbacks.push(compute(scrollTopLeftCache));
				this._updateQueue.clear();
				for (const setTopLeft of setTopLeftCallbacks) setTopLeft();
				scrollTopLeftCache.clear();
			} else this._scheduledUpdatePositions();
		}, _updateDummyInputsTimeout);
	}
};
/**
* Parent class that encapsulates the behaviour of dummy inputs (focus sentinels)
*/
var DummyInputManagerCore = class {
	constructor(tabster, element, manager, priority, sys, outsideByDefault, callForDefaultAction) {
		this._wrappers = [];
		this._isOutside = false;
		this._transformElements = /* @__PURE__ */ new Set();
		this._onFocusIn = (dummyInput, isBackward, relatedTarget) => {
			this._onFocus(true, dummyInput, isBackward, relatedTarget);
		};
		this._onFocusOut = (dummyInput, isBackward, relatedTarget) => {
			this._onFocus(false, dummyInput, isBackward, relatedTarget);
		};
		this.moveOut = (backwards) => {
			var _a;
			const first = this._firstDummy;
			const last = this._lastDummy;
			if (first && last) {
				this._ensurePosition();
				const firstInput = first.input;
				const lastInput = last.input;
				const element$1 = (_a = this._element) === null || _a === void 0 ? void 0 : _a.get();
				if (firstInput && lastInput && element$1) {
					let toFocus;
					if (backwards) {
						firstInput.tabIndex = 0;
						toFocus = firstInput;
					} else {
						lastInput.tabIndex = 0;
						toFocus = lastInput;
					}
					if (toFocus) nativeFocus(toFocus);
				}
			}
		};
		/**
		* Prepares to move focus out of the given element by focusing
		* one of the dummy inputs and setting the `useDefaultAction` flag
		* @param backwards focus moving to an element behind the given element
		*/
		this.moveOutWithDefaultAction = (backwards, relatedEvent) => {
			var _a;
			const first = this._firstDummy;
			const last = this._lastDummy;
			if (first && last) {
				this._ensurePosition();
				const firstInput = first.input;
				const lastInput = last.input;
				const element$1 = (_a = this._element) === null || _a === void 0 ? void 0 : _a.get();
				if (firstInput && lastInput && element$1) {
					let toFocus;
					if (backwards) if (!first.isOutside && this._tabster.focusable.isFocusable(element$1, true, true, true)) toFocus = element$1;
					else {
						first.useDefaultAction = true;
						firstInput.tabIndex = 0;
						toFocus = firstInput;
					}
					else {
						last.useDefaultAction = true;
						lastInput.tabIndex = 0;
						toFocus = lastInput;
					}
					if (toFocus && element$1.dispatchEvent(new TabsterMoveFocusEvent({
						by: "root",
						owner: element$1,
						next: null,
						relatedEvent
					}))) nativeFocus(toFocus);
				}
			}
		};
		this.setTabbable = (manager$1, tabbable) => {
			var _a, _b;
			for (const w of this._wrappers) if (w.manager === manager$1) {
				w.tabbable = tabbable;
				break;
			}
			const wrapper = this._getCurrent();
			if (wrapper) {
				const tabIndex = wrapper.tabbable ? 0 : -1;
				let input = (_a = this._firstDummy) === null || _a === void 0 ? void 0 : _a.input;
				if (input) input.tabIndex = tabIndex;
				input = (_b = this._lastDummy) === null || _b === void 0 ? void 0 : _b.input;
				if (input) input.tabIndex = tabIndex;
			}
			this._firstDummy && setDummyInputDebugValue(this._firstDummy, this._wrappers);
			this._lastDummy && setDummyInputDebugValue(this._lastDummy, this._wrappers);
		};
		/**
		* Adds dummy inputs as the first and last child of the given element
		* Called each time the children under the element is mutated
		*/
		this._addDummyInputs = () => {
			if (this._addTimer) return;
			this._addTimer = this._getWindow().setTimeout(() => {
				delete this._addTimer;
				this._ensurePosition();
				this._firstDummy && setDummyInputDebugValue(this._firstDummy, this._wrappers);
				this._lastDummy && setDummyInputDebugValue(this._lastDummy, this._wrappers);
				this._addTransformOffsets();
			}, 0);
		};
		this._addTransformOffsets = () => {
			this._tabster._dummyObserver.updatePositions(this._computeTransformOffsets);
		};
		this._computeTransformOffsets = (scrollTopLeftCache) => {
			var _a, _b;
			const from = ((_a = this._firstDummy) === null || _a === void 0 ? void 0 : _a.input) || ((_b = this._lastDummy) === null || _b === void 0 ? void 0 : _b.input);
			const transformElements = this._transformElements;
			const newTransformElements = /* @__PURE__ */ new Set();
			let scrollTop = 0;
			let scrollLeft = 0;
			const win = this._getWindow();
			for (let element$1 = from; element$1 && element$1.nodeType === Node.ELEMENT_NODE; element$1 = dom.getParentElement(element$1)) {
				let scrollTopLeft = scrollTopLeftCache.get(element$1);
				if (scrollTopLeft === void 0) {
					const transform = win.getComputedStyle(element$1).transform;
					if (transform && transform !== "none") scrollTopLeft = {
						scrollTop: element$1.scrollTop,
						scrollLeft: element$1.scrollLeft
					};
					scrollTopLeftCache.set(element$1, scrollTopLeft || null);
				}
				if (scrollTopLeft) {
					newTransformElements.add(element$1);
					if (!transformElements.has(element$1)) element$1.addEventListener("scroll", this._addTransformOffsets);
					scrollTop += scrollTopLeft.scrollTop;
					scrollLeft += scrollTopLeft.scrollLeft;
				}
			}
			for (const el$1 of transformElements) if (!newTransformElements.has(el$1)) el$1.removeEventListener("scroll", this._addTransformOffsets);
			this._transformElements = newTransformElements;
			return () => {
				var _a$1, _b$1;
				(_a$1 = this._firstDummy) === null || _a$1 === void 0 || _a$1.setTopLeft(scrollTop, scrollLeft);
				(_b$1 = this._lastDummy) === null || _b$1 === void 0 || _b$1.setTopLeft(scrollTop, scrollLeft);
			};
		};
		const el = element.get();
		if (!el) throw new Error("No element");
		this._tabster = tabster;
		this._getWindow = tabster.getWindow;
		this._callForDefaultAction = callForDefaultAction;
		const instance = el.__tabsterDummy;
		(instance || this)._wrappers.push({
			manager,
			priority,
			tabbable: true
		});
		if (instance) {
			this._firstDummy && setDummyInputDebugValue(this._firstDummy, instance._wrappers);
			this._lastDummy && setDummyInputDebugValue(this._lastDummy, instance._wrappers);
			return instance;
		}
		el.__tabsterDummy = this;
		const forcedDummyPosition = sys === null || sys === void 0 ? void 0 : sys.dummyInputsPosition;
		const tagName = el.tagName;
		this._isOutside = !forcedDummyPosition ? (outsideByDefault || tagName === "UL" || tagName === "OL" || tagName === "TABLE") && !(tagName === "LI" || tagName === "TD" || tagName === "TH") : forcedDummyPosition === SysDummyInputsPositions.Outside;
		this._firstDummy = new DummyInput(this._getWindow, this._isOutside, { isFirst: true }, element);
		this._lastDummy = new DummyInput(this._getWindow, this._isOutside, { isFirst: false }, element);
		const dummyElement = this._firstDummy.input;
		dummyElement && tabster._dummyObserver.add(dummyElement, this._addDummyInputs);
		this._firstDummy.onFocusIn = this._onFocusIn;
		this._firstDummy.onFocusOut = this._onFocusOut;
		this._lastDummy.onFocusIn = this._onFocusIn;
		this._lastDummy.onFocusOut = this._onFocusOut;
		this._element = element;
		this._addDummyInputs();
	}
	dispose(manager, force) {
		var _a, _b, _c, _d;
		const wrappers = this._wrappers = this._wrappers.filter((w) => w.manager !== manager && !force);
		this._firstDummy && setDummyInputDebugValue(this._firstDummy, wrappers);
		this._lastDummy && setDummyInputDebugValue(this._lastDummy, wrappers);
		if (wrappers.length === 0) {
			delete ((_a = this._element) === null || _a === void 0 ? void 0 : _a.get()).__tabsterDummy;
			for (const el of this._transformElements) el.removeEventListener("scroll", this._addTransformOffsets);
			this._transformElements.clear();
			const win = this._getWindow();
			if (this._addTimer) {
				win.clearTimeout(this._addTimer);
				delete this._addTimer;
			}
			const dummyElement = (_b = this._firstDummy) === null || _b === void 0 ? void 0 : _b.input;
			dummyElement && this._tabster._dummyObserver.remove(dummyElement);
			(_c = this._firstDummy) === null || _c === void 0 || _c.dispose();
			(_d = this._lastDummy) === null || _d === void 0 || _d.dispose();
		}
	}
	_onFocus(isIn, dummyInput, isBackward, relatedTarget) {
		var _a;
		const wrapper = this._getCurrent();
		if (wrapper && (!dummyInput.useDefaultAction || this._callForDefaultAction)) (_a = wrapper.manager.getHandler(isIn)) === null || _a === void 0 || _a(dummyInput, isBackward, relatedTarget);
	}
	_getCurrent() {
		this._wrappers.sort((a, b) => {
			if (a.tabbable !== b.tabbable) return a.tabbable ? -1 : 1;
			return a.priority - b.priority;
		});
		return this._wrappers[0];
	}
	_ensurePosition() {
		var _a, _b, _c;
		const element = (_a = this._element) === null || _a === void 0 ? void 0 : _a.get();
		const firstDummyInput = (_b = this._firstDummy) === null || _b === void 0 ? void 0 : _b.input;
		const lastDummyInput = (_c = this._lastDummy) === null || _c === void 0 ? void 0 : _c.input;
		if (!element || !firstDummyInput || !lastDummyInput) return;
		if (this._isOutside) {
			const elementParent = dom.getParentNode(element);
			if (elementParent) {
				const nextSibling = dom.getNextSibling(element);
				if (nextSibling !== lastDummyInput) dom.insertBefore(elementParent, lastDummyInput, nextSibling);
				if (dom.getPreviousElementSibling(element) !== firstDummyInput) dom.insertBefore(elementParent, firstDummyInput, element);
			}
		} else {
			if (dom.getLastElementChild(element) !== lastDummyInput) dom.appendChild(element, lastDummyInput);
			const firstElementChild = dom.getFirstElementChild(element);
			if (firstElementChild && firstElementChild !== firstDummyInput && firstElementChild.parentNode) dom.insertBefore(firstElementChild.parentNode, firstDummyInput, firstElementChild);
		}
	}
};
function getLastChild$2(container) {
	let lastChild = null;
	for (let i = dom.getLastElementChild(container); i; i = dom.getLastElementChild(i)) lastChild = i;
	return lastChild || void 0;
}
function getAdjacentElement(from, prev) {
	let cur = from;
	let adjacent = null;
	while (cur && !adjacent) {
		adjacent = prev ? dom.getPreviousElementSibling(cur) : dom.getNextElementSibling(cur);
		cur = dom.getParentElement(cur);
	}
	return adjacent || void 0;
}
function augmentAttribute(tabster, element, name, value) {
	const entry = tabster.storageEntry(element, true);
	let ret = false;
	if (!entry.aug) {
		if (value === void 0) return ret;
		entry.aug = {};
	}
	if (value === void 0) {
		if (name in entry.aug) {
			const origVal = entry.aug[name];
			delete entry.aug[name];
			if (origVal === null) element.removeAttribute(name);
			else element.setAttribute(name, origVal);
			ret = true;
		}
	} else {
		let origValue;
		if (!(name in entry.aug)) origValue = element.getAttribute(name);
		if (origValue !== void 0 && origValue !== value) {
			entry.aug[name] = origValue;
			if (value === null) element.removeAttribute(name);
			else element.setAttribute(name, value);
			ret = true;
		}
	}
	if (value === void 0 && Object.keys(entry.aug).length === 0) {
		delete entry.aug;
		tabster.storageEntry(element, false);
	}
	return ret;
}
function isDisplayNone(element) {
	var _a, _b;
	const elementDocument = element.ownerDocument;
	const computedStyle = (_a = elementDocument.defaultView) === null || _a === void 0 ? void 0 : _a.getComputedStyle(element);
	if (element.offsetParent === null && elementDocument.body !== element && (computedStyle === null || computedStyle === void 0 ? void 0 : computedStyle.position) !== "fixed") return true;
	if ((computedStyle === null || computedStyle === void 0 ? void 0 : computedStyle.visibility) === "hidden") return true;
	if ((computedStyle === null || computedStyle === void 0 ? void 0 : computedStyle.position) === "fixed") {
		if (computedStyle.display === "none") return true;
		if (((_b = element.parentElement) === null || _b === void 0 ? void 0 : _b.offsetParent) === null && elementDocument.body !== element.parentElement) return true;
	}
	return false;
}
function isRadio(element) {
	return element.tagName === "INPUT" && !!element.name && element.type === "radio";
}
function getRadioButtonGroup(element) {
	if (!isRadio(element)) return;
	const name = element.name;
	let radioButtons = Array.from(dom.getElementsByName(element, name));
	let checked;
	radioButtons = radioButtons.filter((el) => {
		if (isRadio(el)) {
			if (el.checked) checked = el;
			return true;
		}
		return false;
	});
	return {
		name,
		buttons: new Set(radioButtons),
		checked
	};
}
/**
* If the passed element is Tabster dummy input, returns the container element this dummy input belongs to.
* @param element Element to check for being dummy input.
* @returns Dummy input container element (if the passed element is a dummy input) or null.
*/
function getDummyInputContainer(element) {
	var _a;
	return ((_a = element === null || element === void 0 ? void 0 : element.__tabsterDummyContainer) === null || _a === void 0 ? void 0 : _a.get()) || null;
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
function getTabsterAttribute(props, plain) {
	const attr = JSON.stringify(props);
	if (plain === true) return attr;
	return { [TABSTER_ATTRIBUTE_NAME]: attr };
}
/**
* Updates Tabster props object with new props.
* @param element an element to set data-tabster attribute on.
* @param props current Tabster props to update.
* @param newProps new Tabster props to add.
*  When the value of a property in newProps is undefined, the property
*  will be removed from the attribute.
*/
function mergeTabsterProps(props, newProps) {
	for (const key of Object.keys(newProps)) {
		const value = newProps[key];
		if (value) props[key] = value;
		else delete props[key];
	}
}
/**
* Sets or updates Tabster attribute of the element.
* @param element an element to set data-tabster attribute on.
* @param newProps new Tabster props to set.
* @param update if true, newProps will be merged with the existing props.
*  When true and the value of a property in newProps is undefined, the property
*  will be removed from the attribute.
*/
function setTabsterAttribute(element, newProps, update) {
	let props;
	if (update) {
		const attr = element.getAttribute(TABSTER_ATTRIBUTE_NAME);
		if (attr) try {
			props = JSON.parse(attr);
		} catch (e) {
			console.error(`data-tabster attribute error: ${e}`, element);
		}
	}
	if (!props) props = {};
	mergeTabsterProps(props, newProps);
	if (Object.keys(props).length > 0) element.setAttribute(TABSTER_ATTRIBUTE_NAME, getTabsterAttribute(props, true));
	else element.removeAttribute(TABSTER_ATTRIBUTE_NAME);
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
function _setInformativeStyle$3(weakElement, remove, id) {
	{
		const element = weakElement.get();
		if (element) if (remove) element.style.removeProperty("--tabster-root");
		else element.style.setProperty("--tabster-root", id + ",");
	}
}
var RootDummyManager = class extends DummyInputManager {
	constructor(tabster, element, setFocused, sys) {
		super(tabster, element, DummyInputManagerPriorities.Root, sys, void 0, true);
		this._onDummyInputFocus = (dummyInput) => {
			var _a;
			if (dummyInput.useDefaultAction) this._setFocused(false);
			else {
				this._tabster.keyboardNavigation.setNavigatingWithKeyboard(true);
				const element$1 = this._element.get();
				if (element$1) {
					this._setFocused(true);
					const toFocus = this._tabster.focusedElement.getFirstOrLastTabbable(dummyInput.isFirst, {
						container: element$1,
						ignoreAccessibility: true
					});
					if (toFocus) {
						nativeFocus(toFocus);
						return;
					}
				}
				(_a = dummyInput.input) === null || _a === void 0 || _a.blur();
			}
		};
		this._setHandlers(this._onDummyInputFocus);
		this._tabster = tabster;
		this._setFocused = setFocused;
	}
};
var Root = class extends TabsterPart {
	constructor(tabster, element, onDispose, props, sys) {
		super(tabster, element, props);
		this._isFocused = false;
		this._setFocused = (hasFocused) => {
			var _a;
			if (this._setFocusedTimer) {
				this._tabster.getWindow().clearTimeout(this._setFocusedTimer);
				delete this._setFocusedTimer;
			}
			if (this._isFocused === hasFocused) return;
			const element$1 = this._element.get();
			if (element$1) if (hasFocused) {
				this._isFocused = true;
				(_a = this._dummyManager) === null || _a === void 0 || _a.setTabbable(false);
				element$1.dispatchEvent(new RootFocusEvent({ element: element$1 }));
			} else this._setFocusedTimer = this._tabster.getWindow().setTimeout(() => {
				var _a$1;
				delete this._setFocusedTimer;
				this._isFocused = false;
				(_a$1 = this._dummyManager) === null || _a$1 === void 0 || _a$1.setTabbable(true);
				element$1.dispatchEvent(new RootBlurEvent({ element: element$1 }));
			}, 0);
		};
		this._onFocusIn = (event) => {
			const getParent$1 = this._tabster.getParent;
			const rootElement = this._element.get();
			let curElement = event.composedPath()[0];
			do {
				if (curElement === rootElement) {
					this._setFocused(true);
					return;
				}
				curElement = curElement && getParent$1(curElement);
			} while (curElement);
		};
		this._onFocusOut = () => {
			this._setFocused(false);
		};
		this._onDispose = onDispose;
		const win = tabster.getWindow;
		this.uid = getElementUId(win, element);
		this._sys = sys;
		if (tabster.controlTab || tabster.rootDummyInputs) this.addDummyInputs();
		const doc = win().document;
		doc.addEventListener(KEYBORG_FOCUSIN, this._onFocusIn);
		doc.addEventListener(KEYBORG_FOCUSOUT, this._onFocusOut);
		this._add();
	}
	addDummyInputs() {
		if (!this._dummyManager) this._dummyManager = new RootDummyManager(this._tabster, this._element, this._setFocused, this._sys);
	}
	dispose() {
		var _a;
		this._onDispose(this);
		const win = this._tabster.getWindow();
		const doc = win.document;
		doc.removeEventListener(KEYBORG_FOCUSIN, this._onFocusIn);
		doc.removeEventListener(KEYBORG_FOCUSOUT, this._onFocusOut);
		if (this._setFocusedTimer) {
			win.clearTimeout(this._setFocusedTimer);
			delete this._setFocusedTimer;
		}
		(_a = this._dummyManager) === null || _a === void 0 || _a.dispose();
		this._remove();
	}
	moveOutWithDefaultAction(isBackward, relatedEvent) {
		const dummyManager = this._dummyManager;
		if (dummyManager) dummyManager.moveOutWithDefaultAction(isBackward, relatedEvent);
		else {
			const el = this.getElement();
			if (el) RootDummyManager.moveWithPhantomDummy(this._tabster, el, true, isBackward, relatedEvent);
		}
	}
	_add() {
		_setInformativeStyle$3(this._element, false, this.uid);
	}
	_remove() {
		_setInformativeStyle$3(this._element, true);
	}
};
var RootAPI = class {
	constructor(tabster, autoRoot) {
		this._autoRootWaiting = false;
		this._roots = {};
		this._forceDummy = false;
		this.rootById = {};
		this._autoRootCreate = () => {
			var _a;
			const doc = this._win().document;
			const body = doc.body;
			if (body) {
				this._autoRootUnwait(doc);
				const props = this._autoRoot;
				if (props) {
					setTabsterAttribute(body, { root: props }, true);
					updateTabsterByAttribute(this._tabster, body);
					return (_a = getTabsterOnElement(this._tabster, body)) === null || _a === void 0 ? void 0 : _a.root;
				}
			} else if (!this._autoRootWaiting) {
				this._autoRootWaiting = true;
				doc.addEventListener("readystatechange", this._autoRootCreate);
			}
		};
		this._onRootDispose = (root) => {
			delete this._roots[root.id];
		};
		this._tabster = tabster;
		this._win = tabster.getWindow;
		this._autoRoot = autoRoot;
		tabster.queueInit(() => {
			if (this._autoRoot) this._autoRootCreate();
		});
	}
	_autoRootUnwait(doc) {
		doc.removeEventListener("readystatechange", this._autoRootCreate);
		this._autoRootWaiting = false;
	}
	dispose() {
		const win = this._win();
		this._autoRootUnwait(win.document);
		delete this._autoRoot;
		Object.keys(this._roots).forEach((rootId) => {
			if (this._roots[rootId]) {
				this._roots[rootId].dispose();
				delete this._roots[rootId];
			}
		});
		this.rootById = {};
	}
	createRoot(element, props, sys) {
		const newRoot = new Root(this._tabster, element, this._onRootDispose, props, sys);
		this._roots[newRoot.id] = newRoot;
		if (this._forceDummy) newRoot.addDummyInputs();
		return newRoot;
	}
	addDummyInputs() {
		this._forceDummy = true;
		const roots = this._roots;
		for (const id of Object.keys(roots)) roots[id].addDummyInputs();
	}
	static getRootByUId(getWindow$1, id) {
		const tabster = getWindow$1().__tabsterInstance;
		return tabster && tabster.root.rootById[id];
	}
	/**
	* Fetches the tabster context for an element walking up its ancestors
	*
	* @param tabster Tabster instance
	* @param element The element the tabster context should represent
	* @param options Additional options
	* @returns undefined if the element is not a child of a tabster root, otherwise all applicable tabster behaviours and configurations
	*/
	static getTabsterContext(tabster, element, options) {
		if (options === void 0) options = {};
		var _a, _b, _c, _d;
		if (!element.ownerDocument) return;
		const { checkRtl, referenceElement } = options;
		const getParent$1 = tabster.getParent;
		tabster.drainInitQueue();
		let root;
		let modalizer;
		let groupper;
		let mover;
		let excludedFromMover = false;
		let groupperBeforeMover;
		let modalizerInGroupper;
		let dirRightToLeft;
		let uncontrolled;
		let curElement = referenceElement || element;
		const ignoreKeydown = {};
		while (curElement && (!root || checkRtl)) {
			const tabsterOnElement = getTabsterOnElement(tabster, curElement);
			if (checkRtl && dirRightToLeft === void 0) {
				const dir = curElement.dir;
				if (dir) dirRightToLeft = dir.toLowerCase() === "rtl";
			}
			if (!tabsterOnElement) {
				curElement = getParent$1(curElement);
				continue;
			}
			const tagName = curElement.tagName;
			if ((tabsterOnElement.uncontrolled || tagName === "IFRAME" || tagName === "WEBVIEW") && tabster.focusable.isVisible(curElement)) uncontrolled = curElement;
			if (!mover && ((_a = tabsterOnElement.focusable) === null || _a === void 0 ? void 0 : _a.excludeFromMover) && !groupper) excludedFromMover = true;
			const curModalizer = tabsterOnElement.modalizer;
			const curGroupper = tabsterOnElement.groupper;
			const curMover = tabsterOnElement.mover;
			if (!modalizer && curModalizer) modalizer = curModalizer;
			if (!groupper && curGroupper && (!modalizer || curModalizer)) if (modalizer) {
				if (!curGroupper.isActive() && curGroupper.getProps().tabbability && modalizer.userId !== ((_b = tabster.modalizer) === null || _b === void 0 ? void 0 : _b.activeId)) {
					modalizer = void 0;
					groupper = curGroupper;
				}
				modalizerInGroupper = curGroupper;
			} else groupper = curGroupper;
			if (!mover && curMover && (!modalizer || curModalizer) && (!curGroupper || curElement !== element) && curElement.contains(element)) {
				mover = curMover;
				groupperBeforeMover = !!groupper && groupper !== curGroupper;
			}
			if (tabsterOnElement.root) root = tabsterOnElement.root;
			if ((_c = tabsterOnElement.focusable) === null || _c === void 0 ? void 0 : _c.ignoreKeydown) Object.assign(ignoreKeydown, tabsterOnElement.focusable.ignoreKeydown);
			curElement = getParent$1(curElement);
		}
		if (!root) {
			const rootAPI = tabster.root;
			if (rootAPI._autoRoot) {
				if ((_d = element.ownerDocument) === null || _d === void 0 ? void 0 : _d.body) root = rootAPI._autoRootCreate();
			}
		}
		if (groupper && !mover) groupperBeforeMover = true;
		if (!root) {
			if (modalizer || groupper || mover) console.error("Tabster Root is required for Mover, Groupper and Modalizer to work.");
		}
		const shouldIgnoreKeydown = (event) => !!ignoreKeydown[event.key];
		return root ? {
			root,
			modalizer,
			groupper,
			mover,
			groupperBeforeMover,
			modalizerInGroupper,
			rtl: checkRtl ? !!dirRightToLeft : void 0,
			uncontrolled,
			excludedFromMover,
			ignoreKeydown: shouldIgnoreKeydown
		} : void 0;
	}
	static getRoot(tabster, element) {
		var _a;
		const getParent$1 = tabster.getParent;
		for (let el = element; el; el = getParent$1(el)) {
			const root = (_a = getTabsterOnElement(tabster, el)) === null || _a === void 0 ? void 0 : _a.root;
			if (root) return root;
		}
	}
	onRoot(root, removed) {
		if (removed) delete this.rootById[root.uid];
		else this.rootById[root.uid] = root;
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var Subscribable = class {
	constructor() {
		this._callbacks = [];
	}
	dispose() {
		this._callbacks = [];
		delete this._val;
	}
	subscribe(callback) {
		const callbacks = this._callbacks;
		if (callbacks.indexOf(callback) < 0) callbacks.push(callback);
	}
	subscribeFirst(callback) {
		const callbacks = this._callbacks;
		const index = callbacks.indexOf(callback);
		if (index >= 0) callbacks.splice(index, 1);
		callbacks.unshift(callback);
	}
	unsubscribe(callback) {
		const index = this._callbacks.indexOf(callback);
		if (index >= 0) this._callbacks.splice(index, 1);
	}
	setVal(val, detail) {
		if (this._val === val) return;
		this._val = val;
		this._callCallbacks(val, detail);
	}
	getVal() {
		return this._val;
	}
	trigger(val, detail) {
		this._callCallbacks(val, detail);
	}
	_callCallbacks(val, detail) {
		this._callbacks.forEach((callback) => callback(val, detail));
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var FocusableAPI = class {
	constructor(tabster) {
		this._tabster = tabster;
	}
	dispose() {}
	getProps(element) {
		const tabsterOnElement = getTabsterOnElement(this._tabster, element);
		return tabsterOnElement && tabsterOnElement.focusable || {};
	}
	isFocusable(el, includeProgrammaticallyFocusable, noVisibleCheck, noAccessibleCheck) {
		if (matchesSelector(el, FOCUSABLE_SELECTOR) && (includeProgrammaticallyFocusable || el.tabIndex !== -1)) return (noVisibleCheck || this.isVisible(el)) && (noAccessibleCheck || this.isAccessible(el));
		return false;
	}
	isVisible(el) {
		if (!el.ownerDocument || el.nodeType !== Node.ELEMENT_NODE) return false;
		if (isDisplayNone(el)) return false;
		const rect = el.ownerDocument.body.getBoundingClientRect();
		if (rect.width === 0 && rect.height === 0) return false;
		return true;
	}
	isAccessible(el) {
		var _a;
		for (let e = el; e; e = dom.getParentElement(e)) {
			const tabsterOnElement = getTabsterOnElement(this._tabster, e);
			if (this._isHidden(e)) return false;
			if (!((_a = tabsterOnElement === null || tabsterOnElement === void 0 ? void 0 : tabsterOnElement.focusable) === null || _a === void 0 ? void 0 : _a.ignoreAriaDisabled) && this._isDisabled(e)) return false;
		}
		return true;
	}
	_isDisabled(el) {
		return el.hasAttribute("disabled");
	}
	_isHidden(el) {
		var _a;
		const attrVal = el.getAttribute("aria-hidden");
		if (attrVal && attrVal.toLowerCase() === "true") {
			if (!((_a = this._tabster.modalizer) === null || _a === void 0 ? void 0 : _a.isAugmented(el))) return true;
		}
		return false;
	}
	findFirst(options, out) {
		return this.findElement({ ...options }, out);
	}
	findLast(options, out) {
		return this.findElement({
			isBackward: true,
			...options
		}, out);
	}
	findNext(options, out) {
		return this.findElement({ ...options }, out);
	}
	findPrev(options, out) {
		return this.findElement({
			...options,
			isBackward: true
		}, out);
	}
	findDefault(options, out) {
		return this.findElement({
			...options,
			acceptCondition: (el) => this.isFocusable(el, options.includeProgrammaticallyFocusable) && !!this.getProps(el).isDefault
		}, out) || null;
	}
	findAll(options) {
		return this._findElements(true, options) || [];
	}
	findElement(options, out) {
		const found = this._findElements(false, options, out);
		return found ? found[0] : found;
	}
	_findElements(isFindAll, options, out) {
		var _a, _b, _c;
		const { container, currentElement = null, includeProgrammaticallyFocusable, useActiveModalizer, ignoreAccessibility, modalizerId, isBackward, onElement } = options;
		if (!out) out = {};
		const elements = [];
		let { acceptCondition } = options;
		const hasCustomCondition = !!acceptCondition;
		if (!container) return null;
		if (!acceptCondition) acceptCondition = (el) => this.isFocusable(el, includeProgrammaticallyFocusable, false, ignoreAccessibility);
		const acceptElementState = {
			container,
			modalizerUserId: modalizerId === void 0 && useActiveModalizer ? (_a = this._tabster.modalizer) === null || _a === void 0 ? void 0 : _a.activeId : modalizerId || ((_c = (_b = RootAPI.getTabsterContext(this._tabster, container)) === null || _b === void 0 ? void 0 : _b.modalizer) === null || _c === void 0 ? void 0 : _c.userId),
			from: currentElement || container,
			isBackward,
			isFindAll,
			acceptCondition,
			hasCustomCondition,
			includeProgrammaticallyFocusable,
			ignoreAccessibility,
			cachedGrouppers: {},
			cachedRadioGroups: {}
		};
		const walker = createElementTreeWalker(container.ownerDocument, container, (node) => this._acceptElement(node, acceptElementState));
		if (!walker) return null;
		const prepareForNextElement = (shouldContinueIfNotFound) => {
			var _a$1, _b$1;
			const foundElement = (_a$1 = acceptElementState.foundElement) !== null && _a$1 !== void 0 ? _a$1 : acceptElementState.foundBackward;
			if (foundElement) elements.push(foundElement);
			if (isFindAll) {
				if (foundElement) {
					acceptElementState.found = false;
					delete acceptElementState.foundElement;
					delete acceptElementState.foundBackward;
					delete acceptElementState.fromCtx;
					acceptElementState.from = foundElement;
					if (onElement && !onElement(foundElement)) return false;
				}
				return !!(foundElement || shouldContinueIfNotFound);
			} else {
				if (foundElement && out) out.uncontrolled = (_b$1 = RootAPI.getTabsterContext(this._tabster, foundElement)) === null || _b$1 === void 0 ? void 0 : _b$1.uncontrolled;
				return !!(shouldContinueIfNotFound && !foundElement);
			}
		};
		if (!currentElement) out.outOfDOMOrder = true;
		if (currentElement && dom.nodeContains(container, currentElement)) walker.currentNode = currentElement;
		else if (isBackward) {
			const lastChild = getLastChild$2(container);
			if (!lastChild) return null;
			if (this._acceptElement(lastChild, acceptElementState) === NodeFilter.FILTER_ACCEPT && !prepareForNextElement(true)) {
				if (acceptElementState.skippedFocusable) out.outOfDOMOrder = true;
				return elements;
			}
			walker.currentNode = lastChild;
		}
		do
			if (isBackward) walker.previousNode();
			else walker.nextNode();
		while (prepareForNextElement());
		if (acceptElementState.skippedFocusable) out.outOfDOMOrder = true;
		return elements.length ? elements : null;
	}
	_acceptElement(element, state) {
		var _a, _b, _c;
		if (state.found) return NodeFilter.FILTER_ACCEPT;
		const foundBackward = state.foundBackward;
		if (foundBackward && (element === foundBackward || !dom.nodeContains(foundBackward, element))) {
			state.found = true;
			state.foundElement = foundBackward;
			return NodeFilter.FILTER_ACCEPT;
		}
		const container = state.container;
		if (element === container) return NodeFilter.FILTER_SKIP;
		if (!dom.nodeContains(container, element)) return NodeFilter.FILTER_REJECT;
		if (getDummyInputContainer(element)) return NodeFilter.FILTER_REJECT;
		if (dom.nodeContains(state.rejectElementsFrom, element)) return NodeFilter.FILTER_REJECT;
		const ctx = state.currentCtx = RootAPI.getTabsterContext(this._tabster, element);
		if (!ctx) return NodeFilter.FILTER_SKIP;
		if (shouldIgnoreFocus(element)) {
			if (this.isFocusable(element, void 0, true, true)) state.skippedFocusable = true;
			return NodeFilter.FILTER_SKIP;
		}
		if (!state.hasCustomCondition && (element.tagName === "IFRAME" || element.tagName === "WEBVIEW")) if (this.isVisible(element) && ((_a = ctx.modalizer) === null || _a === void 0 ? void 0 : _a.userId) === ((_b = this._tabster.modalizer) === null || _b === void 0 ? void 0 : _b.activeId)) {
			state.found = true;
			state.rejectElementsFrom = state.foundElement = element;
			return NodeFilter.FILTER_ACCEPT;
		} else return NodeFilter.FILTER_REJECT;
		if (!state.ignoreAccessibility && !this.isAccessible(element)) {
			if (this.isFocusable(element, false, true, true)) state.skippedFocusable = true;
			return NodeFilter.FILTER_REJECT;
		}
		let result;
		let fromCtx = state.fromCtx;
		if (!fromCtx) fromCtx = state.fromCtx = RootAPI.getTabsterContext(this._tabster, state.from);
		const fromMover = fromCtx === null || fromCtx === void 0 ? void 0 : fromCtx.mover;
		let groupper = ctx.groupper;
		let mover = ctx.mover;
		result = (_c = this._tabster.modalizer) === null || _c === void 0 ? void 0 : _c.acceptElement(element, state);
		if (result !== void 0) state.skippedFocusable = true;
		if (result === void 0 && (groupper || mover || fromMover)) {
			const groupperElement = groupper === null || groupper === void 0 ? void 0 : groupper.getElement();
			const fromMoverElement = fromMover === null || fromMover === void 0 ? void 0 : fromMover.getElement();
			let moverElement = mover === null || mover === void 0 ? void 0 : mover.getElement();
			if (moverElement && dom.nodeContains(fromMoverElement, moverElement) && dom.nodeContains(container, fromMoverElement) && (!groupperElement || !mover || dom.nodeContains(fromMoverElement, groupperElement))) {
				mover = fromMover;
				moverElement = fromMoverElement;
			}
			if (groupperElement) {
				if (groupperElement === container || !dom.nodeContains(container, groupperElement)) groupper = void 0;
				else if (!dom.nodeContains(groupperElement, element)) return NodeFilter.FILTER_REJECT;
			}
			if (moverElement) {
				if (!dom.nodeContains(container, moverElement)) mover = void 0;
				else if (!dom.nodeContains(moverElement, element)) return NodeFilter.FILTER_REJECT;
			}
			if (groupper && mover) if (moverElement && groupperElement && !dom.nodeContains(groupperElement, moverElement)) mover = void 0;
			else groupper = void 0;
			if (groupper) result = groupper.acceptElement(element, state);
			if (mover) result = mover.acceptElement(element, state);
		}
		if (result === void 0) {
			result = state.acceptCondition(element) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
			if (result === NodeFilter.FILTER_SKIP && this.isFocusable(element, false, true, true)) state.skippedFocusable = true;
		}
		if (result === NodeFilter.FILTER_ACCEPT && !state.found) {
			if (!state.isFindAll && isRadio(element) && !element.checked) {
				const radioGroupName = element.name;
				let radioGroup = state.cachedRadioGroups[radioGroupName];
				if (!radioGroup) {
					radioGroup = getRadioButtonGroup(element);
					if (radioGroup) state.cachedRadioGroups[radioGroupName] = radioGroup;
				}
				if ((radioGroup === null || radioGroup === void 0 ? void 0 : radioGroup.checked) && radioGroup.checked !== element) return NodeFilter.FILTER_SKIP;
			}
			if (state.isBackward) {
				state.foundBackward = element;
				result = NodeFilter.FILTER_SKIP;
			} else {
				state.found = true;
				state.foundElement = element;
			}
		}
		return result;
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var Keys = {
	Tab: "Tab",
	Enter: "Enter",
	Escape: "Escape",
	PageUp: "PageUp",
	PageDown: "PageDown",
	End: "End",
	Home: "Home",
	ArrowLeft: "ArrowLeft",
	ArrowUp: "ArrowUp",
	ArrowRight: "ArrowRight",
	ArrowDown: "ArrowDown"
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
function getUncontrolledCompletelyContainer(tabster, element) {
	var _a;
	const getParent$1 = tabster.getParent;
	let el = element;
	do {
		const uncontrolledOnElement = (_a = getTabsterOnElement(tabster, el)) === null || _a === void 0 ? void 0 : _a.uncontrolled;
		if (uncontrolledOnElement && tabster.uncontrolled.isUncontrolledCompletely(el, !!uncontrolledOnElement.completely)) return el;
		el = getParent$1(el);
	} while (el);
}
var AsyncFocusIntentPriorityBySource = {
	[AsyncFocusSources.Restorer]: 0,
	[AsyncFocusSources.Deloser]: 1,
	[AsyncFocusSources.EscapeGroupper]: 2
};
var FocusedElementState = class FocusedElementState extends Subscribable {
	constructor(tabster, getWindow$1) {
		super();
		this._init = () => {
			const win = this._win();
			const doc = win.document;
			doc.addEventListener(KEYBORG_FOCUSIN, this._onFocusIn, true);
			doc.addEventListener(KEYBORG_FOCUSOUT, this._onFocusOut, true);
			win.addEventListener("keydown", this._onKeyDown, true);
			const activeElement = dom.getActiveElement(doc);
			if (activeElement && activeElement !== doc.body) this._setFocusedElement(activeElement);
			this.subscribe(this._onChanged);
		};
		this._onFocusIn = (e) => {
			const target = e.composedPath()[0];
			if (target) this._setFocusedElement(target, e.detail.relatedTarget, e.detail.isFocusedProgrammatically);
		};
		this._onFocusOut = (e) => {
			var _a;
			this._setFocusedElement(void 0, (_a = e.detail) === null || _a === void 0 ? void 0 : _a.originalEvent.relatedTarget);
		};
		this._validateFocusedElement = (element) => {};
		this._onKeyDown = (event) => {
			if (event.key !== Keys.Tab || event.ctrlKey) return;
			const currentElement = this.getVal();
			if (!currentElement || !currentElement.ownerDocument || currentElement.contentEditable === "true") return;
			const tabster$1 = this._tabster;
			const controlTab = tabster$1.controlTab;
			const ctx = RootAPI.getTabsterContext(tabster$1, currentElement);
			if (!ctx || ctx.ignoreKeydown(event)) return;
			const isBackward = event.shiftKey;
			const next = FocusedElementState.findNextTabbable(tabster$1, ctx, void 0, currentElement, void 0, isBackward, true);
			const rootElement = ctx.root.getElement();
			if (!rootElement) return;
			const nextElement = next === null || next === void 0 ? void 0 : next.element;
			const uncontrolledCompletelyContainer = getUncontrolledCompletelyContainer(tabster$1, currentElement);
			if (nextElement) {
				const nextUncontrolled = next.uncontrolled;
				if (ctx.uncontrolled || dom.nodeContains(nextUncontrolled, currentElement)) {
					if (!next.outOfDOMOrder && nextUncontrolled === ctx.uncontrolled || uncontrolledCompletelyContainer && !dom.nodeContains(uncontrolledCompletelyContainer, nextElement)) return;
					DummyInputManager.addPhantomDummyWithTarget(tabster$1, currentElement, isBackward, nextElement);
					return;
				}
				if (nextUncontrolled && tabster$1.focusable.isVisible(nextUncontrolled) || nextElement.tagName === "IFRAME" && tabster$1.focusable.isVisible(nextElement)) {
					if (rootElement.dispatchEvent(new TabsterMoveFocusEvent({
						by: "root",
						owner: rootElement,
						next: nextElement,
						relatedEvent: event
					}))) DummyInputManager.moveWithPhantomDummy(tabster$1, nextUncontrolled !== null && nextUncontrolled !== void 0 ? nextUncontrolled : nextElement, false, isBackward, event);
					return;
				}
				if (controlTab || (next === null || next === void 0 ? void 0 : next.outOfDOMOrder)) {
					if (rootElement.dispatchEvent(new TabsterMoveFocusEvent({
						by: "root",
						owner: rootElement,
						next: nextElement,
						relatedEvent: event
					}))) {
						event.preventDefault();
						event.stopImmediatePropagation();
						nativeFocus(nextElement);
					}
				}
			} else if (!uncontrolledCompletelyContainer && rootElement.dispatchEvent(new TabsterMoveFocusEvent({
				by: "root",
				owner: rootElement,
				next: null,
				relatedEvent: event
			}))) ctx.root.moveOutWithDefaultAction(isBackward, event);
		};
		this._onChanged = (element, detail) => {
			var _a, _b;
			if (element) element.dispatchEvent(new TabsterFocusInEvent(detail));
			else {
				const last = (_a = this._lastVal) === null || _a === void 0 ? void 0 : _a.get();
				if (last) {
					const d = { ...detail };
					const lastCtx = RootAPI.getTabsterContext(this._tabster, last);
					const modalizerId = (_b = lastCtx === null || lastCtx === void 0 ? void 0 : lastCtx.modalizer) === null || _b === void 0 ? void 0 : _b.userId;
					if (modalizerId) d.modalizerId = modalizerId;
					last.dispatchEvent(new TabsterFocusOutEvent(d));
				}
			}
		};
		this._tabster = tabster;
		this._win = getWindow$1;
		tabster.queueInit(this._init);
	}
	dispose() {
		super.dispose();
		const win = this._win();
		const doc = win.document;
		doc.removeEventListener(KEYBORG_FOCUSIN, this._onFocusIn, true);
		doc.removeEventListener(KEYBORG_FOCUSOUT, this._onFocusOut, true);
		win.removeEventListener("keydown", this._onKeyDown, true);
		this.unsubscribe(this._onChanged);
		const asyncFocus = this._asyncFocus;
		if (asyncFocus) {
			win.clearTimeout(asyncFocus.timeout);
			delete this._asyncFocus;
		}
		delete FocusedElementState._lastResetElement;
		delete this._nextVal;
		delete this._lastVal;
	}
	static forgetMemorized(instance, parent) {
		var _a, _b;
		let wel = FocusedElementState._lastResetElement;
		let el = wel && wel.get();
		if (el && dom.nodeContains(parent, el)) delete FocusedElementState._lastResetElement;
		el = (_b = (_a = instance._nextVal) === null || _a === void 0 ? void 0 : _a.element) === null || _b === void 0 ? void 0 : _b.get();
		if (el && dom.nodeContains(parent, el)) delete instance._nextVal;
		wel = instance._lastVal;
		el = wel && wel.get();
		if (el && dom.nodeContains(parent, el)) delete instance._lastVal;
	}
	getFocusedElement() {
		return this.getVal();
	}
	getLastFocusedElement() {
		var _a;
		let el = (_a = this._lastVal) === null || _a === void 0 ? void 0 : _a.get();
		if (!el || el && !documentContains(el.ownerDocument, el)) this._lastVal = el = void 0;
		return el;
	}
	focus(element, noFocusedProgrammaticallyFlag, noAccessibleCheck, preventScroll) {
		if (!this._tabster.focusable.isFocusable(element, noFocusedProgrammaticallyFlag, false, noAccessibleCheck)) return false;
		element.focus({ preventScroll });
		return true;
	}
	focusDefault(container) {
		const el = this._tabster.focusable.findDefault({ container });
		if (el) {
			this._tabster.focusedElement.focus(el);
			return true;
		}
		return false;
	}
	getFirstOrLastTabbable(isFirst, props) {
		var _a;
		const { container, ignoreAccessibility } = props;
		let toFocus;
		if (container) {
			const ctx = RootAPI.getTabsterContext(this._tabster, container);
			if (ctx) toFocus = (_a = FocusedElementState.findNextTabbable(this._tabster, ctx, container, void 0, void 0, !isFirst, ignoreAccessibility)) === null || _a === void 0 ? void 0 : _a.element;
		}
		if (toFocus && !dom.nodeContains(container, toFocus)) toFocus = void 0;
		return toFocus || void 0;
	}
	_focusFirstOrLast(isFirst, props) {
		const toFocus = this.getFirstOrLastTabbable(isFirst, props);
		if (toFocus) {
			this.focus(toFocus, false, true);
			return true;
		}
		return false;
	}
	focusFirst(props) {
		return this._focusFirstOrLast(true, props);
	}
	focusLast(props) {
		return this._focusFirstOrLast(false, props);
	}
	resetFocus(container) {
		if (!this._tabster.focusable.isVisible(container)) return false;
		if (!this._tabster.focusable.isFocusable(container, true, true, true)) {
			const prevTabIndex = container.getAttribute("tabindex");
			const prevAriaHidden = container.getAttribute("aria-hidden");
			container.tabIndex = -1;
			container.setAttribute("aria-hidden", "true");
			FocusedElementState._lastResetElement = new WeakHTMLElement(this._win, container);
			this.focus(container, true, true);
			this._setOrRemoveAttribute(container, "tabindex", prevTabIndex);
			this._setOrRemoveAttribute(container, "aria-hidden", prevAriaHidden);
		} else this.focus(container);
		return true;
	}
	requestAsyncFocus(source, callback, delay) {
		const win = this._tabster.getWindow();
		const currentAsyncFocus = this._asyncFocus;
		if (currentAsyncFocus) {
			if (AsyncFocusIntentPriorityBySource[source] > AsyncFocusIntentPriorityBySource[currentAsyncFocus.source]) return;
			win.clearTimeout(currentAsyncFocus.timeout);
		}
		this._asyncFocus = {
			source,
			callback,
			timeout: win.setTimeout(() => {
				this._asyncFocus = void 0;
				callback();
			}, delay)
		};
	}
	cancelAsyncFocus(source) {
		const asyncFocus = this._asyncFocus;
		if ((asyncFocus === null || asyncFocus === void 0 ? void 0 : asyncFocus.source) === source) {
			this._tabster.getWindow().clearTimeout(asyncFocus.timeout);
			this._asyncFocus = void 0;
		}
	}
	_setOrRemoveAttribute(element, name, value) {
		if (value === null) element.removeAttribute(name);
		else element.setAttribute(name, value);
	}
	_setFocusedElement(element, relatedTarget, isFocusedProgrammatically) {
		var _a, _b;
		if (this._tabster._noop) return;
		const detail = { relatedTarget };
		if (element) {
			const lastResetElement = (_a = FocusedElementState._lastResetElement) === null || _a === void 0 ? void 0 : _a.get();
			FocusedElementState._lastResetElement = void 0;
			if (lastResetElement === element || shouldIgnoreFocus(element)) return;
			detail.isFocusedProgrammatically = isFocusedProgrammatically;
			const ctx = RootAPI.getTabsterContext(this._tabster, element);
			const modalizerId = (_b = ctx === null || ctx === void 0 ? void 0 : ctx.modalizer) === null || _b === void 0 ? void 0 : _b.userId;
			if (modalizerId) detail.modalizerId = modalizerId;
		}
		const nextVal = this._nextVal = {
			element: element ? new WeakHTMLElement(this._win, element) : void 0,
			detail
		};
		if (element && element !== this._val) this._validateFocusedElement(element);
		if (this._nextVal === nextVal) this.setVal(element, detail);
		this._nextVal = void 0;
	}
	setVal(val, detail) {
		super.setVal(val, detail);
		if (val) this._lastVal = new WeakHTMLElement(this._win, val);
	}
	static findNextTabbable(tabster, ctx, container, currentElement, referenceElement, isBackward, ignoreAccessibility) {
		const actualContainer = container || ctx.root.getElement();
		if (!actualContainer) return null;
		let next = null;
		const isTabbingTimer = FocusedElementState._isTabbingTimer;
		const win = tabster.getWindow();
		if (isTabbingTimer) win.clearTimeout(isTabbingTimer);
		FocusedElementState.isTabbing = true;
		FocusedElementState._isTabbingTimer = win.setTimeout(() => {
			delete FocusedElementState._isTabbingTimer;
			FocusedElementState.isTabbing = false;
		}, 0);
		const modalizer = ctx.modalizer;
		const groupper = ctx.groupper;
		const mover = ctx.mover;
		const callFindNext = (what) => {
			next = what.findNextTabbable(currentElement, referenceElement, isBackward, ignoreAccessibility);
			if (currentElement && !(next === null || next === void 0 ? void 0 : next.element)) {
				const parentElement = what !== modalizer && dom.getParentElement(what.getElement());
				if (parentElement) {
					const parentCtx = RootAPI.getTabsterContext(tabster, currentElement, { referenceElement: parentElement });
					if (parentCtx) {
						const currentScopeElement = what.getElement();
						const newCurrent = isBackward ? currentScopeElement : currentScopeElement && getLastChild$2(currentScopeElement) || currentScopeElement;
						if (newCurrent) {
							next = FocusedElementState.findNextTabbable(tabster, parentCtx, container, newCurrent, parentElement, isBackward, ignoreAccessibility);
							if (next) next.outOfDOMOrder = true;
						}
					}
				}
			}
		};
		if (groupper && mover) callFindNext(ctx.groupperBeforeMover ? groupper : mover);
		else if (groupper) callFindNext(groupper);
		else if (mover) callFindNext(mover);
		else if (modalizer) callFindNext(modalizer);
		else {
			const findProps = {
				container: actualContainer,
				currentElement,
				referenceElement,
				ignoreAccessibility,
				useActiveModalizer: true
			};
			const findPropsOut = {};
			next = {
				element: tabster.focusable[isBackward ? "findPrev" : "findNext"](findProps, findPropsOut),
				outOfDOMOrder: findPropsOut.outOfDOMOrder,
				uncontrolled: findPropsOut.uncontrolled
			};
		}
		return next;
	}
};
FocusedElementState.isTabbing = false;
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var GroupperDummyManager = class extends DummyInputManager {
	constructor(element, groupper, tabster, sys) {
		super(tabster, element, DummyInputManagerPriorities.Groupper, sys, true);
		this._setHandlers((dummyInput, isBackward, relatedTarget) => {
			var _a, _b;
			const container = element.get();
			const input = dummyInput.input;
			if (container && input) {
				const ctx = RootAPI.getTabsterContext(tabster, input);
				if (ctx) {
					let next;
					next = (_a = groupper.findNextTabbable(relatedTarget || void 0, void 0, isBackward, true)) === null || _a === void 0 ? void 0 : _a.element;
					if (!next) next = (_b = FocusedElementState.findNextTabbable(tabster, ctx, void 0, dummyInput.isOutside ? input : getAdjacentElement(container, !isBackward), void 0, isBackward, true)) === null || _b === void 0 ? void 0 : _b.element;
					if (next) nativeFocus(next);
				}
			}
		});
	}
};
var Groupper = class extends TabsterPart {
	constructor(tabster, element, onDispose, props, sys) {
		super(tabster, element, props);
		this._shouldTabInside = false;
		this.makeTabbable(false);
		this._onDispose = onDispose;
		if (!tabster.controlTab) this.dummyManager = new GroupperDummyManager(this._element, this, tabster, sys);
	}
	dispose() {
		var _a;
		this._onDispose(this);
		const element = this._element.get();
		(_a = this.dummyManager) === null || _a === void 0 || _a.dispose();
		delete this.dummyManager;
		if (element) _setInformativeStyle$1(this._element, true);
		delete this._first;
	}
	findNextTabbable(currentElement, referenceElement, isBackward, ignoreAccessibility) {
		const groupperElement = this.getElement();
		if (!groupperElement) return null;
		const currentIsDummy = getDummyInputContainer(currentElement) === groupperElement;
		if (!this._shouldTabInside && currentElement && dom.nodeContains(groupperElement, currentElement) && !currentIsDummy) return {
			element: void 0,
			outOfDOMOrder: true
		};
		const groupperFirstFocusable = this.getFirst(true);
		if (!currentElement || !dom.nodeContains(groupperElement, currentElement) || currentIsDummy) return {
			element: groupperFirstFocusable,
			outOfDOMOrder: true
		};
		const tabster = this._tabster;
		let next = null;
		let outOfDOMOrder = false;
		let uncontrolled;
		if (this._shouldTabInside && groupperFirstFocusable) {
			const findProps = {
				container: groupperElement,
				currentElement,
				referenceElement,
				ignoreAccessibility,
				useActiveModalizer: true
			};
			const findPropsOut = {};
			next = tabster.focusable[isBackward ? "findPrev" : "findNext"](findProps, findPropsOut);
			outOfDOMOrder = !!findPropsOut.outOfDOMOrder;
			if (!next && this._props.tabbability === GroupperTabbabilities.LimitedTrapFocus) {
				next = tabster.focusable[isBackward ? "findLast" : "findFirst"]({
					container: groupperElement,
					ignoreAccessibility,
					useActiveModalizer: true
				}, findPropsOut);
				outOfDOMOrder = true;
			}
			uncontrolled = findPropsOut.uncontrolled;
		}
		return {
			element: next,
			uncontrolled,
			outOfDOMOrder
		};
	}
	makeTabbable(isTabbable) {
		this._shouldTabInside = isTabbable || !this._props.tabbability;
		_setInformativeStyle$1(this._element, !this._shouldTabInside);
	}
	isActive(noIfFirstIsFocused) {
		var _a;
		const element = this.getElement() || null;
		let isParentActive = true;
		for (let e = dom.getParentElement(element); e; e = dom.getParentElement(e)) {
			const g = (_a = getTabsterOnElement(this._tabster, e)) === null || _a === void 0 ? void 0 : _a.groupper;
			if (g) {
				if (!g._shouldTabInside) isParentActive = false;
			}
		}
		let ret = isParentActive ? this._props.tabbability ? this._shouldTabInside : false : void 0;
		if (ret && noIfFirstIsFocused) {
			const focused = this._tabster.focusedElement.getFocusedElement();
			if (focused) ret = focused !== this.getFirst(true);
		}
		return ret;
	}
	getFirst(orContainer) {
		var _a;
		const groupperElement = this.getElement();
		let first;
		if (groupperElement) {
			if (orContainer && this._tabster.focusable.isFocusable(groupperElement)) return groupperElement;
			first = (_a = this._first) === null || _a === void 0 ? void 0 : _a.get();
			if (!first) {
				first = this._tabster.focusable.findFirst({
					container: groupperElement,
					useActiveModalizer: true
				}) || void 0;
				if (first) this.setFirst(first);
			}
		}
		return first;
	}
	setFirst(element) {
		if (element) this._first = new WeakHTMLElement(this._tabster.getWindow, element);
		else delete this._first;
	}
	acceptElement(element, state) {
		const cachedGrouppers = state.cachedGrouppers;
		const parentElement = dom.getParentElement(this.getElement());
		const parentCtx = parentElement && RootAPI.getTabsterContext(this._tabster, parentElement);
		const parentCtxGroupper = parentCtx === null || parentCtx === void 0 ? void 0 : parentCtx.groupper;
		const parentGroupper = (parentCtx === null || parentCtx === void 0 ? void 0 : parentCtx.groupperBeforeMover) ? parentCtxGroupper : void 0;
		let parentGroupperElement;
		const getIsActive = (groupper) => {
			let cached = cachedGrouppers[groupper.id];
			let isActive$1;
			if (cached) isActive$1 = cached.isActive;
			else {
				isActive$1 = this.isActive(true);
				cached = cachedGrouppers[groupper.id] = { isActive: isActive$1 };
			}
			return isActive$1;
		};
		if (parentGroupper) {
			parentGroupperElement = parentGroupper.getElement();
			if (!getIsActive(parentGroupper) && parentGroupperElement && state.container !== parentGroupperElement && dom.nodeContains(state.container, parentGroupperElement)) {
				state.skippedFocusable = true;
				return NodeFilter.FILTER_REJECT;
			}
		}
		const isActive = getIsActive(this);
		const groupperElement = this.getElement();
		if (groupperElement) {
			if (isActive !== true) {
				if (groupperElement === element && parentCtxGroupper) {
					if (!parentGroupperElement) parentGroupperElement = parentCtxGroupper.getElement();
					if (parentGroupperElement && !getIsActive(parentCtxGroupper) && dom.nodeContains(state.container, parentGroupperElement) && parentGroupperElement !== state.container) {
						state.skippedFocusable = true;
						return NodeFilter.FILTER_REJECT;
					}
				}
				if (groupperElement !== element && dom.nodeContains(groupperElement, element)) {
					state.skippedFocusable = true;
					return NodeFilter.FILTER_REJECT;
				}
				const cached = cachedGrouppers[this.id];
				let first;
				if ("first" in cached) first = cached.first;
				else first = cached.first = this.getFirst(true);
				if (first && state.acceptCondition(first)) {
					state.rejectElementsFrom = groupperElement;
					state.skippedFocusable = true;
					if (first !== state.from) {
						state.found = true;
						state.foundElement = first;
						return NodeFilter.FILTER_ACCEPT;
					} else return NodeFilter.FILTER_REJECT;
				}
			}
		}
	}
};
var GroupperAPI = class {
	constructor(tabster, getWindow$1) {
		this._current = {};
		this._grouppers = {};
		this._init = () => {
			const win = this._win();
			this._tabster.focusedElement.subscribeFirst(this._onFocus);
			const doc = win.document;
			const activeElement = dom.getActiveElement(doc);
			if (activeElement) this._onFocus(activeElement);
			doc.addEventListener("mousedown", this._onMouseDown, true);
			win.addEventListener("keydown", this._onKeyDown, true);
			win.addEventListener(GroupperMoveFocusEventName, this._onMoveFocus);
		};
		this._onGroupperDispose = (groupper) => {
			delete this._grouppers[groupper.id];
		};
		this._onFocus = (element) => {
			if (element) this._updateCurrent(element);
		};
		this._onMouseDown = (e) => {
			let target = e.target;
			while (target && !this._tabster.focusable.isFocusable(target)) target = this._tabster.getParent(target);
			if (target) this._updateCurrent(target);
		};
		this._onKeyDown = (event) => {
			if (event.key !== Keys.Enter && event.key !== Keys.Escape) return;
			if (event.ctrlKey || event.altKey || event.shiftKey || event.metaKey) return;
			const element = this._tabster.focusedElement.getFocusedElement();
			if (element) this.handleKeyPress(element, event);
		};
		this._onMoveFocus = (e) => {
			var _a;
			const element = e.composedPath()[0];
			const action = (_a = e.detail) === null || _a === void 0 ? void 0 : _a.action;
			if (element && action !== void 0 && !e.defaultPrevented) {
				if (action === GroupperMoveFocusActions.Enter) this._enterGroupper(element);
				else this._escapeGroupper(element);
				e.stopImmediatePropagation();
			}
		};
		this._tabster = tabster;
		this._win = getWindow$1;
		tabster.queueInit(this._init);
	}
	dispose() {
		const win = this._win();
		this._tabster.focusedElement.cancelAsyncFocus(AsyncFocusSources.EscapeGroupper);
		this._current = {};
		if (this._updateTimer) {
			win.clearTimeout(this._updateTimer);
			delete this._updateTimer;
		}
		this._tabster.focusedElement.unsubscribe(this._onFocus);
		win.document.removeEventListener("mousedown", this._onMouseDown, true);
		win.removeEventListener("keydown", this._onKeyDown, true);
		win.removeEventListener(GroupperMoveFocusEventName, this._onMoveFocus);
		Object.keys(this._grouppers).forEach((groupperId) => {
			if (this._grouppers[groupperId]) {
				this._grouppers[groupperId].dispose();
				delete this._grouppers[groupperId];
			}
		});
	}
	createGroupper(element, props, sys) {
		const tabster = this._tabster;
		const newGroupper = new Groupper(tabster, element, this._onGroupperDispose, props, sys);
		this._grouppers[newGroupper.id] = newGroupper;
		const focusedElement = tabster.focusedElement.getFocusedElement();
		if (focusedElement && dom.nodeContains(element, focusedElement) && !this._updateTimer) this._updateTimer = this._win().setTimeout(() => {
			delete this._updateTimer;
			if (focusedElement === tabster.focusedElement.getFocusedElement()) this._updateCurrent(focusedElement);
		}, 0);
		return newGroupper;
	}
	forgetCurrentGrouppers() {
		this._current = {};
	}
	_updateCurrent(element) {
		var _a;
		if (this._updateTimer) {
			this._win().clearTimeout(this._updateTimer);
			delete this._updateTimer;
		}
		const tabster = this._tabster;
		const newIds = {};
		for (let el = tabster.getParent(element); el; el = tabster.getParent(el)) {
			const groupper = (_a = getTabsterOnElement(tabster, el)) === null || _a === void 0 ? void 0 : _a.groupper;
			if (groupper) {
				newIds[groupper.id] = true;
				this._current[groupper.id] = groupper;
				const isTabbable = groupper.isActive() || element !== el && (!groupper.getProps().delegated || groupper.getFirst(false) !== element);
				groupper.makeTabbable(isTabbable);
			}
		}
		for (const id of Object.keys(this._current)) {
			const groupper = this._current[id];
			if (!(groupper.id in newIds)) {
				groupper.makeTabbable(false);
				groupper.setFirst(void 0);
				delete this._current[id];
			}
		}
	}
	_enterGroupper(element, relatedEvent) {
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, element);
		const groupper = (ctx === null || ctx === void 0 ? void 0 : ctx.groupper) || (ctx === null || ctx === void 0 ? void 0 : ctx.modalizerInGroupper);
		const groupperElement = groupper === null || groupper === void 0 ? void 0 : groupper.getElement();
		if (groupper && groupperElement && (element === groupperElement || groupper.getProps().delegated && element === groupper.getFirst(false))) {
			const next = tabster.focusable.findNext({
				container: groupperElement,
				currentElement: element,
				useActiveModalizer: true
			});
			if (next && (!relatedEvent || relatedEvent && groupperElement.dispatchEvent(new TabsterMoveFocusEvent({
				by: "groupper",
				owner: groupperElement,
				next,
				relatedEvent
			})))) {
				if (relatedEvent) {
					relatedEvent.preventDefault();
					relatedEvent.stopImmediatePropagation();
				}
				next.focus();
				return next;
			}
		}
		return null;
	}
	_escapeGroupper(element, relatedEvent, fromModalizer) {
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, element);
		let groupper = (ctx === null || ctx === void 0 ? void 0 : ctx.groupper) || (ctx === null || ctx === void 0 ? void 0 : ctx.modalizerInGroupper);
		const groupperElement = groupper === null || groupper === void 0 ? void 0 : groupper.getElement();
		if (groupper && groupperElement && dom.nodeContains(groupperElement, element)) {
			let next;
			if (element !== groupperElement || fromModalizer) next = groupper.getFirst(true);
			else {
				const parentElement = dom.getParentElement(groupperElement);
				const parentCtx = parentElement ? RootAPI.getTabsterContext(tabster, parentElement) : void 0;
				groupper = parentCtx === null || parentCtx === void 0 ? void 0 : parentCtx.groupper;
				next = groupper === null || groupper === void 0 ? void 0 : groupper.getFirst(true);
			}
			if (next && (!relatedEvent || relatedEvent && groupperElement.dispatchEvent(new TabsterMoveFocusEvent({
				by: "groupper",
				owner: groupperElement,
				next,
				relatedEvent
			})))) {
				if (groupper) groupper.makeTabbable(false);
				next.focus();
				return next;
			}
		}
		return null;
	}
	moveFocus(element, action) {
		return action === GroupperMoveFocusActions.Enter ? this._enterGroupper(element) : this._escapeGroupper(element);
	}
	handleKeyPress(element, event, fromModalizer) {
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, element);
		if (ctx && ((ctx === null || ctx === void 0 ? void 0 : ctx.groupper) || (ctx === null || ctx === void 0 ? void 0 : ctx.modalizerInGroupper))) {
			tabster.focusedElement.cancelAsyncFocus(AsyncFocusSources.EscapeGroupper);
			if (ctx.ignoreKeydown(event)) return;
			if (event.key === Keys.Enter) this._enterGroupper(element, event);
			else if (event.key === Keys.Escape) {
				const focusedElement = tabster.focusedElement.getFocusedElement();
				tabster.focusedElement.requestAsyncFocus(AsyncFocusSources.EscapeGroupper, () => {
					if (focusedElement !== tabster.focusedElement.getFocusedElement() && (fromModalizer && !focusedElement || !fromModalizer)) return;
					this._escapeGroupper(element, event, fromModalizer);
				}, 0);
			}
		}
	}
};
function _setInformativeStyle$1(weakElement, remove) {
	{
		const element = weakElement.get();
		if (element) if (remove) element.style.removeProperty("--tabster-groupper");
		else element.style.setProperty("--tabster-groupper", "unlimited");
	}
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var KeyboardNavigationState = class extends Subscribable {
	constructor(getWindow$1) {
		super();
		this._onChange = (isNavigatingWithKeyboard) => {
			this.setVal(isNavigatingWithKeyboard, void 0);
		};
		this._keyborg = createKeyborg(getWindow$1());
		this._keyborg.subscribe(this._onChange);
	}
	dispose() {
		super.dispose();
		if (this._keyborg) {
			this._keyborg.unsubscribe(this._onChange);
			disposeKeyborg(this._keyborg);
			delete this._keyborg;
		}
	}
	setNavigatingWithKeyboard(isNavigatingWithKeyboard) {
		var _a;
		(_a = this._keyborg) === null || _a === void 0 || _a.setVal(isNavigatingWithKeyboard);
	}
	isNavigatingWithKeyboard() {
		var _a;
		return !!((_a = this._keyborg) === null || _a === void 0 ? void 0 : _a.isNavigatingWithKeyboard());
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var _wasFocusedCounter = 0;
var _ariaHidden = "aria-hidden";
function _setInformativeStyle(weakElement, remove, internalId, userId, isActive, wasFocused) {
	{
		const element = weakElement.get();
		if (element) if (remove) element.style.removeProperty("--tabster-modalizer");
		else element.style.setProperty("--tabster-modalizer", internalId + "," + userId + "," + (isActive ? "active" : "inactive") + ",," + (wasFocused ? `focused(${wasFocused})` : "not-focused"));
	}
}
/**
* Manages the dummy inputs for the Modalizer.
*/
var ModalizerDummyManager = class extends DummyInputManager {
	constructor(element, tabster, sys) {
		super(tabster, element, DummyInputManagerPriorities.Modalizer, sys);
		this._setHandlers((dummyInput, isBackward) => {
			var _a, _b;
			const el = element.get();
			const container = el && ((_a = RootAPI.getRoot(tabster, el)) === null || _a === void 0 ? void 0 : _a.getElement());
			const input = dummyInput.input;
			let toFocus;
			if (container && input) {
				const dummyContainer = getDummyInputContainer(input);
				const ctx = RootAPI.getTabsterContext(tabster, dummyContainer || input);
				if (ctx) toFocus = (_b = FocusedElementState.findNextTabbable(tabster, ctx, container, input, void 0, isBackward, true)) === null || _b === void 0 ? void 0 : _b.element;
				if (toFocus) nativeFocus(toFocus);
			}
		});
	}
};
var Modalizer = class extends TabsterPart {
	constructor(tabster, element, onDispose, props, sys, activeElements) {
		super(tabster, element, props);
		this._wasFocused = 0;
		this.userId = props.id;
		this._onDispose = onDispose;
		this._activeElements = activeElements;
		if (!tabster.controlTab) this.dummyManager = new ModalizerDummyManager(this._element, tabster, sys);
		_setInformativeStyle(this._element, false, this.id, this.userId, this._isActive, this._wasFocused);
	}
	makeActive(isActive) {
		if (this._isActive !== isActive) {
			this._isActive = isActive;
			const element = this.getElement();
			if (element) {
				const activeElements = this._activeElements;
				const index = activeElements.map((e) => e.get()).indexOf(element);
				if (isActive) {
					if (index < 0) activeElements.push(new WeakHTMLElement(this._tabster.getWindow, element));
				} else if (index >= 0) activeElements.splice(index, 1);
			}
			_setInformativeStyle(this._element, false, this.id, this.userId, this._isActive, this._wasFocused);
			this._dispatchEvent(isActive);
		}
	}
	focused(noIncrement) {
		if (!noIncrement) this._wasFocused = ++_wasFocusedCounter;
		return this._wasFocused;
	}
	setProps(props) {
		if (props.id) this.userId = props.id;
		this._props = { ...props };
	}
	dispose() {
		var _a;
		this.makeActive(false);
		this._onDispose(this);
		(_a = this.dummyManager) === null || _a === void 0 || _a.dispose();
		delete this.dummyManager;
		this._activeElements = [];
		this._remove();
	}
	isActive() {
		return !!this._isActive;
	}
	contains(element) {
		return dom.nodeContains(this.getElement(), element);
	}
	findNextTabbable(currentElement, referenceElement, isBackward, ignoreAccessibility) {
		var _a, _b;
		if (!this.getElement()) return null;
		const tabster = this._tabster;
		let next = null;
		let outOfDOMOrder = false;
		let uncontrolled;
		const container = currentElement && ((_a = RootAPI.getRoot(tabster, currentElement)) === null || _a === void 0 ? void 0 : _a.getElement());
		if (container) {
			const findProps = {
				container,
				currentElement,
				referenceElement,
				ignoreAccessibility,
				useActiveModalizer: true
			};
			const findPropsOut = {};
			next = tabster.focusable[isBackward ? "findPrev" : "findNext"](findProps, findPropsOut);
			if (!next && this._props.isTrapped && ((_b = tabster.modalizer) === null || _b === void 0 ? void 0 : _b.activeId)) {
				next = tabster.focusable[isBackward ? "findLast" : "findFirst"]({
					container,
					ignoreAccessibility,
					useActiveModalizer: true
				}, findPropsOut);
				if (next === null) next = currentElement;
				outOfDOMOrder = true;
			} else outOfDOMOrder = !!findPropsOut.outOfDOMOrder;
			uncontrolled = findPropsOut.uncontrolled;
		}
		return {
			element: next,
			uncontrolled,
			outOfDOMOrder
		};
	}
	_dispatchEvent(isActive, allElements) {
		const element = this.getElement();
		let defaultPrevented = false;
		if (element) {
			const elements = allElements ? this._activeElements.map((e) => e.get()) : [element];
			for (const el of elements) if (el) {
				const eventDetail = {
					id: this.userId,
					element
				};
				const event = isActive ? new ModalizerActiveEvent(eventDetail) : new ModalizerInactiveEvent(eventDetail);
				el.dispatchEvent(event);
				if (event.defaultPrevented) defaultPrevented = true;
			}
		}
		return defaultPrevented;
	}
	_remove() {
		_setInformativeStyle(this._element, true);
	}
};
var ModalizerAPI = class {
	constructor(tabster, alwaysAccessibleSelector, accessibleCheck) {
		this._onModalizerDispose = (modalizer) => {
			const id = modalizer.id;
			const userId = modalizer.userId;
			const part = this._parts[userId];
			delete this._modalizers[id];
			if (part) {
				delete part[id];
				if (Object.keys(part).length === 0) {
					delete this._parts[userId];
					const activationHistory = this._activationHistory;
					const cleanActivationHistory = [];
					let prevHistoryItem;
					for (let i = activationHistory.length; i--;) {
						const modalizerUserIdFromHistory = activationHistory[i];
						if (modalizerUserIdFromHistory === userId) continue;
						if (modalizerUserIdFromHistory !== prevHistoryItem) {
							prevHistoryItem = modalizerUserIdFromHistory;
							if (modalizerUserIdFromHistory || cleanActivationHistory.length > 0) cleanActivationHistory.unshift(modalizerUserIdFromHistory);
						}
					}
					this._activationHistory = cleanActivationHistory;
					if (this.activeId === userId) {
						const prevActiveId = cleanActivationHistory[0];
						const prevActive = prevActiveId ? Object.values(this._parts[prevActiveId])[0] : void 0;
						this.setActive(prevActive);
					}
				}
			}
		};
		this._onKeyDown = (event) => {
			var _a;
			if (event.key !== Keys.Escape) return;
			const tabster$1 = this._tabster;
			const element = tabster$1.focusedElement.getFocusedElement();
			if (element) {
				const ctx = RootAPI.getTabsterContext(tabster$1, element);
				const modalizer = ctx === null || ctx === void 0 ? void 0 : ctx.modalizer;
				if (ctx && !ctx.groupper && (modalizer === null || modalizer === void 0 ? void 0 : modalizer.isActive()) && !ctx.ignoreKeydown(event)) {
					const activeId = modalizer.userId;
					if (activeId) {
						const part = this._parts[activeId];
						if (part) {
							const focusedSince = Object.keys(part).map((id) => {
								var _a$1;
								const m = part[id];
								const el = m.getElement();
								let groupper;
								if (el) groupper = (_a$1 = getTabsterOnElement(tabster$1, el)) === null || _a$1 === void 0 ? void 0 : _a$1.groupper;
								return m && el && groupper ? {
									el,
									focusedSince: m.focused(true)
								} : { focusedSince: 0 };
							}).filter((f) => f.focusedSince > 0).sort((a, b) => a.focusedSince > b.focusedSince ? -1 : a.focusedSince < b.focusedSince ? 1 : 0);
							if (focusedSince.length) {
								const groupperElement = focusedSince[0].el;
								if (groupperElement) (_a = tabster$1.groupper) === null || _a === void 0 || _a.handleKeyPress(groupperElement, event, true);
							}
						}
					}
				}
			}
		};
		/**
		* Subscribes to the focus state and handles modalizer related focus events
		* @param focusedElement - Element that is focused
		* @param detail - Additional data about the focus event
		*/
		this._onFocus = (focusedElement, detail) => {
			var _a;
			const tabster$1 = this._tabster;
			const ctx = focusedElement && RootAPI.getTabsterContext(tabster$1, focusedElement);
			if (!ctx || !focusedElement) return;
			const augmentedMap = this._augMap;
			for (let e = focusedElement; e; e = dom.getParentElement(e)) if (augmentedMap.has(e)) {
				augmentedMap.delete(e);
				augmentAttribute(tabster$1, e, _ariaHidden);
			}
			let modalizer = ctx.modalizer;
			const tabsterOnFocusedElement = getTabsterOnElement(tabster$1, focusedElement);
			const modalizerOnFocusedElement = tabsterOnFocusedElement === null || tabsterOnFocusedElement === void 0 ? void 0 : tabsterOnFocusedElement.modalizer;
			if (modalizerOnFocusedElement) {
				modalizerOnFocusedElement.focused();
				if (modalizerOnFocusedElement.userId === this.activeId && tabsterOnFocusedElement.groupper) {
					const parentElement = tabster$1.getParent(focusedElement);
					const parentModalizer = parentElement && ((_a = RootAPI.getTabsterContext(tabster$1, parentElement)) === null || _a === void 0 ? void 0 : _a.modalizer);
					if (parentModalizer) modalizer = parentModalizer;
					else {
						this.setActive(void 0);
						return;
					}
				}
			}
			modalizer === null || modalizer === void 0 || modalizer.focused();
			if ((modalizer === null || modalizer === void 0 ? void 0 : modalizer.userId) === this.activeId) {
				this.currentIsOthersAccessible = modalizer === null || modalizer === void 0 ? void 0 : modalizer.getProps().isOthersAccessible;
				return;
			}
			if (detail.isFocusedProgrammatically || this.currentIsOthersAccessible || (modalizer === null || modalizer === void 0 ? void 0 : modalizer.getProps().isAlwaysAccessible)) this.setActive(modalizer);
			else {
				const win = this._win();
				win.clearTimeout(this._restoreModalizerFocusTimer);
				this._restoreModalizerFocusTimer = win.setTimeout(() => this._restoreModalizerFocus(focusedElement), 100);
			}
		};
		this._tabster = tabster;
		this._win = tabster.getWindow;
		this._modalizers = {};
		this._parts = {};
		this._augMap = /* @__PURE__ */ new WeakMap();
		this._aug = [];
		this._alwaysAccessibleSelector = alwaysAccessibleSelector;
		this._accessibleCheck = accessibleCheck;
		this._activationHistory = [];
		this.activeElements = [];
		if (!tabster.controlTab) tabster.root.addDummyInputs();
		this._win().addEventListener("keydown", this._onKeyDown, true);
		tabster.queueInit(() => {
			this._tabster.focusedElement.subscribe(this._onFocus);
		});
	}
	dispose() {
		const win = this._win();
		win.removeEventListener("keydown", this._onKeyDown, true);
		Object.keys(this._modalizers).forEach((modalizerId) => {
			if (this._modalizers[modalizerId]) {
				this._modalizers[modalizerId].dispose();
				delete this._modalizers[modalizerId];
			}
		});
		win.clearTimeout(this._restoreModalizerFocusTimer);
		win.clearTimeout(this._hiddenUpdateTimer);
		this._parts = {};
		delete this.activeId;
		this.activeElements = [];
		this._augMap = /* @__PURE__ */ new WeakMap();
		this._aug = [];
		this._tabster.focusedElement.unsubscribe(this._onFocus);
	}
	createModalizer(element, props, sys) {
		var _a;
		const modalizer = new Modalizer(this._tabster, element, this._onModalizerDispose, props, sys, this.activeElements);
		const id = modalizer.id;
		const userId = props.id;
		this._modalizers[id] = modalizer;
		let part = this._parts[userId];
		if (!part) part = this._parts[userId] = {};
		part[id] = modalizer;
		const focusedElement = (_a = this._tabster.focusedElement.getFocusedElement()) !== null && _a !== void 0 ? _a : null;
		if (element !== focusedElement && dom.nodeContains(element, focusedElement)) if (userId !== this.activeId) this.setActive(modalizer);
		else modalizer.makeActive(true);
		return modalizer;
	}
	isAugmented(element) {
		return this._augMap.has(element);
	}
	hiddenUpdate() {
		if (this._hiddenUpdateTimer) return;
		this._hiddenUpdateTimer = this._win().setTimeout(() => {
			delete this._hiddenUpdateTimer;
			this._hiddenUpdate();
		}, 250);
	}
	setActive(modalizer) {
		const userId = modalizer === null || modalizer === void 0 ? void 0 : modalizer.userId;
		const activeId = this.activeId;
		if (activeId === userId) return;
		this.activeId = userId;
		if (activeId) {
			const part = this._parts[activeId];
			if (part) for (const id of Object.keys(part)) part[id].makeActive(false);
		}
		if (userId) {
			const part = this._parts[userId];
			if (part) for (const id of Object.keys(part)) part[id].makeActive(true);
		}
		this.currentIsOthersAccessible = modalizer === null || modalizer === void 0 ? void 0 : modalizer.getProps().isOthersAccessible;
		this.hiddenUpdate();
		const activationHistory = this._activationHistory;
		if (activationHistory[0] !== userId && (userId !== void 0 || activationHistory.length > 0)) activationHistory.unshift(userId);
	}
	focus(elementFromModalizer, noFocusFirst, noFocusDefault) {
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, elementFromModalizer);
		const modalizer = ctx === null || ctx === void 0 ? void 0 : ctx.modalizer;
		if (modalizer) {
			this.setActive(modalizer);
			const props = modalizer.getProps();
			const modalizerRoot = modalizer.getElement();
			if (modalizerRoot) {
				if (noFocusFirst === void 0) noFocusFirst = props.isNoFocusFirst;
				if (!noFocusFirst && tabster.keyboardNavigation.isNavigatingWithKeyboard() && tabster.focusedElement.focusFirst({ container: modalizerRoot })) return true;
				if (noFocusDefault === void 0) noFocusDefault = props.isNoFocusDefault;
				if (!noFocusDefault && tabster.focusedElement.focusDefault(modalizerRoot)) return true;
				tabster.focusedElement.resetFocus(modalizerRoot);
			}
		} else console.error("Element is not in Modalizer.", elementFromModalizer);
		return false;
	}
	activate(modalizerElementOrContainer) {
		var _a;
		const modalizerToActivate = modalizerElementOrContainer ? (_a = RootAPI.getTabsterContext(this._tabster, modalizerElementOrContainer)) === null || _a === void 0 ? void 0 : _a.modalizer : void 0;
		if (!modalizerElementOrContainer || modalizerToActivate) {
			this.setActive(modalizerToActivate);
			return true;
		}
		return false;
	}
	acceptElement(element, state) {
		var _a;
		const modalizerUserId = state.modalizerUserId;
		const currentModalizer = (_a = state.currentCtx) === null || _a === void 0 ? void 0 : _a.modalizer;
		if (modalizerUserId) for (const e of this.activeElements) {
			const el = e.get();
			if (el && (dom.nodeContains(element, el) || el === element)) return NodeFilter.FILTER_SKIP;
		}
		const ret = modalizerUserId === (currentModalizer === null || currentModalizer === void 0 ? void 0 : currentModalizer.userId) || !modalizerUserId && (currentModalizer === null || currentModalizer === void 0 ? void 0 : currentModalizer.getProps().isAlwaysAccessible) ? void 0 : NodeFilter.FILTER_SKIP;
		if (ret !== void 0) state.skippedFocusable = true;
		return ret;
	}
	_hiddenUpdate() {
		var _a;
		const tabster = this._tabster;
		const body = tabster.getWindow().document.body;
		const activeId = this.activeId;
		const parts = this._parts;
		const visibleElements = [];
		const hiddenElements = [];
		const alwaysAccessibleSelector = this._alwaysAccessibleSelector;
		const alwaysAccessibleElements = alwaysAccessibleSelector ? Array.from(dom.querySelectorAll(body, alwaysAccessibleSelector)) : [];
		const activeModalizerElements = [];
		for (const userId of Object.keys(parts)) {
			const modalizerParts = parts[userId];
			for (const id of Object.keys(modalizerParts)) {
				const modalizer = modalizerParts[id];
				const el = modalizer.getElement();
				const isAlwaysAccessible = modalizer.getProps().isAlwaysAccessible;
				if (el) if (userId === activeId) {
					activeModalizerElements.push(el);
					if (!this.currentIsOthersAccessible) visibleElements.push(el);
				} else if (isAlwaysAccessible) alwaysAccessibleElements.push(el);
				else hiddenElements.push(el);
			}
		}
		const augmentedMap = this._augMap;
		const allVisibleElements = visibleElements.length > 0 ? [...visibleElements, ...alwaysAccessibleElements] : void 0;
		const newAugmented = [];
		const newAugmentedMap = /* @__PURE__ */ new WeakMap();
		const toggle = (element, hide$2) => {
			var _a$1;
			const tagName = element.tagName;
			if (tagName === "SCRIPT" || tagName === "STYLE") return;
			let isAugmented = false;
			if (augmentedMap.has(element)) if (hide$2) isAugmented = true;
			else {
				augmentedMap.delete(element);
				augmentAttribute(tabster, element, _ariaHidden);
			}
			else if (hide$2 && !((_a$1 = this._accessibleCheck) === null || _a$1 === void 0 ? void 0 : _a$1.call(this, element, activeModalizerElements)) && augmentAttribute(tabster, element, _ariaHidden, "true")) {
				augmentedMap.set(element, true);
				isAugmented = true;
			}
			if (isAugmented) {
				newAugmented.push(new WeakHTMLElement(tabster.getWindow, element));
				newAugmentedMap.set(element, true);
			}
		};
		const walk = (element) => {
			var _a$1;
			for (let el = dom.getFirstElementChild(element); el; el = dom.getNextElementSibling(el)) {
				let skip = false;
				let containsModalizer = false;
				let containedByModalizer = false;
				if (allVisibleElements) {
					const elParent = tabster.getParent(el);
					for (const c of allVisibleElements) {
						if (el === c) {
							skip = true;
							break;
						}
						if (dom.nodeContains(el, c)) {
							containsModalizer = true;
							break;
						} else if (dom.nodeContains(c, elParent)) containedByModalizer = true;
					}
					if (containsModalizer || ((_a$1 = el.__tabsterElementFlags) === null || _a$1 === void 0 ? void 0 : _a$1.noDirectAriaHidden)) walk(el);
					else if (!skip && !containedByModalizer) toggle(el, true);
				} else toggle(el, false);
			}
		};
		if (!allVisibleElements) alwaysAccessibleElements.forEach((e) => toggle(e, false));
		hiddenElements.forEach((e) => toggle(e, true));
		if (body) walk(body);
		(_a = this._aug) === null || _a === void 0 || _a.map((e) => e.get()).forEach((e) => {
			if (e && !newAugmentedMap.get(e)) toggle(e, false);
		});
		this._aug = newAugmented;
		this._augMap = newAugmentedMap;
	}
	/**
	* Called when an element is focused outside of an active modalizer.
	* Attempts to pull focus back into the active modalizer
	* @param outsideElement - An element being focused outside of the modalizer
	*/
	_restoreModalizerFocus(outsideElement) {
		var _a;
		const ownerDocument = outsideElement === null || outsideElement === void 0 ? void 0 : outsideElement.ownerDocument;
		if (!outsideElement || !ownerDocument) return;
		const focusedElement = this._tabster.focusedElement.getFocusedElement();
		const focusedElementModalizer = focusedElement && ((_a = RootAPI.getTabsterContext(this._tabster, focusedElement)) === null || _a === void 0 ? void 0 : _a.modalizer);
		if (!focusedElement || focusedElement && (focusedElementModalizer === null || focusedElementModalizer === void 0 ? void 0 : focusedElementModalizer.userId) === this.activeId) return;
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, outsideElement);
		const modalizer = ctx === null || ctx === void 0 ? void 0 : ctx.modalizer;
		const activeId = this.activeId;
		if (!modalizer && !activeId || modalizer && activeId === modalizer.userId) return;
		const container = ctx === null || ctx === void 0 ? void 0 : ctx.root.getElement();
		if (container) {
			let toFocus = tabster.focusable.findFirst({
				container,
				useActiveModalizer: true
			});
			if (toFocus) {
				if (outsideElement.compareDocumentPosition(toFocus) & document.DOCUMENT_POSITION_PRECEDING) {
					toFocus = tabster.focusable.findLast({
						container,
						useActiveModalizer: true
					});
					if (!toFocus) throw new Error("Something went wrong.");
				}
				tabster.focusedElement.focus(toFocus);
				return;
			}
		}
		outsideElement.blur();
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var _inputSelector = /* @__PURE__ */ [
	"input",
	"textarea",
	"*[contenteditable]"
].join(", ");
var MoverDummyManager = class extends DummyInputManager {
	constructor(element, tabster, getMemorized, sys) {
		super(tabster, element, DummyInputManagerPriorities.Mover, sys);
		this._onFocusDummyInput = (dummyInput) => {
			var _a, _b;
			const container = this._element.get();
			const input = dummyInput.input;
			if (container && input) {
				const ctx = RootAPI.getTabsterContext(this._tabster, container);
				let toFocus;
				if (ctx) toFocus = (_a = FocusedElementState.findNextTabbable(this._tabster, ctx, void 0, input, void 0, !dummyInput.isFirst, true)) === null || _a === void 0 ? void 0 : _a.element;
				const memorized = (_b = this._getMemorized()) === null || _b === void 0 ? void 0 : _b.get();
				if (memorized && this._tabster.focusable.isFocusable(memorized)) toFocus = memorized;
				if (toFocus) nativeFocus(toFocus);
			}
		};
		this._tabster = tabster;
		this._getMemorized = getMemorized;
		this._setHandlers(this._onFocusDummyInput);
	}
};
var _moverUpdateAdd = 1;
var _moverUpdateAttr = 2;
var _moverUpdateRemove = 3;
var Mover = class extends TabsterPart {
	constructor(tabster, element, onDispose, props, sys) {
		var _a;
		super(tabster, element, props);
		this._visible = {};
		this._onIntersection = (entries) => {
			for (const entry of entries) {
				const el = entry.target;
				const id = getElementUId(this._win, el);
				let newVisibility;
				let fullyVisible = this._fullyVisible;
				if (entry.intersectionRatio >= .25) {
					newVisibility = entry.intersectionRatio >= .75 ? Visibilities.Visible : Visibilities.PartiallyVisible;
					if (newVisibility === Visibilities.Visible) fullyVisible = id;
				} else newVisibility = Visibilities.Invisible;
				if (this._visible[id] !== newVisibility) {
					if (newVisibility === void 0) {
						delete this._visible[id];
						if (fullyVisible === id) delete this._fullyVisible;
					} else {
						this._visible[id] = newVisibility;
						this._fullyVisible = fullyVisible;
					}
					const state = this.getState(el);
					if (state) el.dispatchEvent(new MoverStateEvent(state));
				}
			}
		};
		this._win = tabster.getWindow;
		this.visibilityTolerance = (_a = props.visibilityTolerance) !== null && _a !== void 0 ? _a : .8;
		if (this._props.trackState || this._props.visibilityAware) {
			this._intersectionObserver = new IntersectionObserver(this._onIntersection, { threshold: [
				0,
				.25,
				.5,
				.75,
				1
			] });
			this._observeState();
		}
		this._onDispose = onDispose;
		const getMemorized = () => props.memorizeCurrent ? this._current : void 0;
		if (!tabster.controlTab) this.dummyManager = new MoverDummyManager(this._element, tabster, getMemorized, sys);
	}
	dispose() {
		var _a;
		this._onDispose(this);
		if (this._intersectionObserver) {
			this._intersectionObserver.disconnect();
			delete this._intersectionObserver;
		}
		delete this._current;
		delete this._fullyVisible;
		delete this._allElements;
		delete this._updateQueue;
		if (this._unobserve) {
			this._unobserve();
			delete this._unobserve;
		}
		const win = this._win();
		if (this._setCurrentTimer) {
			win.clearTimeout(this._setCurrentTimer);
			delete this._setCurrentTimer;
		}
		if (this._updateTimer) {
			win.clearTimeout(this._updateTimer);
			delete this._updateTimer;
		}
		(_a = this.dummyManager) === null || _a === void 0 || _a.dispose();
		delete this.dummyManager;
	}
	setCurrent(element) {
		if (element) this._current = new WeakHTMLElement(this._win, element);
		else this._current = void 0;
		if ((this._props.trackState || this._props.visibilityAware) && !this._setCurrentTimer) this._setCurrentTimer = this._win().setTimeout(() => {
			var _a;
			delete this._setCurrentTimer;
			const changed = [];
			if (this._current !== this._prevCurrent) {
				changed.push(this._current);
				changed.push(this._prevCurrent);
				this._prevCurrent = this._current;
			}
			for (const weak of changed) {
				const el = weak === null || weak === void 0 ? void 0 : weak.get();
				if (el && ((_a = this._allElements) === null || _a === void 0 ? void 0 : _a.get(el)) === this) {
					const props = this._props;
					if (el && (props.visibilityAware !== void 0 || props.trackState)) {
						const state = this.getState(el);
						if (state) el.dispatchEvent(new MoverStateEvent(state));
					}
				}
			}
		});
	}
	getCurrent() {
		var _a;
		return ((_a = this._current) === null || _a === void 0 ? void 0 : _a.get()) || null;
	}
	findNextTabbable(currentElement, referenceElement, isBackward, ignoreAccessibility) {
		const container = this.getElement();
		const currentIsDummy = container && getDummyInputContainer(currentElement) === container;
		if (!container) return null;
		let next = null;
		let outOfDOMOrder = false;
		let uncontrolled;
		if (this._props.tabbable || currentIsDummy || currentElement && !dom.nodeContains(container, currentElement)) {
			const findProps = {
				currentElement,
				referenceElement,
				container,
				ignoreAccessibility,
				useActiveModalizer: true
			};
			const findPropsOut = {};
			next = this._tabster.focusable[isBackward ? "findPrev" : "findNext"](findProps, findPropsOut);
			outOfDOMOrder = !!findPropsOut.outOfDOMOrder;
			uncontrolled = findPropsOut.uncontrolled;
		}
		return {
			element: next,
			uncontrolled,
			outOfDOMOrder
		};
	}
	acceptElement(element, state) {
		var _a, _b;
		if (!FocusedElementState.isTabbing) return ((_a = state.currentCtx) === null || _a === void 0 ? void 0 : _a.excludedFromMover) ? NodeFilter.FILTER_REJECT : void 0;
		const { memorizeCurrent, visibilityAware, hasDefault = true } = this._props;
		const moverElement = this.getElement();
		if (moverElement && (memorizeCurrent || visibilityAware || hasDefault) && (!dom.nodeContains(moverElement, state.from) || getDummyInputContainer(state.from) === moverElement)) {
			let found;
			if (memorizeCurrent) {
				const current = (_b = this._current) === null || _b === void 0 ? void 0 : _b.get();
				if (current && state.acceptCondition(current)) found = current;
			}
			if (!found && hasDefault) found = this._tabster.focusable.findDefault({
				container: moverElement,
				useActiveModalizer: true
			});
			if (!found && visibilityAware) found = this._tabster.focusable.findElement({
				container: moverElement,
				useActiveModalizer: true,
				isBackward: state.isBackward,
				acceptCondition: (el) => {
					var _a$1;
					const id = getElementUId(this._win, el);
					const visibility = this._visible[id];
					return moverElement !== el && !!((_a$1 = this._allElements) === null || _a$1 === void 0 ? void 0 : _a$1.get(el)) && state.acceptCondition(el) && (visibility === Visibilities.Visible || visibility === Visibilities.PartiallyVisible && (visibilityAware === Visibilities.PartiallyVisible || !this._fullyVisible));
				}
			});
			if (found) {
				state.found = true;
				state.foundElement = found;
				state.rejectElementsFrom = moverElement;
				state.skippedFocusable = true;
				return NodeFilter.FILTER_ACCEPT;
			}
		}
	}
	_observeState() {
		const element = this.getElement();
		if (this._unobserve || !element || typeof MutationObserver === "undefined") return;
		const win = this._win();
		const allElements = this._allElements = /* @__PURE__ */ new WeakMap();
		const tabsterFocusable = this._tabster.focusable;
		let updateQueue = this._updateQueue = [];
		const observer = dom.createMutationObserver((mutations) => {
			for (const mutation of mutations) {
				const target = mutation.target;
				const removed = mutation.removedNodes;
				const added = mutation.addedNodes;
				if (mutation.type === "attributes") {
					if (mutation.attributeName === "tabindex") updateQueue.push({
						element: target,
						type: _moverUpdateAttr
					});
				} else {
					for (let i = 0; i < removed.length; i++) updateQueue.push({
						element: removed[i],
						type: _moverUpdateRemove
					});
					for (let i = 0; i < added.length; i++) updateQueue.push({
						element: added[i],
						type: _moverUpdateAdd
					});
				}
			}
			requestUpdate();
		});
		const setElement = (element$1, remove) => {
			var _a, _b;
			const current = allElements.get(element$1);
			if (current && remove) {
				(_a = this._intersectionObserver) === null || _a === void 0 || _a.unobserve(element$1);
				allElements.delete(element$1);
			}
			if (!current && !remove) {
				allElements.set(element$1, this);
				(_b = this._intersectionObserver) === null || _b === void 0 || _b.observe(element$1);
			}
		};
		const updateElement = (element$1) => {
			const isFocusable = tabsterFocusable.isFocusable(element$1);
			if (allElements.get(element$1)) {
				if (!isFocusable) setElement(element$1, true);
			} else if (isFocusable) setElement(element$1);
		};
		const addNewElements = (element$1) => {
			const { mover } = getMoverGroupper(element$1);
			if (mover && mover !== this) if (mover.getElement() === element$1 && tabsterFocusable.isFocusable(element$1)) setElement(element$1);
			else return;
			const walker = createElementTreeWalker(win.document, element$1, (node) => {
				const { mover: mover$1, groupper } = getMoverGroupper(node);
				if (mover$1 && mover$1 !== this) return NodeFilter.FILTER_REJECT;
				const groupperFirstFocusable = groupper === null || groupper === void 0 ? void 0 : groupper.getFirst(true);
				if (groupper && groupper.getElement() !== node && groupperFirstFocusable && groupperFirstFocusable !== node) return NodeFilter.FILTER_REJECT;
				if (tabsterFocusable.isFocusable(node)) setElement(node);
				return NodeFilter.FILTER_SKIP;
			});
			if (walker) {
				walker.currentNode = element$1;
				while (walker.nextNode());
			}
		};
		const removeWalk = (element$1) => {
			if (allElements.get(element$1)) setElement(element$1, true);
			for (let el = dom.getFirstElementChild(element$1); el; el = dom.getNextElementSibling(el)) removeWalk(el);
		};
		const requestUpdate = () => {
			if (!this._updateTimer && updateQueue.length) this._updateTimer = win.setTimeout(() => {
				delete this._updateTimer;
				for (const { element: element$1, type } of updateQueue) switch (type) {
					case _moverUpdateAttr:
						updateElement(element$1);
						break;
					case _moverUpdateAdd:
						addNewElements(element$1);
						break;
					case _moverUpdateRemove:
						removeWalk(element$1);
						break;
				}
				updateQueue = this._updateQueue = [];
			}, 0);
		};
		const getMoverGroupper = (element$1) => {
			const ret = {};
			for (let el = element$1; el; el = dom.getParentElement(el)) {
				const toe = getTabsterOnElement(this._tabster, el);
				if (toe) {
					if (toe.groupper && !ret.groupper) ret.groupper = toe.groupper;
					if (toe.mover) {
						ret.mover = toe.mover;
						break;
					}
				}
			}
			return ret;
		};
		updateQueue.push({
			element,
			type: _moverUpdateAdd
		});
		requestUpdate();
		observer.observe(element, {
			childList: true,
			subtree: true,
			attributes: true,
			attributeFilter: ["tabindex"]
		});
		this._unobserve = () => {
			observer.disconnect();
		};
	}
	getState(element) {
		const id = getElementUId(this._win, element);
		if (id in this._visible) {
			const visibility = this._visible[id] || Visibilities.Invisible;
			return {
				isCurrent: this._current ? this._current.get() === element : void 0,
				visibility
			};
		}
	}
};
/**
* Calculates distance between two rectangles.
*
* @param ax1 first rectangle left
* @param ay1 first rectangle top
* @param ax2 first rectangle right
* @param ay2 first rectangle bottom
* @param bx1 second rectangle left
* @param by1 second rectangle top
* @param bx2 second rectangle right
* @param by2 second rectangle bottom
* @returns number, shortest distance between the rectangles.
*/
function getDistance(ax1, ay1, ax2, ay2, bx1, by1, bx2, by2) {
	const xDistance = ax2 < bx1 ? bx1 - ax2 : bx2 < ax1 ? ax1 - bx2 : 0;
	const yDistance = ay2 < by1 ? by1 - ay2 : by2 < ay1 ? ay1 - by2 : 0;
	return xDistance === 0 ? yDistance : yDistance === 0 ? xDistance : Math.sqrt(xDistance * xDistance + yDistance * yDistance);
}
var MoverAPI = class {
	constructor(tabster, getWindow$1) {
		this._init = () => {
			const win = this._win();
			win.addEventListener("keydown", this._onKeyDown, true);
			win.addEventListener(MoverMoveFocusEventName, this._onMoveFocus);
			win.addEventListener(MoverMemorizedElementEventName, this._onMemorizedElement);
			this._tabster.focusedElement.subscribe(this._onFocus);
		};
		this._onMoverDispose = (mover) => {
			delete this._movers[mover.id];
		};
		this._onFocus = (element) => {
			var _a;
			let currentFocusableElement = element;
			let deepestFocusableElement = element;
			for (let el = dom.getParentElement(element); el; el = dom.getParentElement(el)) {
				const mover = (_a = getTabsterOnElement(this._tabster, el)) === null || _a === void 0 ? void 0 : _a.mover;
				if (mover) {
					mover.setCurrent(deepestFocusableElement);
					currentFocusableElement = void 0;
				}
				if (!currentFocusableElement && this._tabster.focusable.isFocusable(el)) currentFocusableElement = deepestFocusableElement = el;
			}
		};
		this._onKeyDown = async (event) => {
			var _a;
			if (this._ignoredInputTimer) {
				this._win().clearTimeout(this._ignoredInputTimer);
				delete this._ignoredInputTimer;
			}
			(_a = this._ignoredInputResolve) === null || _a === void 0 || _a.call(this, false);
			if (event.ctrlKey || event.altKey || event.shiftKey || event.metaKey) return;
			const key = event.key;
			let moverKey;
			if (key === Keys.ArrowDown) moverKey = MoverKeys.ArrowDown;
			else if (key === Keys.ArrowRight) moverKey = MoverKeys.ArrowRight;
			else if (key === Keys.ArrowUp) moverKey = MoverKeys.ArrowUp;
			else if (key === Keys.ArrowLeft) moverKey = MoverKeys.ArrowLeft;
			else if (key === Keys.PageDown) moverKey = MoverKeys.PageDown;
			else if (key === Keys.PageUp) moverKey = MoverKeys.PageUp;
			else if (key === Keys.Home) moverKey = MoverKeys.Home;
			else if (key === Keys.End) moverKey = MoverKeys.End;
			if (!moverKey) return;
			const focused = this._tabster.focusedElement.getFocusedElement();
			if (!focused || await this._isIgnoredInput(focused, key)) return;
			this._moveFocus(focused, moverKey, event);
		};
		this._onMoveFocus = (e) => {
			var _a;
			const element = e.composedPath()[0];
			const key = (_a = e.detail) === null || _a === void 0 ? void 0 : _a.key;
			if (element && key !== void 0 && !e.defaultPrevented) {
				this._moveFocus(element, key);
				e.stopImmediatePropagation();
			}
		};
		this._onMemorizedElement = (e) => {
			var _a;
			const target = e.composedPath()[0];
			let memorizedElement = (_a = e.detail) === null || _a === void 0 ? void 0 : _a.memorizedElement;
			if (target) {
				const ctx = RootAPI.getTabsterContext(this._tabster, target);
				const mover = ctx === null || ctx === void 0 ? void 0 : ctx.mover;
				if (mover) {
					if (memorizedElement && !dom.nodeContains(mover.getElement(), memorizedElement)) memorizedElement = void 0;
					mover.setCurrent(memorizedElement);
					e.stopImmediatePropagation();
				}
			}
		};
		this._tabster = tabster;
		this._win = getWindow$1;
		this._movers = {};
		tabster.queueInit(this._init);
	}
	dispose() {
		var _a;
		const win = this._win();
		this._tabster.focusedElement.unsubscribe(this._onFocus);
		(_a = this._ignoredInputResolve) === null || _a === void 0 || _a.call(this, false);
		if (this._ignoredInputTimer) {
			win.clearTimeout(this._ignoredInputTimer);
			delete this._ignoredInputTimer;
		}
		win.removeEventListener("keydown", this._onKeyDown, true);
		win.removeEventListener(MoverMoveFocusEventName, this._onMoveFocus);
		win.removeEventListener(MoverMemorizedElementEventName, this._onMemorizedElement);
		Object.keys(this._movers).forEach((moverId) => {
			if (this._movers[moverId]) {
				this._movers[moverId].dispose();
				delete this._movers[moverId];
			}
		});
	}
	createMover(element, props, sys) {
		const newMover = new Mover(this._tabster, element, this._onMoverDispose, props, sys);
		this._movers[newMover.id] = newMover;
		return newMover;
	}
	moveFocus(fromElement, key) {
		return this._moveFocus(fromElement, key);
	}
	_moveFocus(fromElement, key, relatedEvent) {
		var _a, _b;
		const tabster = this._tabster;
		const ctx = RootAPI.getTabsterContext(tabster, fromElement, { checkRtl: true });
		if (!ctx || !ctx.mover || ctx.excludedFromMover || relatedEvent && ctx.ignoreKeydown(relatedEvent)) return null;
		const mover = ctx.mover;
		const container = mover.getElement();
		if (ctx.groupperBeforeMover) {
			const groupper = ctx.groupper;
			if (groupper && !groupper.isActive(true)) {
				for (let el = dom.getParentElement(groupper.getElement()); el && el !== container; el = dom.getParentElement(el)) if ((_b = (_a = getTabsterOnElement(tabster, el)) === null || _a === void 0 ? void 0 : _a.groupper) === null || _b === void 0 ? void 0 : _b.isActive(true)) return null;
			} else return null;
		}
		if (!container) return null;
		const focusable = tabster.focusable;
		const moverProps = mover.getProps();
		const direction = moverProps.direction || MoverDirections.Both;
		const isBoth = direction === MoverDirections.Both;
		const isVertical = isBoth || direction === MoverDirections.Vertical;
		const isHorizontal = isBoth || direction === MoverDirections.Horizontal;
		const isGridLinear = direction === MoverDirections.GridLinear;
		const isGrid = isGridLinear || direction === MoverDirections.Grid;
		const isCyclic = moverProps.cyclic;
		let next;
		let scrollIntoViewArg;
		let focusedElementRect;
		let focusedElementX1 = 0;
		let focusedElementX2 = 0;
		if (isGrid) {
			focusedElementRect = fromElement.getBoundingClientRect();
			focusedElementX1 = Math.ceil(focusedElementRect.left);
			focusedElementX2 = Math.floor(focusedElementRect.right);
		}
		if (ctx.rtl) {
			if (key === MoverKeys.ArrowRight) key = MoverKeys.ArrowLeft;
			else if (key === MoverKeys.ArrowLeft) key = MoverKeys.ArrowRight;
		}
		if (key === MoverKeys.ArrowDown && isVertical || key === MoverKeys.ArrowRight && (isHorizontal || isGrid)) {
			next = focusable.findNext({
				currentElement: fromElement,
				container,
				useActiveModalizer: true
			});
			if (next && isGrid) {
				const nextElementX1 = Math.ceil(next.getBoundingClientRect().left);
				if (!isGridLinear && focusedElementX2 > nextElementX1) next = void 0;
			} else if (!next && isCyclic) next = focusable.findFirst({
				container,
				useActiveModalizer: true
			});
		} else if (key === MoverKeys.ArrowUp && isVertical || key === MoverKeys.ArrowLeft && (isHorizontal || isGrid)) {
			next = focusable.findPrev({
				currentElement: fromElement,
				container,
				useActiveModalizer: true
			});
			if (next && isGrid) {
				const nextElementX2 = Math.floor(next.getBoundingClientRect().right);
				if (!isGridLinear && nextElementX2 > focusedElementX1) next = void 0;
			} else if (!next && isCyclic) next = focusable.findLast({
				container,
				useActiveModalizer: true
			});
		} else if (key === MoverKeys.Home) if (isGrid) focusable.findElement({
			container,
			currentElement: fromElement,
			useActiveModalizer: true,
			isBackward: true,
			acceptCondition: (el) => {
				var _a$1;
				if (!focusable.isFocusable(el)) return false;
				const nextElementX1 = Math.ceil((_a$1 = el.getBoundingClientRect().left) !== null && _a$1 !== void 0 ? _a$1 : 0);
				if (el !== fromElement && focusedElementX1 <= nextElementX1) return true;
				next = el;
				return false;
			}
		});
		else next = focusable.findFirst({
			container,
			useActiveModalizer: true
		});
		else if (key === MoverKeys.End) if (isGrid) focusable.findElement({
			container,
			currentElement: fromElement,
			useActiveModalizer: true,
			acceptCondition: (el) => {
				var _a$1;
				if (!focusable.isFocusable(el)) return false;
				const nextElementX1 = Math.ceil((_a$1 = el.getBoundingClientRect().left) !== null && _a$1 !== void 0 ? _a$1 : 0);
				if (el !== fromElement && focusedElementX1 >= nextElementX1) return true;
				next = el;
				return false;
			}
		});
		else next = focusable.findLast({
			container,
			useActiveModalizer: true
		});
		else if (key === MoverKeys.PageUp) {
			focusable.findElement({
				currentElement: fromElement,
				container,
				useActiveModalizer: true,
				isBackward: true,
				acceptCondition: (el) => {
					if (!focusable.isFocusable(el)) return false;
					if (isElementVerticallyVisibleInContainer(this._win, el, mover.visibilityTolerance)) {
						next = el;
						return false;
					}
					return true;
				}
			});
			if (isGrid && next) {
				const firstColumnX1 = Math.ceil(next.getBoundingClientRect().left);
				focusable.findElement({
					currentElement: next,
					container,
					useActiveModalizer: true,
					acceptCondition: (el) => {
						if (!focusable.isFocusable(el)) return false;
						const nextElementX1 = Math.ceil(el.getBoundingClientRect().left);
						if (focusedElementX1 < nextElementX1 || firstColumnX1 >= nextElementX1) return true;
						next = el;
						return false;
					}
				});
			}
			scrollIntoViewArg = false;
		} else if (key === MoverKeys.PageDown) {
			focusable.findElement({
				currentElement: fromElement,
				container,
				useActiveModalizer: true,
				acceptCondition: (el) => {
					if (!focusable.isFocusable(el)) return false;
					if (isElementVerticallyVisibleInContainer(this._win, el, mover.visibilityTolerance)) {
						next = el;
						return false;
					}
					return true;
				}
			});
			if (isGrid && next) {
				const lastColumnX1 = Math.ceil(next.getBoundingClientRect().left);
				focusable.findElement({
					currentElement: next,
					container,
					useActiveModalizer: true,
					isBackward: true,
					acceptCondition: (el) => {
						if (!focusable.isFocusable(el)) return false;
						const nextElementX1 = Math.ceil(el.getBoundingClientRect().left);
						if (focusedElementX1 > nextElementX1 || lastColumnX1 <= nextElementX1) return true;
						next = el;
						return false;
					}
				});
			}
			scrollIntoViewArg = true;
		} else if (isGrid) {
			const isBackward = key === MoverKeys.ArrowUp;
			const ax1 = focusedElementX1;
			const ay1 = Math.ceil(focusedElementRect.top);
			const ax2 = focusedElementX2;
			const ay2 = Math.floor(focusedElementRect.bottom);
			let targetElement;
			let lastDistance;
			let lastIntersection = 0;
			focusable.findAll({
				container,
				currentElement: fromElement,
				isBackward,
				onElement: (el) => {
					const rect = el.getBoundingClientRect();
					const bx1 = Math.ceil(rect.left);
					const by1 = Math.ceil(rect.top);
					const bx2 = Math.floor(rect.right);
					const by2 = Math.floor(rect.bottom);
					if (isBackward && ay1 < by2 || !isBackward && ay2 > by1) return true;
					const xIntersectionWidth = Math.ceil(Math.min(ax2, bx2)) - Math.floor(Math.max(ax1, bx1));
					const minWidth = Math.ceil(Math.min(ax2 - ax1, bx2 - bx1));
					if (xIntersectionWidth > 0 && minWidth >= xIntersectionWidth) {
						const intersection = xIntersectionWidth / minWidth;
						if (intersection > lastIntersection) {
							targetElement = el;
							lastIntersection = intersection;
						}
					} else if (lastIntersection === 0) {
						const distance = getDistance(ax1, ay1, ax2, ay2, bx1, by1, bx2, by2);
						if (lastDistance === void 0 || distance < lastDistance) {
							lastDistance = distance;
							targetElement = el;
						}
					} else if (lastIntersection > 0) return false;
					return true;
				}
			});
			next = targetElement;
		}
		if (next && (!relatedEvent || relatedEvent && container.dispatchEvent(new TabsterMoveFocusEvent({
			by: "mover",
			owner: container,
			next,
			relatedEvent
		})))) {
			if (scrollIntoViewArg !== void 0) scrollIntoView(this._win, next, scrollIntoViewArg);
			if (relatedEvent) {
				relatedEvent.preventDefault();
				relatedEvent.stopImmediatePropagation();
			}
			nativeFocus(next);
			return next;
		}
		return null;
	}
	async _isIgnoredInput(element, key) {
		if (element.getAttribute("aria-expanded") === "true" && element.hasAttribute("aria-activedescendant")) return true;
		if (matchesSelector(element, _inputSelector)) {
			let selectionStart = 0;
			let selectionEnd = 0;
			let textLength = 0;
			let asyncRet;
			if (element.tagName === "INPUT" || element.tagName === "TEXTAREA") {
				const type = element.type;
				textLength = (element.value || "").length;
				if (type === "email" || type === "number") {
					if (textLength) {
						const selection = dom.getSelection(element);
						if (selection) {
							const initialLength = selection.toString().length;
							const isBackward = key === Keys.ArrowLeft || key === Keys.ArrowUp;
							selection.modify("extend", isBackward ? "backward" : "forward", "character");
							if (initialLength !== selection.toString().length) {
								selection.modify("extend", isBackward ? "forward" : "backward", "character");
								return true;
							} else textLength = 0;
						}
					}
				} else {
					const selStart = element.selectionStart;
					if (selStart === null) return type === "hidden";
					selectionStart = selStart || 0;
					selectionEnd = element.selectionEnd || 0;
				}
			} else if (element.contentEditable === "true") asyncRet = new (getPromise(this._win))((resolve) => {
				this._ignoredInputResolve = (value) => {
					delete this._ignoredInputResolve;
					resolve(value);
				};
				const win = this._win();
				if (this._ignoredInputTimer) win.clearTimeout(this._ignoredInputTimer);
				const { anchorNode: prevAnchorNode, focusNode: prevFocusNode, anchorOffset: prevAnchorOffset, focusOffset: prevFocusOffset } = dom.getSelection(element) || {};
				this._ignoredInputTimer = win.setTimeout(() => {
					var _a, _b, _c;
					delete this._ignoredInputTimer;
					const { anchorNode, focusNode, anchorOffset, focusOffset } = dom.getSelection(element) || {};
					if (anchorNode !== prevAnchorNode || focusNode !== prevFocusNode || anchorOffset !== prevAnchorOffset || focusOffset !== prevFocusOffset) {
						(_a = this._ignoredInputResolve) === null || _a === void 0 || _a.call(this, false);
						return;
					}
					selectionStart = anchorOffset || 0;
					selectionEnd = focusOffset || 0;
					textLength = ((_b = element.textContent) === null || _b === void 0 ? void 0 : _b.length) || 0;
					if (anchorNode && focusNode) {
						if (dom.nodeContains(element, anchorNode) && dom.nodeContains(element, focusNode)) {
							if (anchorNode !== element) {
								let anchorFound = false;
								const addOffsets = (node) => {
									if (node === anchorNode) anchorFound = true;
									else if (node === focusNode) return true;
									const nodeText = node.textContent;
									if (nodeText && !dom.getFirstChild(node)) {
										const len = nodeText.length;
										if (anchorFound) {
											if (focusNode !== anchorNode) selectionEnd += len;
										} else {
											selectionStart += len;
											selectionEnd += len;
										}
									}
									let stop = false;
									for (let e = dom.getFirstChild(node); e && !stop; e = e.nextSibling) stop = addOffsets(e);
									return stop;
								};
								addOffsets(element);
							}
						}
					}
					(_c = this._ignoredInputResolve) === null || _c === void 0 || _c.call(this, true);
				}, 0);
			});
			if (asyncRet && !await asyncRet) return true;
			if (selectionStart !== selectionEnd) return true;
			if (selectionStart > 0 && (key === Keys.ArrowLeft || key === Keys.ArrowUp || key === Keys.Home)) return true;
			if (selectionStart < textLength && (key === Keys.ArrowRight || key === Keys.ArrowDown || key === Keys.End)) return true;
		}
		return false;
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
function observeMutations(doc, tabster, updateTabsterByAttribute$1, syncState) {
	if (typeof MutationObserver === "undefined") return () => {};
	const getWindow$1 = tabster.getWindow;
	let elementByUId;
	const onMutation = (mutations) => {
		var _a, _b, _c, _d, _e;
		const removedNodes = /* @__PURE__ */ new Set();
		for (const mutation of mutations) {
			const target = mutation.target;
			const removed = mutation.removedNodes;
			const added = mutation.addedNodes;
			if (mutation.type === "attributes") {
				if (mutation.attributeName === TABSTER_ATTRIBUTE_NAME) {
					if (!removedNodes.has(target)) updateTabsterByAttribute$1(tabster, target);
				}
			} else {
				for (let i = 0; i < removed.length; i++) {
					const removedNode = removed[i];
					removedNodes.add(removedNode);
					updateTabsterElements(removedNode, true);
					(_b = (_a = tabster._dummyObserver).domChanged) === null || _b === void 0 || _b.call(_a, target);
				}
				for (let i = 0; i < added.length; i++) {
					updateTabsterElements(added[i]);
					(_d = (_c = tabster._dummyObserver).domChanged) === null || _d === void 0 || _d.call(_c, target);
				}
			}
		}
		removedNodes.clear();
		(_e = tabster.modalizer) === null || _e === void 0 || _e.hiddenUpdate();
	};
	function updateTabsterElements(node, removed) {
		if (!elementByUId) elementByUId = getInstanceContext(getWindow$1).elementByUId;
		processNode(node, removed);
		const walker = createElementTreeWalker(doc, node, (element) => {
			return processNode(element, removed);
		});
		if (walker) while (walker.nextNode());
	}
	function processNode(element, removed) {
		var _a;
		if (!element.getAttribute) return NodeFilter.FILTER_SKIP;
		const uid = element.__tabsterElementUID;
		if (uid && elementByUId) if (removed) delete elementByUId[uid];
		else (_a = elementByUId[uid]) !== null && _a !== void 0 || (elementByUId[uid] = new WeakHTMLElement(getWindow$1, element));
		if (getTabsterOnElement(tabster, element) || element.hasAttribute(TABSTER_ATTRIBUTE_NAME)) updateTabsterByAttribute$1(tabster, element, removed);
		return NodeFilter.FILTER_SKIP;
	}
	const observer = dom.createMutationObserver(onMutation);
	if (syncState) updateTabsterElements(getWindow$1().document.body);
	observer.observe(doc, {
		childList: true,
		subtree: true,
		attributes: true,
		attributeFilter: [TABSTER_ATTRIBUTE_NAME]
	});
	return () => {
		observer.disconnect();
	};
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var _conditionCheckTimeout = 100;
var ObservedElementAPI = class extends Subscribable {
	constructor(tabster) {
		super();
		this._waiting = {};
		this._lastRequestFocusId = 0;
		this._observedById = {};
		this._observedByName = {};
		this._currentRequestTimestamp = 0;
		this._onFocus = (e) => {
			if (e) {
				const current = this._currentRequest;
				if (current) {
					if (Date.now() - this._currentRequestTimestamp >= 300) {
						delete this._currentRequest;
						current.cancel();
					}
				}
			}
		};
		this.onObservedElementUpdate = (element) => {
			var _a;
			const observed = (_a = getTabsterOnElement(this._tabster, element)) === null || _a === void 0 ? void 0 : _a.observed;
			const uid = getElementUId(this._win, element);
			let info = this._observedById[uid];
			if (observed && documentContains(element.ownerDocument, element)) {
				if (!info) info = this._observedById[uid] = { element: new WeakHTMLElement(this._win, element) };
				observed.names.sort();
				const observedNames = observed.names;
				const prevNames = info.prevNames;
				if (this._isObservedNamesUpdated(observedNames, prevNames)) {
					if (prevNames) prevNames.forEach((prevName) => {
						const obn = this._observedByName[prevName];
						if (obn && obn[uid]) if (Object.keys(obn).length > 1) delete obn[uid];
						else delete this._observedByName[prevName];
					});
					info.prevNames = observedNames;
				}
				observedNames.forEach((observedName) => {
					let obn = this._observedByName[observedName];
					if (!obn) obn = this._observedByName[observedName] = {};
					obn[uid] = info;
					this._waitConditional(observedName);
				});
			} else if (info) {
				const prevNames = info.prevNames;
				if (prevNames) prevNames.forEach((prevName) => {
					const obn = this._observedByName[prevName];
					if (obn && obn[uid]) if (Object.keys(obn).length > 1) delete obn[uid];
					else delete this._observedByName[prevName];
				});
				delete this._observedById[uid];
			}
		};
		this._tabster = tabster;
		this._win = tabster.getWindow;
		tabster.queueInit(() => {
			this._tabster.focusedElement.subscribe(this._onFocus);
		});
	}
	dispose() {
		this._tabster.focusedElement.unsubscribe(this._onFocus);
		for (const key of Object.keys(this._waiting)) this._rejectWaiting(key);
		this._observedById = {};
		this._observedByName = {};
	}
	_rejectWaiting(key, shouldResolve) {
		const w = this._waiting[key];
		if (w) {
			const win = this._win();
			if (w.timer) win.clearTimeout(w.timer);
			if (w.conditionTimer) win.clearTimeout(w.conditionTimer);
			if (!shouldResolve && w.reject) w.reject();
			else if (shouldResolve && w.resolve) w.resolve(null);
			delete this._waiting[key];
		}
	}
	_isObservedNamesUpdated(cur, prev) {
		if (!prev || cur.length !== prev.length) return true;
		for (let i = 0; i < cur.length; ++i) if (cur[i] !== prev[i]) return true;
		return false;
	}
	/**
	* Returns existing element by observed name
	*
	* @param observedName An observed name
	* @param accessibility Optionally, return only if the element is accessible or focusable
	* @returns HTMLElement | null
	*/
	getElement(observedName, accessibility) {
		const o = this._observedByName[observedName];
		if (o) for (const uid of Object.keys(o)) {
			let el = o[uid].element.get() || null;
			if (el) {
				if (accessibility === ObservedElementAccessibilities.Accessible && !this._tabster.focusable.isAccessible(el) || accessibility === ObservedElementAccessibilities.Focusable && !this._tabster.focusable.isFocusable(el, true)) el = null;
			} else {
				delete o[uid];
				delete this._observedById[uid];
			}
			return el;
		}
		return null;
	}
	/**
	* Waits for the element to appear in the DOM and returns it.
	*
	* @param observedName An observed name
	* @param timeout Wait no longer than this timeout
	* @param accessibility Optionally, wait for the element to also become accessible or focusable before returning it
	* @returns Promise<HTMLElement | null>
	*/
	waitElement(observedName, timeout, accessibility) {
		const el = this.getElement(observedName, accessibility);
		if (el) return {
			result: getPromise(this._win).resolve(el),
			cancel: () => {},
			status: ObservedElementRequestStatuses.Succeeded
		};
		let prefix;
		if (accessibility === ObservedElementAccessibilities.Accessible) prefix = "a";
		else if (accessibility === ObservedElementAccessibilities.Focusable) prefix = "f";
		else prefix = "_";
		const key = prefix + observedName;
		let w = this._waiting[key];
		if (w && w.request) return w.request;
		w = this._waiting[key] = { timer: this._win().setTimeout(() => {
			if (w.conditionTimer) this._win().clearTimeout(w.conditionTimer);
			delete this._waiting[key];
			if (w.request) w.request.status = ObservedElementRequestStatuses.TimedOut;
			if (w.resolve) w.resolve(null);
		}, timeout) };
		const request = {
			result: new (getPromise(this._win))((resolve, reject) => {
				w.resolve = resolve;
				w.reject = reject;
			}).catch(() => {
				return null;
			}),
			cancel: () => {
				if (request.status === ObservedElementRequestStatuses.Waiting) request.status = ObservedElementRequestStatuses.Canceled;
				this._rejectWaiting(key, true);
			},
			status: ObservedElementRequestStatuses.Waiting
		};
		w.request = request;
		if (accessibility && this.getElement(observedName)) this._waitConditional(observedName);
		return request;
	}
	requestFocus(observedName, timeout, options) {
		if (options === void 0) options = {};
		const requestId = ++this._lastRequestFocusId;
		const currentRequestFocus = this._currentRequest;
		if (currentRequestFocus) currentRequestFocus.cancel();
		const request = this.waitElement(observedName, timeout, ObservedElementAccessibilities.Focusable);
		this._currentRequest = request;
		this._currentRequestTimestamp = Date.now();
		const ret = {
			result: request.result.then((element) => this._lastRequestFocusId === requestId && element ? this._tabster.focusedElement.focus(element, true, void 0, options.preventScroll) : false),
			cancel: () => {
				request.cancel();
			},
			status: request.status
		};
		request.result.finally(() => {
			if (this._currentRequest === request) delete this._currentRequest;
			ret.status = request.status;
		});
		return ret;
	}
	_waitConditional(observedName) {
		const waitingElementKey = "_" + observedName;
		const waitingAccessibleElementKey = "a" + observedName;
		const waitingFocusableElementKey = "f" + observedName;
		const waitingElement = this._waiting[waitingElementKey];
		const waitingAccessibleElement = this._waiting[waitingAccessibleElementKey];
		const waitingFocusableElement = this._waiting[waitingFocusableElementKey];
		const win = this._win();
		const resolve = (element, key, waiting, accessibility) => {
			var _a;
			const observed = (_a = getTabsterOnElement(this._tabster, element)) === null || _a === void 0 ? void 0 : _a.observed;
			if (!observed || !observed.names.includes(observedName)) return;
			if (waiting.timer) win.clearTimeout(waiting.timer);
			delete this._waiting[key];
			if (waiting.request) waiting.request.status = ObservedElementRequestStatuses.Succeeded;
			if (waiting.resolve) waiting.resolve(element);
			this.trigger(element, {
				names: [observedName],
				details: observed.details,
				accessibility
			});
		};
		if (waitingElement) {
			const element = this.getElement(observedName);
			if (element && documentContains(element.ownerDocument, element)) resolve(element, waitingElementKey, waitingElement, ObservedElementAccessibilities.Any);
		}
		if (waitingAccessibleElement && !waitingAccessibleElement.conditionTimer) {
			const resolveAccessible = () => {
				const element = this.getElement(observedName);
				if (element && documentContains(element.ownerDocument, element) && this._tabster.focusable.isAccessible(element)) resolve(element, waitingAccessibleElementKey, waitingAccessibleElement, ObservedElementAccessibilities.Accessible);
				else waitingAccessibleElement.conditionTimer = win.setTimeout(resolveAccessible, _conditionCheckTimeout);
			};
			resolveAccessible();
		}
		if (waitingFocusableElement && !waitingFocusableElement.conditionTimer) {
			const resolveFocusable = () => {
				const element = this.getElement(observedName);
				if (element && documentContains(element.ownerDocument, element) && this._tabster.focusable.isFocusable(element, true)) resolve(element, waitingFocusableElementKey, waitingFocusableElement, ObservedElementAccessibilities.Focusable);
				else waitingFocusableElement.conditionTimer = win.setTimeout(resolveFocusable, _conditionCheckTimeout);
			};
			resolveFocusable();
		}
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
/**
* Allows default or user focus behaviour on the DOM subtree
* i.e. Tabster will not control focus events within an uncontrolled area
*/
var UncontrolledAPI = class {
	constructor(isUncontrolledCompletely) {
		this._isUncontrolledCompletely = isUncontrolledCompletely;
	}
	isUncontrolledCompletely(element, completely) {
		var _a;
		const isUncontrolledCompletely = (_a = this._isUncontrolledCompletely) === null || _a === void 0 ? void 0 : _a.call(this, element, completely);
		return isUncontrolledCompletely === void 0 ? completely : isUncontrolledCompletely;
	}
};
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var Restorer = class extends TabsterPart {
	constructor(tabster, element, props) {
		var _a;
		super(tabster, element, props);
		this._hasFocus = false;
		this._onFocusOut = (e) => {
			var _a$1;
			const element$1 = (_a$1 = this._element) === null || _a$1 === void 0 ? void 0 : _a$1.get();
			if (element$1 && e.relatedTarget === null) element$1.dispatchEvent(new RestorerRestoreFocusEvent());
			if (element$1 && !dom.nodeContains(element$1, e.relatedTarget)) this._hasFocus = false;
		};
		this._onFocusIn = () => {
			this._hasFocus = true;
		};
		if (this._props.type === RestorerTypes.Source) {
			const element$1 = (_a = this._element) === null || _a === void 0 ? void 0 : _a.get();
			element$1 === null || element$1 === void 0 || element$1.addEventListener("focusout", this._onFocusOut);
			element$1 === null || element$1 === void 0 || element$1.addEventListener("focusin", this._onFocusIn);
			this._hasFocus = dom.nodeContains(element$1, element$1 && dom.getActiveElement(element$1.ownerDocument));
		}
	}
	dispose() {
		var _a;
		if (this._props.type === RestorerTypes.Source) {
			const element = (_a = this._element) === null || _a === void 0 ? void 0 : _a.get();
			element === null || element === void 0 || element.removeEventListener("focusout", this._onFocusOut);
			element === null || element === void 0 || element.removeEventListener("focusin", this._onFocusIn);
			if (this._hasFocus) this._tabster.getWindow().document.body.dispatchEvent(new RestorerRestoreFocusEvent());
		}
	}
};
var History = class History {
	constructor(getWindow$1) {
		this._stack = [];
		this._getWindow = getWindow$1;
	}
	/**
	* Push a weak element to the top of the history stack.
	* If the stack is full, the bottom weak element is removed.
	* If the element is already at the top of the stack, it is not duplicated.
	*/
	push(element) {
		var _a;
		if (((_a = this._stack[this._stack.length - 1]) === null || _a === void 0 ? void 0 : _a.get()) === element) return;
		if (this._stack.length > History.DEPTH) this._stack.shift();
		this._stack.push(new WeakHTMLElement(this._getWindow, element));
	}
	/**
	* Pop the first element from the history that satisfies the callback.
	* The history is searched from the top to the bottom (from the most recent to the least recent).
	*
	* If a weak reference to the element is broken,
	* or the element is no longer in the DOM,
	* the element is removed from the top of the stack while popping.
	*
	* If no matching element is found, undefined is returned.
	* If the stack is empty, undefined is returned.
	*/
	pop(filter) {
		if (filter === void 0) filter = () => true;
		var _a;
		const doc = this._getWindow().document;
		for (let index = this._stack.length - 1; index >= 0; index--) {
			const maybeElement = (_a = this._stack.pop()) === null || _a === void 0 ? void 0 : _a.get();
			if (maybeElement && dom.nodeContains(doc.body, dom.getParentElement(maybeElement)) && filter(maybeElement)) return maybeElement;
		}
	}
};
History.DEPTH = 10;
var RestorerAPI = class {
	constructor(tabster) {
		this._onRestoreFocus = (e) => {
			var _a, _b;
			this._focusedElementState.cancelAsyncFocus(AsyncFocusSources.Restorer);
			const source = e.composedPath()[0];
			if (source) {
				const sourceId = (_b = (_a = getTabsterOnElement(this._tabster, source)) === null || _a === void 0 ? void 0 : _a.restorer) === null || _b === void 0 ? void 0 : _b.getProps().id;
				this._focusedElementState.requestAsyncFocus(AsyncFocusSources.Restorer, () => this._restoreFocus(source, sourceId), 0);
			}
		};
		this._onFocusIn = (element) => {
			var _a;
			if (!element) return;
			const tabsterAttribute = getTabsterOnElement(this._tabster, element);
			if (((_a = tabsterAttribute === null || tabsterAttribute === void 0 ? void 0 : tabsterAttribute.restorer) === null || _a === void 0 ? void 0 : _a.getProps().type) !== RestorerTypes.Target) return;
			this._history.push(element);
		};
		this._restoreFocus = (source, sourceId) => {
			var _a;
			const doc = this._getWindow().document;
			if (dom.getActiveElement(doc) !== doc.body) return;
			if (!this._keyboardNavState.isNavigatingWithKeyboard() && dom.nodeContains(doc.body, source)) return;
			const getId = (element) => {
				var _a$1, _b;
				const restorerProps = (_b = (_a$1 = getTabsterOnElement(this._tabster, element)) === null || _a$1 === void 0 ? void 0 : _a$1.restorer) === null || _b === void 0 ? void 0 : _b.getProps();
				return restorerProps ? restorerProps.id : null;
			};
			(_a = this._history.pop((target) => sourceId === getId(target))) === null || _a === void 0 || _a.focus();
		};
		this._tabster = tabster;
		this._getWindow = tabster.getWindow;
		this._getWindow().addEventListener(RestorerRestoreFocusEventName, this._onRestoreFocus);
		this._history = new History(this._getWindow);
		this._keyboardNavState = tabster.keyboardNavigation;
		this._focusedElementState = tabster.focusedElement;
		this._focusedElementState.subscribe(this._onFocusIn);
	}
	dispose() {
		const win = this._getWindow();
		this._focusedElementState.unsubscribe(this._onFocusIn);
		this._focusedElementState.cancelAsyncFocus(AsyncFocusSources.Restorer);
		win.removeEventListener(RestorerRestoreFocusEventName, this._onRestoreFocus);
	}
	createRestorer(element, props) {
		const restorer = new Restorer(this._tabster, element, props);
		if (props.type === RestorerTypes.Target && dom.getActiveElement(element.ownerDocument) === element) this._history.push(element);
		return restorer;
	}
};
function nodeContains(node, otherNode) {
	var _a, _b;
	if (!node || !otherNode) return false;
	let currentNode = otherNode;
	while (currentNode) {
		if (currentNode === node) return true;
		if (typeof currentNode.assignedElements !== "function" && ((_a = currentNode.assignedSlot) === null || _a === void 0 ? void 0 : _a.parentNode)) currentNode = (_b = currentNode.assignedSlot) === null || _b === void 0 ? void 0 : _b.parentNode;
		else if (currentNode.nodeType === document.DOCUMENT_FRAGMENT_NODE) currentNode = currentNode.host;
		else currentNode = currentNode.parentNode;
	}
	return false;
}
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var ShadowMutationObserver = class ShadowMutationObserver {
	static _overrideAttachShadow(win) {
		const origAttachShadow = win.Element.prototype.attachShadow;
		if (origAttachShadow.__origAttachShadow) return;
		Element.prototype.attachShadow = function(options) {
			const shadowRoot = origAttachShadow.call(this, options);
			for (const shadowObserver of ShadowMutationObserver._shadowObservers) shadowObserver._addSubObserver(shadowRoot);
			return shadowRoot;
		};
		Element.prototype.attachShadow.__origAttachShadow = origAttachShadow;
	}
	constructor(callback) {
		this._isObserving = false;
		this._callbackWrapper = (mutations, observer) => {
			for (const mutation of mutations) if (mutation.type === "childList") {
				const removed = mutation.removedNodes;
				const added = mutation.addedNodes;
				for (let i = 0; i < removed.length; i++) this._walkShadows(removed[i], true);
				for (let i = 0; i < added.length; i++) this._walkShadows(added[i]);
			}
			this._callback(mutations, observer);
		};
		this._callback = callback;
		this._observer = new MutationObserver(this._callbackWrapper);
		this._subObservers = /* @__PURE__ */ new Map();
	}
	_addSubObserver(shadowRoot) {
		if (!this._options || !this._callback || this._subObservers.has(shadowRoot)) return;
		if (this._options.subtree && nodeContains(this._root, shadowRoot)) {
			const subObserver = new MutationObserver(this._callbackWrapper);
			this._subObservers.set(shadowRoot, subObserver);
			if (this._isObserving) subObserver.observe(shadowRoot, this._options);
			this._walkShadows(shadowRoot);
		}
	}
	disconnect() {
		this._isObserving = false;
		delete this._options;
		ShadowMutationObserver._shadowObservers.delete(this);
		for (const subObserver of this._subObservers.values()) subObserver.disconnect();
		this._subObservers.clear();
		this._observer.disconnect();
	}
	observe(target, options) {
		const doc = target.nodeType === Node.DOCUMENT_NODE ? target : target.ownerDocument;
		const win = doc === null || doc === void 0 ? void 0 : doc.defaultView;
		if (!doc || !win) return;
		ShadowMutationObserver._overrideAttachShadow(win);
		ShadowMutationObserver._shadowObservers.add(this);
		this._root = target;
		this._options = options;
		this._isObserving = true;
		this._observer.observe(target, options);
		this._walkShadows(target);
	}
	_walkShadows(target, remove) {
		const doc = target.nodeType === Node.DOCUMENT_NODE ? target : target.ownerDocument;
		if (!doc) return;
		if (target === doc) target = doc.body;
		else {
			const shadowRoot = target.shadowRoot;
			if (shadowRoot) {
				this._addSubObserver(shadowRoot);
				return;
			}
		}
		doc.createTreeWalker(target, NodeFilter.SHOW_ELEMENT, { acceptNode: (node) => {
			if (node.nodeType === Node.ELEMENT_NODE) if (remove) {
				const subObserver = this._subObservers.get(node);
				if (subObserver) {
					subObserver.disconnect();
					this._subObservers.delete(node);
				}
			} else {
				const shadowRoot = node.shadowRoot;
				if (shadowRoot) this._addSubObserver(shadowRoot);
			}
			return NodeFilter.FILTER_SKIP;
		} }).nextNode();
	}
	takeRecords() {
		const records = this._observer.takeRecords();
		for (const subObserver of this._subObservers.values()) records.push(...subObserver.takeRecords());
		return records;
	}
};
ShadowMutationObserver._shadowObservers = /* @__PURE__ */ new Set();
/*!
* Copyright (c) Microsoft Corporation. All rights reserved.
* Licensed under the MIT License.
*/
var Tabster = class {
	constructor(tabster) {
		this.keyboardNavigation = tabster.keyboardNavigation;
		this.focusedElement = tabster.focusedElement;
		this.focusable = tabster.focusable;
		this.root = tabster.root;
		this.uncontrolled = tabster.uncontrolled;
		this.core = tabster;
	}
};
/**
* Extends Window to include an internal Tabster instance.
*/
var TabsterCore = class {
	constructor(win, props) {
		var _a, _b;
		this._forgetMemorizedElements = [];
		this._wrappers = /* @__PURE__ */ new Set();
		this._initQueue = [];
		this._version = "8.5.6";
		this._noop = false;
		this.getWindow = () => {
			if (!this._win) throw new Error("Using disposed Tabster.");
			return this._win;
		};
		this._storage = createWeakMap(win);
		this._win = win;
		const getWindow$1 = this.getWindow;
		if (props === null || props === void 0 ? void 0 : props.DOMAPI) setDOMAPI({ ...props.DOMAPI });
		this.keyboardNavigation = new KeyboardNavigationState(getWindow$1);
		this.focusedElement = new FocusedElementState(this, getWindow$1);
		this.focusable = new FocusableAPI(this);
		this.root = new RootAPI(this, props === null || props === void 0 ? void 0 : props.autoRoot);
		this.uncontrolled = new UncontrolledAPI((props === null || props === void 0 ? void 0 : props.checkUncontrolledCompletely) || (props === null || props === void 0 ? void 0 : props.checkUncontrolledTrappingFocus));
		this.controlTab = (_a = props === null || props === void 0 ? void 0 : props.controlTab) !== null && _a !== void 0 ? _a : true;
		this.rootDummyInputs = !!(props === null || props === void 0 ? void 0 : props.rootDummyInputs);
		this._dummyObserver = new DummyInputObserver(getWindow$1);
		this.getParent = (_b = props === null || props === void 0 ? void 0 : props.getParent) !== null && _b !== void 0 ? _b : dom.getParentNode;
		this.internal = {
			stopObserver: () => {
				if (this._unobserve) {
					this._unobserve();
					delete this._unobserve;
				}
			},
			resumeObserver: (syncState) => {
				if (!this._unobserve) {
					const doc = getWindow$1().document;
					this._unobserve = observeMutations(doc, this, updateTabsterByAttribute, syncState);
				}
			}
		};
		startFakeWeakRefsCleanup(getWindow$1);
		this.queueInit(() => {
			this.internal.resumeObserver(true);
		});
	}
	/**
	* Merges external props with the current props. Not all
	* props can/should be mergeable, so let's add more as we move on.
	* @param props Tabster props
	*/
	_mergeProps(props) {
		var _a;
		if (!props) return;
		this.getParent = (_a = props.getParent) !== null && _a !== void 0 ? _a : this.getParent;
	}
	createTabster(noRefCount, props) {
		const wrapper = new Tabster(this);
		if (!noRefCount) this._wrappers.add(wrapper);
		this._mergeProps(props);
		return wrapper;
	}
	disposeTabster(wrapper, allInstances) {
		if (allInstances) this._wrappers.clear();
		else this._wrappers.delete(wrapper);
		if (this._wrappers.size === 0) this.dispose();
	}
	dispose() {
		var _a, _b, _c, _d, _e, _f, _g, _h;
		this.internal.stopObserver();
		const win = this._win;
		win === null || win === void 0 || win.clearTimeout(this._initTimer);
		delete this._initTimer;
		this._initQueue = [];
		this._forgetMemorizedElements = [];
		if (win && this._forgetMemorizedTimer) {
			win.clearTimeout(this._forgetMemorizedTimer);
			delete this._forgetMemorizedTimer;
		}
		(_a = this.outline) === null || _a === void 0 || _a.dispose();
		(_b = this.crossOrigin) === null || _b === void 0 || _b.dispose();
		(_c = this.deloser) === null || _c === void 0 || _c.dispose();
		(_d = this.groupper) === null || _d === void 0 || _d.dispose();
		(_e = this.mover) === null || _e === void 0 || _e.dispose();
		(_f = this.modalizer) === null || _f === void 0 || _f.dispose();
		(_g = this.observedElement) === null || _g === void 0 || _g.dispose();
		(_h = this.restorer) === null || _h === void 0 || _h.dispose();
		this.keyboardNavigation.dispose();
		this.focusable.dispose();
		this.focusedElement.dispose();
		this.root.dispose();
		this._dummyObserver.dispose();
		stopFakeWeakRefsCleanupAndClearStorage(this.getWindow);
		clearElementCache(this.getWindow);
		this._storage = /* @__PURE__ */ new WeakMap();
		this._wrappers.clear();
		if (win) {
			disposeInstanceContext(win);
			delete win.__tabsterInstance;
			delete this._win;
		}
	}
	storageEntry(element, addremove) {
		const storage = this._storage;
		let entry = storage.get(element);
		if (entry) {
			if (addremove === false && Object.keys(entry).length === 0) storage.delete(element);
		} else if (addremove === true) {
			entry = {};
			storage.set(element, entry);
		}
		return entry;
	}
	forceCleanup() {
		if (!this._win) return;
		this._forgetMemorizedElements.push(this._win.document.body);
		if (this._forgetMemorizedTimer) return;
		this._forgetMemorizedTimer = this._win.setTimeout(() => {
			delete this._forgetMemorizedTimer;
			for (let el = this._forgetMemorizedElements.shift(); el; el = this._forgetMemorizedElements.shift()) {
				clearElementCache(this.getWindow, el);
				FocusedElementState.forgetMemorized(this.focusedElement, el);
			}
		}, 0);
		cleanupFakeWeakRefs(this.getWindow, true);
	}
	queueInit(callback) {
		var _a;
		if (!this._win) return;
		this._initQueue.push(callback);
		if (!this._initTimer) this._initTimer = (_a = this._win) === null || _a === void 0 ? void 0 : _a.setTimeout(() => {
			delete this._initTimer;
			this.drainInitQueue();
		}, 0);
	}
	drainInitQueue() {
		if (!this._win) return;
		const queue = this._initQueue;
		this._initQueue = [];
		queue.forEach((callback) => callback());
	}
};
/**
* Creates an instance of Tabster, returns the current window instance if it already exists.
*/
function createTabster(win, props) {
	let tabster = getCurrentTabster(win);
	if (tabster) return tabster.createTabster(false, props);
	tabster = new TabsterCore(win, props);
	win.__tabsterInstance = tabster;
	return tabster.createTabster();
}
/**
* Creates a new groupper instance or returns an existing one
* @param tabster Tabster instance
*/
function getGroupper(tabster) {
	const tabsterCore = tabster.core;
	if (!tabsterCore.groupper) tabsterCore.groupper = new GroupperAPI(tabsterCore, tabsterCore.getWindow);
	return tabsterCore.groupper;
}
/**
* Creates a new mover instance or returns an existing one
* @param tabster Tabster instance
*/
function getMover(tabster) {
	const tabsterCore = tabster.core;
	if (!tabsterCore.mover) tabsterCore.mover = new MoverAPI(tabsterCore, tabsterCore.getWindow);
	return tabsterCore.mover;
}
/**
* Creates a new modalizer instance or returns an existing one
* @param tabster Tabster instance
* @param alwaysAccessibleSelector When Modalizer is active, we put
* aria-hidden to everything else to hide it from screen readers. This CSS
* selector allows to exclude some elements from this behaviour. For example,
* this could be used to exclude aria-live region with the application-wide
* status announcements.
* @param accessibleCheck An optional callback that will be called when
* active Modalizer wants to hide an element that doesn't belong to it from
* the screen readers by setting aria-hidden. Similar to alwaysAccessibleSelector
* but allows to address the elements programmatically rather than with a selector.
* If the callback returns true, the element will not receive aria-hidden.
*/
function getModalizer(tabster, alwaysAccessibleSelector, accessibleCheck) {
	const tabsterCore = tabster.core;
	if (!tabsterCore.modalizer) tabsterCore.modalizer = new ModalizerAPI(tabsterCore, alwaysAccessibleSelector, accessibleCheck);
	return tabsterCore.modalizer;
}
function getObservedElement(tabster) {
	const tabsterCore = tabster.core;
	if (!tabsterCore.observedElement) tabsterCore.observedElement = new ObservedElementAPI(tabsterCore);
	return tabsterCore.observedElement;
}
function getRestorer(tabster) {
	const tabsterCore = tabster.core;
	if (!tabsterCore.restorer) tabsterCore.restorer = new RestorerAPI(tabsterCore);
	return tabsterCore.restorer;
}
function disposeTabster(tabster, allInstances) {
	tabster.core.disposeTabster(tabster, allInstances);
}
/**
* Returns an instance of Tabster if it already exists on the window .
* @param win window instance that could contain an Tabster instance.
*/
function getCurrentTabster(win) {
	return win.__tabsterInstance;
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useTabster.js
var DEFAULT_FACTORY = (tabster) => {
	return tabster;
};
/**
* Creates a tabster instance with the provided configuration
*
* @internal
* @param targetDocument
*/ function createTabsterWithConfig(targetDocument) {
	const defaultView = (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) || void 0;
	const shadowDOMAPI = defaultView === null || defaultView === void 0 ? void 0 : defaultView.__tabsterShadowDOMAPI;
	if (defaultView) return createTabster(defaultView, {
		autoRoot: {},
		controlTab: false,
		getParent,
		checkUncontrolledCompletely: (element) => {
			var _element_firstElementChild;
			return ((_element_firstElementChild = element.firstElementChild) === null || _element_firstElementChild === void 0 ? void 0 : _element_firstElementChild.hasAttribute("data-is-focus-trap-zone-bumper")) === true || void 0;
		},
		DOMAPI: shadowDOMAPI
	});
}
function useTabster(factory = DEFAULT_FACTORY) {
	const { targetDocument } = useFluent();
	const factoryResultRef = import_react.useRef(null);
	useIsomorphicLayoutEffect(() => {
		const tabster = createTabsterWithConfig(targetDocument);
		if (tabster) {
			factoryResultRef.current = factory(tabster);
			return () => {
				disposeTabster(tabster);
				factoryResultRef.current = null;
			};
		}
	}, [targetDocument, factory]);
	{
		const previousFactory = usePrevious(factory);
		if (previousFactory !== null && previousFactory !== factory) throw new Error(["@fluentui/react-tabster: ", "The factory function passed to useTabster has changed. This should not ever happen."].join("\n"));
	}
	return factoryResultRef;
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useTabsterAttributes.js
/**
* @internal
* Hook that returns tabster attributes while ensuring tabster exists
*/ const useTabsterAttributes = (props) => {
	useTabster();
	const strAttr = getTabsterAttribute(props, true);
	return import_react.useMemo(() => ({ [TABSTER_ATTRIBUTE_NAME]: strAttr }), [strAttr]);
};

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useArrowNavigationGroup.js
/**
* A hook that returns the necessary tabster attributes to support arrow key navigation
* @param options - Options to configure keyboard navigation
*/ const useArrowNavigationGroup = (options = {}) => {
	const { circular, axis, memorizeCurrent = true, tabbable, ignoreDefaultKeydown, unstable_hasDefault } = options;
	useTabster(getMover);
	return useTabsterAttributes({
		mover: {
			cyclic: !!circular,
			direction: axisToMoverDirection(axis !== null && axis !== void 0 ? axis : "vertical"),
			memorizeCurrent,
			tabbable,
			hasDefault: unstable_hasDefault
		},
		...ignoreDefaultKeydown && { focusable: { ignoreKeydown: ignoreDefaultKeydown } }
	});
};
function axisToMoverDirection(axis) {
	switch (axis) {
		case "horizontal": return MoverDirections.Horizontal;
		case "grid": return MoverDirections.Grid;
		case "grid-linear": return MoverDirections.GridLinear;
		case "both": return MoverDirections.Both;
		case "vertical":
		default: return MoverDirections.Vertical;
	}
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useFocusableGroup.js
/**
* A hook that returns the necessary tabster attributes to support groupping.
* @param options - Options to configure keyboard navigation
*/ const useFocusableGroup = (options) => {
	useTabster(getGroupper);
	return useTabsterAttributes({
		groupper: { tabbability: getTabbability(options === null || options === void 0 ? void 0 : options.tabBehavior) },
		focusable: { ignoreKeydown: options === null || options === void 0 ? void 0 : options.ignoreDefaultKeydown }
	});
};
var getTabbability = (tabBehavior) => {
	switch (tabBehavior) {
		case "unlimited": return GroupperTabbabilities.Unlimited;
		case "limited": return GroupperTabbabilities.Limited;
		case "limited-trap-focus": return GroupperTabbabilities.LimitedTrapFocus;
		default: return;
	}
};

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/focus/constants.js
const KEYBOARD_NAV_ATTRIBUTE = "data-keyboard-nav";
const KEYBOARD_NAV_SELECTOR = `:global([${KEYBOARD_NAV_ATTRIBUTE}])`;
/**
* @internal
*/ const FOCUS_VISIBLE_ATTR = "data-fui-focus-visible";
/**
* @internal
*/ const FOCUS_WITHIN_ATTR = "data-fui-focus-within";
const defaultOptions$2 = {
	style: {},
	selector: "focus",
	customizeSelector: (selector) => selector
};

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/focus/focusVisiblePolyfill.js
/**
* @internal
* @param scope - Applies the ponyfill to all DOM children
* @param targetWindow - window
*/ function applyFocusVisiblePolyfill(scope, targetWindow) {
	if (alreadyInScope(scope)) return () => void 0;
	const state = { current: void 0 };
	const keyborg = createKeyborg(targetWindow);
	function registerElementIfNavigating(el) {
		if (keyborg.isNavigatingWithKeyboard() && isHTMLElement(el)) {
			state.current = el;
			el.setAttribute(FOCUS_VISIBLE_ATTR, "");
		}
	}
	function disposeCurrentElement() {
		if (state.current) {
			state.current.removeAttribute(FOCUS_VISIBLE_ATTR);
			state.current = void 0;
		}
	}
	keyborg.subscribe((isNavigatingWithKeyboard) => {
		if (!isNavigatingWithKeyboard) disposeCurrentElement();
		else registerElementIfNavigating(targetWindow.document.activeElement);
	});
	const keyborgListener = (e) => {
		disposeCurrentElement();
		const target = e.composedPath()[0];
		registerElementIfNavigating(target);
	};
	const blurListener = (e) => {
		if (!e.relatedTarget || isHTMLElement(e.relatedTarget) && !scope.contains(e.relatedTarget)) disposeCurrentElement();
	};
	scope.addEventListener(KEYBORG_FOCUSIN, keyborgListener);
	scope.addEventListener("focusout", blurListener);
	scope.focusVisible = true;
	if (scope.contains(targetWindow.document.activeElement)) registerElementIfNavigating(targetWindow.document.activeElement);
	return () => {
		disposeCurrentElement();
		scope.removeEventListener(KEYBORG_FOCUSIN, keyborgListener);
		scope.removeEventListener("focusout", blurListener);
		scope.focusVisible = void 0;
		disposeKeyborg(keyborg);
	};
}
function alreadyInScope(el) {
	if (!el) return false;
	if (el.focusVisible) return true;
	return alreadyInScope(el === null || el === void 0 ? void 0 : el.parentElement);
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useFocusVisible.js
function useFocusVisible(options = {}) {
	const contextValue = useFluent();
	const scopeRef = import_react.useRef(null);
	var _options_targetDocument;
	const targetDocument = (_options_targetDocument = options.targetDocument) !== null && _options_targetDocument !== void 0 ? _options_targetDocument : contextValue.targetDocument;
	import_react.useEffect(() => {
		if ((targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) && scopeRef.current) return applyFocusVisiblePolyfill(scopeRef.current, targetDocument.defaultView);
	}, [scopeRef, targetDocument]);
	return scopeRef;
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useKeyborgRef.js
/**
* @internal
* Instantiates [keyborg](https://github.com/microsoft/keyborg)
* @returns - keyborg instance
*/ function useKeyborgRef() {
	const { targetDocument } = useFluent();
	const keyborgRef = import_react.useRef(null);
	import_react.useEffect(() => {
		const targetWindow = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
		if (targetWindow) {
			const keyborg = createKeyborg(targetWindow);
			keyborgRef.current = keyborg;
			return () => {
				disposeKeyborg(keyborg);
				keyborgRef.current = null;
			};
		}
	}, [targetDocument]);
	return keyborgRef;
}

//#endregion
//#region node_modules/@fluentui/react-tabster/lib/hooks/useIsNavigatingWithKeyboard.js
/**
* Instantiates [keyborg](https://github.com/microsoft/keyborg) and checks if the user is navigating with the keyboard.
* @returns
*/ function useIsNavigatingWithKeyboard() {
	const keyborgRef = useKeyborgRef();
	return import_react.useCallback(() => {
		var _keyborgRef_current;
		var _keyborgRef_current_isNavigatingWithKeyboard;
		return (_keyborgRef_current_isNavigatingWithKeyboard = (_keyborgRef_current = keyborgRef.current) === null || _keyborgRef_current === void 0 ? void 0 : _keyborgRef_current.isNavigatingWithKeyboard()) !== null && _keyborgRef_current_isNavigatingWithKeyboard !== void 0 ? _keyborgRef_current_isNavigatingWithKeyboard : false;
	}, [keyborgRef]);
}

//#endregion
//#region node_modules/@fluentui/tokens/lib/tokens.js
const tokens = {
	colorNeutralForeground1: "var(--colorNeutralForeground1)",
	colorNeutralForeground1Hover: "var(--colorNeutralForeground1Hover)",
	colorNeutralForeground1Pressed: "var(--colorNeutralForeground1Pressed)",
	colorNeutralForeground1Selected: "var(--colorNeutralForeground1Selected)",
	colorNeutralForeground2: "var(--colorNeutralForeground2)",
	colorNeutralForeground2Hover: "var(--colorNeutralForeground2Hover)",
	colorNeutralForeground2Pressed: "var(--colorNeutralForeground2Pressed)",
	colorNeutralForeground2Selected: "var(--colorNeutralForeground2Selected)",
	colorNeutralForeground2BrandHover: "var(--colorNeutralForeground2BrandHover)",
	colorNeutralForeground2BrandPressed: "var(--colorNeutralForeground2BrandPressed)",
	colorNeutralForeground2BrandSelected: "var(--colorNeutralForeground2BrandSelected)",
	colorNeutralForeground3: "var(--colorNeutralForeground3)",
	colorNeutralForeground3Hover: "var(--colorNeutralForeground3Hover)",
	colorNeutralForeground3Pressed: "var(--colorNeutralForeground3Pressed)",
	colorNeutralForeground3Selected: "var(--colorNeutralForeground3Selected)",
	colorNeutralForeground3BrandHover: "var(--colorNeutralForeground3BrandHover)",
	colorNeutralForeground3BrandPressed: "var(--colorNeutralForeground3BrandPressed)",
	colorNeutralForeground3BrandSelected: "var(--colorNeutralForeground3BrandSelected)",
	colorNeutralForeground4: "var(--colorNeutralForeground4)",
	colorNeutralForegroundDisabled: "var(--colorNeutralForegroundDisabled)",
	colorBrandForegroundLink: "var(--colorBrandForegroundLink)",
	colorBrandForegroundLinkHover: "var(--colorBrandForegroundLinkHover)",
	colorBrandForegroundLinkPressed: "var(--colorBrandForegroundLinkPressed)",
	colorBrandForegroundLinkSelected: "var(--colorBrandForegroundLinkSelected)",
	colorNeutralForeground2Link: "var(--colorNeutralForeground2Link)",
	colorNeutralForeground2LinkHover: "var(--colorNeutralForeground2LinkHover)",
	colorNeutralForeground2LinkPressed: "var(--colorNeutralForeground2LinkPressed)",
	colorNeutralForeground2LinkSelected: "var(--colorNeutralForeground2LinkSelected)",
	colorCompoundBrandForeground1: "var(--colorCompoundBrandForeground1)",
	colorCompoundBrandForeground1Hover: "var(--colorCompoundBrandForeground1Hover)",
	colorCompoundBrandForeground1Pressed: "var(--colorCompoundBrandForeground1Pressed)",
	colorNeutralForegroundOnBrand: "var(--colorNeutralForegroundOnBrand)",
	colorNeutralForegroundInverted: "var(--colorNeutralForegroundInverted)",
	colorNeutralForegroundInvertedHover: "var(--colorNeutralForegroundInvertedHover)",
	colorNeutralForegroundInvertedPressed: "var(--colorNeutralForegroundInvertedPressed)",
	colorNeutralForegroundInvertedSelected: "var(--colorNeutralForegroundInvertedSelected)",
	colorNeutralForegroundInverted2: "var(--colorNeutralForegroundInverted2)",
	colorNeutralForegroundStaticInverted: "var(--colorNeutralForegroundStaticInverted)",
	colorNeutralForegroundInvertedLink: "var(--colorNeutralForegroundInvertedLink)",
	colorNeutralForegroundInvertedLinkHover: "var(--colorNeutralForegroundInvertedLinkHover)",
	colorNeutralForegroundInvertedLinkPressed: "var(--colorNeutralForegroundInvertedLinkPressed)",
	colorNeutralForegroundInvertedLinkSelected: "var(--colorNeutralForegroundInvertedLinkSelected)",
	colorNeutralForegroundInvertedDisabled: "var(--colorNeutralForegroundInvertedDisabled)",
	colorBrandForeground1: "var(--colorBrandForeground1)",
	colorBrandForeground2: "var(--colorBrandForeground2)",
	colorBrandForeground2Hover: "var(--colorBrandForeground2Hover)",
	colorBrandForeground2Pressed: "var(--colorBrandForeground2Pressed)",
	colorNeutralForeground1Static: "var(--colorNeutralForeground1Static)",
	colorBrandForegroundInverted: "var(--colorBrandForegroundInverted)",
	colorBrandForegroundInvertedHover: "var(--colorBrandForegroundInvertedHover)",
	colorBrandForegroundInvertedPressed: "var(--colorBrandForegroundInvertedPressed)",
	colorBrandForegroundOnLight: "var(--colorBrandForegroundOnLight)",
	colorBrandForegroundOnLightHover: "var(--colorBrandForegroundOnLightHover)",
	colorBrandForegroundOnLightPressed: "var(--colorBrandForegroundOnLightPressed)",
	colorBrandForegroundOnLightSelected: "var(--colorBrandForegroundOnLightSelected)",
	colorNeutralBackground1: "var(--colorNeutralBackground1)",
	colorNeutralBackground1Hover: "var(--colorNeutralBackground1Hover)",
	colorNeutralBackground1Pressed: "var(--colorNeutralBackground1Pressed)",
	colorNeutralBackground1Selected: "var(--colorNeutralBackground1Selected)",
	colorNeutralBackground2: "var(--colorNeutralBackground2)",
	colorNeutralBackground2Hover: "var(--colorNeutralBackground2Hover)",
	colorNeutralBackground2Pressed: "var(--colorNeutralBackground2Pressed)",
	colorNeutralBackground2Selected: "var(--colorNeutralBackground2Selected)",
	colorNeutralBackground3: "var(--colorNeutralBackground3)",
	colorNeutralBackground3Hover: "var(--colorNeutralBackground3Hover)",
	colorNeutralBackground3Pressed: "var(--colorNeutralBackground3Pressed)",
	colorNeutralBackground3Selected: "var(--colorNeutralBackground3Selected)",
	colorNeutralBackground4: "var(--colorNeutralBackground4)",
	colorNeutralBackground4Hover: "var(--colorNeutralBackground4Hover)",
	colorNeutralBackground4Pressed: "var(--colorNeutralBackground4Pressed)",
	colorNeutralBackground4Selected: "var(--colorNeutralBackground4Selected)",
	colorNeutralBackground5: "var(--colorNeutralBackground5)",
	colorNeutralBackground5Hover: "var(--colorNeutralBackground5Hover)",
	colorNeutralBackground5Pressed: "var(--colorNeutralBackground5Pressed)",
	colorNeutralBackground5Selected: "var(--colorNeutralBackground5Selected)",
	colorNeutralBackground6: "var(--colorNeutralBackground6)",
	colorNeutralBackgroundInverted: "var(--colorNeutralBackgroundInverted)",
	colorNeutralBackgroundStatic: "var(--colorNeutralBackgroundStatic)",
	colorNeutralBackgroundAlpha: "var(--colorNeutralBackgroundAlpha)",
	colorNeutralBackgroundAlpha2: "var(--colorNeutralBackgroundAlpha2)",
	colorSubtleBackground: "var(--colorSubtleBackground)",
	colorSubtleBackgroundHover: "var(--colorSubtleBackgroundHover)",
	colorSubtleBackgroundPressed: "var(--colorSubtleBackgroundPressed)",
	colorSubtleBackgroundSelected: "var(--colorSubtleBackgroundSelected)",
	colorSubtleBackgroundLightAlphaHover: "var(--colorSubtleBackgroundLightAlphaHover)",
	colorSubtleBackgroundLightAlphaPressed: "var(--colorSubtleBackgroundLightAlphaPressed)",
	colorSubtleBackgroundLightAlphaSelected: "var(--colorSubtleBackgroundLightAlphaSelected)",
	colorSubtleBackgroundInverted: "var(--colorSubtleBackgroundInverted)",
	colorSubtleBackgroundInvertedHover: "var(--colorSubtleBackgroundInvertedHover)",
	colorSubtleBackgroundInvertedPressed: "var(--colorSubtleBackgroundInvertedPressed)",
	colorSubtleBackgroundInvertedSelected: "var(--colorSubtleBackgroundInvertedSelected)",
	colorTransparentBackground: "var(--colorTransparentBackground)",
	colorTransparentBackgroundHover: "var(--colorTransparentBackgroundHover)",
	colorTransparentBackgroundPressed: "var(--colorTransparentBackgroundPressed)",
	colorTransparentBackgroundSelected: "var(--colorTransparentBackgroundSelected)",
	colorNeutralBackgroundDisabled: "var(--colorNeutralBackgroundDisabled)",
	colorNeutralBackgroundInvertedDisabled: "var(--colorNeutralBackgroundInvertedDisabled)",
	colorNeutralStencil1: "var(--colorNeutralStencil1)",
	colorNeutralStencil2: "var(--colorNeutralStencil2)",
	colorNeutralStencil1Alpha: "var(--colorNeutralStencil1Alpha)",
	colorNeutralStencil2Alpha: "var(--colorNeutralStencil2Alpha)",
	colorBackgroundOverlay: "var(--colorBackgroundOverlay)",
	colorScrollbarOverlay: "var(--colorScrollbarOverlay)",
	colorBrandBackground: "var(--colorBrandBackground)",
	colorBrandBackgroundHover: "var(--colorBrandBackgroundHover)",
	colorBrandBackgroundPressed: "var(--colorBrandBackgroundPressed)",
	colorBrandBackgroundSelected: "var(--colorBrandBackgroundSelected)",
	colorCompoundBrandBackground: "var(--colorCompoundBrandBackground)",
	colorCompoundBrandBackgroundHover: "var(--colorCompoundBrandBackgroundHover)",
	colorCompoundBrandBackgroundPressed: "var(--colorCompoundBrandBackgroundPressed)",
	colorBrandBackgroundStatic: "var(--colorBrandBackgroundStatic)",
	colorBrandBackground2: "var(--colorBrandBackground2)",
	colorBrandBackground2Hover: "var(--colorBrandBackground2Hover)",
	colorBrandBackground2Pressed: "var(--colorBrandBackground2Pressed)",
	colorBrandBackground3Static: "var(--colorBrandBackground3Static)",
	colorBrandBackground4Static: "var(--colorBrandBackground4Static)",
	colorBrandBackgroundInverted: "var(--colorBrandBackgroundInverted)",
	colorBrandBackgroundInvertedHover: "var(--colorBrandBackgroundInvertedHover)",
	colorBrandBackgroundInvertedPressed: "var(--colorBrandBackgroundInvertedPressed)",
	colorBrandBackgroundInvertedSelected: "var(--colorBrandBackgroundInvertedSelected)",
	colorNeutralCardBackground: "var(--colorNeutralCardBackground)",
	colorNeutralCardBackgroundHover: "var(--colorNeutralCardBackgroundHover)",
	colorNeutralCardBackgroundPressed: "var(--colorNeutralCardBackgroundPressed)",
	colorNeutralCardBackgroundSelected: "var(--colorNeutralCardBackgroundSelected)",
	colorNeutralCardBackgroundDisabled: "var(--colorNeutralCardBackgroundDisabled)",
	colorNeutralStrokeAccessible: "var(--colorNeutralStrokeAccessible)",
	colorNeutralStrokeAccessibleHover: "var(--colorNeutralStrokeAccessibleHover)",
	colorNeutralStrokeAccessiblePressed: "var(--colorNeutralStrokeAccessiblePressed)",
	colorNeutralStrokeAccessibleSelected: "var(--colorNeutralStrokeAccessibleSelected)",
	colorNeutralStroke1: "var(--colorNeutralStroke1)",
	colorNeutralStroke1Hover: "var(--colorNeutralStroke1Hover)",
	colorNeutralStroke1Pressed: "var(--colorNeutralStroke1Pressed)",
	colorNeutralStroke1Selected: "var(--colorNeutralStroke1Selected)",
	colorNeutralStroke2: "var(--colorNeutralStroke2)",
	colorNeutralStroke3: "var(--colorNeutralStroke3)",
	colorNeutralStrokeSubtle: "var(--colorNeutralStrokeSubtle)",
	colorNeutralStrokeOnBrand: "var(--colorNeutralStrokeOnBrand)",
	colorNeutralStrokeOnBrand2: "var(--colorNeutralStrokeOnBrand2)",
	colorNeutralStrokeOnBrand2Hover: "var(--colorNeutralStrokeOnBrand2Hover)",
	colorNeutralStrokeOnBrand2Pressed: "var(--colorNeutralStrokeOnBrand2Pressed)",
	colorNeutralStrokeOnBrand2Selected: "var(--colorNeutralStrokeOnBrand2Selected)",
	colorBrandStroke1: "var(--colorBrandStroke1)",
	colorBrandStroke2: "var(--colorBrandStroke2)",
	colorBrandStroke2Hover: "var(--colorBrandStroke2Hover)",
	colorBrandStroke2Pressed: "var(--colorBrandStroke2Pressed)",
	colorBrandStroke2Contrast: "var(--colorBrandStroke2Contrast)",
	colorCompoundBrandStroke: "var(--colorCompoundBrandStroke)",
	colorCompoundBrandStrokeHover: "var(--colorCompoundBrandStrokeHover)",
	colorCompoundBrandStrokePressed: "var(--colorCompoundBrandStrokePressed)",
	colorNeutralStrokeDisabled: "var(--colorNeutralStrokeDisabled)",
	colorNeutralStrokeInvertedDisabled: "var(--colorNeutralStrokeInvertedDisabled)",
	colorTransparentStroke: "var(--colorTransparentStroke)",
	colorTransparentStrokeInteractive: "var(--colorTransparentStrokeInteractive)",
	colorTransparentStrokeDisabled: "var(--colorTransparentStrokeDisabled)",
	colorNeutralStrokeAlpha: "var(--colorNeutralStrokeAlpha)",
	colorNeutralStrokeAlpha2: "var(--colorNeutralStrokeAlpha2)",
	colorStrokeFocus1: "var(--colorStrokeFocus1)",
	colorStrokeFocus2: "var(--colorStrokeFocus2)",
	colorNeutralShadowAmbient: "var(--colorNeutralShadowAmbient)",
	colorNeutralShadowKey: "var(--colorNeutralShadowKey)",
	colorNeutralShadowAmbientLighter: "var(--colorNeutralShadowAmbientLighter)",
	colorNeutralShadowKeyLighter: "var(--colorNeutralShadowKeyLighter)",
	colorNeutralShadowAmbientDarker: "var(--colorNeutralShadowAmbientDarker)",
	colorNeutralShadowKeyDarker: "var(--colorNeutralShadowKeyDarker)",
	colorBrandShadowAmbient: "var(--colorBrandShadowAmbient)",
	colorBrandShadowKey: "var(--colorBrandShadowKey)",
	colorPaletteRedBackground1: "var(--colorPaletteRedBackground1)",
	colorPaletteRedBackground2: "var(--colorPaletteRedBackground2)",
	colorPaletteRedBackground3: "var(--colorPaletteRedBackground3)",
	colorPaletteRedBorderActive: "var(--colorPaletteRedBorderActive)",
	colorPaletteRedBorder1: "var(--colorPaletteRedBorder1)",
	colorPaletteRedBorder2: "var(--colorPaletteRedBorder2)",
	colorPaletteRedForeground1: "var(--colorPaletteRedForeground1)",
	colorPaletteRedForeground2: "var(--colorPaletteRedForeground2)",
	colorPaletteRedForeground3: "var(--colorPaletteRedForeground3)",
	colorPaletteRedForegroundInverted: "var(--colorPaletteRedForegroundInverted)",
	colorPaletteGreenBackground1: "var(--colorPaletteGreenBackground1)",
	colorPaletteGreenBackground2: "var(--colorPaletteGreenBackground2)",
	colorPaletteGreenBackground3: "var(--colorPaletteGreenBackground3)",
	colorPaletteGreenBorderActive: "var(--colorPaletteGreenBorderActive)",
	colorPaletteGreenBorder1: "var(--colorPaletteGreenBorder1)",
	colorPaletteGreenBorder2: "var(--colorPaletteGreenBorder2)",
	colorPaletteGreenForeground1: "var(--colorPaletteGreenForeground1)",
	colorPaletteGreenForeground2: "var(--colorPaletteGreenForeground2)",
	colorPaletteGreenForeground3: "var(--colorPaletteGreenForeground3)",
	colorPaletteGreenForegroundInverted: "var(--colorPaletteGreenForegroundInverted)",
	colorPaletteDarkOrangeBackground1: "var(--colorPaletteDarkOrangeBackground1)",
	colorPaletteDarkOrangeBackground2: "var(--colorPaletteDarkOrangeBackground2)",
	colorPaletteDarkOrangeBackground3: "var(--colorPaletteDarkOrangeBackground3)",
	colorPaletteDarkOrangeBorderActive: "var(--colorPaletteDarkOrangeBorderActive)",
	colorPaletteDarkOrangeBorder1: "var(--colorPaletteDarkOrangeBorder1)",
	colorPaletteDarkOrangeBorder2: "var(--colorPaletteDarkOrangeBorder2)",
	colorPaletteDarkOrangeForeground1: "var(--colorPaletteDarkOrangeForeground1)",
	colorPaletteDarkOrangeForeground2: "var(--colorPaletteDarkOrangeForeground2)",
	colorPaletteDarkOrangeForeground3: "var(--colorPaletteDarkOrangeForeground3)",
	colorPaletteYellowBackground1: "var(--colorPaletteYellowBackground1)",
	colorPaletteYellowBackground2: "var(--colorPaletteYellowBackground2)",
	colorPaletteYellowBackground3: "var(--colorPaletteYellowBackground3)",
	colorPaletteYellowBorderActive: "var(--colorPaletteYellowBorderActive)",
	colorPaletteYellowBorder1: "var(--colorPaletteYellowBorder1)",
	colorPaletteYellowBorder2: "var(--colorPaletteYellowBorder2)",
	colorPaletteYellowForeground1: "var(--colorPaletteYellowForeground1)",
	colorPaletteYellowForeground2: "var(--colorPaletteYellowForeground2)",
	colorPaletteYellowForeground3: "var(--colorPaletteYellowForeground3)",
	colorPaletteYellowForegroundInverted: "var(--colorPaletteYellowForegroundInverted)",
	colorPaletteBerryBackground1: "var(--colorPaletteBerryBackground1)",
	colorPaletteBerryBackground2: "var(--colorPaletteBerryBackground2)",
	colorPaletteBerryBackground3: "var(--colorPaletteBerryBackground3)",
	colorPaletteBerryBorderActive: "var(--colorPaletteBerryBorderActive)",
	colorPaletteBerryBorder1: "var(--colorPaletteBerryBorder1)",
	colorPaletteBerryBorder2: "var(--colorPaletteBerryBorder2)",
	colorPaletteBerryForeground1: "var(--colorPaletteBerryForeground1)",
	colorPaletteBerryForeground2: "var(--colorPaletteBerryForeground2)",
	colorPaletteBerryForeground3: "var(--colorPaletteBerryForeground3)",
	colorPaletteMarigoldBackground1: "var(--colorPaletteMarigoldBackground1)",
	colorPaletteMarigoldBackground2: "var(--colorPaletteMarigoldBackground2)",
	colorPaletteMarigoldBackground3: "var(--colorPaletteMarigoldBackground3)",
	colorPaletteMarigoldBorderActive: "var(--colorPaletteMarigoldBorderActive)",
	colorPaletteMarigoldBorder1: "var(--colorPaletteMarigoldBorder1)",
	colorPaletteMarigoldBorder2: "var(--colorPaletteMarigoldBorder2)",
	colorPaletteMarigoldForeground1: "var(--colorPaletteMarigoldForeground1)",
	colorPaletteMarigoldForeground2: "var(--colorPaletteMarigoldForeground2)",
	colorPaletteMarigoldForeground3: "var(--colorPaletteMarigoldForeground3)",
	colorPaletteLightGreenBackground1: "var(--colorPaletteLightGreenBackground1)",
	colorPaletteLightGreenBackground2: "var(--colorPaletteLightGreenBackground2)",
	colorPaletteLightGreenBackground3: "var(--colorPaletteLightGreenBackground3)",
	colorPaletteLightGreenBorderActive: "var(--colorPaletteLightGreenBorderActive)",
	colorPaletteLightGreenBorder1: "var(--colorPaletteLightGreenBorder1)",
	colorPaletteLightGreenBorder2: "var(--colorPaletteLightGreenBorder2)",
	colorPaletteLightGreenForeground1: "var(--colorPaletteLightGreenForeground1)",
	colorPaletteLightGreenForeground2: "var(--colorPaletteLightGreenForeground2)",
	colorPaletteLightGreenForeground3: "var(--colorPaletteLightGreenForeground3)",
	colorPaletteAnchorBackground2: "var(--colorPaletteAnchorBackground2)",
	colorPaletteAnchorBorderActive: "var(--colorPaletteAnchorBorderActive)",
	colorPaletteAnchorForeground2: "var(--colorPaletteAnchorForeground2)",
	colorPaletteBeigeBackground2: "var(--colorPaletteBeigeBackground2)",
	colorPaletteBeigeBorderActive: "var(--colorPaletteBeigeBorderActive)",
	colorPaletteBeigeForeground2: "var(--colorPaletteBeigeForeground2)",
	colorPaletteBlueBackground2: "var(--colorPaletteBlueBackground2)",
	colorPaletteBlueBorderActive: "var(--colorPaletteBlueBorderActive)",
	colorPaletteBlueForeground2: "var(--colorPaletteBlueForeground2)",
	colorPaletteBrassBackground2: "var(--colorPaletteBrassBackground2)",
	colorPaletteBrassBorderActive: "var(--colorPaletteBrassBorderActive)",
	colorPaletteBrassForeground2: "var(--colorPaletteBrassForeground2)",
	colorPaletteBrownBackground2: "var(--colorPaletteBrownBackground2)",
	colorPaletteBrownBorderActive: "var(--colorPaletteBrownBorderActive)",
	colorPaletteBrownForeground2: "var(--colorPaletteBrownForeground2)",
	colorPaletteCornflowerBackground2: "var(--colorPaletteCornflowerBackground2)",
	colorPaletteCornflowerBorderActive: "var(--colorPaletteCornflowerBorderActive)",
	colorPaletteCornflowerForeground2: "var(--colorPaletteCornflowerForeground2)",
	colorPaletteCranberryBackground2: "var(--colorPaletteCranberryBackground2)",
	colorPaletteCranberryBorderActive: "var(--colorPaletteCranberryBorderActive)",
	colorPaletteCranberryForeground2: "var(--colorPaletteCranberryForeground2)",
	colorPaletteDarkGreenBackground2: "var(--colorPaletteDarkGreenBackground2)",
	colorPaletteDarkGreenBorderActive: "var(--colorPaletteDarkGreenBorderActive)",
	colorPaletteDarkGreenForeground2: "var(--colorPaletteDarkGreenForeground2)",
	colorPaletteDarkRedBackground2: "var(--colorPaletteDarkRedBackground2)",
	colorPaletteDarkRedBorderActive: "var(--colorPaletteDarkRedBorderActive)",
	colorPaletteDarkRedForeground2: "var(--colorPaletteDarkRedForeground2)",
	colorPaletteForestBackground2: "var(--colorPaletteForestBackground2)",
	colorPaletteForestBorderActive: "var(--colorPaletteForestBorderActive)",
	colorPaletteForestForeground2: "var(--colorPaletteForestForeground2)",
	colorPaletteGoldBackground2: "var(--colorPaletteGoldBackground2)",
	colorPaletteGoldBorderActive: "var(--colorPaletteGoldBorderActive)",
	colorPaletteGoldForeground2: "var(--colorPaletteGoldForeground2)",
	colorPaletteGrapeBackground2: "var(--colorPaletteGrapeBackground2)",
	colorPaletteGrapeBorderActive: "var(--colorPaletteGrapeBorderActive)",
	colorPaletteGrapeForeground2: "var(--colorPaletteGrapeForeground2)",
	colorPaletteLavenderBackground2: "var(--colorPaletteLavenderBackground2)",
	colorPaletteLavenderBorderActive: "var(--colorPaletteLavenderBorderActive)",
	colorPaletteLavenderForeground2: "var(--colorPaletteLavenderForeground2)",
	colorPaletteLightTealBackground2: "var(--colorPaletteLightTealBackground2)",
	colorPaletteLightTealBorderActive: "var(--colorPaletteLightTealBorderActive)",
	colorPaletteLightTealForeground2: "var(--colorPaletteLightTealForeground2)",
	colorPaletteLilacBackground2: "var(--colorPaletteLilacBackground2)",
	colorPaletteLilacBorderActive: "var(--colorPaletteLilacBorderActive)",
	colorPaletteLilacForeground2: "var(--colorPaletteLilacForeground2)",
	colorPaletteMagentaBackground2: "var(--colorPaletteMagentaBackground2)",
	colorPaletteMagentaBorderActive: "var(--colorPaletteMagentaBorderActive)",
	colorPaletteMagentaForeground2: "var(--colorPaletteMagentaForeground2)",
	colorPaletteMinkBackground2: "var(--colorPaletteMinkBackground2)",
	colorPaletteMinkBorderActive: "var(--colorPaletteMinkBorderActive)",
	colorPaletteMinkForeground2: "var(--colorPaletteMinkForeground2)",
	colorPaletteNavyBackground2: "var(--colorPaletteNavyBackground2)",
	colorPaletteNavyBorderActive: "var(--colorPaletteNavyBorderActive)",
	colorPaletteNavyForeground2: "var(--colorPaletteNavyForeground2)",
	colorPalettePeachBackground2: "var(--colorPalettePeachBackground2)",
	colorPalettePeachBorderActive: "var(--colorPalettePeachBorderActive)",
	colorPalettePeachForeground2: "var(--colorPalettePeachForeground2)",
	colorPalettePinkBackground2: "var(--colorPalettePinkBackground2)",
	colorPalettePinkBorderActive: "var(--colorPalettePinkBorderActive)",
	colorPalettePinkForeground2: "var(--colorPalettePinkForeground2)",
	colorPalettePlatinumBackground2: "var(--colorPalettePlatinumBackground2)",
	colorPalettePlatinumBorderActive: "var(--colorPalettePlatinumBorderActive)",
	colorPalettePlatinumForeground2: "var(--colorPalettePlatinumForeground2)",
	colorPalettePlumBackground2: "var(--colorPalettePlumBackground2)",
	colorPalettePlumBorderActive: "var(--colorPalettePlumBorderActive)",
	colorPalettePlumForeground2: "var(--colorPalettePlumForeground2)",
	colorPalettePumpkinBackground2: "var(--colorPalettePumpkinBackground2)",
	colorPalettePumpkinBorderActive: "var(--colorPalettePumpkinBorderActive)",
	colorPalettePumpkinForeground2: "var(--colorPalettePumpkinForeground2)",
	colorPalettePurpleBackground2: "var(--colorPalettePurpleBackground2)",
	colorPalettePurpleBorderActive: "var(--colorPalettePurpleBorderActive)",
	colorPalettePurpleForeground2: "var(--colorPalettePurpleForeground2)",
	colorPaletteRoyalBlueBackground2: "var(--colorPaletteRoyalBlueBackground2)",
	colorPaletteRoyalBlueBorderActive: "var(--colorPaletteRoyalBlueBorderActive)",
	colorPaletteRoyalBlueForeground2: "var(--colorPaletteRoyalBlueForeground2)",
	colorPaletteSeafoamBackground2: "var(--colorPaletteSeafoamBackground2)",
	colorPaletteSeafoamBorderActive: "var(--colorPaletteSeafoamBorderActive)",
	colorPaletteSeafoamForeground2: "var(--colorPaletteSeafoamForeground2)",
	colorPaletteSteelBackground2: "var(--colorPaletteSteelBackground2)",
	colorPaletteSteelBorderActive: "var(--colorPaletteSteelBorderActive)",
	colorPaletteSteelForeground2: "var(--colorPaletteSteelForeground2)",
	colorPaletteTealBackground2: "var(--colorPaletteTealBackground2)",
	colorPaletteTealBorderActive: "var(--colorPaletteTealBorderActive)",
	colorPaletteTealForeground2: "var(--colorPaletteTealForeground2)",
	colorStatusSuccessBackground1: "var(--colorStatusSuccessBackground1)",
	colorStatusSuccessBackground2: "var(--colorStatusSuccessBackground2)",
	colorStatusSuccessBackground3: "var(--colorStatusSuccessBackground3)",
	colorStatusSuccessForeground1: "var(--colorStatusSuccessForeground1)",
	colorStatusSuccessForeground2: "var(--colorStatusSuccessForeground2)",
	colorStatusSuccessForeground3: "var(--colorStatusSuccessForeground3)",
	colorStatusSuccessForegroundInverted: "var(--colorStatusSuccessForegroundInverted)",
	colorStatusSuccessBorderActive: "var(--colorStatusSuccessBorderActive)",
	colorStatusSuccessBorder1: "var(--colorStatusSuccessBorder1)",
	colorStatusSuccessBorder2: "var(--colorStatusSuccessBorder2)",
	colorStatusWarningBackground1: "var(--colorStatusWarningBackground1)",
	colorStatusWarningBackground2: "var(--colorStatusWarningBackground2)",
	colorStatusWarningBackground3: "var(--colorStatusWarningBackground3)",
	colorStatusWarningForeground1: "var(--colorStatusWarningForeground1)",
	colorStatusWarningForeground2: "var(--colorStatusWarningForeground2)",
	colorStatusWarningForeground3: "var(--colorStatusWarningForeground3)",
	colorStatusWarningForegroundInverted: "var(--colorStatusWarningForegroundInverted)",
	colorStatusWarningBorderActive: "var(--colorStatusWarningBorderActive)",
	colorStatusWarningBorder1: "var(--colorStatusWarningBorder1)",
	colorStatusWarningBorder2: "var(--colorStatusWarningBorder2)",
	colorStatusDangerBackground1: "var(--colorStatusDangerBackground1)",
	colorStatusDangerBackground2: "var(--colorStatusDangerBackground2)",
	colorStatusDangerBackground3: "var(--colorStatusDangerBackground3)",
	colorStatusDangerBackground3Hover: "var(--colorStatusDangerBackground3Hover)",
	colorStatusDangerBackground3Pressed: "var(--colorStatusDangerBackground3Pressed)",
	colorStatusDangerForeground1: "var(--colorStatusDangerForeground1)",
	colorStatusDangerForeground2: "var(--colorStatusDangerForeground2)",
	colorStatusDangerForeground3: "var(--colorStatusDangerForeground3)",
	colorStatusDangerForegroundInverted: "var(--colorStatusDangerForegroundInverted)",
	colorStatusDangerBorderActive: "var(--colorStatusDangerBorderActive)",
	colorStatusDangerBorder1: "var(--colorStatusDangerBorder1)",
	colorStatusDangerBorder2: "var(--colorStatusDangerBorder2)",
	borderRadiusNone: "var(--borderRadiusNone)",
	borderRadiusSmall: "var(--borderRadiusSmall)",
	borderRadiusMedium: "var(--borderRadiusMedium)",
	borderRadiusLarge: "var(--borderRadiusLarge)",
	borderRadiusXLarge: "var(--borderRadiusXLarge)",
	borderRadiusCircular: "var(--borderRadiusCircular)",
	fontFamilyBase: "var(--fontFamilyBase)",
	fontFamilyMonospace: "var(--fontFamilyMonospace)",
	fontFamilyNumeric: "var(--fontFamilyNumeric)",
	fontSizeBase100: "var(--fontSizeBase100)",
	fontSizeBase200: "var(--fontSizeBase200)",
	fontSizeBase300: "var(--fontSizeBase300)",
	fontSizeBase400: "var(--fontSizeBase400)",
	fontSizeBase500: "var(--fontSizeBase500)",
	fontSizeBase600: "var(--fontSizeBase600)",
	fontSizeHero700: "var(--fontSizeHero700)",
	fontSizeHero800: "var(--fontSizeHero800)",
	fontSizeHero900: "var(--fontSizeHero900)",
	fontSizeHero1000: "var(--fontSizeHero1000)",
	fontWeightRegular: "var(--fontWeightRegular)",
	fontWeightMedium: "var(--fontWeightMedium)",
	fontWeightSemibold: "var(--fontWeightSemibold)",
	fontWeightBold: "var(--fontWeightBold)",
	lineHeightBase100: "var(--lineHeightBase100)",
	lineHeightBase200: "var(--lineHeightBase200)",
	lineHeightBase300: "var(--lineHeightBase300)",
	lineHeightBase400: "var(--lineHeightBase400)",
	lineHeightBase500: "var(--lineHeightBase500)",
	lineHeightBase600: "var(--lineHeightBase600)",
	lineHeightHero700: "var(--lineHeightHero700)",
	lineHeightHero800: "var(--lineHeightHero800)",
	lineHeightHero900: "var(--lineHeightHero900)",
	lineHeightHero1000: "var(--lineHeightHero1000)",
	shadow2: "var(--shadow2)",
	shadow4: "var(--shadow4)",
	shadow8: "var(--shadow8)",
	shadow16: "var(--shadow16)",
	shadow28: "var(--shadow28)",
	shadow64: "var(--shadow64)",
	shadow2Brand: "var(--shadow2Brand)",
	shadow4Brand: "var(--shadow4Brand)",
	shadow8Brand: "var(--shadow8Brand)",
	shadow16Brand: "var(--shadow16Brand)",
	shadow28Brand: "var(--shadow28Brand)",
	shadow64Brand: "var(--shadow64Brand)",
	strokeWidthThin: "var(--strokeWidthThin)",
	strokeWidthThick: "var(--strokeWidthThick)",
	strokeWidthThicker: "var(--strokeWidthThicker)",
	strokeWidthThickest: "var(--strokeWidthThickest)",
	spacingHorizontalNone: "var(--spacingHorizontalNone)",
	spacingHorizontalXXS: "var(--spacingHorizontalXXS)",
	spacingHorizontalXS: "var(--spacingHorizontalXS)",
	spacingHorizontalSNudge: "var(--spacingHorizontalSNudge)",
	spacingHorizontalS: "var(--spacingHorizontalS)",
	spacingHorizontalMNudge: "var(--spacingHorizontalMNudge)",
	spacingHorizontalM: "var(--spacingHorizontalM)",
	spacingHorizontalL: "var(--spacingHorizontalL)",
	spacingHorizontalXL: "var(--spacingHorizontalXL)",
	spacingHorizontalXXL: "var(--spacingHorizontalXXL)",
	spacingHorizontalXXXL: "var(--spacingHorizontalXXXL)",
	spacingVerticalNone: "var(--spacingVerticalNone)",
	spacingVerticalXXS: "var(--spacingVerticalXXS)",
	spacingVerticalXS: "var(--spacingVerticalXS)",
	spacingVerticalSNudge: "var(--spacingVerticalSNudge)",
	spacingVerticalS: "var(--spacingVerticalS)",
	spacingVerticalMNudge: "var(--spacingVerticalMNudge)",
	spacingVerticalM: "var(--spacingVerticalM)",
	spacingVerticalL: "var(--spacingVerticalL)",
	spacingVerticalXL: "var(--spacingVerticalXL)",
	spacingVerticalXXL: "var(--spacingVerticalXXL)",
	spacingVerticalXXXL: "var(--spacingVerticalXXXL)",
	durationUltraFast: "var(--durationUltraFast)",
	durationFaster: "var(--durationFaster)",
	durationFast: "var(--durationFast)",
	durationNormal: "var(--durationNormal)",
	durationGentle: "var(--durationGentle)",
	durationSlow: "var(--durationSlow)",
	durationSlower: "var(--durationSlower)",
	durationUltraSlow: "var(--durationUltraSlow)",
	curveAccelerateMax: "var(--curveAccelerateMax)",
	curveAccelerateMid: "var(--curveAccelerateMid)",
	curveAccelerateMin: "var(--curveAccelerateMin)",
	curveDecelerateMax: "var(--curveDecelerateMax)",
	curveDecelerateMid: "var(--curveDecelerateMid)",
	curveDecelerateMin: "var(--curveDecelerateMin)",
	curveEasyEaseMax: "var(--curveEasyEaseMax)",
	curveEasyEase: "var(--curveEasyEase)",
	curveLinear: "var(--curveLinear)",
	zIndexBackground: "var(--zIndexBackground, 0)",
	zIndexContent: "var(--zIndexContent, 1)",
	zIndexOverlay: "var(--zIndexOverlay, 1000)",
	zIndexPopup: "var(--zIndexPopup, 2000)",
	zIndexMessages: "var(--zIndexMessages, 3000)",
	zIndexFloating: "var(--zIndexFloating, 4000)",
	zIndexPriority: "var(--zIndexPriority, 5000)",
	zIndexDebug: "var(--zIndexDebug, 6000)"
};

//#endregion
//#region node_modules/@fluentui/react-button/lib/contexts/ButtonContext.js
var buttonContext = import_react.createContext(void 0);
var buttonContextDefaultValue = {};
/**
* @internal
* Internal context provider used to update default values between internal components
*/ const ButtonContextProvider = buttonContext.Provider;
/**
* @internal
* Internal context hook used to update default values between internal components
*/ const useButtonContext = () => {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(buttonContext)) !== null && _React_useContext !== void 0 ? _React_useContext : buttonContextDefaultValue;
};

//#endregion
//#region node_modules/@fluentui/react-button/lib/components/Button/useButton.js
/**
* Given user props, defines default props for the Button, calls useButtonState, and returns processed state.
* @param props - User provided props to the Button component.
* @param ref - User provided ref to be passed to the Button component.
*/ const useButton_unstable = (props, ref) => {
	const { size: contextSize } = useButtonContext();
	const { appearance = "secondary", as = "button", disabled = false, disabledFocusable = false, icon, iconPosition = "before", shape = "rounded", size: size$2 = contextSize !== null && contextSize !== void 0 ? contextSize : "medium" } = props;
	const iconShorthand = optional(icon, { elementType: "span" });
	return {
		appearance,
		disabled,
		disabledFocusable,
		iconPosition,
		shape,
		size: size$2,
		iconOnly: Boolean((iconShorthand === null || iconShorthand === void 0 ? void 0 : iconShorthand.children) && !props.children),
		components: {
			root: "button",
			icon: "span"
		},
		root: always(getIntrinsicElementProps(as, useARIAButtonProps(props.as, props)), {
			elementType: "button",
			defaultProps: {
				ref,
				type: as === "button" ? "button" : void 0
			}
		}),
		icon: iconShorthand
	};
};

//#endregion
//#region node_modules/@fluentui/react-button/lib/components/Button/useButtonStyles.styles.js
const buttonClassNames = {
	root: "fui-Button",
	icon: "fui-Button__icon"
};
`${tokens.strokeWidthThin}`;
var useRootBaseClassName = /* @__PURE__ */ __resetStyles("r1alrhcs", null, {
	r: [
		".r1alrhcs{align-items:center;box-sizing:border-box;display:inline-flex;justify-content:center;text-decoration-line:none;vertical-align:middle;margin:0;overflow:hidden;background-color:var(--colorNeutralBackground1);color:var(--colorNeutralForeground1);border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);font-family:var(--fontFamilyBase);outline-style:none;padding:5px var(--spacingHorizontalM);min-width:96px;border-radius:var(--borderRadiusMedium);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightSemibold);line-height:var(--lineHeightBase300);transition-duration:var(--durationFaster);transition-property:background,border,color;transition-timing-function:var(--curveEasyEase);}",
		".r1alrhcs:hover{background-color:var(--colorNeutralBackground1Hover);border-color:var(--colorNeutralStroke1Hover);color:var(--colorNeutralForeground1Hover);cursor:pointer;}",
		".r1alrhcs:hover:active{background-color:var(--colorNeutralBackground1Pressed);border-color:var(--colorNeutralStroke1Pressed);color:var(--colorNeutralForeground1Pressed);outline-style:none;}",
		".r1alrhcs[data-fui-focus-visible]{border-color:var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);border-width:1px;outline:var(--strokeWidthThick) solid var(--colorTransparentStroke);box-shadow:0 0 0 var(--strokeWidthThin) var(--colorStrokeFocus2) inset;z-index:1;}"
	],
	s: [
		"@media screen and (prefers-reduced-motion: reduce){.r1alrhcs{transition-duration:0.01ms;}}",
		"@media (forced-colors: active){.r1alrhcs:focus{border-color:ButtonText;}.r1alrhcs:hover{background-color:HighlightText;border-color:Highlight;color:Highlight;forced-color-adjust:none;}.r1alrhcs:hover:active{background-color:HighlightText;border-color:Highlight;color:Highlight;forced-color-adjust:none;}}",
		"@supports (-moz-appearance:button){.r1alrhcs[data-fui-focus-visible]{box-shadow:0 0 0 calc(var(--strokeWidthThin) + 0.25px) var(--colorStrokeFocus2) inset;}}"
	]
});
var useIconBaseClassName = /* @__PURE__ */ __resetStyles("rywnvv2", null, [".rywnvv2{align-items:center;display:inline-flex;justify-content:center;font-size:20px;height:20px;width:20px;--fui-Button__icon--spacing:var(--spacingHorizontalSNudge);}"]);
var useRootStyles = /* @__PURE__ */ __styles({
	outline: {
		De3pzq: "f1c21dwh",
		Jwef8y: "fjxutwb",
		iro3zm: "fwiml72"
	},
	primary: {
		De3pzq: "ffp7eso",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "f1phragk",
		Jwef8y: "f15wkkf3",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "f1rq72xc",
		iro3zm: "fnp9lpt",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1d6v5y2",
		By8wz76: "f1nz3ub2",
		Bcq6wej: "fag2qd2",
		Jcjdmf: ["fmvhcg7", "f14bpyus"],
		sc4o1m: "f1o3dhpw",
		Bosien3: ["f14bpyus", "fmvhcg7"],
		B7iucu3: "fqc85l4",
		B8gzw0y: "f1h3a8gf",
		Bbkh6qg: "fkiggi6",
		F230oe: "f8gmj8i",
		Bdw8ktp: ["f1ap8nzx", "fjag8bx"],
		Bj1xduy: "f1igan7k",
		Bhh2cfd: ["fjag8bx", "f1ap8nzx"],
		Bahaeuw: "f1v3eptx",
		rxnm8d: "fpelvsg",
		Bso50sa: "f1r9enuy",
		B65bq0w: ["fdvt4n0", "f1grx941"],
		Buont6p: "f1l34yyb",
		B0o9ejx: ["f1grx941", "fdvt4n0"],
		Dcq74g: "fqfbdvs"
	},
	secondary: {},
	subtle: {
		De3pzq: "fhovq9v",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "fkfq4zb",
		Jwef8y: "f1t94bn6",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "fnwyq0v",
		Bk3fhr4: "ft1hn21",
		Bmfj8id: "fuxngvv",
		Bbdnnc7: "fy5bs14",
		iro3zm: "fsv2rcd",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1omzyqd",
		em6i61: "f1dfjoow",
		vm6p8p: "f1j98vj9",
		x3br3k: "fj8yq94",
		Bahaeuw: "f1v3eptx",
		Buhizc3: "fivsta0",
		Dcq74g: "fqfbdvs",
		zyxd5v: "f1wfsnb3"
	},
	transparent: {
		De3pzq: "f1c21dwh",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "fkfq4zb",
		Jwef8y: "fjxutwb",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "f139oj5f",
		Bk3fhr4: "ft1hn21",
		Bmfj8id: "fuxngvv",
		iro3zm: "fwiml72",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1fg1p5m",
		em6i61: "f1dfjoow",
		vm6p8p: "f1j98vj9",
		Bbkh6qg: "fxoo9op",
		Bahaeuw: "f1v3eptx",
		rxnm8d: "f11slz88",
		Dcq74g: "fqfbdvs"
	},
	circular: {
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "f44lkw9"
	},
	rounded: {},
	square: {
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "f1fabniw"
	},
	small: {
		Bf4jedk: "fh7ncta",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "fneth5b",
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "ft85np5",
		Be2twd7: "fy9rknc",
		Bhrd7zp: "figsok6",
		Bg96gwp: "fwrc4pm"
	},
	smallWithIcon: {
		Byoj8tv: "f1brlhvm",
		z8tnut: "f1sl3k7w"
	},
	medium: {},
	large: {
		Bf4jedk: "f14es27b",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f4db1ww",
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "ft85np5",
		Be2twd7: "fod5ikn",
		Bhrd7zp: "fl43uef",
		Bg96gwp: "faaz57k"
	},
	largeWithIcon: {
		Byoj8tv: "fy7v416",
		z8tnut: "f1a1bwwz"
	}
}, {
	d: [
		".f1c21dwh{background-color:var(--colorTransparentBackground);}",
		".ffp7eso{background-color:var(--colorBrandBackground);}",
		".f1p3nwhy{border-top-color:transparent;}",
		".f11589ue{border-right-color:transparent;}",
		".f1pdflbu{border-left-color:transparent;}",
		".f1q5o8ev{border-bottom-color:transparent;}",
		".f1phragk{color:var(--colorNeutralForegroundOnBrand);}",
		".fhovq9v{background-color:var(--colorSubtleBackground);}",
		".fkfq4zb{color:var(--colorNeutralForeground2);}",
		[".f44lkw9{border-radius:var(--borderRadiusCircular);}", { p: -1 }],
		[".f1fabniw{border-radius:var(--borderRadiusNone);}", { p: -1 }],
		".fh7ncta{min-width:64px;}",
		[".fneth5b{padding:3px var(--spacingHorizontalS);}", { p: -1 }],
		[".ft85np5{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
		".fy9rknc{font-size:var(--fontSizeBase200);}",
		".figsok6{font-weight:var(--fontWeightRegular);}",
		".fwrc4pm{line-height:var(--lineHeightBase200);}",
		".f1brlhvm{padding-bottom:1px;}",
		".f1sl3k7w{padding-top:1px;}",
		".f14es27b{min-width:96px;}",
		[".f4db1ww{padding:8px var(--spacingHorizontalL);}", { p: -1 }],
		[".ft85np5{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
		".fod5ikn{font-size:var(--fontSizeBase400);}",
		".fl43uef{font-weight:var(--fontWeightSemibold);}",
		".faaz57k{line-height:var(--lineHeightBase400);}",
		".fy7v416{padding-bottom:7px;}",
		".f1a1bwwz{padding-top:7px;}"
	],
	h: [
		".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}",
		".fwiml72:hover:active{background-color:var(--colorTransparentBackgroundPressed);}",
		".f15wkkf3:hover{background-color:var(--colorBrandBackgroundHover);}",
		".f1s2uweq:hover{border-top-color:transparent;}",
		".fr80ssc:hover{border-right-color:transparent;}",
		".fecsdlb:hover{border-left-color:transparent;}",
		".f1ukrpxl:hover{border-bottom-color:transparent;}",
		".f1rq72xc:hover{color:var(--colorNeutralForegroundOnBrand);}",
		".fnp9lpt:hover:active{background-color:var(--colorBrandBackgroundPressed);}",
		".f1h0usnq:hover:active{border-top-color:transparent;}",
		".fs4ktlq:hover:active{border-right-color:transparent;}",
		".fx2bmrt:hover:active{border-left-color:transparent;}",
		".f16h9ulv:hover:active{border-bottom-color:transparent;}",
		".f1d6v5y2:hover:active{color:var(--colorNeutralForegroundOnBrand);}",
		".f1t94bn6:hover{background-color:var(--colorSubtleBackgroundHover);}",
		".fnwyq0v:hover{color:var(--colorNeutralForeground2Hover);}",
		".ft1hn21:hover .fui-Icon-filled{display:inline;}",
		".fuxngvv:hover .fui-Icon-regular{display:none;}",
		".fy5bs14:hover .fui-Button__icon{color:var(--colorNeutralForeground2BrandHover);}",
		".fsv2rcd:hover:active{background-color:var(--colorSubtleBackgroundPressed);}",
		".f1omzyqd:hover:active{color:var(--colorNeutralForeground2Pressed);}",
		".f1dfjoow:hover:active .fui-Icon-filled{display:inline;}",
		".f1j98vj9:hover:active .fui-Icon-regular{display:none;}",
		".fj8yq94:hover:active .fui-Button__icon{color:var(--colorNeutralForeground2BrandPressed);}",
		".f139oj5f:hover{color:var(--colorNeutralForeground2BrandHover);}",
		".f1fg1p5m:hover:active{color:var(--colorNeutralForeground2BrandPressed);}"
	],
	m: [
		["@media (forced-colors: active){.f1nz3ub2{background-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fag2qd2{border-top-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f14bpyus{border-left-color:HighlightText;}.fmvhcg7{border-right-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1o3dhpw{border-bottom-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fqc85l4{color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1h3a8gf{forced-color-adjust:none;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fkiggi6:hover{background-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f8gmj8i:hover{border-top-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1ap8nzx:hover{border-right-color:Highlight;}.fjag8bx:hover{border-left-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1igan7k:hover{border-bottom-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1v3eptx:hover{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fpelvsg:hover:active{background-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1r9enuy:hover:active{border-top-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1grx941:hover:active{border-left-color:Highlight;}.fdvt4n0:hover:active{border-right-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1l34yyb:hover:active{border-bottom-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fqfbdvs:hover:active{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fivsta0:hover .fui-Button__icon{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1wfsnb3:hover:active .fui-Button__icon{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fxoo9op:hover{background-color:var(--colorTransparentBackground);}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f11slz88:hover:active{background-color:var(--colorTransparentBackground);}}", { m: "(forced-colors: active)" }]
	]
});
var useRootDisabledStyles$1 = /* @__PURE__ */ __styles({
	base: {
		De3pzq: "f1bg9a2p",
		g2u3we: "f1jj8ep1",
		h3c5rm: ["f15xbau", "fy0fskl"],
		B9xav0g: "f4ikngz",
		zhjwy3: ["fy0fskl", "f15xbau"],
		sj55zd: "f1s2aq7o",
		Bceei9c: "fdrzuqr",
		Bfinmwp: "f15x8b5r",
		Jwef8y: "f1falr9n",
		Bgoe8wy: "f12mpcsy",
		Bwzppfd: ["f1gwvigk", "f18rmfxp"],
		oetu4i: "f1jnshp0",
		gg5e9n: ["f18rmfxp", "f1gwvigk"],
		Bi91k9c: "fvgxktp",
		eoavqd: "fphbwmw",
		Bk3fhr4: "f19vpps7",
		Bmfj8id: "fv5swzo",
		Bbdnnc7: "f1al02dq",
		iro3zm: "f1t6o4dc",
		b661bw: "f10ztigi",
		Bk6r4ia: ["f1ft5sdu", "f1gzf82w"],
		B9zn80p: "f12zbtn2",
		Bpld233: ["f1gzf82w", "f1ft5sdu"],
		B2d53fq: "fcvwxyo",
		c3iz72: "f8w4c43",
		em6i61: "f1ol4fw6",
		vm6p8p: "f1q1lw4e",
		x3br3k: "f1dwjv2g"
	},
	highContrast: {
		By8wz76: "f14ptb23",
		Bcq6wej: "f9dbb4x",
		Jcjdmf: ["f3qs60o", "f5u9ap2"],
		sc4o1m: "fwd1oij",
		Bosien3: ["f5u9ap2", "f3qs60o"],
		B7iucu3: "f1cyfu5x",
		Grqk0h: "f127ot8j",
		h3ptyc: "f19etb0b",
		Buw724y: ["f4f984j", "fw441p0"],
		Buk7464: "f3d22hf",
		Hwei09: ["fw441p0", "f4f984j"],
		Bbkh6qg: "fj8k9ua",
		F230oe: "fifrq0d",
		Bdw8ktp: ["f196mwp7", "fnekfq"],
		Bj1xduy: "f1l6uprw",
		Bhh2cfd: ["fnekfq", "f196mwp7"],
		Bahaeuw: "fa9u7a5",
		Buhizc3: "f1m71e0y",
		rxnm8d: "f1xxg0vq",
		Bso50sa: "f16oldlo",
		B65bq0w: ["f17g64ui", "fqbrke7"],
		Buont6p: "fjvf891",
		B0o9ejx: ["fqbrke7", "f17g64ui"],
		Dcq74g: "f1efp33f",
		zyxd5v: "f1gue8i"
	},
	outline: {
		De3pzq: "f1c21dwh",
		Jwef8y: "f9ql6rf",
		iro3zm: "f3h1zc4"
	},
	primary: {
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	},
	secondary: {},
	subtle: {
		De3pzq: "f1c21dwh",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Jwef8y: "f9ql6rf",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		iro3zm: "f3h1zc4",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	},
	transparent: {
		De3pzq: "f1c21dwh",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Jwef8y: "f9ql6rf",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		iro3zm: "f3h1zc4",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	}
}, {
	d: [
		".f1bg9a2p{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
		".fdrzuqr{cursor:not-allowed;}",
		".f15x8b5r .fui-Button__icon{color:var(--colorNeutralForegroundDisabled);}",
		".f1c21dwh{background-color:var(--colorTransparentBackground);}",
		".f1p3nwhy{border-top-color:transparent;}",
		".f11589ue{border-right-color:transparent;}",
		".f1pdflbu{border-left-color:transparent;}",
		".f1q5o8ev{border-bottom-color:transparent;}"
	],
	h: [
		".f1falr9n:hover{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f12mpcsy:hover{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f1gwvigk:hover{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".f18rmfxp:hover{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f1jnshp0:hover{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".fvgxktp:hover{color:var(--colorNeutralForegroundDisabled);}",
		".fphbwmw:hover{cursor:not-allowed;}",
		".f19vpps7:hover .fui-Icon-filled{display:none;}",
		".fv5swzo:hover .fui-Icon-regular{display:inline;}",
		".f1al02dq:hover .fui-Button__icon{color:var(--colorNeutralForegroundDisabled);}",
		".f1t6o4dc:hover:active{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f10ztigi:hover:active{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f1ft5sdu:hover:active{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".f1gzf82w:hover:active{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f12zbtn2:hover:active{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".fcvwxyo:hover:active{color:var(--colorNeutralForegroundDisabled);}",
		".f8w4c43:hover:active{cursor:not-allowed;}",
		".f1ol4fw6:hover:active .fui-Icon-filled{display:none;}",
		".f1q1lw4e:hover:active .fui-Icon-regular{display:inline;}",
		".f1dwjv2g:hover:active .fui-Button__icon{color:var(--colorNeutralForegroundDisabled);}",
		".f9ql6rf:hover{background-color:var(--colorTransparentBackground);}",
		".f3h1zc4:hover:active{background-color:var(--colorTransparentBackground);}",
		".f1s2uweq:hover{border-top-color:transparent;}",
		".fr80ssc:hover{border-right-color:transparent;}",
		".fecsdlb:hover{border-left-color:transparent;}",
		".f1ukrpxl:hover{border-bottom-color:transparent;}",
		".f1h0usnq:hover:active{border-top-color:transparent;}",
		".fs4ktlq:hover:active{border-right-color:transparent;}",
		".fx2bmrt:hover:active{border-left-color:transparent;}",
		".f16h9ulv:hover:active{border-bottom-color:transparent;}"
	],
	m: [
		["@media (forced-colors: active){.f14ptb23{background-color:ButtonFace;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f9dbb4x{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f3qs60o{border-right-color:GrayText;}.f5u9ap2{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fwd1oij{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1cyfu5x{color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f127ot8j .fui-Button__icon{color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f19etb0b:focus{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f4f984j:focus{border-right-color:GrayText;}.fw441p0:focus{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f3d22hf:focus{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fj8k9ua:hover{background-color:ButtonFace;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fifrq0d:hover{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f196mwp7:hover{border-right-color:GrayText;}.fnekfq:hover{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1l6uprw:hover{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fa9u7a5:hover{color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1m71e0y:hover .fui-Button__icon{color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1xxg0vq:hover:active{background-color:ButtonFace;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f16oldlo:hover:active{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f17g64ui:hover:active{border-right-color:GrayText;}.fqbrke7:hover:active{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fjvf891:hover:active{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1efp33f:hover:active{color:GrayText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1gue8i:hover:active .fui-Button__icon{color:GrayText;}}", { m: "(forced-colors: active)" }]
	]
});
var useRootFocusStyles = /* @__PURE__ */ __styles({
	circular: {
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "f1062rbf"
	},
	rounded: {},
	square: {
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "fj0ryk1"
	},
	primary: {
		B8q5s1w: "f17t0x8g",
		Bci5o5g: ["f194v5ow", "fk7jm04"],
		n8qw10: "f1qgg65p",
		Bdrgwmp: ["fk7jm04", "f194v5ow"],
		j6ew2k: ["fhgccpy", "fjo7pq6"],
		he4mth: "f32wu9k",
		Byr4aka: "fu5nqqq",
		lks7q5: ["f13prjl2", "f1nl83rv"],
		Bnan3qt: "f1czftr5",
		k1dn9: ["f1nl83rv", "f13prjl2"],
		Bqsb82s: ["fixhny3", "f18mfu3r"],
		jg1oma: "feygou5"
	},
	small: {
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "fazmxh"
	},
	medium: {},
	large: {
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "f1b6alqh"
	}
}, {
	d: [
		[".f1062rbf[data-fui-focus-visible]{border-radius:var(--borderRadiusCircular);}", { p: -1 }],
		[".fj0ryk1[data-fui-focus-visible]{border-radius:var(--borderRadiusNone);}", { p: -1 }],
		".f17t0x8g[data-fui-focus-visible]{border-top-color:var(--colorStrokeFocus2);}",
		".f194v5ow[data-fui-focus-visible]{border-right-color:var(--colorStrokeFocus2);}",
		".fk7jm04[data-fui-focus-visible]{border-left-color:var(--colorStrokeFocus2);}",
		".f1qgg65p[data-fui-focus-visible]{border-bottom-color:var(--colorStrokeFocus2);}",
		".fhgccpy[data-fui-focus-visible]{box-shadow:var(--shadow2),0 0 0 var(--strokeWidthThin) var(--colorStrokeFocus2) inset,0 0 0 var(--strokeWidthThick) var(--colorNeutralForegroundOnBrand) inset;}",
		".fjo7pq6[data-fui-focus-visible]{box-shadow:var(--shadow2),0 0 0 var(--strokeWidthThin) var(--colorStrokeFocus2) inset,0 0 0 var(--strokeWidthThick) var(--colorNeutralForegroundOnBrand) inset;}",
		".f32wu9k[data-fui-focus-visible]:hover{box-shadow:var(--shadow2),0 0 0 var(--strokeWidthThin) var(--colorStrokeFocus2) inset;}",
		".fu5nqqq[data-fui-focus-visible]:hover{border-top-color:var(--colorStrokeFocus2);}",
		".f13prjl2[data-fui-focus-visible]:hover{border-right-color:var(--colorStrokeFocus2);}",
		".f1nl83rv[data-fui-focus-visible]:hover{border-left-color:var(--colorStrokeFocus2);}",
		".f1czftr5[data-fui-focus-visible]:hover{border-bottom-color:var(--colorStrokeFocus2);}",
		[".fazmxh[data-fui-focus-visible]{border-radius:var(--borderRadiusSmall);}", { p: -1 }],
		[".f1b6alqh[data-fui-focus-visible]{border-radius:var(--borderRadiusLarge);}", { p: -1 }]
	],
	t: ["@supports (-moz-appearance:button){.f18mfu3r[data-fui-focus-visible]{box-shadow:var(--shadow2),0 0 0 calc(var(--strokeWidthThin) + 0.25px) var(--colorStrokeFocus2) inset,0 0 0 var(--strokeWidthThick) var(--colorNeutralForegroundOnBrand) inset;}.fixhny3[data-fui-focus-visible]{box-shadow:var(--shadow2),0 0 0 calc(var(--strokeWidthThin) + 0.25px) var(--colorStrokeFocus2) inset,0 0 0 var(--strokeWidthThick) var(--colorNeutralForegroundOnBrand) inset;}}", "@supports (-moz-appearance:button){.feygou5[data-fui-focus-visible]:hover{box-shadow:var(--shadow2),0 0 0 calc(var(--strokeWidthThin) + 0.25px) var(--colorStrokeFocus2) inset;}}"]
});
var useRootIconOnlyStyles = /* @__PURE__ */ __styles({
	small: {
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "fu97m5z",
		Bf4jedk: "f17fgpbq",
		B2u0y6b: "f1jt17bm"
	},
	medium: {
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f18ktai2",
		Bf4jedk: "fwbmr0d",
		B2u0y6b: "f44c6la"
	},
	large: {
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f1hbd1aw",
		Bf4jedk: "f12clzc2",
		B2u0y6b: "fjy1crr"
	}
}, { d: [
	[".fu97m5z{padding:1px;}", { p: -1 }],
	".f17fgpbq{min-width:24px;}",
	".f1jt17bm{max-width:24px;}",
	[".f18ktai2{padding:5px;}", { p: -1 }],
	".fwbmr0d{min-width:32px;}",
	".f44c6la{max-width:32px;}",
	[".f1hbd1aw{padding:7px;}", { p: -1 }],
	".f12clzc2{min-width:40px;}",
	".fjy1crr{max-width:40px;}"
] });
var useIconStyles = /* @__PURE__ */ __styles({
	small: {
		Be2twd7: "fe5j1ua",
		Bqenvij: "fjamq6b",
		a9b677: "f64fuq3",
		Bqrlyyl: "fbaiahx"
	},
	medium: {},
	large: {
		Be2twd7: "f1rt2boy",
		Bqenvij: "frvgh55",
		a9b677: "fq4mcun",
		Bqrlyyl: "f1exjqw5"
	},
	before: { t21cq0: ["f1nizpg2", "f1a695kz"] },
	after: { Frg6f3: ["f1a695kz", "f1nizpg2"] }
}, { d: [
	".fe5j1ua{font-size:20px;}",
	".fjamq6b{height:20px;}",
	".f64fuq3{width:20px;}",
	".fbaiahx{--fui-Button__icon--spacing:var(--spacingHorizontalXS);}",
	".f1rt2boy{font-size:24px;}",
	".frvgh55{height:24px;}",
	".fq4mcun{width:24px;}",
	".f1exjqw5{--fui-Button__icon--spacing:var(--spacingHorizontalSNudge);}",
	".f1nizpg2{margin-right:var(--fui-Button__icon--spacing);}",
	".f1a695kz{margin-left:var(--fui-Button__icon--spacing);}"
] });
const useButtonStyles_unstable = (state) => {
	"use no memo";
	const rootBaseClassName = useRootBaseClassName();
	const iconBaseClassName = useIconBaseClassName();
	const rootStyles = useRootStyles();
	const rootDisabledStyles = useRootDisabledStyles$1();
	const rootFocusStyles = useRootFocusStyles();
	const rootIconOnlyStyles = useRootIconOnlyStyles();
	const iconStyles = useIconStyles();
	const { appearance, disabled, disabledFocusable, icon, iconOnly, iconPosition, shape, size: size$2 } = state;
	state.root.className = mergeClasses(buttonClassNames.root, rootBaseClassName, appearance && rootStyles[appearance], rootStyles[size$2], icon && size$2 === "small" && rootStyles.smallWithIcon, icon && size$2 === "large" && rootStyles.largeWithIcon, rootStyles[shape], (disabled || disabledFocusable) && rootDisabledStyles.base, (disabled || disabledFocusable) && rootDisabledStyles.highContrast, appearance && (disabled || disabledFocusable) && rootDisabledStyles[appearance], appearance === "primary" && rootFocusStyles.primary, rootFocusStyles[size$2], rootFocusStyles[shape], iconOnly && rootIconOnlyStyles[size$2], state.root.className);
	if (state.icon) state.icon.className = mergeClasses(buttonClassNames.icon, iconBaseClassName, !!state.root.children && iconStyles[iconPosition], iconStyles[size$2], state.icon.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-button/lib/utils/useToggleState.js
function useToggleState(props, state) {
	const { checked, defaultChecked, disabled, disabledFocusable } = props;
	const { onClick, role } = state.root;
	const [checkedValue, setCheckedValue] = useControllableState({
		state: checked,
		defaultState: defaultChecked,
		initialState: false
	});
	const isCheckboxTypeRole = role === "menuitemcheckbox" || role === "checkbox";
	const onToggleClick = import_react.useCallback((ev) => {
		if (!disabled && !disabledFocusable) {
			if (ev.defaultPrevented) return;
			setCheckedValue(!checkedValue);
		}
	}, [
		checkedValue,
		disabled,
		disabledFocusable,
		setCheckedValue
	]);
	return {
		...state,
		checked: checkedValue,
		root: {
			...state.root,
			[isCheckboxTypeRole ? "aria-checked" : "aria-pressed"]: checkedValue,
			onClick: useEventCallback(mergeCallbacks(onClick, onToggleClick))
		}
	};
}

//#endregion
//#region node_modules/@fluentui/react-button/lib/components/ToggleButton/useToggleButton.js
/**
* Given user props, defines default props for the ToggleButton, calls useButtonState and useChecked, and returns
* processed state.
* @param props - User provided props to the ToggleButton component.
* @param ref - User provided ref to be passed to the ToggleButton component.
*/ const useToggleButton_unstable = (props, ref) => {
	const buttonState = useButton_unstable(props, ref);
	return useToggleState(props, buttonState);
};

//#endregion
//#region node_modules/@fluentui/react-button/lib/components/ToggleButton/useToggleButtonStyles.styles.js
const toggleButtonClassNames = {
	root: "fui-ToggleButton",
	icon: "fui-ToggleButton__icon"
};
var useRootCheckedStyles = /* @__PURE__ */ __styles({
	base: {
		De3pzq: "f1nfm20t",
		g2u3we: "fj3muxo",
		h3c5rm: ["f1akhkt", "f1lxtadh"],
		B9xav0g: "f1aperda",
		zhjwy3: ["f1lxtadh", "f1akhkt"],
		sj55zd: "f14nttnl",
		B4j52fo: "f192inf7",
		Bekrc4i: ["f5tn483", "f1ojsxk5"],
		Bn0qgzm: "f1vxd6vx",
		ibv6hh: ["f1ojsxk5", "f5tn483"],
		D0sxk3: "fxoiby5",
		t6yez3: "f15q0o9g",
		Jwef8y: "f1knas48",
		Bgoe8wy: "fvcxoqz",
		Bwzppfd: ["f1ub3y4t", "f1m52nbi"],
		oetu4i: "f1xlaoq0",
		gg5e9n: ["f1m52nbi", "f1ub3y4t"],
		Bi91k9c: "feu1g3u",
		iro3zm: "f141de4g",
		b661bw: "f11v6sdu",
		Bk6r4ia: ["f9yn8i4", "f1ajwf28"],
		B9zn80p: "f1uwu36w",
		Bpld233: ["f1ajwf28", "f9yn8i4"],
		B2d53fq: "f9olfzr"
	},
	highContrast: {
		By8wz76: "f1nz3ub2",
		Bcq6wej: "fjq791v",
		Jcjdmf: ["fkq2p2y", "f1sehlss"],
		sc4o1m: "f11odvng",
		Bosien3: ["f1sehlss", "fkq2p2y"],
		B7iucu3: "fqc85l4",
		B8gzw0y: "f1h3a8gf",
		Bbkh6qg: "fkiggi6",
		F230oe: "f8gmj8i",
		Bdw8ktp: ["f1ap8nzx", "fjag8bx"],
		Bj1xduy: "f1igan7k",
		Bhh2cfd: ["fjag8bx", "f1ap8nzx"],
		Bahaeuw: "f1v3eptx",
		rxnm8d: "fpelvsg",
		Bso50sa: "f1r9enuy",
		B65bq0w: ["fdvt4n0", "f1grx941"],
		Buont6p: "f1l34yyb",
		B0o9ejx: ["f1grx941", "fdvt4n0"],
		Dcq74g: "fqfbdvs",
		B6rz4yo: 0,
		Buk7464: 0,
		Bqg8rp8: 0,
		pjr8j7: 0,
		Bgs2klq: 0,
		Hwei09: 0,
		Bi9aqk7: 0,
		Fihjvf: 0,
		nhyz0p: 0,
		Buw724y: 0,
		Bn7qjfh: 0,
		B0u7xl9: 0,
		md97jv: 0,
		h3ptyc: 0,
		s1kvfj: 0,
		kogrdj: 0,
		dqx2i2: "fdmpsdn",
		o0nolc: "fgjsukj"
	},
	outline: {
		De3pzq: "f1q9pm1r",
		g2u3we: "fj3muxo",
		h3c5rm: ["f1akhkt", "f1lxtadh"],
		B9xav0g: "f1aperda",
		zhjwy3: ["f1lxtadh", "f1akhkt"],
		B4j52fo: "fgx37oo",
		Bekrc4i: ["f130t4y6", "f1efpmoh"],
		Bn0qgzm: "fv51ejd",
		ibv6hh: ["f1efpmoh", "f130t4y6"],
		Jwef8y: "fjxutwb",
		iro3zm: "fwiml72",
		B8q5s1w: "fcaw57c",
		Bci5o5g: ["fpwd27e", "f1999bjr"],
		n8qw10: "f1hi52o4",
		Bdrgwmp: ["f1999bjr", "fpwd27e"]
	},
	primary: {
		De3pzq: "f8w4g0q",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "f1phragk",
		Jwef8y: "f15wkkf3",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "f1rq72xc",
		iro3zm: "fnp9lpt",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1d6v5y2"
	},
	secondary: {},
	subtle: {
		De3pzq: "fq5gl1p",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "f1eryozh",
		Jwef8y: "f1t94bn6",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "fnwyq0v",
		iro3zm: "fsv2rcd",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1omzyqd"
	},
	transparent: {
		De3pzq: "f1q9pm1r",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		sj55zd: "f1qj7y59",
		Jwef8y: "fjxutwb",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		Bi91k9c: "f139oj5f",
		iro3zm: "fwiml72",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"],
		B2d53fq: "f1fg1p5m"
	}
}, {
	d: [
		".f1nfm20t{background-color:var(--colorNeutralBackground1Selected);}",
		".fj3muxo{border-top-color:var(--colorNeutralStroke1);}",
		".f1akhkt{border-right-color:var(--colorNeutralStroke1);}",
		".f1lxtadh{border-left-color:var(--colorNeutralStroke1);}",
		".f1aperda{border-bottom-color:var(--colorNeutralStroke1);}",
		".f14nttnl{color:var(--colorNeutralForeground1Selected);}",
		".f192inf7{border-top-width:var(--strokeWidthThin);}",
		".f5tn483{border-right-width:var(--strokeWidthThin);}",
		".f1ojsxk5{border-left-width:var(--strokeWidthThin);}",
		".f1vxd6vx{border-bottom-width:var(--strokeWidthThin);}",
		".fxoiby5 .fui-Icon-filled{display:inline;}",
		".f15q0o9g .fui-Icon-regular{display:none;}",
		".f1q9pm1r{background-color:var(--colorTransparentBackgroundSelected);}",
		".fgx37oo{border-top-width:var(--strokeWidthThicker);}",
		".f130t4y6{border-right-width:var(--strokeWidthThicker);}",
		".f1efpmoh{border-left-width:var(--strokeWidthThicker);}",
		".fv51ejd{border-bottom-width:var(--strokeWidthThicker);}",
		".fcaw57c[data-fui-focus-visible]{border-top-color:var(--colorNeutralStroke1);}",
		".fpwd27e[data-fui-focus-visible]{border-right-color:var(--colorNeutralStroke1);}",
		".f1999bjr[data-fui-focus-visible]{border-left-color:var(--colorNeutralStroke1);}",
		".f1hi52o4[data-fui-focus-visible]{border-bottom-color:var(--colorNeutralStroke1);}",
		".f8w4g0q{background-color:var(--colorBrandBackgroundSelected);}",
		".f1p3nwhy{border-top-color:transparent;}",
		".f11589ue{border-right-color:transparent;}",
		".f1pdflbu{border-left-color:transparent;}",
		".f1q5o8ev{border-bottom-color:transparent;}",
		".f1phragk{color:var(--colorNeutralForegroundOnBrand);}",
		".fq5gl1p{background-color:var(--colorSubtleBackgroundSelected);}",
		".f1eryozh{color:var(--colorNeutralForeground2Selected);}",
		".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}"
	],
	h: [
		".f1knas48:hover{background-color:var(--colorNeutralBackground1Hover);}",
		".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}",
		".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}",
		".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}",
		".f1xlaoq0:hover{border-bottom-color:var(--colorNeutralStroke1Hover);}",
		".feu1g3u:hover{color:var(--colorNeutralForeground1Hover);}",
		".f141de4g:hover:active{background-color:var(--colorNeutralBackground1Pressed);}",
		".f11v6sdu:hover:active{border-top-color:var(--colorNeutralStroke1Pressed);}",
		".f9yn8i4:hover:active{border-right-color:var(--colorNeutralStroke1Pressed);}",
		".f1ajwf28:hover:active{border-left-color:var(--colorNeutralStroke1Pressed);}",
		".f1uwu36w:hover:active{border-bottom-color:var(--colorNeutralStroke1Pressed);}",
		".f9olfzr:hover:active{color:var(--colorNeutralForeground1Pressed);}",
		".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}",
		".fwiml72:hover:active{background-color:var(--colorTransparentBackgroundPressed);}",
		".f15wkkf3:hover{background-color:var(--colorBrandBackgroundHover);}",
		".f1s2uweq:hover{border-top-color:transparent;}",
		".fr80ssc:hover{border-right-color:transparent;}",
		".fecsdlb:hover{border-left-color:transparent;}",
		".f1ukrpxl:hover{border-bottom-color:transparent;}",
		".f1rq72xc:hover{color:var(--colorNeutralForegroundOnBrand);}",
		".fnp9lpt:hover:active{background-color:var(--colorBrandBackgroundPressed);}",
		".f1h0usnq:hover:active{border-top-color:transparent;}",
		".fs4ktlq:hover:active{border-right-color:transparent;}",
		".fx2bmrt:hover:active{border-left-color:transparent;}",
		".f16h9ulv:hover:active{border-bottom-color:transparent;}",
		".f1d6v5y2:hover:active{color:var(--colorNeutralForegroundOnBrand);}",
		".f1t94bn6:hover{background-color:var(--colorSubtleBackgroundHover);}",
		".fnwyq0v:hover{color:var(--colorNeutralForeground2Hover);}",
		".fsv2rcd:hover:active{background-color:var(--colorSubtleBackgroundPressed);}",
		".f1omzyqd:hover:active{color:var(--colorNeutralForeground2Pressed);}",
		".f139oj5f:hover{color:var(--colorNeutralForeground2BrandHover);}",
		".f1fg1p5m:hover:active{color:var(--colorNeutralForeground2BrandPressed);}"
	],
	m: [
		["@media (forced-colors: active){.f1nz3ub2{background-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fjq791v{border-top-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1sehlss{border-left-color:Highlight;}.fkq2p2y{border-right-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f11odvng{border-bottom-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fqc85l4{color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1h3a8gf{forced-color-adjust:none;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fkiggi6:hover{background-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f8gmj8i:hover{border-top-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1ap8nzx:hover{border-right-color:Highlight;}.fjag8bx:hover{border-left-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1igan7k:hover{border-bottom-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1v3eptx:hover{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fpelvsg:hover:active{background-color:HighlightText;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1r9enuy:hover:active{border-top-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1grx941:hover:active{border-left-color:Highlight;}.fdvt4n0:hover:active{border-right-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.f1l34yyb:hover:active{border-bottom-color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fqfbdvs:hover:active{color:Highlight;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fdmpsdn:focus{border:1px solid HighlightText;}}", {
			p: -2,
			m: "(forced-colors: active)"
		}],
		["@media (forced-colors: active){.fgjsukj:focus{outline-color:Highlight;}}", { m: "(forced-colors: active)" }]
	]
});
var useRootDisabledStyles = /* @__PURE__ */ __styles({
	base: {
		De3pzq: "f1bg9a2p",
		g2u3we: "f1jj8ep1",
		h3c5rm: ["f15xbau", "fy0fskl"],
		B9xav0g: "f4ikngz",
		zhjwy3: ["fy0fskl", "f15xbau"],
		sj55zd: "f1s2aq7o",
		Jwef8y: "f1falr9n",
		Bgoe8wy: "f12mpcsy",
		Bwzppfd: ["f1gwvigk", "f18rmfxp"],
		oetu4i: "f1jnshp0",
		gg5e9n: ["f18rmfxp", "f1gwvigk"],
		Bi91k9c: "fvgxktp",
		iro3zm: "f1t6o4dc",
		b661bw: "f10ztigi",
		Bk6r4ia: ["f1ft5sdu", "f1gzf82w"],
		B9zn80p: "f12zbtn2",
		Bpld233: ["f1gzf82w", "f1ft5sdu"],
		B2d53fq: "fcvwxyo"
	},
	outline: {},
	primary: {
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	},
	secondary: {},
	subtle: {
		De3pzq: "f1c21dwh",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Jwef8y: "fjxutwb",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		iro3zm: "fwiml72",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	},
	transparent: {
		De3pzq: "f1c21dwh",
		g2u3we: "f1p3nwhy",
		h3c5rm: ["f11589ue", "f1pdflbu"],
		B9xav0g: "f1q5o8ev",
		zhjwy3: ["f1pdflbu", "f11589ue"],
		Jwef8y: "fjxutwb",
		Bgoe8wy: "f1s2uweq",
		Bwzppfd: ["fr80ssc", "fecsdlb"],
		oetu4i: "f1ukrpxl",
		gg5e9n: ["fecsdlb", "fr80ssc"],
		iro3zm: "fwiml72",
		b661bw: "f1h0usnq",
		Bk6r4ia: ["fs4ktlq", "fx2bmrt"],
		B9zn80p: "f16h9ulv",
		Bpld233: ["fx2bmrt", "fs4ktlq"]
	}
}, {
	d: [
		".f1bg9a2p{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
		".f1p3nwhy{border-top-color:transparent;}",
		".f11589ue{border-right-color:transparent;}",
		".f1pdflbu{border-left-color:transparent;}",
		".f1q5o8ev{border-bottom-color:transparent;}",
		".f1c21dwh{background-color:var(--colorTransparentBackground);}"
	],
	h: [
		".f1falr9n:hover{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f12mpcsy:hover{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f1gwvigk:hover{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".f18rmfxp:hover{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f1jnshp0:hover{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".fvgxktp:hover{color:var(--colorNeutralForegroundDisabled);}",
		".f1t6o4dc:hover:active{background-color:var(--colorNeutralBackgroundDisabled);}",
		".f10ztigi:hover:active{border-top-color:var(--colorNeutralStrokeDisabled);}",
		".f1ft5sdu:hover:active{border-right-color:var(--colorNeutralStrokeDisabled);}",
		".f1gzf82w:hover:active{border-left-color:var(--colorNeutralStrokeDisabled);}",
		".f12zbtn2:hover:active{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
		".fcvwxyo:hover:active{color:var(--colorNeutralForegroundDisabled);}",
		".f1s2uweq:hover{border-top-color:transparent;}",
		".fr80ssc:hover{border-right-color:transparent;}",
		".fecsdlb:hover{border-left-color:transparent;}",
		".f1ukrpxl:hover{border-bottom-color:transparent;}",
		".f1h0usnq:hover:active{border-top-color:transparent;}",
		".fs4ktlq:hover:active{border-right-color:transparent;}",
		".fx2bmrt:hover:active{border-left-color:transparent;}",
		".f16h9ulv:hover:active{border-bottom-color:transparent;}",
		".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}",
		".fwiml72:hover:active{background-color:var(--colorTransparentBackgroundPressed);}"
	]
});
var useIconCheckedStyles = /* @__PURE__ */ __styles({
	subtleOrTransparent: { sj55zd: "f1qj7y59" },
	highContrast: { B8gzw0y: "f1dd5bof" }
}, {
	d: [".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}"],
	m: [["@media (forced-colors: active){.f1dd5bof{forced-color-adjust:auto;}}", { m: "(forced-colors: active)" }]]
});
var usePrimaryHighContrastStyles = /* @__PURE__ */ __styles({
	base: {
		By8wz76: "f14ptb23",
		Bcq6wej: "fd7znuh",
		Jcjdmf: ["f1wh4a04", "f15h7fac"],
		sc4o1m: "f1f064oi",
		Bosien3: ["f15h7fac", "f1wh4a04"],
		B7iucu3: "f3ggph1",
		B8gzw0y: "f1dd5bof"
	},
	disabled: {
		Bcq6wej: "f9dbb4x",
		Jcjdmf: ["f3qs60o", "f5u9ap2"],
		sc4o1m: "fwd1oij",
		Bosien3: ["f5u9ap2", "f3qs60o"],
		B7iucu3: "f1cyfu5x",
		h3ptyc: "f19etb0b",
		Buw724y: ["f4f984j", "fw441p0"],
		Buk7464: "f3d22hf",
		Hwei09: ["fw441p0", "f4f984j"]
	}
}, { m: [
	["@media (forced-colors: active){.f14ptb23{background-color:ButtonFace;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.fd7znuh{border-top-color:ButtonBorder;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f15h7fac{border-left-color:ButtonBorder;}.f1wh4a04{border-right-color:ButtonBorder;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f1f064oi{border-bottom-color:ButtonBorder;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f3ggph1{color:ButtonText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f1dd5bof{forced-color-adjust:auto;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f9dbb4x{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f3qs60o{border-right-color:GrayText;}.f5u9ap2{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.fwd1oij{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f1cyfu5x{color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f19etb0b:focus{border-top-color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f4f984j:focus{border-right-color:GrayText;}.fw441p0:focus{border-left-color:GrayText;}}", { m: "(forced-colors: active)" }],
	["@media (forced-colors: active){.f3d22hf:focus{border-bottom-color:GrayText;}}", { m: "(forced-colors: active)" }]
] });
const useToggleButtonStyles_unstable = (state) => {
	"use no memo";
	const rootCheckedStyles = useRootCheckedStyles();
	const rootDisabledStyles = useRootDisabledStyles();
	const iconCheckedStyles = useIconCheckedStyles();
	const primaryHighContrastStyles = usePrimaryHighContrastStyles();
	const { appearance, checked, disabled, disabledFocusable } = state;
	state.root.className = mergeClasses(toggleButtonClassNames.root, appearance === "primary" && primaryHighContrastStyles.base, appearance === "primary" && (disabled || disabledFocusable) && primaryHighContrastStyles.disabled, checked && rootCheckedStyles.base, checked && rootCheckedStyles.highContrast, appearance && checked && rootCheckedStyles[appearance], (disabled || disabledFocusable) && rootDisabledStyles.base, appearance && (disabled || disabledFocusable) && rootDisabledStyles[appearance], state.root.className);
	if (state.icon) state.icon.className = mergeClasses(toggleButtonClassNames.icon, checked && (appearance === "subtle" || appearance === "transparent") && iconCheckedStyles.subtleOrTransparent, iconCheckedStyles.highContrast, state.icon.className);
	useButtonStyles_unstable(state);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-context-selector/lib/createContext.js
var import_scheduler = /* @__PURE__ */ __toESM(require_scheduler());
var createProvider = (Original) => {
	const Provider$1 = (props) => {
		const valueRef = import_react.useRef(props.value);
		const versionRef = import_react.useRef(0);
		const contextValue = import_react.useRef(null);
		if (!contextValue.current) contextValue.current = {
			value: valueRef,
			version: versionRef,
			listeners: []
		};
		useIsomorphicLayoutEffect(() => {
			valueRef.current = props.value;
			versionRef.current += 1;
			(0, import_scheduler.unstable_runWithPriority)(import_scheduler.unstable_NormalPriority, () => {
				contextValue.current.listeners.forEach((listener) => {
					listener([versionRef.current, props.value]);
				});
			});
		}, [props.value]);
		return import_react.createElement(Original, { value: contextValue.current }, props.children);
	};
	Provider$1.displayName = "ContextSelector.Provider";
	return Provider$1;
};
/**
* @internal
*/ const createContext = (defaultValue) => {
	const context = import_react.createContext({
		value: { current: defaultValue },
		version: { current: -1 },
		listeners: []
	});
	context.Provider = createProvider(context.Provider);
	delete context.Consumer;
	return context;
};

//#endregion
//#region node_modules/@fluentui/react-context-selector/lib/useContextSelector.js
/**
* @internal
* This hook returns context selected value by selector.
* It will only accept context created by `createContext`.
* It will trigger re-render if only the selected value is referentially changed.
*/ const useContextSelector = (context, selector) => {
	const { value: { current: value }, version: { current: version }, listeners } = import_react.useContext(context);
	const selected = selector(value);
	const [state, setState] = import_react.useState([value, selected]);
	const dispatch = (payload) => {
		setState((prevState) => {
			if (!payload) return [value, selected];
			if (payload[0] <= version) {
				if (Object.is(prevState[1], selected)) return prevState;
				return [value, selected];
			}
			try {
				if (Object.is(prevState[0], payload[1])) return prevState;
				const nextSelected = selector(payload[1]);
				if (Object.is(prevState[1], nextSelected)) return prevState;
				return [payload[1], nextSelected];
			} catch (e) {}
			return [prevState[0], prevState[1]];
		});
	};
	if (!Object.is(state[1], selected)) dispatch(void 0);
	const stableDispatch = useEventCallback(dispatch);
	useIsomorphicLayoutEffect(() => {
		listeners.push(stableDispatch);
		return () => {
			const index = listeners.indexOf(stableDispatch);
			listeners.splice(index, 1);
		};
	}, [stableDispatch, listeners]);
	return state[1];
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselContext.js
const carouselContextDefaultValue = {
	activeIndex: 0,
	selectPageByElement: () => {
		return 0;
	},
	selectPageByDirection: () => {
		return 0;
	},
	selectPageByIndex: () => {
		/** noop */	},
	subscribeForValues: () => () => {
		/** noop */	},
	enableAutoplay: () => {
		/** noop */	},
	resetAutoplay: () => {
		/** noop */	},
	circular: false,
	containerRef: void 0,
	viewportRef: void 0
};
var CarouselContext = createContext(void 0);
const CarouselProvider = CarouselContext.Provider;
const useCarouselContext_unstable = (selector) => useContextSelector(CarouselContext, (ctx = carouselContextDefaultValue) => selector(ctx));

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselButton/useCarouselButtonStyles.styles.js
const carouselButtonClassNames = {
	root: "fui-CarouselButton",
	icon: "fui-CarouselButton__icon"
};
/**
* Styles for the root slot
*/
var useStyles$10 = /* @__PURE__ */ __styles({ root: {
	B6of3ja: "fgr6219",
	jrapky: "f10jk5vf",
	sj55zd: "fkfq4zb",
	De3pzq: "fkfdr9r",
	Bkecrkj: "fc5wo7j",
	eoavqd: "f8491dx"
} }, {
	d: [
		".fgr6219{margin-top:auto;}",
		".f10jk5vf{margin-bottom:auto;}",
		".fkfq4zb{color:var(--colorNeutralForeground2);}",
		".fkfdr9r{background-color:var(--colorNeutralBackgroundAlpha);}",
		".fc5wo7j{pointer-events:all;}"
	],
	h: [".f8491dx:hover{cursor:pointer;}"]
});
/**
* Apply styling to the CarouselButton slots based on the state
*/
const useCarouselButtonStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$10();
	state = {
		...state,
		...useButtonStyles_unstable(state)
	};
	state.root.className = mergeClasses(carouselButtonClassNames.root, styles.root, state.root.className);
	if (state.icon) state.icon.className = mergeClasses(carouselButtonClassNames.icon, state.icon.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselButton/useCarouselButton.js
/**
* Create the state required to render CarouselButton.
*
* The returned state can be modified with hooks such as useCarouselButtonStyles_unstable,
* before being passed to renderCarouselButton_unstable.
*
* @param props - props from this instance of CarouselButton
* @param ref - reference to root HTMLDivElement of CarouselButton
*/ const useCarouselButton_unstable = (props, ref) => {
	const { navType = "next" } = props;
	const [totalSlides, setTotalSlides] = import_react.useState(0);
	const { dir } = useFluent();
	const buttonRef = import_react.useRef(void 0);
	const circular = useCarouselContext_unstable((ctx) => ctx.circular);
	const [canLoop, setCanLoop] = import_react.useState(circular);
	const containerRef = useCarouselContext_unstable((ctx) => ctx.containerRef);
	const selectPageByDirection = useCarouselContext_unstable((ctx) => ctx.selectPageByDirection);
	const subscribeForValues = useCarouselContext_unstable((ctx) => ctx.subscribeForValues);
	const resetAutoplay = useCarouselContext_unstable((ctx) => ctx.resetAutoplay);
	const isTrailing = useCarouselContext_unstable((ctx) => {
		if (circular && canLoop) return false;
		if (navType === "prev") return ctx.activeIndex === 0;
		return ctx.activeIndex === totalSlides - 1;
	});
	const handleClick = (event) => {
		if (event.isDefaultPrevented()) return;
		const nextIndex = selectPageByDirection(event, navType);
		let _trailing = false;
		if (navType === "prev") _trailing = nextIndex === 0;
		else _trailing = nextIndex === totalSlides - 1;
		if (!circular && _trailing && (containerRef === null || containerRef === void 0 ? void 0 : containerRef.current)) containerRef.current.querySelectorAll(`.${carouselButtonClassNames.root}`).forEach((_buttonRef) => {
			if (_buttonRef !== buttonRef.current) _buttonRef.focus();
		});
		resetAutoplay();
	};
	useIsomorphicLayoutEffect(() => {
		return subscribeForValues((data) => {
			if (data.canLoop !== void 0) setCanLoop(data.canLoop);
			setTotalSlides(data.navItemsCount);
		});
	}, [subscribeForValues]);
	const nextArrowIcon = dir === "ltr" ? /* @__PURE__ */ import_react.createElement(ChevronRightRegular, null) : /* @__PURE__ */ import_react.createElement(ChevronLeftRegular, null);
	const prevArrowIcon = dir === "ltr" ? /* @__PURE__ */ import_react.createElement(ChevronLeftRegular, null) : /* @__PURE__ */ import_react.createElement(ChevronRightRegular, null);
	return {
		navType,
		...useButton_unstable({
			icon: optional(props.icon, {
				defaultProps: { children: navType === "next" ? nextArrowIcon : prevArrowIcon },
				renderByDefault: true,
				elementType: "span"
			}),
			disabled: isTrailing,
			tabIndex: isTrailing ? -1 : 0,
			"aria-disabled": isTrailing,
			appearance: "subtle",
			...props,
			onClick: useEventCallback(mergeCallbacks(handleClick, props.onClick))
		}, useMergedRefs(ref, buttonRef))
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselButton/renderCarouselButton.js
/**
* Render the final JSX of CarouselButton
*/ const renderCarouselButton_unstable = (state) => {
	assertSlots(state);
	return renderButton_unstable(state);
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselButton/CarouselButton.js
/**
* A default navigation button that will set value to the next/previous page,
* driven by it's type 'next' or 'previous'.
*/ const CarouselButton = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselButton_unstable(props, ref);
	useCarouselButtonStyles_unstable(state);
	useCustomStyleHook("useCarouselButtonStyles_unstable")(state);
	return renderCarouselButton_unstable(state);
});
CarouselButton.displayName = "CarouselButton";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/CarouselNavContext.js
var carouselNavContext = import_react.createContext(void 0);
const carouselNavContextDefaultValue = { appearance: void 0 };
const useCarouselNavContext = () => {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(carouselNavContext)) !== null && _React_useContext !== void 0 ? _React_useContext : carouselNavContextDefaultValue;
};
const CarouselNavContextProvider = carouselNavContext.Provider;
function useCarouselNavContextValues_unstable(state) {
	const { appearance } = state;
	return { carouselNav: import_react.useMemo(() => ({ appearance }), [appearance]) };
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/CarouselNavIndexContext.js
var carouselNavIndexContext = import_react.createContext(void 0);
const carouselNavIndexContextDefaultValue = 0;
const useCarouselNavIndexContext = () => {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(carouselNavIndexContext)) !== null && _React_useContext !== void 0 ? _React_useContext : carouselNavIndexContextDefaultValue;
};
const CarouselNavIndexContextProvider = carouselNavIndexContext.Provider;

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/renderCarouselNav.js
/**
* Render the final JSX of CarouselNav
*/ const renderCarouselNav_unstable = (state, contextValues) => {
	assertSlots(state);
	const { totalSlides, renderNavButton } = state;
	return /* @__PURE__ */ jsx(state.root, { children: /* @__PURE__ */ jsx(CarouselNavContextProvider, {
		value: contextValues.carouselNav,
		children: new Array(totalSlides).fill(null).map((_, index) => /* @__PURE__ */ jsx(CarouselNavIndexContextProvider, {
			value: index,
			children: renderNavButton(index)
		}, index))
	}) });
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/useCarouselNav.js
/**
* Create the state required to render CarouselNav.
*
* The returned state can be modified with hooks such as useCarouselNavStyles_unstable,
* before being passed to renderCarouselNav_unstable.
*
* @param props - props from this instance of CarouselNav
* @param ref - reference to root HTMLDivElement of CarouselNav
*/ const useCarouselNav_unstable = (props, ref) => {
	const { appearance } = props;
	const focusableGroupAttr = useArrowNavigationGroup({
		circular: false,
		axis: "horizontal",
		memorizeCurrent: false,
		unstable_hasDefault: true
	});
	const [totalSlides, setTotalSlides] = useControllableState({
		state: props.totalSlides,
		initialState: 0
	});
	const subscribeForValues = useCarouselContext_unstable((ctx) => ctx.subscribeForValues);
	useIsomorphicLayoutEffect(() => {
		return subscribeForValues((data) => {
			setTotalSlides(data.navItemsCount);
		});
	}, [subscribeForValues, setTotalSlides]);
	return {
		totalSlides,
		appearance,
		renderNavButton: props.children,
		components: { root: "div" },
		root: always(getIntrinsicElementProps("div", {
			ref,
			role: "tablist",
			...props,
			...focusableGroupAttr,
			children: null
		}), { elementType: "div" })
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/useCarouselNavStyles.styles.js
const carouselNavClassNames = { root: "fui-CarouselNav" };
/**
* Styles for the root slot
*/
var useStyles$9 = /* @__PURE__ */ __styles({ root: {
	mc9l5x: "f22iagw",
	Beiy3e4: "f1063pyq",
	Bt984gj: "f122n59",
	Brf1p80: "f4d9j23",
	Bkecrkj: "fc5wo7j",
	Bfpq7zp: 0,
	g9k6zt: 0,
	Bn4voq9: 0,
	giviqs: "f89hs3r",
	Bw81rd7: 0,
	kdpuga: 0,
	dm238s: 0,
	B6xbmo0: 0,
	B3whbx2: "f2krc9w",
	B8q5s1w: "f8hki3x",
	Bci5o5g: ["f1d2448m", "ffh67wi"],
	n8qw10: "f1bjia2o",
	Bdrgwmp: ["ffh67wi", "f1d2448m"],
	Beyfa6y: 0,
	Bbmb7ep: 0,
	Btl43ni: 0,
	B7oj6ja: 0,
	Dimara: "f1kijzfu",
	jrapky: 0,
	Frg6f3: 0,
	t21cq0: 0,
	B6of3ja: 0,
	B74szlk: "fkb7v5e",
	De3pzq: "fkfdr9r"
} }, { d: [
	".f22iagw{display:flex;}",
	".f1063pyq{flex-direction:row;}",
	".f122n59{align-items:center;}",
	".f4d9j23{justify-content:center;}",
	".fc5wo7j{pointer-events:all;}",
	[".f89hs3r[data-fui-focus-visible]{outline:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}", { p: -1 }],
	[".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
	".f8hki3x[data-fui-focus-visible]{border-top-color:transparent;}",
	".f1d2448m[data-fui-focus-visible]{border-right-color:transparent;}",
	".ffh67wi[data-fui-focus-visible]{border-left-color:transparent;}",
	".f1bjia2o[data-fui-focus-visible]{border-bottom-color:transparent;}",
	[".f1kijzfu{border-radius:var(--borderRadiusXLarge);}", { p: -1 }],
	[".fkb7v5e{margin:auto var(--spacingHorizontalS);}", { p: -1 }],
	".fkfdr9r{background-color:var(--colorNeutralBackgroundAlpha);}"
] });
/**
* Apply styling to the CarouselNav slots based on the state
*/
const useCarouselNavStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$9();
	state.root.className = mergeClasses(carouselNavClassNames.root, styles.root, state.root.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNav/CarouselNav.js
/**
* Used to jump to a card based on index, using arrow navigation via Tabster.
*
* The children of this component will be wrapped in a context to
* provide the appropriate value based on their index position.
*/ const CarouselNav = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselNav_unstable(props, ref);
	const contextValues = useCarouselNavContextValues_unstable(state);
	useCarouselNavStyles_unstable(state);
	useCustomStyleHook("useCarouselNavStyles_unstable")(state);
	return renderCarouselNav_unstable(state, contextValues);
});
CarouselNav.displayName = "CarouselNav";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavButton/useCarouselNavButton.js
/**
* Create the state required to render CarouselNavButton.
*
* The returned state can be modified with hooks such as useCarouselNavButtonStyles_unstable,
* before being passed to renderCarouselNavButton_unstable.
*
* @param props - props from this instance of CarouselNavButton
* @param ref - reference to root HTMLDivElement of CarouselNavButton
*/ const useCarouselNavButton_unstable = (props, ref) => {
	const { onClick, as = "button" } = props;
	const { appearance } = useCarouselNavContext();
	const index = useCarouselNavIndexContext();
	const selectPageByIndex = useCarouselContext_unstable((ctx) => ctx.selectPageByIndex);
	const selected = useCarouselContext_unstable((ctx) => ctx.activeIndex === index);
	const subscribeForValues = useCarouselContext_unstable((ctx) => ctx.subscribeForValues);
	const resetAutoplay = useCarouselContext_unstable((ctx) => ctx.resetAutoplay);
	const handleClick = useEventCallback((event) => {
		onClick === null || onClick === void 0 || onClick(event);
		if (!event.defaultPrevented && isHTMLElement(event.target)) selectPageByIndex(event, index);
		resetAutoplay();
	});
	const defaultTabProps = useTabsterAttributes({ focusable: { isDefault: selected } });
	const buttonRef = import_react.useRef(void 0);
	const _carouselButton = always(getIntrinsicElementProps(as, useARIAButtonProps(props.as, props)), {
		elementType: "button",
		defaultProps: {
			ref: useMergedRefs(ref, buttonRef),
			role: "tab",
			type: "button",
			"aria-selected": selected,
			...defaultTabProps
		}
	});
	useIsomorphicLayoutEffect(() => {
		return subscribeForValues((data) => {
			var _data_groupIndexList;
			var _data_groupIndexList_index;
			const _controlledSlideIds = ((_data_groupIndexList_index = (_data_groupIndexList = data.groupIndexList) === null || _data_groupIndexList === void 0 ? void 0 : _data_groupIndexList[index]) !== null && _data_groupIndexList_index !== void 0 ? _data_groupIndexList_index : []).map((slideIndex) => {
				return data.slideNodes[slideIndex].id;
			}).join(" ");
			if (buttonRef.current) buttonRef.current.setAttribute("aria-controls", _controlledSlideIds);
		});
	}, [index, subscribeForValues]);
	_carouselButton.onClick = handleClick;
	return {
		selected,
		appearance,
		components: { root: "button" },
		root: _carouselButton
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavButton/renderCarouselNavButton.js
/**
* Render the final JSX of CarouselNavButton
*/ const renderCarouselNavButton_unstable = (state) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(state.root, {});
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavButton/useCarouselNavButtonStyles.styles.js
const carouselNavButtonClassNames = { root: "fui-CarouselNavButton" };
/**
* Styles for the root slot
*/
var useStyles$8 = /* @__PURE__ */ __styles({
	root: {
		Bceei9c: "f1k6fduh",
		Bkecrkj: "fc5wo7j",
		a9b677: "f1van5z7",
		Bqenvij: "f1fkmctz",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f1f5q0n8",
		B7ck84d: "f1e4lqlz",
		De3pzq: "f1c21dwh",
		B4j52fo: "fre7gi1",
		Bekrc4i: ["f1358rze", "f1rvrf73"],
		Bn0qgzm: "fqdk4by",
		ibv6hh: ["f1rvrf73", "f1358rze"],
		Bsft5z2: "f13zj6fq",
		ap17g6: "f2gz7yw",
		li1rpt: "f1gw3sf2",
		d9w3h3: 0,
		B3778ie: 0,
		B4j8arr: 0,
		Bl18szs: 0,
		Blrzh8d: "f1x820d0",
		Bjuhk93: 0,
		B1q35kw: 0,
		Bw17bha: 0,
		Bcgy8vk: 0,
		Du69r6: 0,
		Gp14am: 0,
		vfts7: 0,
		Bhxzhr1: 0,
		G63luc: 0,
		s924m2: 0,
		Barhvk9: 0,
		Ihftqj: 0,
		wywymt: 0,
		B0n5ga8: 0,
		Bm2nyyq: 0,
		xrcqlc: 0,
		e1d83w: "fnwf5yv",
		Dlnsje: "foue38v",
		a2br6o: "fi4ui2s",
		Bjyk6c5: "f1w4p7kh",
		go7t6h: "fo5b2b9",
		xdqbwx: "f16vizm6",
		Hwb57: "fqolsir",
		umgawz: "fim7wbh"
	},
	rootUnselected: {
		Bw0xxkn: 0,
		oeaueh: 0,
		Bpd4iqm: 0,
		Befb4lg: "f71xx7",
		Byu6kyc: 0,
		n8qw10: 0,
		Bbjhlyh: 0,
		i2cumq: 0,
		Bunx835: 0,
		Bdrgwmp: 0,
		mqozju: 0,
		lbo84a: 0,
		Bksnhdo: 0,
		Bci5o5g: 0,
		u5e7qz: 0,
		Bn40d3w: 0,
		B7b6zxw: 0,
		B8q5s1w: 0,
		B5gfjzb: 0,
		Bbcte9g: 0,
		Bqz3imu: "f1j9b7x8",
		Bj9ihqo: 0,
		Bl51kww: 0,
		B3bvztg: 0,
		Btyt4dx: 0,
		Brhw1f9: "f1tdm9ui",
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "f2krc9w",
		Bp15pi3: "f7x02et",
		Bay5ve9: "f1ry2q4s",
		Bni0232: "f1e9f9ku"
	},
	rootSelected: {
		a9b677: "f1eh74fx",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "fwku66v",
		Bw0xxkn: 0,
		oeaueh: 0,
		Bpd4iqm: 0,
		Befb4lg: "f71xx7",
		Byu6kyc: 0,
		n8qw10: 0,
		Bbjhlyh: 0,
		i2cumq: 0,
		Bunx835: 0,
		Bdrgwmp: 0,
		mqozju: 0,
		lbo84a: 0,
		Bksnhdo: 0,
		Bci5o5g: 0,
		u5e7qz: 0,
		Bn40d3w: 0,
		B7b6zxw: 0,
		B8q5s1w: 0,
		B5gfjzb: 0,
		Bbcte9g: 0,
		Bqz3imu: "f1j9b7x8",
		Bj9ihqo: 0,
		Bl51kww: 0,
		B3bvztg: 0,
		Btyt4dx: 0,
		Brhw1f9: "f1tdm9ui",
		Bw81rd7: 0,
		kdpuga: 0,
		dm238s: 0,
		B6xbmo0: 0,
		B3whbx2: "f2krc9w",
		a2br6o: "f1v6lwa2",
		d9w3h3: 0,
		B3778ie: 0,
		B4j8arr: 0,
		Bl18szs: 0,
		Blrzh8d: "fgm6wgx",
		Bay5ve9: "f1ry2q4s",
		Bni0232: "f1gxfet"
	},
	brand: {
		Bjyk6c5: "fnrv5e1",
		Bp15pi3: "fjsqi2x",
		Glksuk: "frrwqtn",
		Bay5ve9: "f9atwx8",
		Blzl0y7: "fmmpig5",
		Bni0232: "f1e9f9ku"
	},
	unselectedBrand: {
		Bp15pi3: "f7x02et",
		Bjyk6c5: "f1w4p7kh",
		Bay5ve9: "f1ry2q4s",
		Bni0232: "f1e9f9ku"
	}
}, {
	d: [
		".f1k6fduh{cursor:pointer;}",
		".fc5wo7j{pointer-events:all;}",
		".f1van5z7{width:var(--spacingHorizontalS);}",
		".f1fkmctz{height:var(--spacingVerticalS);}",
		[".f1f5q0n8{padding:var(--spacingVerticalS) var(--spacingHorizontalS);}", { p: -1 }],
		".f1e4lqlz{box-sizing:content-box;}",
		".f1c21dwh{background-color:var(--colorTransparentBackground);}",
		".fre7gi1{border-top-width:0;}",
		".f1358rze{border-right-width:0;}",
		".f1rvrf73{border-left-width:0;}",
		".fqdk4by{border-bottom-width:0;}",
		".f13zj6fq::after{content:\"\";}",
		".f2gz7yw::after{display:block;}",
		".f1gw3sf2::after{box-sizing:border-box;}",
		[".f1x820d0::after{border-radius:50%;}", { p: -1 }],
		[".fnwf5yv::after{border:none;}", { p: -2 }],
		".foue38v::after{height:var(--spacingVerticalS);}",
		".fi4ui2s::after{width:var(--spacingHorizontalS);}",
		".f1w4p7kh::after{background-color:var(--colorNeutralForeground1);}",
		".fo5b2b9::after{color:var(--colorNeutralForeground1);}",
		[".f71xx7{outline:var(--strokeWidthThin) solid transparent;}", { p: -1 }],
		[".f1j9b7x8[data-fui-focus-visible]{border:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}", { p: -2 }],
		[".f1tdm9ui[data-fui-focus-visible]{margin:calc(-1 * var(--strokeWidthThick));}", { p: -1 }],
		[".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
		".f7x02et::after{opacity:0.6;}",
		".f1eh74fx{width:var(--spacingHorizontalL);}",
		[".fwku66v{padding:var(--spacingVerticalS) var(--spacingHorizontalXS);}", { p: -1 }],
		[".f71xx7{outline:var(--strokeWidthThin) solid transparent;}", { p: -1 }],
		[".f1j9b7x8[data-fui-focus-visible]{border:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}", { p: -2 }],
		[".f1tdm9ui[data-fui-focus-visible]{margin:calc(-1 * var(--strokeWidthThick));}", { p: -1 }],
		[".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
		".f1v6lwa2::after{width:var(--spacingHorizontalL);}",
		[".fgm6wgx::after{border-radius:4px;}", { p: -1 }],
		".fnrv5e1::after{background-color:var(--colorCompoundBrandBackground);}",
		".fjsqi2x::after{opacity:1;}"
	],
	m: [
		["@media (forced-colors: active){.f16vizm6::after{forced-color-adjust:none;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fqolsir::after{background-color:white;}}", { m: "(forced-colors: active)" }],
		["@media (forced-colors: active){.fim7wbh::after{mix-blend-mode:difference;}}", { m: "(forced-colors: active)" }]
	],
	h: [
		".f1ry2q4s:hover::after{opacity:0.75;}",
		".frrwqtn:hover::after{background-color:var(--colorCompoundBrandBackgroundHover);}",
		".f9atwx8:hover::after{opacity:1;}"
	],
	a: [
		".f1e9f9ku:active::after{opacity:1;}",
		".f1gxfet:active::after{opacity:0.65;}",
		".fmmpig5:active::after{background-color:var(--colorCompoundBrandBackgroundPressed);}"
	]
});
/**
* Apply styling to the CarouselNavButton slots based on the state
*/
const useCarouselNavButtonStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$8();
	const { selected, appearance } = state;
	state.root.className = mergeClasses(carouselNavButtonClassNames.root, styles.root, selected ? styles.rootSelected : styles.rootUnselected, appearance === "brand" && styles.brand, !selected && appearance === "brand" && styles.unselectedBrand, state.root.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavButton/CarouselNavButton.js
/**
* The child element of CarouselNav, a singular button that will set the carousels active value on click.
*/ const CarouselNavButton = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselNavButton_unstable(props, ref);
	useCarouselNavButtonStyles_unstable(state);
	useCustomStyleHook("useCarouselNavButtonStyles_unstable")(state);
	return renderCarouselNavButton_unstable(state);
});
CarouselNavButton.displayName = "CarouselNavButton";

//#endregion
//#region node_modules/embla-carousel/esm/embla-carousel.esm.js
function isNumber$1(subject) {
	return typeof subject === "number";
}
function isString(subject) {
	return typeof subject === "string";
}
function isBoolean(subject) {
	return typeof subject === "boolean";
}
function isObject(subject) {
	return Object.prototype.toString.call(subject) === "[object Object]";
}
function mathAbs(n) {
	return Math.abs(n);
}
function mathSign(n) {
	return Math.sign(n);
}
function deltaAbs(valueB, valueA) {
	return mathAbs(valueB - valueA);
}
function factorAbs(valueB, valueA) {
	if (valueB === 0 || valueA === 0) return 0;
	if (mathAbs(valueB) <= mathAbs(valueA)) return 0;
	const diff = deltaAbs(mathAbs(valueB), mathAbs(valueA));
	return mathAbs(diff / valueB);
}
function roundToTwoDecimals(num) {
	return Math.round(num * 100) / 100;
}
function arrayKeys(array) {
	return objectKeys(array).map(Number);
}
function arrayLast(array) {
	return array[arrayLastIndex(array)];
}
function arrayLastIndex(array) {
	return Math.max(0, array.length - 1);
}
function arrayIsLastIndex(array, index) {
	return index === arrayLastIndex(array);
}
function arrayFromNumber(n, startAt = 0) {
	return Array.from(Array(n), (_, i) => startAt + i);
}
function objectKeys(object) {
	return Object.keys(object);
}
function objectsMergeDeep(objectA, objectB) {
	return [objectA, objectB].reduce((mergedObjects, currentObject) => {
		objectKeys(currentObject).forEach((key) => {
			const valueA = mergedObjects[key];
			const valueB = currentObject[key];
			mergedObjects[key] = isObject(valueA) && isObject(valueB) ? objectsMergeDeep(valueA, valueB) : valueB;
		});
		return mergedObjects;
	}, {});
}
function isMouseEvent(evt, ownerWindow) {
	return typeof ownerWindow.MouseEvent !== "undefined" && evt instanceof ownerWindow.MouseEvent;
}
function Alignment(align, viewSize) {
	const predefined = {
		start,
		center,
		end
	};
	function start() {
		return 0;
	}
	function center(n) {
		return end(n) / 2;
	}
	function end(n) {
		return viewSize - n;
	}
	function measure(n, index) {
		if (isString(align)) return predefined[align](n);
		return align(viewSize, n, index);
	}
	return { measure };
}
function EventStore() {
	let listeners = [];
	function add(node, type, handler, options = { passive: true }) {
		let removeListener;
		if ("addEventListener" in node) {
			node.addEventListener(type, handler, options);
			removeListener = () => node.removeEventListener(type, handler, options);
		} else {
			const legacyMediaQueryList = node;
			legacyMediaQueryList.addListener(handler);
			removeListener = () => legacyMediaQueryList.removeListener(handler);
		}
		listeners.push(removeListener);
		return self;
	}
	function clear() {
		listeners = listeners.filter((remove) => remove());
	}
	const self = {
		add,
		clear
	};
	return self;
}
function Animations(ownerDocument, ownerWindow, update, render) {
	const documentVisibleHandler = EventStore();
	const fixedTimeStep = 1e3 / 60;
	let lastTimeStamp = null;
	let accumulatedTime = 0;
	let animationId = 0;
	function init() {
		documentVisibleHandler.add(ownerDocument, "visibilitychange", () => {
			if (ownerDocument.hidden) reset();
		});
	}
	function destroy() {
		stop();
		documentVisibleHandler.clear();
	}
	function animate(timeStamp) {
		if (!animationId) return;
		if (!lastTimeStamp) {
			lastTimeStamp = timeStamp;
			update();
			update();
		}
		const timeElapsed = timeStamp - lastTimeStamp;
		lastTimeStamp = timeStamp;
		accumulatedTime += timeElapsed;
		while (accumulatedTime >= fixedTimeStep) {
			update();
			accumulatedTime -= fixedTimeStep;
		}
		const alpha = accumulatedTime / fixedTimeStep;
		render(alpha);
		if (animationId) animationId = ownerWindow.requestAnimationFrame(animate);
	}
	function start() {
		if (animationId) return;
		animationId = ownerWindow.requestAnimationFrame(animate);
	}
	function stop() {
		ownerWindow.cancelAnimationFrame(animationId);
		lastTimeStamp = null;
		accumulatedTime = 0;
		animationId = 0;
	}
	function reset() {
		lastTimeStamp = null;
		accumulatedTime = 0;
	}
	return {
		init,
		destroy,
		start,
		stop,
		update,
		render
	};
}
function Axis(axis, contentDirection) {
	const isRightToLeft = contentDirection === "rtl";
	const isVertical = axis === "y";
	const scroll = isVertical ? "y" : "x";
	const cross = isVertical ? "x" : "y";
	const sign = !isVertical && isRightToLeft ? -1 : 1;
	const startEdge = getStartEdge();
	const endEdge = getEndEdge();
	function measureSize(nodeRect) {
		const { height, width } = nodeRect;
		return isVertical ? height : width;
	}
	function getStartEdge() {
		if (isVertical) return "top";
		return isRightToLeft ? "right" : "left";
	}
	function getEndEdge() {
		if (isVertical) return "bottom";
		return isRightToLeft ? "left" : "right";
	}
	function direction(n) {
		return n * sign;
	}
	return {
		scroll,
		cross,
		startEdge,
		endEdge,
		measureSize,
		direction
	};
}
function Limit(min$1 = 0, max$1 = 0) {
	const length = mathAbs(min$1 - max$1);
	function reachedMin(n) {
		return n < min$1;
	}
	function reachedMax(n) {
		return n > max$1;
	}
	function reachedAny(n) {
		return reachedMin(n) || reachedMax(n);
	}
	function constrain(n) {
		if (!reachedAny(n)) return n;
		return reachedMin(n) ? min$1 : max$1;
	}
	function removeOffset(n) {
		if (!length) return n;
		return n - length * Math.ceil((n - max$1) / length);
	}
	return {
		length,
		max: max$1,
		min: min$1,
		constrain,
		reachedAny,
		reachedMax,
		reachedMin,
		removeOffset
	};
}
function Counter(max$1, start, loop) {
	const { constrain } = Limit(0, max$1);
	const loopEnd = max$1 + 1;
	let counter$1 = withinLimit(start);
	function withinLimit(n) {
		return !loop ? constrain(n) : mathAbs((loopEnd + n) % loopEnd);
	}
	function get() {
		return counter$1;
	}
	function set(n) {
		counter$1 = withinLimit(n);
		return self;
	}
	function add(n) {
		return clone().set(get() + n);
	}
	function clone() {
		return Counter(max$1, get(), loop);
	}
	const self = {
		get,
		set,
		add,
		clone
	};
	return self;
}
function DragHandler(axis, rootNode, ownerDocument, ownerWindow, target, dragTracker, location, animation, scrollTo, scrollBody, scrollTarget, index, eventHandler, percentOfView, dragFree, dragThreshold, skipSnaps, baseFriction, watchDrag) {
	const { cross: crossAxis, direction } = axis;
	const focusNodes = [
		"INPUT",
		"SELECT",
		"TEXTAREA"
	];
	const nonPassiveEvent = { passive: false };
	const initEvents = EventStore();
	const dragEvents = EventStore();
	const goToNextThreshold = Limit(50, 225).constrain(percentOfView.measure(20));
	const snapForceBoost = {
		mouse: 300,
		touch: 400
	};
	const freeForceBoost = {
		mouse: 500,
		touch: 600
	};
	const baseSpeed = dragFree ? 43 : 25;
	let isMoving = false;
	let startScroll = 0;
	let startCross = 0;
	let pointerIsDown = false;
	let preventScroll = false;
	let preventClick = false;
	let isMouse = false;
	function init(emblaApi) {
		if (!watchDrag) return;
		function downIfAllowed(evt) {
			if (isBoolean(watchDrag) || watchDrag(emblaApi, evt)) down(evt);
		}
		const node = rootNode;
		initEvents.add(node, "dragstart", (evt) => evt.preventDefault(), nonPassiveEvent).add(node, "touchmove", () => void 0, nonPassiveEvent).add(node, "touchend", () => void 0).add(node, "touchstart", downIfAllowed).add(node, "mousedown", downIfAllowed).add(node, "touchcancel", up).add(node, "contextmenu", up).add(node, "click", click, true);
	}
	function destroy() {
		initEvents.clear();
		dragEvents.clear();
	}
	function addDragEvents() {
		const node = isMouse ? ownerDocument : rootNode;
		dragEvents.add(node, "touchmove", move, nonPassiveEvent).add(node, "touchend", up).add(node, "mousemove", move, nonPassiveEvent).add(node, "mouseup", up);
	}
	function isFocusNode(node) {
		const nodeName = node.nodeName || "";
		return focusNodes.includes(nodeName);
	}
	function forceBoost() {
		return (dragFree ? freeForceBoost : snapForceBoost)[isMouse ? "mouse" : "touch"];
	}
	function allowedForce(force, targetChanged) {
		const next = index.add(mathSign(force) * -1);
		const baseForce = scrollTarget.byDistance(force, !dragFree).distance;
		if (dragFree || mathAbs(force) < goToNextThreshold) return baseForce;
		if (skipSnaps && targetChanged) return baseForce * .5;
		return scrollTarget.byIndex(next.get(), 0).distance;
	}
	function down(evt) {
		const isMouseEvt = isMouseEvent(evt, ownerWindow);
		isMouse = isMouseEvt;
		preventClick = dragFree && isMouseEvt && !evt.buttons && isMoving;
		isMoving = deltaAbs(target.get(), location.get()) >= 2;
		if (isMouseEvt && evt.button !== 0) return;
		if (isFocusNode(evt.target)) return;
		pointerIsDown = true;
		dragTracker.pointerDown(evt);
		scrollBody.useFriction(0).useDuration(0);
		target.set(location);
		addDragEvents();
		startScroll = dragTracker.readPoint(evt);
		startCross = dragTracker.readPoint(evt, crossAxis);
		eventHandler.emit("pointerDown");
	}
	function move(evt) {
		if (!isMouseEvent(evt, ownerWindow) && evt.touches.length >= 2) return up(evt);
		const lastScroll = dragTracker.readPoint(evt);
		const lastCross = dragTracker.readPoint(evt, crossAxis);
		const diffScroll = deltaAbs(lastScroll, startScroll);
		const diffCross = deltaAbs(lastCross, startCross);
		if (!preventScroll && !isMouse) {
			if (!evt.cancelable) return up(evt);
			preventScroll = diffScroll > diffCross;
			if (!preventScroll) return up(evt);
		}
		const diff = dragTracker.pointerMove(evt);
		if (diffScroll > dragThreshold) preventClick = true;
		scrollBody.useFriction(.3).useDuration(.75);
		animation.start();
		target.add(direction(diff));
		evt.preventDefault();
	}
	function up(evt) {
		const targetChanged = scrollTarget.byDistance(0, false).index !== index.get();
		const rawForce = dragTracker.pointerUp(evt) * forceBoost();
		const force = allowedForce(direction(rawForce), targetChanged);
		const forceFactor = factorAbs(rawForce, force);
		const speed = baseSpeed - 10 * forceFactor;
		const friction = baseFriction + forceFactor / 50;
		preventScroll = false;
		pointerIsDown = false;
		dragEvents.clear();
		scrollBody.useDuration(speed).useFriction(friction);
		scrollTo.distance(force, !dragFree);
		isMouse = false;
		eventHandler.emit("pointerUp");
	}
	function click(evt) {
		if (preventClick) {
			evt.stopPropagation();
			evt.preventDefault();
			preventClick = false;
		}
	}
	function pointerDown() {
		return pointerIsDown;
	}
	return {
		init,
		destroy,
		pointerDown
	};
}
function DragTracker(axis, ownerWindow) {
	const logInterval = 170;
	let startEvent;
	let lastEvent;
	function readTime(evt) {
		return evt.timeStamp;
	}
	function readPoint(evt, evtAxis) {
		const coord = `client${(evtAxis || axis.scroll) === "x" ? "X" : "Y"}`;
		return (isMouseEvent(evt, ownerWindow) ? evt : evt.touches[0])[coord];
	}
	function pointerDown(evt) {
		startEvent = evt;
		lastEvent = evt;
		return readPoint(evt);
	}
	function pointerMove(evt) {
		const diff = readPoint(evt) - readPoint(lastEvent);
		const expired = readTime(evt) - readTime(startEvent) > logInterval;
		lastEvent = evt;
		if (expired) startEvent = evt;
		return diff;
	}
	function pointerUp(evt) {
		if (!startEvent || !lastEvent) return 0;
		const diffDrag = readPoint(lastEvent) - readPoint(startEvent);
		const diffTime = readTime(evt) - readTime(startEvent);
		const expired = readTime(evt) - readTime(lastEvent) > logInterval;
		const force = diffDrag / diffTime;
		return diffTime && !expired && mathAbs(force) > .1 ? force : 0;
	}
	return {
		pointerDown,
		pointerMove,
		pointerUp,
		readPoint
	};
}
function NodeRects() {
	function measure(node) {
		const { offsetTop, offsetLeft, offsetWidth, offsetHeight } = node;
		return {
			top: offsetTop,
			right: offsetLeft + offsetWidth,
			bottom: offsetTop + offsetHeight,
			left: offsetLeft,
			width: offsetWidth,
			height: offsetHeight
		};
	}
	return { measure };
}
function PercentOfView(viewSize) {
	function measure(n) {
		return viewSize * (n / 100);
	}
	return { measure };
}
function ResizeHandler(container, eventHandler, ownerWindow, slides, axis, watchResize, nodeRects) {
	const observeNodes = [container].concat(slides);
	let resizeObserver;
	let containerSize;
	let slideSizes = [];
	let destroyed = false;
	function readSize(node) {
		return axis.measureSize(nodeRects.measure(node));
	}
	function init(emblaApi) {
		if (!watchResize) return;
		containerSize = readSize(container);
		slideSizes = slides.map(readSize);
		function defaultCallback(entries) {
			for (const entry of entries) {
				if (destroyed) return;
				const isContainer = entry.target === container;
				const slideIndex = slides.indexOf(entry.target);
				const lastSize = isContainer ? containerSize : slideSizes[slideIndex];
				const newSize = readSize(isContainer ? container : slides[slideIndex]);
				if (mathAbs(newSize - lastSize) >= .5) {
					emblaApi.reInit();
					eventHandler.emit("resize");
					break;
				}
			}
		}
		resizeObserver = new ResizeObserver((entries) => {
			if (isBoolean(watchResize) || watchResize(emblaApi, entries)) defaultCallback(entries);
		});
		ownerWindow.requestAnimationFrame(() => {
			observeNodes.forEach((node) => resizeObserver.observe(node));
		});
	}
	function destroy() {
		destroyed = true;
		if (resizeObserver) resizeObserver.disconnect();
	}
	return {
		init,
		destroy
	};
}
function ScrollBody(location, offsetLocation, previousLocation, target, baseDuration, baseFriction) {
	let scrollVelocity = 0;
	let scrollDirection = 0;
	let scrollDuration = baseDuration;
	let scrollFriction = baseFriction;
	let rawLocation = location.get();
	let rawLocationPrevious = 0;
	function seek() {
		const displacement = target.get() - location.get();
		const isInstant = !scrollDuration;
		let scrollDistance = 0;
		if (isInstant) {
			scrollVelocity = 0;
			previousLocation.set(target);
			location.set(target);
			scrollDistance = displacement;
		} else {
			previousLocation.set(location);
			scrollVelocity += displacement / scrollDuration;
			scrollVelocity *= scrollFriction;
			rawLocation += scrollVelocity;
			location.add(scrollVelocity);
			scrollDistance = rawLocation - rawLocationPrevious;
		}
		scrollDirection = mathSign(scrollDistance);
		rawLocationPrevious = rawLocation;
		return self;
	}
	function settled() {
		const diff = target.get() - offsetLocation.get();
		return mathAbs(diff) < .001;
	}
	function duration() {
		return scrollDuration;
	}
	function direction() {
		return scrollDirection;
	}
	function velocity() {
		return scrollVelocity;
	}
	function useBaseDuration() {
		return useDuration(baseDuration);
	}
	function useBaseFriction() {
		return useFriction(baseFriction);
	}
	function useDuration(n) {
		scrollDuration = n;
		return self;
	}
	function useFriction(n) {
		scrollFriction = n;
		return self;
	}
	const self = {
		direction,
		duration,
		velocity,
		seek,
		settled,
		useBaseFriction,
		useBaseDuration,
		useFriction,
		useDuration
	};
	return self;
}
function ScrollBounds(limit, location, target, scrollBody, percentOfView) {
	const pullBackThreshold = percentOfView.measure(10);
	const edgeOffsetTolerance = percentOfView.measure(50);
	const frictionLimit = Limit(.1, .99);
	let disabled = false;
	function shouldConstrain() {
		if (disabled) return false;
		if (!limit.reachedAny(target.get())) return false;
		if (!limit.reachedAny(location.get())) return false;
		return true;
	}
	function constrain(pointerDown) {
		if (!shouldConstrain()) return;
		const edge = limit.reachedMin(location.get()) ? "min" : "max";
		const diffToEdge = mathAbs(limit[edge] - location.get());
		const diffToTarget = target.get() - location.get();
		const friction = frictionLimit.constrain(diffToEdge / edgeOffsetTolerance);
		target.subtract(diffToTarget * friction);
		if (!pointerDown && mathAbs(diffToTarget) < pullBackThreshold) {
			target.set(limit.constrain(target.get()));
			scrollBody.useDuration(25).useBaseFriction();
		}
	}
	function toggleActive(active) {
		disabled = !active;
	}
	return {
		shouldConstrain,
		constrain,
		toggleActive
	};
}
function ScrollContain(viewSize, contentSize, snapsAligned, containScroll, pixelTolerance) {
	const scrollBounds = Limit(-contentSize + viewSize, 0);
	const snapsBounded = measureBounded();
	const scrollContainLimit = findScrollContainLimit();
	const snapsContained = measureContained();
	function usePixelTolerance(bound, snap) {
		return deltaAbs(bound, snap) <= 1;
	}
	function findScrollContainLimit() {
		const startSnap = snapsBounded[0];
		const endSnap = arrayLast(snapsBounded);
		const min$1 = snapsBounded.lastIndexOf(startSnap);
		const max$1 = snapsBounded.indexOf(endSnap) + 1;
		return Limit(min$1, max$1);
	}
	function measureBounded() {
		return snapsAligned.map((snapAligned, index) => {
			const { min: min$1, max: max$1 } = scrollBounds;
			const snap = scrollBounds.constrain(snapAligned);
			const isFirst = !index;
			const isLast = arrayIsLastIndex(snapsAligned, index);
			if (isFirst) return max$1;
			if (isLast) return min$1;
			if (usePixelTolerance(min$1, snap)) return min$1;
			if (usePixelTolerance(max$1, snap)) return max$1;
			return snap;
		}).map((scrollBound) => parseFloat(scrollBound.toFixed(3)));
	}
	function measureContained() {
		if (contentSize <= viewSize + pixelTolerance) return [scrollBounds.max];
		if (containScroll === "keepSnaps") return snapsBounded;
		const { min: min$1, max: max$1 } = scrollContainLimit;
		return snapsBounded.slice(min$1, max$1);
	}
	return {
		snapsContained,
		scrollContainLimit
	};
}
function ScrollLimit(contentSize, scrollSnaps, loop) {
	const max$1 = scrollSnaps[0];
	const min$1 = loop ? max$1 - contentSize : arrayLast(scrollSnaps);
	return { limit: Limit(min$1, max$1) };
}
function ScrollLooper(contentSize, limit, location, vectors) {
	const jointSafety = .1;
	const min$1 = limit.min + jointSafety;
	const max$1 = limit.max + jointSafety;
	const { reachedMin, reachedMax } = Limit(min$1, max$1);
	function shouldLoop(direction) {
		if (direction === 1) return reachedMax(location.get());
		if (direction === -1) return reachedMin(location.get());
		return false;
	}
	function loop(direction) {
		if (!shouldLoop(direction)) return;
		const loopDistance = contentSize * (direction * -1);
		vectors.forEach((v) => v.add(loopDistance));
	}
	return { loop };
}
function ScrollProgress(limit) {
	const { max: max$1, length } = limit;
	function get(n) {
		const currentLocation = n - max$1;
		return length ? currentLocation / -length : 0;
	}
	return { get };
}
function ScrollSnaps(axis, alignment, containerRect, slideRects, slidesToScroll) {
	const { startEdge, endEdge } = axis;
	const { groupSlides } = slidesToScroll;
	const alignments = measureSizes().map(alignment.measure);
	const snaps = measureUnaligned();
	const snapsAligned = measureAligned();
	function measureSizes() {
		return groupSlides(slideRects).map((rects) => arrayLast(rects)[endEdge] - rects[0][startEdge]).map(mathAbs);
	}
	function measureUnaligned() {
		return slideRects.map((rect) => containerRect[startEdge] - rect[startEdge]).map((snap) => -mathAbs(snap));
	}
	function measureAligned() {
		return groupSlides(snaps).map((g) => g[0]).map((snap, index) => snap + alignments[index]);
	}
	return {
		snaps,
		snapsAligned
	};
}
function SlideRegistry(containSnaps, containScroll, scrollSnaps, scrollContainLimit, slidesToScroll, slideIndexes) {
	const { groupSlides } = slidesToScroll;
	const { min: min$1, max: max$1 } = scrollContainLimit;
	const slideRegistry = createSlideRegistry();
	function createSlideRegistry() {
		const groupedSlideIndexes = groupSlides(slideIndexes);
		const doNotContain = !containSnaps || containScroll === "keepSnaps";
		if (scrollSnaps.length === 1) return [slideIndexes];
		if (doNotContain) return groupedSlideIndexes;
		return groupedSlideIndexes.slice(min$1, max$1).map((group, index, groups) => {
			const isFirst = !index;
			const isLast = arrayIsLastIndex(groups, index);
			if (isFirst) {
				const range = arrayLast(groups[0]) + 1;
				return arrayFromNumber(range);
			}
			if (isLast) {
				const range = arrayLastIndex(slideIndexes) - arrayLast(groups)[0] + 1;
				return arrayFromNumber(range, arrayLast(groups)[0]);
			}
			return group;
		});
	}
	return { slideRegistry };
}
function ScrollTarget(loop, scrollSnaps, contentSize, limit, targetVector) {
	const { reachedAny, removeOffset, constrain } = limit;
	function minDistance(distances) {
		return distances.concat().sort((a, b) => mathAbs(a) - mathAbs(b))[0];
	}
	function findTargetSnap(target) {
		const distance = loop ? removeOffset(target) : constrain(target);
		const { index } = scrollSnaps.map((snap, index$1) => ({
			diff: shortcut(snap - distance, 0),
			index: index$1
		})).sort((d1, d2) => mathAbs(d1.diff) - mathAbs(d2.diff))[0];
		return {
			index,
			distance
		};
	}
	function shortcut(target, direction) {
		const targets = [
			target,
			target + contentSize,
			target - contentSize
		];
		if (!loop) return target;
		if (!direction) return minDistance(targets);
		const matchingTargets = targets.filter((t) => mathSign(t) === direction);
		if (matchingTargets.length) return minDistance(matchingTargets);
		return arrayLast(targets) - contentSize;
	}
	function byIndex(index, direction) {
		const diffToSnap = scrollSnaps[index] - targetVector.get();
		const distance = shortcut(diffToSnap, direction);
		return {
			index,
			distance
		};
	}
	function byDistance(distance, snap) {
		const target = targetVector.get() + distance;
		const { index, distance: targetSnapDistance } = findTargetSnap(target);
		const reachedBound = !loop && reachedAny(target);
		if (!snap || reachedBound) return {
			index,
			distance
		};
		const diffToSnap = scrollSnaps[index] - targetSnapDistance;
		const snapDistance = distance + shortcut(diffToSnap, 0);
		return {
			index,
			distance: snapDistance
		};
	}
	return {
		byDistance,
		byIndex,
		shortcut
	};
}
function ScrollTo(animation, indexCurrent, indexPrevious, scrollBody, scrollTarget, targetVector, eventHandler) {
	function scrollTo(target) {
		const distanceDiff = target.distance;
		const indexDiff = target.index !== indexCurrent.get();
		targetVector.add(distanceDiff);
		if (distanceDiff) if (scrollBody.duration()) animation.start();
		else {
			animation.update();
			animation.render(1);
			animation.update();
		}
		if (indexDiff) {
			indexPrevious.set(indexCurrent.get());
			indexCurrent.set(target.index);
			eventHandler.emit("select");
		}
	}
	function distance(n, snap) {
		const target = scrollTarget.byDistance(n, snap);
		scrollTo(target);
	}
	function index(n, direction) {
		const targetIndex = indexCurrent.clone().set(n);
		const target = scrollTarget.byIndex(targetIndex.get(), direction);
		scrollTo(target);
	}
	return {
		distance,
		index
	};
}
function SlideFocus(root, slides, slideRegistry, scrollTo, scrollBody, eventStore, eventHandler, watchFocus) {
	const focusListenerOptions = {
		passive: true,
		capture: true
	};
	let lastTabPressTime = 0;
	function init(emblaApi) {
		if (!watchFocus) return;
		function defaultCallback(index) {
			if ((/* @__PURE__ */ new Date()).getTime() - lastTabPressTime > 10) return;
			eventHandler.emit("slideFocusStart");
			root.scrollLeft = 0;
			const group = slideRegistry.findIndex((group$1) => group$1.includes(index));
			if (!isNumber$1(group)) return;
			scrollBody.useDuration(0);
			scrollTo.index(group, 0);
			eventHandler.emit("slideFocus");
		}
		eventStore.add(document, "keydown", registerTabPress, false);
		slides.forEach((slide, slideIndex) => {
			eventStore.add(slide, "focus", (evt) => {
				if (isBoolean(watchFocus) || watchFocus(emblaApi, evt)) defaultCallback(slideIndex);
			}, focusListenerOptions);
		});
	}
	function registerTabPress(event) {
		if (event.code === "Tab") lastTabPressTime = (/* @__PURE__ */ new Date()).getTime();
	}
	return { init };
}
function Vector1D(initialValue) {
	let value = initialValue;
	function get() {
		return value;
	}
	function set(n) {
		value = normalizeInput(n);
	}
	function add(n) {
		value += normalizeInput(n);
	}
	function subtract(n) {
		value -= normalizeInput(n);
	}
	function normalizeInput(n) {
		return isNumber$1(n) ? n : n.get();
	}
	return {
		get,
		set,
		add,
		subtract
	};
}
function Translate(axis, container) {
	const translate = axis.scroll === "x" ? x : y;
	const containerStyle = container.style;
	let previousTarget = null;
	let disabled = false;
	function x(n) {
		return `translate3d(${n}px,0px,0px)`;
	}
	function y(n) {
		return `translate3d(0px,${n}px,0px)`;
	}
	function to(target) {
		if (disabled) return;
		const newTarget = roundToTwoDecimals(axis.direction(target));
		if (newTarget === previousTarget) return;
		containerStyle.transform = translate(newTarget);
		previousTarget = newTarget;
	}
	function toggleActive(active) {
		disabled = !active;
	}
	function clear() {
		if (disabled) return;
		containerStyle.transform = "";
		if (!container.getAttribute("style")) container.removeAttribute("style");
	}
	return {
		clear,
		to,
		toggleActive
	};
}
function SlideLooper(axis, viewSize, contentSize, slideSizes, slideSizesWithGaps, snaps, scrollSnaps, location, slides) {
	const roundingSafety = .5;
	const ascItems = arrayKeys(slideSizesWithGaps);
	const descItems = arrayKeys(slideSizesWithGaps).reverse();
	const loopPoints = startPoints().concat(endPoints());
	function removeSlideSizes(indexes, from) {
		return indexes.reduce((a, i) => {
			return a - slideSizesWithGaps[i];
		}, from);
	}
	function slidesInGap(indexes, gap) {
		return indexes.reduce((a, i) => {
			return removeSlideSizes(a, gap) > 0 ? a.concat([i]) : a;
		}, []);
	}
	function findSlideBounds(offset$3) {
		return snaps.map((snap, index) => ({
			start: snap - slideSizes[index] + roundingSafety + offset$3,
			end: snap + viewSize - roundingSafety + offset$3
		}));
	}
	function findLoopPoints(indexes, offset$3, isEndEdge) {
		const slideBounds = findSlideBounds(offset$3);
		return indexes.map((index) => {
			const initial = isEndEdge ? 0 : -contentSize;
			const altered = isEndEdge ? contentSize : 0;
			const boundEdge = isEndEdge ? "end" : "start";
			const loopPoint = slideBounds[index][boundEdge];
			return {
				index,
				loopPoint,
				slideLocation: Vector1D(-1),
				translate: Translate(axis, slides[index]),
				target: () => location.get() > loopPoint ? initial : altered
			};
		});
	}
	function startPoints() {
		const gap = scrollSnaps[0];
		const indexes = slidesInGap(descItems, gap);
		return findLoopPoints(indexes, contentSize, false);
	}
	function endPoints() {
		const gap = viewSize - scrollSnaps[0] - 1;
		const indexes = slidesInGap(ascItems, gap);
		return findLoopPoints(indexes, -contentSize, true);
	}
	function canLoop() {
		return loopPoints.every(({ index }) => {
			const otherIndexes = ascItems.filter((i) => i !== index);
			return removeSlideSizes(otherIndexes, viewSize) <= .1;
		});
	}
	function loop() {
		loopPoints.forEach((loopPoint) => {
			const { target, translate, slideLocation } = loopPoint;
			const shiftLocation = target();
			if (shiftLocation === slideLocation.get()) return;
			translate.to(shiftLocation);
			slideLocation.set(shiftLocation);
		});
	}
	function clear() {
		loopPoints.forEach((loopPoint) => loopPoint.translate.clear());
	}
	return {
		canLoop,
		clear,
		loop,
		loopPoints
	};
}
function SlidesHandler(container, eventHandler, watchSlides) {
	let mutationObserver;
	let destroyed = false;
	function init(emblaApi) {
		if (!watchSlides) return;
		function defaultCallback(mutations) {
			for (const mutation of mutations) if (mutation.type === "childList") {
				emblaApi.reInit();
				eventHandler.emit("slidesChanged");
				break;
			}
		}
		mutationObserver = new MutationObserver((mutations) => {
			if (destroyed) return;
			if (isBoolean(watchSlides) || watchSlides(emblaApi, mutations)) defaultCallback(mutations);
		});
		mutationObserver.observe(container, { childList: true });
	}
	function destroy() {
		if (mutationObserver) mutationObserver.disconnect();
		destroyed = true;
	}
	return {
		init,
		destroy
	};
}
function SlidesInView(container, slides, eventHandler, threshold) {
	const intersectionEntryMap = {};
	let inViewCache = null;
	let notInViewCache = null;
	let intersectionObserver;
	let destroyed = false;
	function init() {
		intersectionObserver = new IntersectionObserver((entries) => {
			if (destroyed) return;
			entries.forEach((entry) => {
				const index = slides.indexOf(entry.target);
				intersectionEntryMap[index] = entry;
			});
			inViewCache = null;
			notInViewCache = null;
			eventHandler.emit("slidesInView");
		}, {
			root: container.parentElement,
			threshold
		});
		slides.forEach((slide) => intersectionObserver.observe(slide));
	}
	function destroy() {
		if (intersectionObserver) intersectionObserver.disconnect();
		destroyed = true;
	}
	function createInViewList(inView) {
		return objectKeys(intersectionEntryMap).reduce((list, slideIndex) => {
			const index = parseInt(slideIndex);
			const { isIntersecting } = intersectionEntryMap[index];
			if (inView && isIntersecting || !inView && !isIntersecting) list.push(index);
			return list;
		}, []);
	}
	function get(inView = true) {
		if (inView && inViewCache) return inViewCache;
		if (!inView && notInViewCache) return notInViewCache;
		const slideIndexes = createInViewList(inView);
		if (inView) inViewCache = slideIndexes;
		if (!inView) notInViewCache = slideIndexes;
		return slideIndexes;
	}
	return {
		init,
		destroy,
		get
	};
}
function SlideSizes(axis, containerRect, slideRects, slides, readEdgeGap, ownerWindow) {
	const { measureSize, startEdge, endEdge } = axis;
	const withEdgeGap = slideRects[0] && readEdgeGap;
	const startGap = measureStartGap();
	const endGap = measureEndGap();
	const slideSizes = slideRects.map(measureSize);
	const slideSizesWithGaps = measureWithGaps();
	function measureStartGap() {
		if (!withEdgeGap) return 0;
		const slideRect = slideRects[0];
		return mathAbs(containerRect[startEdge] - slideRect[startEdge]);
	}
	function measureEndGap() {
		if (!withEdgeGap) return 0;
		const style = ownerWindow.getComputedStyle(arrayLast(slides));
		return parseFloat(style.getPropertyValue(`margin-${endEdge}`));
	}
	function measureWithGaps() {
		return slideRects.map((rect, index, rects) => {
			const isFirst = !index;
			const isLast = arrayIsLastIndex(rects, index);
			if (isFirst) return slideSizes[index] + startGap;
			if (isLast) return slideSizes[index] + endGap;
			return rects[index + 1][startEdge] - rect[startEdge];
		}).map(mathAbs);
	}
	return {
		slideSizes,
		slideSizesWithGaps,
		startGap,
		endGap
	};
}
function SlidesToScroll(axis, viewSize, slidesToScroll, loop, containerRect, slideRects, startGap, endGap, pixelTolerance) {
	const { startEdge, endEdge, direction } = axis;
	const groupByNumber = isNumber$1(slidesToScroll);
	function byNumber(array, groupSize) {
		return arrayKeys(array).filter((i) => i % groupSize === 0).map((i) => array.slice(i, i + groupSize));
	}
	function bySize(array) {
		if (!array.length) return [];
		return arrayKeys(array).reduce((groups, rectB, index) => {
			const rectA = arrayLast(groups) || 0;
			const isFirst = rectA === 0;
			const isLast = rectB === arrayLastIndex(array);
			const edgeA = containerRect[startEdge] - slideRects[rectA][startEdge];
			const edgeB = containerRect[startEdge] - slideRects[rectB][endEdge];
			const gapA = !loop && isFirst ? direction(startGap) : 0;
			const gapB = !loop && isLast ? direction(endGap) : 0;
			const chunkSize = mathAbs(edgeB - gapB - (edgeA + gapA));
			if (index && chunkSize > viewSize + pixelTolerance) groups.push(rectB);
			if (isLast) groups.push(array.length);
			return groups;
		}, []).map((currentSize, index, groups) => {
			const previousSize = Math.max(groups[index - 1] || 0);
			return array.slice(previousSize, currentSize);
		});
	}
	function groupSlides(array) {
		return groupByNumber ? byNumber(array, slidesToScroll) : bySize(array);
	}
	return { groupSlides };
}
function Engine(root, container, slides, ownerDocument, ownerWindow, options, eventHandler) {
	const { align, axis: scrollAxis, direction, startIndex, loop, duration, dragFree, dragThreshold, inViewThreshold, slidesToScroll: groupSlides, skipSnaps, containScroll, watchResize, watchSlides, watchDrag, watchFocus } = options;
	const pixelTolerance = 2;
	const nodeRects = NodeRects();
	const containerRect = nodeRects.measure(container);
	const slideRects = slides.map(nodeRects.measure);
	const axis = Axis(scrollAxis, direction);
	const viewSize = axis.measureSize(containerRect);
	const percentOfView = PercentOfView(viewSize);
	const alignment = Alignment(align, viewSize);
	const containSnaps = !loop && !!containScroll;
	const { slideSizes, slideSizesWithGaps, startGap, endGap } = SlideSizes(axis, containerRect, slideRects, slides, loop || !!containScroll, ownerWindow);
	const slidesToScroll = SlidesToScroll(axis, viewSize, groupSlides, loop, containerRect, slideRects, startGap, endGap, pixelTolerance);
	const { snaps, snapsAligned } = ScrollSnaps(axis, alignment, containerRect, slideRects, slidesToScroll);
	const contentSize = -arrayLast(snaps) + arrayLast(slideSizesWithGaps);
	const { snapsContained, scrollContainLimit } = ScrollContain(viewSize, contentSize, snapsAligned, containScroll, pixelTolerance);
	const scrollSnaps = containSnaps ? snapsContained : snapsAligned;
	const { limit } = ScrollLimit(contentSize, scrollSnaps, loop);
	const index = Counter(arrayLastIndex(scrollSnaps), startIndex, loop);
	const indexPrevious = index.clone();
	const slideIndexes = arrayKeys(slides);
	const update = ({ dragHandler, scrollBody: scrollBody$1, scrollBounds, options: { loop: loop$1 } }) => {
		if (!loop$1) scrollBounds.constrain(dragHandler.pointerDown());
		scrollBody$1.seek();
	};
	const render = ({ scrollBody: scrollBody$1, translate, location: location$1, offsetLocation: offsetLocation$1, previousLocation: previousLocation$1, scrollLooper, slideLooper, dragHandler, animation: animation$1, eventHandler: eventHandler$1, scrollBounds, options: { loop: loop$1 } }, alpha) => {
		const shouldSettle = scrollBody$1.settled();
		const withinBounds = !scrollBounds.shouldConstrain();
		const hasSettled = loop$1 ? shouldSettle : shouldSettle && withinBounds;
		const hasSettledAndIdle = hasSettled && !dragHandler.pointerDown();
		if (hasSettledAndIdle) animation$1.stop();
		const interpolatedLocation = location$1.get() * alpha + previousLocation$1.get() * (1 - alpha);
		offsetLocation$1.set(interpolatedLocation);
		if (loop$1) {
			scrollLooper.loop(scrollBody$1.direction());
			slideLooper.loop();
		}
		translate.to(offsetLocation$1.get());
		if (hasSettledAndIdle) eventHandler$1.emit("settle");
		if (!hasSettled) eventHandler$1.emit("scroll");
	};
	const animation = Animations(ownerDocument, ownerWindow, () => update(engine), (alpha) => render(engine, alpha));
	const friction = .68;
	const startLocation = scrollSnaps[index.get()];
	const location = Vector1D(startLocation);
	const previousLocation = Vector1D(startLocation);
	const offsetLocation = Vector1D(startLocation);
	const target = Vector1D(startLocation);
	const scrollBody = ScrollBody(location, offsetLocation, previousLocation, target, duration, friction);
	const scrollTarget = ScrollTarget(loop, scrollSnaps, contentSize, limit, target);
	const scrollTo = ScrollTo(animation, index, indexPrevious, scrollBody, scrollTarget, target, eventHandler);
	const scrollProgress = ScrollProgress(limit);
	const eventStore = EventStore();
	const slidesInView = SlidesInView(container, slides, eventHandler, inViewThreshold);
	const { slideRegistry } = SlideRegistry(containSnaps, containScroll, scrollSnaps, scrollContainLimit, slidesToScroll, slideIndexes);
	const slideFocus = SlideFocus(root, slides, slideRegistry, scrollTo, scrollBody, eventStore, eventHandler, watchFocus);
	const engine = {
		ownerDocument,
		ownerWindow,
		eventHandler,
		containerRect,
		slideRects,
		animation,
		axis,
		dragHandler: DragHandler(axis, root, ownerDocument, ownerWindow, target, DragTracker(axis, ownerWindow), location, animation, scrollTo, scrollBody, scrollTarget, index, eventHandler, percentOfView, dragFree, dragThreshold, skipSnaps, friction, watchDrag),
		eventStore,
		percentOfView,
		index,
		indexPrevious,
		limit,
		location,
		offsetLocation,
		previousLocation,
		options,
		resizeHandler: ResizeHandler(container, eventHandler, ownerWindow, slides, axis, watchResize, nodeRects),
		scrollBody,
		scrollBounds: ScrollBounds(limit, offsetLocation, target, scrollBody, percentOfView),
		scrollLooper: ScrollLooper(contentSize, limit, offsetLocation, [
			location,
			offsetLocation,
			previousLocation,
			target
		]),
		scrollProgress,
		scrollSnapList: scrollSnaps.map(scrollProgress.get),
		scrollSnaps,
		scrollTarget,
		scrollTo,
		slideLooper: SlideLooper(axis, viewSize, contentSize, slideSizes, slideSizesWithGaps, snaps, scrollSnaps, offsetLocation, slides),
		slideFocus,
		slidesHandler: SlidesHandler(container, eventHandler, watchSlides),
		slidesInView,
		slideIndexes,
		slideRegistry,
		slidesToScroll,
		target,
		translate: Translate(axis, container)
	};
	return engine;
}
function EventHandler() {
	let listeners = {};
	let api;
	function init(emblaApi) {
		api = emblaApi;
	}
	function getListeners(evt) {
		return listeners[evt] || [];
	}
	function emit(evt) {
		getListeners(evt).forEach((e) => e(api, evt));
		return self;
	}
	function on(evt, cb) {
		listeners[evt] = getListeners(evt).concat([cb]);
		return self;
	}
	function off(evt, cb) {
		listeners[evt] = getListeners(evt).filter((e) => e !== cb);
		return self;
	}
	function clear() {
		listeners = {};
	}
	const self = {
		init,
		emit,
		off,
		on,
		clear
	};
	return self;
}
var defaultOptions$1 = {
	align: "center",
	axis: "x",
	container: null,
	slides: null,
	containScroll: "trimSnaps",
	direction: "ltr",
	slidesToScroll: 1,
	inViewThreshold: 0,
	breakpoints: {},
	dragFree: false,
	dragThreshold: 10,
	loop: false,
	skipSnaps: false,
	duration: 25,
	startIndex: 0,
	active: true,
	watchDrag: true,
	watchResize: true,
	watchSlides: true,
	watchFocus: true
};
function OptionsHandler(ownerWindow) {
	function mergeOptions(optionsA, optionsB) {
		return objectsMergeDeep(optionsA, optionsB || {});
	}
	function optionsAtMedia(options) {
		const optionsAtMedia$1 = options.breakpoints || {};
		const matchedMediaOptions = objectKeys(optionsAtMedia$1).filter((media) => ownerWindow.matchMedia(media).matches).map((media) => optionsAtMedia$1[media]).reduce((a, mediaOption) => mergeOptions(a, mediaOption), {});
		return mergeOptions(options, matchedMediaOptions);
	}
	function optionsMediaQueries(optionsList) {
		return optionsList.map((options) => objectKeys(options.breakpoints || {})).reduce((acc, mediaQueries) => acc.concat(mediaQueries), []).map(ownerWindow.matchMedia);
	}
	return {
		mergeOptions,
		optionsAtMedia,
		optionsMediaQueries
	};
}
function PluginsHandler(optionsHandler) {
	let activePlugins = [];
	function init(emblaApi, plugins) {
		activePlugins = plugins.filter(({ options }) => optionsHandler.optionsAtMedia(options).active !== false);
		activePlugins.forEach((plugin) => plugin.init(emblaApi, optionsHandler));
		return plugins.reduce((map, plugin) => Object.assign(map, { [plugin.name]: plugin }), {});
	}
	function destroy() {
		activePlugins = activePlugins.filter((plugin) => plugin.destroy());
	}
	return {
		init,
		destroy
	};
}
function EmblaCarousel(root, userOptions, userPlugins) {
	const ownerDocument = root.ownerDocument;
	const ownerWindow = ownerDocument.defaultView;
	const optionsHandler = OptionsHandler(ownerWindow);
	const pluginsHandler = PluginsHandler(optionsHandler);
	const mediaHandlers = EventStore();
	const eventHandler = EventHandler();
	const { mergeOptions, optionsAtMedia, optionsMediaQueries } = optionsHandler;
	const { on, off, emit } = eventHandler;
	const reInit = reActivate;
	let destroyed = false;
	let engine;
	let optionsBase = mergeOptions(defaultOptions$1, EmblaCarousel.globalOptions);
	let options = mergeOptions(optionsBase);
	let pluginList = [];
	let pluginApis;
	let container;
	let slides;
	function storeElements() {
		const { container: userContainer, slides: userSlides } = options;
		container = (isString(userContainer) ? root.querySelector(userContainer) : userContainer) || root.children[0];
		const customSlides = isString(userSlides) ? container.querySelectorAll(userSlides) : userSlides;
		slides = [].slice.call(customSlides || container.children);
	}
	function createEngine(options$1) {
		const engine$1 = Engine(root, container, slides, ownerDocument, ownerWindow, options$1, eventHandler);
		if (options$1.loop && !engine$1.slideLooper.canLoop()) {
			const optionsWithoutLoop = Object.assign({}, options$1, { loop: false });
			return createEngine(optionsWithoutLoop);
		}
		return engine$1;
	}
	function activate(withOptions, withPlugins) {
		if (destroyed) return;
		optionsBase = mergeOptions(optionsBase, withOptions);
		options = optionsAtMedia(optionsBase);
		pluginList = withPlugins || pluginList;
		storeElements();
		engine = createEngine(options);
		optionsMediaQueries([optionsBase, ...pluginList.map(({ options: options$1 }) => options$1)]).forEach((query) => mediaHandlers.add(query, "change", reActivate));
		if (!options.active) return;
		engine.translate.to(engine.location.get());
		engine.animation.init();
		engine.slidesInView.init();
		engine.slideFocus.init(self);
		engine.eventHandler.init(self);
		engine.resizeHandler.init(self);
		engine.slidesHandler.init(self);
		if (engine.options.loop) engine.slideLooper.loop();
		if (container.offsetParent && slides.length) engine.dragHandler.init(self);
		pluginApis = pluginsHandler.init(self, pluginList);
	}
	function reActivate(withOptions, withPlugins) {
		const startIndex = selectedScrollSnap();
		deActivate();
		activate(mergeOptions({ startIndex }, withOptions), withPlugins);
		eventHandler.emit("reInit");
	}
	function deActivate() {
		engine.dragHandler.destroy();
		engine.eventStore.clear();
		engine.translate.clear();
		engine.slideLooper.clear();
		engine.resizeHandler.destroy();
		engine.slidesHandler.destroy();
		engine.slidesInView.destroy();
		engine.animation.destroy();
		pluginsHandler.destroy();
		mediaHandlers.clear();
	}
	function destroy() {
		if (destroyed) return;
		destroyed = true;
		mediaHandlers.clear();
		deActivate();
		eventHandler.emit("destroy");
		eventHandler.clear();
	}
	function scrollTo(index, jump, direction) {
		if (!options.active || destroyed) return;
		engine.scrollBody.useBaseFriction().useDuration(jump === true ? 0 : options.duration);
		engine.scrollTo.index(index, direction || 0);
	}
	function scrollNext(jump) {
		const next = engine.index.add(1).get();
		scrollTo(next, jump, -1);
	}
	function scrollPrev(jump) {
		const prev = engine.index.add(-1).get();
		scrollTo(prev, jump, 1);
	}
	function canScrollNext() {
		return engine.index.add(1).get() !== selectedScrollSnap();
	}
	function canScrollPrev() {
		return engine.index.add(-1).get() !== selectedScrollSnap();
	}
	function scrollSnapList() {
		return engine.scrollSnapList;
	}
	function scrollProgress() {
		return engine.scrollProgress.get(engine.offsetLocation.get());
	}
	function selectedScrollSnap() {
		return engine.index.get();
	}
	function previousScrollSnap() {
		return engine.indexPrevious.get();
	}
	function slidesInView() {
		return engine.slidesInView.get();
	}
	function slidesNotInView() {
		return engine.slidesInView.get(false);
	}
	function plugins() {
		return pluginApis;
	}
	function internalEngine() {
		return engine;
	}
	function rootNode() {
		return root;
	}
	function containerNode() {
		return container;
	}
	function slideNodes() {
		return slides;
	}
	const self = {
		canScrollNext,
		canScrollPrev,
		containerNode,
		internalEngine,
		destroy,
		off,
		on,
		emit,
		plugins,
		previousScrollSnap,
		reInit,
		rootNode,
		scrollNext,
		scrollPrev,
		scrollProgress,
		scrollSnapList,
		scrollTo,
		selectedScrollSnap,
		slideNodes,
		slidesInView,
		slidesNotInView
	};
	activate(userOptions, userPlugins);
	setTimeout(() => eventHandler.emit("init"), 0);
	return self;
}
EmblaCarousel.globalOptions = void 0;

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselCard/useCarouselCardStyles.styles.js
const carouselCardClassNames = { root: "fui-CarouselCard" };
/**
* Styles for the root slot
*/
var useStyles$7 = /* @__PURE__ */ __styles({
	root: {
		xawz: 0,
		Bh6795r: 0,
		Bnnss6s: 0,
		fkmc3a: "fg68ejw",
		B2u0y6b: "f6dzj5z"
	},
	autoSize: {
		xawz: 0,
		Bh6795r: 0,
		Bnnss6s: 0,
		fkmc3a: "fd9q35j",
		Bf4jedk: "fy77jfu",
		a9b677: "f14z66ap",
		B2u0y6b: "f6dzj5z"
	}
}, { d: [
	[".fg68ejw{flex:0 0 100%;}", { p: -1 }],
	".f6dzj5z{max-width:100%;}",
	[".fd9q35j{flex:0 0 auto;}", { p: -1 }],
	".fy77jfu{min-width:0;}",
	".f14z66ap{width:auto;}"
] });
/**
* Apply styling to the CarouselCard slots based on the state
*/
const useCarouselCardStyles_unstable = (state) => {
	"use no memo";
	const { autoSize } = state;
	const styles = useStyles$7();
	state.root.className = mergeClasses(carouselCardClassNames.root, styles.root, autoSize && styles.autoSize, state.root.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselSlider/useCarouselSliderStyles.styles.js
const carouselSliderClassNames = { root: "fui-CarouselSlider" };
/**
* Styles for the root slot
*/
var useStyles$6 = /* @__PURE__ */ __styles({ root: {
	mc9l5x: "f22iagw",
	Eiaeu8: "f1115ve7"
} }, { d: [".f22iagw{display:flex;}", ".f1115ve7{overflow-anchor:none;}"] });
/**
* Apply styling to the CarouselSlider slots based on the state
*/
const useCarouselSliderStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$6();
	state.root.className = mergeClasses(carouselSliderClassNames.root, styles.root, state.root.className);
	return state;
};

//#endregion
//#region node_modules/embla-carousel-autoplay/esm/embla-carousel-autoplay.esm.js
var defaultOptions = {
	active: true,
	breakpoints: {},
	delay: 4e3,
	jump: false,
	playOnInit: true,
	stopOnFocusIn: true,
	stopOnInteraction: true,
	stopOnMouseEnter: false,
	stopOnLastSnap: false,
	rootNode: null
};
function normalizeDelay(emblaApi, delay) {
	const scrollSnaps = emblaApi.scrollSnapList();
	if (typeof delay === "number") return scrollSnaps.map(() => delay);
	return delay(scrollSnaps, emblaApi);
}
function getAutoplayRootNode(emblaApi, rootNode) {
	const emblaRootNode = emblaApi.rootNode();
	return rootNode && rootNode(emblaRootNode) || emblaRootNode;
}
function Autoplay(userOptions = {}) {
	let options;
	let emblaApi;
	let destroyed;
	let delay;
	let timerStartTime = null;
	let timerId = 0;
	let autoplayActive = false;
	let mouseIsOver = false;
	let playOnDocumentVisible = false;
	let jump = false;
	function init(emblaApiInstance, optionsHandler) {
		emblaApi = emblaApiInstance;
		const { mergeOptions, optionsAtMedia } = optionsHandler;
		const optionsBase = mergeOptions(defaultOptions, Autoplay.globalOptions);
		const allOptions = mergeOptions(optionsBase, userOptions);
		options = optionsAtMedia(allOptions);
		if (emblaApi.scrollSnapList().length <= 1) return;
		jump = options.jump;
		destroyed = false;
		delay = normalizeDelay(emblaApi, options.delay);
		const { eventStore, ownerDocument } = emblaApi.internalEngine();
		const isDraggable = !!emblaApi.internalEngine().options.watchDrag;
		const root = getAutoplayRootNode(emblaApi, options.rootNode);
		eventStore.add(ownerDocument, "visibilitychange", visibilityChange);
		if (isDraggable) emblaApi.on("pointerDown", pointerDown);
		if (isDraggable && !options.stopOnInteraction) emblaApi.on("pointerUp", pointerUp);
		if (options.stopOnMouseEnter) eventStore.add(root, "mouseenter", mouseEnter);
		if (options.stopOnMouseEnter && !options.stopOnInteraction) eventStore.add(root, "mouseleave", mouseLeave);
		if (options.stopOnFocusIn) emblaApi.on("slideFocusStart", stopAutoplay);
		if (options.stopOnFocusIn && !options.stopOnInteraction) eventStore.add(emblaApi.containerNode(), "focusout", startAutoplay);
		if (options.playOnInit) startAutoplay();
	}
	function destroy() {
		emblaApi.off("pointerDown", pointerDown).off("pointerUp", pointerUp).off("slideFocusStart", stopAutoplay);
		stopAutoplay();
		destroyed = true;
		autoplayActive = false;
	}
	function setTimer() {
		const { ownerWindow } = emblaApi.internalEngine();
		ownerWindow.clearTimeout(timerId);
		timerId = ownerWindow.setTimeout(next, delay[emblaApi.selectedScrollSnap()]);
		timerStartTime = (/* @__PURE__ */ new Date()).getTime();
		emblaApi.emit("autoplay:timerset");
	}
	function clearTimer() {
		const { ownerWindow } = emblaApi.internalEngine();
		ownerWindow.clearTimeout(timerId);
		timerId = 0;
		timerStartTime = null;
		emblaApi.emit("autoplay:timerstopped");
	}
	function startAutoplay() {
		if (destroyed) return;
		if (documentIsHidden()) {
			playOnDocumentVisible = true;
			return;
		}
		if (!autoplayActive) emblaApi.emit("autoplay:play");
		setTimer();
		autoplayActive = true;
	}
	function stopAutoplay() {
		if (destroyed) return;
		if (autoplayActive) emblaApi.emit("autoplay:stop");
		clearTimer();
		autoplayActive = false;
	}
	function visibilityChange() {
		if (documentIsHidden()) {
			playOnDocumentVisible = autoplayActive;
			return stopAutoplay();
		}
		if (playOnDocumentVisible) startAutoplay();
	}
	function documentIsHidden() {
		const { ownerDocument } = emblaApi.internalEngine();
		return ownerDocument.visibilityState === "hidden";
	}
	function pointerDown() {
		if (!mouseIsOver) stopAutoplay();
	}
	function pointerUp() {
		if (!mouseIsOver) startAutoplay();
	}
	function mouseEnter() {
		mouseIsOver = true;
		stopAutoplay();
	}
	function mouseLeave() {
		mouseIsOver = false;
		startAutoplay();
	}
	function play(jumpOverride) {
		if (typeof jumpOverride !== "undefined") jump = jumpOverride;
		startAutoplay();
	}
	function stop() {
		if (autoplayActive) stopAutoplay();
	}
	function reset() {
		if (autoplayActive) startAutoplay();
	}
	function isPlaying() {
		return autoplayActive;
	}
	function next() {
		const { index } = emblaApi.internalEngine();
		const nextIndex = index.clone().add(1).get();
		const lastIndex = emblaApi.scrollSnapList().length - 1;
		const kill = options.stopOnLastSnap && nextIndex === lastIndex;
		if (emblaApi.canScrollNext()) emblaApi.scrollNext(jump);
		else emblaApi.scrollTo(0, jump);
		emblaApi.emit("autoplay:select");
		if (kill) return stopAutoplay();
		startAutoplay();
	}
	function timeUntilNext() {
		if (!timerStartTime) return null;
		const currentDelay = delay[emblaApi.selectedScrollSnap()];
		const timePastSinceStart = (/* @__PURE__ */ new Date()).getTime() - timerStartTime;
		return currentDelay - timePastSinceStart;
	}
	return {
		name: "autoplay",
		options: userOptions,
		init,
		destroy,
		play,
		stop,
		reset,
		isPlaying,
		timeUntilNext
	};
}
Autoplay.globalOptions = void 0;

//#endregion
//#region node_modules/embla-carousel-fade/esm/embla-carousel-fade.esm.js
function clampNumber(number, min$1, max$1) {
	return Math.min(Math.max(number, min$1), max$1);
}
function isNumber(value) {
	return typeof value === "number" && !isNaN(value);
}
function Fade(userOptions = {}) {
	const fullOpacity = 1;
	const noOpacity = 0;
	const fadeFriction = .68;
	let emblaApi;
	let opacities = [];
	let fadeToNextDistance;
	let distanceFromPointerDown = 0;
	let fadeVelocity = 0;
	let progress = 0;
	let shouldFadePair = false;
	let defaultSettledBehaviour;
	let defaultProgressBehaviour;
	function init(emblaApiInstance) {
		emblaApi = emblaApiInstance;
		const selectedSnap = emblaApi.selectedScrollSnap();
		const { scrollBody, containerRect, axis } = emblaApi.internalEngine();
		const containerSize = axis.measureSize(containerRect);
		fadeToNextDistance = clampNumber(containerSize * .75, 200, 500);
		shouldFadePair = false;
		opacities = emblaApi.scrollSnapList().map((_, index) => index === selectedSnap ? fullOpacity : noOpacity);
		defaultSettledBehaviour = scrollBody.settled;
		defaultProgressBehaviour = emblaApi.scrollProgress;
		scrollBody.settled = settled;
		emblaApi.scrollProgress = scrollProgress;
		emblaApi.on("select", select).on("slideFocus", fadeToSelectedSnapInstantly).on("pointerDown", pointerDown).on("pointerUp", pointerUp);
		disableScroll();
		fadeToSelectedSnapInstantly();
	}
	function destroy() {
		const { scrollBody } = emblaApi.internalEngine();
		scrollBody.settled = defaultSettledBehaviour;
		emblaApi.scrollProgress = defaultProgressBehaviour;
		emblaApi.off("select", select).off("slideFocus", fadeToSelectedSnapInstantly).off("pointerDown", pointerDown).off("pointerUp", pointerUp);
		emblaApi.slideNodes().forEach((slideNode) => {
			const slideStyle = slideNode.style;
			slideStyle.opacity = "";
			slideStyle.transform = "";
			slideStyle.pointerEvents = "";
			if (!slideNode.getAttribute("style")) slideNode.removeAttribute("style");
		});
	}
	function fadeToSelectedSnapInstantly() {
		const selectedSnap = emblaApi.selectedScrollSnap();
		setOpacities(selectedSnap, fullOpacity);
	}
	function pointerUp() {
		shouldFadePair = false;
	}
	function pointerDown() {
		shouldFadePair = false;
		distanceFromPointerDown = 0;
		fadeVelocity = 0;
	}
	function select() {
		const duration = emblaApi.internalEngine().scrollBody.duration();
		fadeVelocity = duration ? 0 : fullOpacity;
		shouldFadePair = true;
		if (!duration) fadeToSelectedSnapInstantly();
	}
	function getSlideTransform(position) {
		const { axis } = emblaApi.internalEngine();
		return `translate${axis.scroll.toUpperCase()}(${axis.direction(position)}px)`;
	}
	function disableScroll() {
		const { translate, slideLooper } = emblaApi.internalEngine();
		translate.clear();
		translate.toggleActive(false);
		slideLooper.loopPoints.forEach(({ translate: translate$1 }) => {
			translate$1.clear();
			translate$1.toggleActive(false);
		});
	}
	function lockExcessiveScroll(fadeIndex) {
		const { scrollSnaps, location, target } = emblaApi.internalEngine();
		if (!isNumber(fadeIndex) || opacities[fadeIndex] < .5) return;
		location.set(scrollSnaps[fadeIndex]);
		target.set(location);
	}
	function setOpacities(fadeIndex, velocity) {
		emblaApi.scrollSnapList().forEach((_, indexA) => {
			const absVelocity = Math.abs(velocity);
			const currentOpacity = opacities[indexA];
			const isFadeIndex = indexA === fadeIndex;
			const nextOpacity = isFadeIndex ? currentOpacity + absVelocity : currentOpacity - absVelocity;
			const clampedOpacity = clampNumber(nextOpacity, noOpacity, fullOpacity);
			opacities[indexA] = clampedOpacity;
			const fadePair = isFadeIndex && shouldFadePair;
			const indexB = emblaApi.previousScrollSnap();
			if (fadePair) opacities[indexB] = 1 - clampedOpacity;
			if (isFadeIndex) setProgress(fadeIndex, clampedOpacity);
			setOpacity(indexA);
		});
	}
	function setOpacity(index) {
		const slidesInSnap = emblaApi.internalEngine().slideRegistry[index];
		const { scrollSnaps, containerRect } = emblaApi.internalEngine();
		const opacity = opacities[index];
		slidesInSnap.forEach((slideIndex) => {
			const slideStyle = emblaApi.slideNodes()[slideIndex].style;
			const roundedOpacity = parseFloat(opacity.toFixed(2));
			const hasOpacity = roundedOpacity > noOpacity;
			const position = hasOpacity ? scrollSnaps[index] : containerRect.width + 2;
			const transform = getSlideTransform(position);
			if (hasOpacity) slideStyle.transform = transform;
			slideStyle.opacity = roundedOpacity.toString();
			slideStyle.pointerEvents = opacity > .5 ? "auto" : "none";
			if (!hasOpacity) slideStyle.transform = transform;
		});
	}
	function setProgress(fadeIndex, opacity) {
		const { index, dragHandler, scrollSnaps } = emblaApi.internalEngine();
		const pointerDown$1 = dragHandler.pointerDown();
		const snapFraction = 1 / (scrollSnaps.length - 1);
		let indexA = fadeIndex;
		let indexB = pointerDown$1 ? emblaApi.selectedScrollSnap() : emblaApi.previousScrollSnap();
		if (pointerDown$1 && indexA === indexB) {
			const reverseSign = Math.sign(distanceFromPointerDown) * -1;
			indexA = indexB;
			indexB = index.clone().set(indexB).add(reverseSign).get();
		}
		const currentPosition = indexB * snapFraction;
		const diffPosition = (indexA - indexB) * snapFraction;
		progress = currentPosition + diffPosition * opacity;
	}
	function getFadeIndex() {
		const { dragHandler, index, scrollBody } = emblaApi.internalEngine();
		const selectedSnap = emblaApi.selectedScrollSnap();
		if (!dragHandler.pointerDown()) return selectedSnap;
		const directionSign = Math.sign(scrollBody.velocity());
		const distanceSign = Math.sign(distanceFromPointerDown);
		const nextSnap = index.clone().set(selectedSnap).add(directionSign * -1).get();
		if (!directionSign || !distanceSign) return null;
		return distanceSign === directionSign ? nextSnap : selectedSnap;
	}
	function fade(emblaApi$1) {
		const { dragHandler, scrollBody } = emblaApi$1.internalEngine();
		const pointerDown$1 = dragHandler.pointerDown();
		const velocity = scrollBody.velocity();
		const duration = scrollBody.duration();
		const fadeIndex = getFadeIndex();
		const noFadeIndex = !isNumber(fadeIndex);
		if (pointerDown$1) {
			if (!velocity) return;
			distanceFromPointerDown += velocity;
			fadeVelocity = Math.abs(velocity / fadeToNextDistance);
			lockExcessiveScroll(fadeIndex);
		}
		if (!pointerDown$1) {
			if (!duration || noFadeIndex) return;
			fadeVelocity += (fullOpacity - opacities[fadeIndex]) / duration;
			fadeVelocity *= fadeFriction;
		}
		if (noFadeIndex) return;
		setOpacities(fadeIndex, fadeVelocity);
	}
	function settled() {
		const { target, location } = emblaApi.internalEngine();
		const diffToTarget = target.get() - location.get();
		const notReachedTarget = Math.abs(diffToTarget) >= 1;
		const fadeIndex = getFadeIndex();
		const noFadeIndex = !isNumber(fadeIndex);
		fade(emblaApi);
		if (noFadeIndex || notReachedTarget) return false;
		return opacities[fadeIndex] > .999;
	}
	function scrollProgress() {
		return progress;
	}
	return {
		name: "fade",
		options: userOptions,
		init,
		destroy
	};
}
Fade.globalOptions = void 0;

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/pointerEvents.js
function pointerEventPlugin(options) {
	let emblaApi;
	let pointerEvent;
	let carouselListenerTarget;
	/**
	* Heads up!
	*
	* We don't use `emblaApi.on('pointerDown', ...)` as the callback does not provide the event.
	*/ function documentDownListener(event) {
		if (event.target) {
			const targetNode = event.target;
			if (targetNode.classList.contains(carouselClassNames.root) || (carouselListenerTarget === null || carouselListenerTarget === void 0 ? void 0 : carouselListenerTarget.contains(targetNode))) pointerEvent = event;
		}
		if (carouselListenerTarget) {
			carouselListenerTarget.removeEventListener("mousedown", documentDownListener);
			carouselListenerTarget.removeEventListener("pointerdown", documentDownListener);
		}
	}
	function pointerUpListener() {
		if (carouselListenerTarget) {
			carouselListenerTarget.addEventListener("mousedown", documentDownListener);
			carouselListenerTarget.addEventListener("pointerdown", documentDownListener);
		}
	}
	function clearPointerEvent() {
		pointerEvent = void 0;
		pointerUpListener();
	}
	function selectListener() {
		if (pointerEvent) {
			var _emblaApi_selectedScrollSnap;
			const newIndex = (_emblaApi_selectedScrollSnap = emblaApi.selectedScrollSnap()) !== null && _emblaApi_selectedScrollSnap !== void 0 ? _emblaApi_selectedScrollSnap : 0;
			options.onSelectViaDrag(pointerEvent, newIndex);
		}
	}
	function init(emblaApiInstance, optionsHandler) {
		emblaApi = emblaApiInstance;
		carouselListenerTarget = emblaApi.containerNode();
		carouselListenerTarget.addEventListener("mousedown", documentDownListener);
		carouselListenerTarget.addEventListener("pointerdown", documentDownListener);
		emblaApi.on("pointerUp", pointerUpListener);
		emblaApi.on("select", selectListener);
		emblaApi.on("settle", clearPointerEvent);
	}
	function destroy() {
		if (carouselListenerTarget) {
			carouselListenerTarget.removeEventListener("mousedown", documentDownListener);
			carouselListenerTarget.removeEventListener("pointerdown", documentDownListener);
		}
		carouselListenerTarget = void 0;
		emblaApi.off("pointerUp", pointerUpListener);
		emblaApi.off("select", selectListener);
		emblaApi.off("settle", clearPointerEvent);
	}
	return {
		name: "pointerEvent",
		options,
		init,
		destroy
	};
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/useEmblaCarousel.js
var DEFAULT_EMBLA_OPTIONS = {
	containScroll: "trimSnaps",
	inViewThreshold: .99,
	watchDrag: false,
	skipSnaps: true,
	container: `.${carouselSliderClassNames.root}`,
	slides: `.${carouselCardClassNames.root}`
};
const EMBLA_VISIBILITY_EVENT = "embla:visibilitychange";
function setTabsterDefault(element, isDefault) {
	const tabsterAttr = element.getAttribute("data-tabster");
	if (tabsterAttr) {
		const tabsterAttributes = JSON.parse(tabsterAttr);
		if (tabsterAttributes.focusable) {
			tabsterAttributes.focusable.isDefault = isDefault;
			element.setAttribute("data-tabster", JSON.stringify(tabsterAttributes));
		}
	}
}
function useEmblaCarousel(options) {
	const { align, autoplayInterval, direction, loop, slidesToScroll, watchDrag, containScroll, motion, onDragIndexChange, onAutoplayIndexChange } = options;
	var _motion_kind;
	const motionType = typeof motion === "string" ? motion : (_motion_kind = motion === null || motion === void 0 ? void 0 : motion.kind) !== null && _motion_kind !== void 0 ? _motion_kind : "slide";
	var _motion_duration;
	const motionDuration = typeof motion === "string" ? 25 : (_motion_duration = motion === null || motion === void 0 ? void 0 : motion.duration) !== null && _motion_duration !== void 0 ? _motion_duration : 25;
	const [activeIndex, setActiveIndex] = useControllableState({
		defaultState: options.defaultActiveIndex,
		state: options.activeIndex,
		initialState: 0
	});
	const onDragEvent = useEventCallback((event, index) => {
		onDragIndexChange === null || onDragIndexChange === void 0 || onDragIndexChange(event, {
			event,
			type: "drag",
			index
		});
	});
	const emblaOptions = import_react.useRef({
		align,
		direction,
		loop,
		slidesToScroll,
		startIndex: activeIndex,
		watchDrag,
		containScroll,
		duration: motionDuration
	});
	const emblaApi = import_react.useRef(null);
	const autoplayRef = import_react.useRef(false);
	const resetAutoplay = import_react.useCallback(() => {
		var _emblaApi_current_plugins_autoplay, _emblaApi_current;
		(_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 || (_emblaApi_current_plugins_autoplay = _emblaApi_current.plugins().autoplay) == null || _emblaApi_current_plugins_autoplay.reset();
	}, []);
	const getPlugins = import_react.useCallback(() => {
		const plugins = [];
		plugins.push(Autoplay({
			playOnInit: autoplayRef.current,
			delay: autoplayInterval,
			stopOnInteraction: true,
			stopOnFocusIn: false,
			stopOnMouseEnter: false
		}));
		if (motionType === "fade") plugins.push(Fade());
		if (watchDrag) plugins.push(pointerEventPlugin({ onSelectViaDrag: onDragEvent }));
		return plugins;
	}, [
		motionType,
		onDragEvent,
		watchDrag,
		autoplayInterval
	]);
	const enableAutoplay = import_react.useCallback((autoplay, temporary) => {
		if (!temporary) autoplayRef.current = autoplay;
		if (autoplay && autoplayRef.current) {
			var _emblaApi_current_plugins_autoplay, _emblaApi_current;
			(_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 || (_emblaApi_current_plugins_autoplay = _emblaApi_current.plugins().autoplay) == null || _emblaApi_current_plugins_autoplay.play();
			resetAutoplay();
		} else if (!autoplay) {
			var _emblaApi_current_plugins_autoplay1, _emblaApi_current1;
			(_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 || (_emblaApi_current_plugins_autoplay1 = _emblaApi_current1.plugins().autoplay) == null || _emblaApi_current_plugins_autoplay1.stop();
		}
	}, [resetAutoplay]);
	const listeners = import_react.useRef(/* @__PURE__ */ new Set());
	const subscribeForValues = import_react.useCallback((listener) => {
		listeners.current.add(listener);
		return () => {
			listeners.current.delete(listener);
		};
	}, []);
	const updateIndex = () => {
		var _emblaApi_current, _emblaApi_current1, _emblaApi_current2, _slideRegistry_newIndex;
		var _emblaApi_current_selectedScrollSnap;
		const newIndex = (_emblaApi_current_selectedScrollSnap = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.selectedScrollSnap()) !== null && _emblaApi_current_selectedScrollSnap !== void 0 ? _emblaApi_current_selectedScrollSnap : 0;
		const slides = (_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 ? void 0 : _emblaApi_current1.slideNodes();
		const slideRegistry = (_emblaApi_current2 = emblaApi.current) === null || _emblaApi_current2 === void 0 ? void 0 : _emblaApi_current2.internalEngine().slideRegistry;
		var _slideRegistry_newIndex_;
		const actualIndex = (_slideRegistry_newIndex_ = slideRegistry === null || slideRegistry === void 0 ? void 0 : (_slideRegistry_newIndex = slideRegistry[newIndex]) === null || _slideRegistry_newIndex === void 0 ? void 0 : _slideRegistry_newIndex[0]) !== null && _slideRegistry_newIndex_ !== void 0 ? _slideRegistry_newIndex_ : 0;
		slides === null || slides === void 0 || slides.forEach((slide, slideIndex) => {
			setTabsterDefault(slide, slideIndex === actualIndex);
		});
		setActiveIndex(newIndex);
	};
	const handleReinit = useEventCallback(() => {
		var _emblaApi_current, _emblaApi_current1, _emblaApi_current2, _emblaApi_current3, _emblaApi_current4;
		var _emblaApi_current_slideNodes;
		const nodes = (_emblaApi_current_slideNodes = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.slideNodes()) !== null && _emblaApi_current_slideNodes !== void 0 ? _emblaApi_current_slideNodes : [];
		var _emblaApi_current_internalEngine_slideRegistry;
		const groupIndexList = (_emblaApi_current_internalEngine_slideRegistry = (_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 ? void 0 : _emblaApi_current1.internalEngine().slideRegistry) !== null && _emblaApi_current_internalEngine_slideRegistry !== void 0 ? _emblaApi_current_internalEngine_slideRegistry : [];
		const navItemsCount = groupIndexList.length > 0 ? groupIndexList.length : nodes.length;
		const canLoop = (_emblaApi_current2 = emblaApi.current) === null || _emblaApi_current2 === void 0 ? void 0 : _emblaApi_current2.internalEngine().slideLooper.canLoop();
		var _emblaApi_current_selectedScrollSnap;
		const data = {
			navItemsCount,
			activeIndex: (_emblaApi_current_selectedScrollSnap = (_emblaApi_current3 = emblaApi.current) === null || _emblaApi_current3 === void 0 ? void 0 : _emblaApi_current3.selectedScrollSnap()) !== null && _emblaApi_current_selectedScrollSnap !== void 0 ? _emblaApi_current_selectedScrollSnap : 0,
			groupIndexList,
			slideNodes: nodes,
			canLoop
		};
		updateIndex();
		(_emblaApi_current4 = emblaApi.current) === null || _emblaApi_current4 === void 0 || _emblaApi_current4.scrollTo(activeIndex, false);
		for (const listener of listeners.current) listener(data);
	});
	const handleIndexChange = useEventCallback((_, eventType) => {
		var _emblaApi_current;
		var _emblaApi_current_selectedScrollSnap;
		const newIndex = (_emblaApi_current_selectedScrollSnap = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.selectedScrollSnap()) !== null && _emblaApi_current_selectedScrollSnap !== void 0 ? _emblaApi_current_selectedScrollSnap : 0;
		updateIndex();
		if (eventType === "autoplay:select") {
			const noopEvent = new Event("autoplay");
			onAutoplayIndexChange === null || onAutoplayIndexChange === void 0 || onAutoplayIndexChange(noopEvent, {
				event: noopEvent,
				type: "autoplay",
				index: newIndex
			});
		}
	});
	const viewportRef = import_react.useRef(null);
	const containerRef = import_react.useMemo(() => {
		const handleVisibilityChange = () => {
			var _emblaApi_current, _emblaApi_current1;
			const cardElements = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.slideNodes();
			var _emblaApi_current_slidesInView;
			const visibleIndexes = (_emblaApi_current_slidesInView = (_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 ? void 0 : _emblaApi_current1.slidesInView()) !== null && _emblaApi_current_slidesInView !== void 0 ? _emblaApi_current_slidesInView : [];
			cardElements === null || cardElements === void 0 || cardElements.forEach((cardElement, index) => {
				cardElement.dispatchEvent(new CustomEvent(EMBLA_VISIBILITY_EVENT, {
					bubbles: false,
					detail: { isVisible: visibleIndexes.includes(index) }
				}));
			});
		};
		const plugins = getPlugins();
		return { set current(newElement) {
			if (emblaApi.current) {
				var _emblaApi_current_plugins_autoplay, _emblaApi_current_plugins, _emblaApi_current;
				(_emblaApi_current_plugins = (_emblaApi_current = emblaApi.current).plugins) === null || _emblaApi_current_plugins === void 0 || (_emblaApi_current_plugins_autoplay = _emblaApi_current_plugins.call(_emblaApi_current).autoplay) == null || _emblaApi_current_plugins_autoplay.stop();
				emblaApi.current.off("slidesInView", handleVisibilityChange);
				emblaApi.current.off("select", handleIndexChange);
				emblaApi.current.off("reInit", handleReinit);
				emblaApi.current.off("autoplay:select", handleIndexChange);
				emblaApi.current.destroy();
				emblaApi.current = null;
			}
			if (newElement) {
				var _viewportRef_current;
				const newEmblaApi = EmblaCarousel((_viewportRef_current = viewportRef.current) !== null && _viewportRef_current !== void 0 ? _viewportRef_current : newElement, {
					...DEFAULT_EMBLA_OPTIONS,
					...emblaOptions.current
				}, plugins);
				newEmblaApi.on("reInit", handleReinit);
				newEmblaApi.on("slidesInView", handleVisibilityChange);
				newEmblaApi.on("select", handleIndexChange);
				newEmblaApi.on("autoplay:select", handleIndexChange);
				emblaApi.current = newEmblaApi;
			}
		} };
	}, [
		getPlugins,
		handleIndexChange,
		handleReinit
	]);
	const carouselApi = import_react.useMemo(() => ({
		scrollToElement: (element, jump) => {
			var _emblaApi_current, _emblaApi_current1, _emblaApi_current2;
			const cardElements = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.slideNodes();
			var _emblaApi_current_internalEngine_slideRegistry;
			const groupIndexList = (_emblaApi_current_internalEngine_slideRegistry = (_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 ? void 0 : _emblaApi_current1.internalEngine().slideRegistry) !== null && _emblaApi_current_internalEngine_slideRegistry !== void 0 ? _emblaApi_current_internalEngine_slideRegistry : [];
			var _cardElements_indexOf;
			const cardIndex = (_cardElements_indexOf = cardElements === null || cardElements === void 0 ? void 0 : cardElements.indexOf(element)) !== null && _cardElements_indexOf !== void 0 ? _cardElements_indexOf : 0;
			const groupIndex = groupIndexList.findIndex((group) => {
				return group.includes(cardIndex);
			});
			const indexFocus = groupIndex !== null && groupIndex !== void 0 ? groupIndex : cardIndex;
			(_emblaApi_current2 = emblaApi.current) === null || _emblaApi_current2 === void 0 || _emblaApi_current2.scrollTo(indexFocus, jump);
			return indexFocus;
		},
		scrollToIndex: (index, jump) => {
			var _emblaApi_current;
			(_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 || _emblaApi_current.scrollTo(index, jump);
		},
		scrollInDirection: (dir) => {
			var _emblaApi_current;
			if (dir === "prev") {
				var _emblaApi_current1;
				(_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 || _emblaApi_current1.scrollPrev();
			} else {
				var _emblaApi_current2;
				(_emblaApi_current2 = emblaApi.current) === null || _emblaApi_current2 === void 0 || _emblaApi_current2.scrollNext();
			}
			var _emblaApi_current_selectedScrollSnap;
			return (_emblaApi_current_selectedScrollSnap = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.selectedScrollSnap()) !== null && _emblaApi_current_selectedScrollSnap !== void 0 ? _emblaApi_current_selectedScrollSnap : 0;
		}
	}), []);
	import_react.useEffect(() => {
		var _emblaApi_current_plugins_autoplay, _emblaApi_current_plugins, _emblaApi_current, _emblaApi_current1;
		const plugins = getPlugins();
		emblaOptions.current = {
			startIndex: emblaOptions.current.startIndex,
			align,
			direction,
			loop,
			slidesToScroll,
			watchDrag,
			containScroll,
			duration: motionDuration
		};
		(_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 || (_emblaApi_current_plugins = _emblaApi_current.plugins) == null || (_emblaApi_current_plugins_autoplay = _emblaApi_current_plugins.call(_emblaApi_current).autoplay) == null || _emblaApi_current_plugins_autoplay.stop();
		(_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 || _emblaApi_current1.reInit({
			...DEFAULT_EMBLA_OPTIONS,
			...emblaOptions.current
		}, plugins);
	}, [
		align,
		containScroll,
		direction,
		getPlugins,
		loop,
		slidesToScroll,
		watchDrag,
		motionDuration
	]);
	import_react.useEffect(() => {
		var _emblaApi_current, _emblaApi_current_slideNodes, _emblaApi_current1;
		var _emblaApi_current_selectedScrollSnap;
		const currentActiveIndex = (_emblaApi_current_selectedScrollSnap = (_emblaApi_current = emblaApi.current) === null || _emblaApi_current === void 0 ? void 0 : _emblaApi_current.selectedScrollSnap()) !== null && _emblaApi_current_selectedScrollSnap !== void 0 ? _emblaApi_current_selectedScrollSnap : 0;
		var _emblaApi_current_slideNodes_length;
		const slideLength = (_emblaApi_current_slideNodes_length = (_emblaApi_current1 = emblaApi.current) === null || _emblaApi_current1 === void 0 ? void 0 : (_emblaApi_current_slideNodes = _emblaApi_current1.slideNodes()) === null || _emblaApi_current_slideNodes === void 0 ? void 0 : _emblaApi_current_slideNodes.length) !== null && _emblaApi_current_slideNodes_length !== void 0 ? _emblaApi_current_slideNodes_length : 0;
		emblaOptions.current.startIndex = activeIndex;
		if (activeIndex < slideLength && activeIndex !== currentActiveIndex) {
			var _emblaApi_current2;
			(_emblaApi_current2 = emblaApi.current) === null || _emblaApi_current2 === void 0 || _emblaApi_current2.scrollTo(activeIndex);
		}
	}, [activeIndex]);
	return {
		activeIndex,
		carouselApi,
		viewportRef,
		containerRef,
		subscribeForValues,
		enableAutoplay,
		resetAutoplay
	};
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/Carousel/useCarousel.js
/**
* Create the state required to render Carousel.
*
* The returned state can be modified with hooks such as useCarouselStyles_unstable,
* before being passed to renderCarousel_unstable.
*
* @param props - props from this instance of Carousel
* @param ref - reference to root HTMLDivElement of Carousel
*/ function useCarousel_unstable(props, ref) {
	"use no memo";
	const { align = "center", circular = false, onActiveIndexChange, groupSize = "auto", draggable = false, whitespace = false, announcement, motion = "slide", autoplayInterval = 4e3 } = props;
	const { dir } = useFluent();
	const { activeIndex, carouselApi, containerRef, viewportRef, subscribeForValues, enableAutoplay, resetAutoplay } = useEmblaCarousel({
		align,
		direction: dir,
		loop: circular,
		slidesToScroll: groupSize,
		defaultActiveIndex: props.defaultActiveIndex,
		activeIndex: props.activeIndex,
		watchDrag: draggable,
		containScroll: whitespace ? false : "keepSnaps",
		motion,
		onDragIndexChange: onActiveIndexChange,
		onAutoplayIndexChange: onActiveIndexChange,
		autoplayInterval
	});
	const selectPageByElement = useEventCallback((event, element, jump) => {
		const foundIndex = carouselApi.scrollToElement(element, jump);
		onActiveIndexChange === null || onActiveIndexChange === void 0 || onActiveIndexChange(event, {
			event,
			type: "focus",
			index: foundIndex
		});
		return foundIndex;
	});
	const selectPageByIndex = useEventCallback((event, index, jump) => {
		carouselApi.scrollToIndex(index, jump);
		onActiveIndexChange === null || onActiveIndexChange === void 0 || onActiveIndexChange(event, {
			event,
			type: "click",
			index
		});
	});
	const selectPageByDirection = useEventCallback((event, direction) => {
		const nextPageIndex = carouselApi.scrollInDirection(direction);
		onActiveIndexChange === null || onActiveIndexChange === void 0 || onActiveIndexChange(event, {
			event,
			type: "click",
			index: nextPageIndex
		});
		return nextPageIndex;
	});
	const mergedContainerRef = useMergedRefs(ref, containerRef);
	const announcementTextRef = import_react.useRef("");
	const totalNavLength = import_react.useRef(0);
	const navGroupRef = import_react.useRef([]);
	const { announce } = useAnnounce();
	const updateAnnouncement = useEventCallback(() => {
		if (totalNavLength.current <= 0 || !announcement) return;
		const announcementText = announcement(activeIndex, totalNavLength.current, navGroupRef.current);
		if (announcementText !== announcementTextRef.current) {
			announcementTextRef.current = announcementText;
			announce(announcementText, { polite: true });
		}
	});
	useIsomorphicLayoutEffect(() => {
		return subscribeForValues((data) => {
			if (totalNavLength.current <= 0 && data.navItemsCount > 0 && announcement) announcementTextRef.current = announcement(data.activeIndex, data.navItemsCount, data.groupIndexList);
			totalNavLength.current = data.navItemsCount;
			navGroupRef.current = data.groupIndexList;
			updateAnnouncement();
		});
	}, [
		subscribeForValues,
		updateAnnouncement,
		announcement
	]);
	useIsomorphicLayoutEffect(() => {
		updateAnnouncement();
	}, [activeIndex, updateAnnouncement]);
	return {
		components: { root: "div" },
		root: always(getIntrinsicElementProps("div", {
			ref: mergedContainerRef,
			role: "region",
			...props
		}), { elementType: "div" }),
		activeIndex,
		circular,
		containerRef: mergedContainerRef,
		viewportRef,
		selectPageByElement,
		selectPageByDirection,
		selectPageByIndex,
		subscribeForValues,
		enableAutoplay,
		resetAutoplay
	};
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/Carousel/renderCarousel.js
/**
* Render the final JSX of Carousel
*/ const renderCarousel_unstable = (state, contextValues) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(CarouselProvider, {
		value: contextValues.carousel,
		children: /* @__PURE__ */ jsx(state.root, {})
	});
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/Carousel/useCarouselStyles.styles.js
const carouselClassNames = { root: "fui-Carousel" };
/**
* Styles for the root slot
*/
var useStyles$5 = /* @__PURE__ */ __styles({ root: {
	B68tc82: "f1p9o1ba",
	Eiaeu8: "f1115ve7",
	qhf8xq: "f10pi13n"
} }, { d: [
	".f1p9o1ba{overflow-x:hidden;}",
	".f1115ve7{overflow-anchor:none;}",
	".f10pi13n{position:relative;}"
] });
/**
* Apply styling to the Carousel slots based on the state
*/
const useCarouselStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$5();
	state.root.className = mergeClasses(carouselClassNames.root, styles.root, state.root.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/Carousel/useCarouselContextValues.js
function useCarouselContextValues_unstable(state) {
	const { activeIndex, selectPageByElement, selectPageByDirection, selectPageByIndex, subscribeForValues, enableAutoplay, resetAutoplay, circular, containerRef, viewportRef } = state;
	return { carousel: import_react.useMemo(() => ({
		activeIndex,
		selectPageByElement,
		selectPageByDirection,
		selectPageByIndex,
		subscribeForValues,
		enableAutoplay,
		resetAutoplay,
		circular,
		containerRef,
		viewportRef
	}), [
		activeIndex,
		selectPageByElement,
		selectPageByDirection,
		selectPageByIndex,
		subscribeForValues,
		enableAutoplay,
		resetAutoplay,
		circular,
		containerRef,
		viewportRef
	]) };
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/Carousel/Carousel.js
/**
* Carousel is the context wrapper and container for all carousel content/controls,
* it has no direct style or slot opinions.
*
* Carousel also provides API interfaces for callbacks that will occur on navigation events.
*/ const Carousel = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarousel_unstable(props, ref);
	useCarouselStyles_unstable(state);
	useCustomStyleHook("useCarouselStyles_unstable")(state);
	const contextValues = useCarouselContextValues_unstable(state);
	return renderCarousel_unstable(state, contextValues);
});
Carousel.displayName = "Carousel";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselSlider/CarouselSliderContext.js
var carouselSliderContext = import_react.createContext(void 0);
const carouselSliderContextDefaultValue = { cardFocus: false };
const useCarouselSliderContext = () => {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(carouselSliderContext)) !== null && _React_useContext !== void 0 ? _React_useContext : carouselSliderContextDefaultValue;
};
const CarouselSliderContextProvider = carouselSliderContext.Provider;
function useCarouselSliderContextValues_unstable(state) {
	const { cardFocus } = state;
	return { carouselSlider: import_react.useMemo(() => ({ cardFocus }), [cardFocus]) };
}

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselCard/useCarouselCard.js
/**
* Create the state required to render CarouselCard.
*
* The returned state can be modified with hooks such as useCarouselCardStyles_unstable,
* before being passed to renderCarouselCard_unstable.
*
* @param props - props from this instance of CarouselCard
* @param ref - reference to root HTMLDivElement of CarouselCard
*/ const useCarouselCard_unstable = (props, ref) => {
	const { autoSize } = props;
	const elementRef = import_react.useRef(null);
	const isMouseEvent$1 = import_react.useRef(false);
	const selectPageByElement = useCarouselContext_unstable((ctx) => ctx.selectPageByElement);
	const containerRef = useCarouselContext_unstable((ctx) => ctx.containerRef);
	const { cardFocus } = useCarouselSliderContext();
	const focusAttr = useFocusableGroup({ tabBehavior: "limited" });
	const focusAttrProps = cardFocus ? {
		...focusAttr,
		tabIndex: 0
	} : {};
	const id = useId(carouselCardClassNames.root, props.id);
	import_react.useEffect(() => {
		const element = elementRef.current;
		if (element) {
			const listener = (_e) => {
				const event = _e;
				if (!cardFocus) {
					const hidden = !event.detail.isVisible;
					element.ariaHidden = hidden.toString();
					element.inert = hidden;
				}
			};
			element.addEventListener(EMBLA_VISIBILITY_EVENT, listener);
			return () => {
				element.removeEventListener(EMBLA_VISIBILITY_EVENT, listener);
			};
		}
	}, [cardFocus]);
	const handleFocus = import_react.useCallback((e) => {
		if (!e.defaultPrevented && isHTMLElement(e.currentTarget) && !isMouseEvent$1.current) {
			var _containerRef_current;
			containerRef === null || containerRef === void 0 || (_containerRef_current = containerRef.current) == null || _containerRef_current.scrollTo(0, 0);
			selectPageByElement(e, e.currentTarget, false);
		}
		isMouseEvent$1.current = false;
	}, [selectPageByElement, containerRef]);
	const handlePointerDown = (e) => {
		if (!e.defaultPrevented) isMouseEvent$1.current = true;
	};
	const handlePointerUp = (e) => {
		if (!e.defaultPrevented) isMouseEvent$1.current = false;
	};
	const onFocusCapture = mergeCallbacks(props.onFocusCapture, handleFocus);
	const onPointerUp = mergeCallbacks(props.onPointerUp, handlePointerUp);
	const onPointerDown = mergeCallbacks(props.onPointerDown, handlePointerDown);
	return {
		autoSize,
		components: { root: "div" },
		root: always(getIntrinsicElementProps("div", {
			ref: useMergedRefs(elementRef, ref),
			role: "tabpanel",
			tabIndex: cardFocus ? 0 : void 0,
			...props,
			id,
			onFocusCapture,
			onPointerUp,
			onPointerDown,
			...focusAttrProps
		}), { elementType: "div" })
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselCard/renderCarouselCard.js
/**
* Render the final JSX of CarouselCard
*/ const renderCarouselCard_unstable = (state) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(state.root, {});
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselCard/CarouselCard.js
/**
* The defining wrapper of a carousel's indexed content, they will take up the full
* viewport of CarouselSlider or div wrapper,
* users may place multiple items within this Card if desired, with consideration of viewport width.
*
* Clickable actions within the content area are available via mouse and tab as expected,
* non-active card content will be set to inert until moved to active card.
*/ const CarouselCard = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselCard_unstable(props, ref);
	useCarouselCardStyles_unstable(state);
	useCustomStyleHook("useCarouselCardStyles_unstable")(state);
	return renderCarouselCard_unstable(state);
});
CarouselCard.displayName = "CarouselCard";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselAutoplayButton/useCarouselAutoplayButton.js
/**
* Create the state required to render CarouselAutoplayButton.
*
* The returned state can be modified with hooks such as useCarouselAutoplayButtonStyles_unstable,
* before being passed to renderCarouselAutoplayButton_unstable.
*
* @param props - props from this instance of CarouselAutoplayButton
* @param ref - reference to root HTMLDivElement of CarouselAutoplayButton
*/ const useCarouselAutoplayButton_unstable = (props, ref) => {
	const { onCheckedChange, checked, defaultChecked } = props;
	const [autoplay, setAutoplay] = useControllableState({
		state: checked,
		defaultState: defaultChecked,
		initialState: false
	});
	const enableAutoplay = useCarouselContext_unstable((ctx) => ctx.enableAutoplay);
	import_react.useEffect(() => {
		enableAutoplay(autoplay);
		return () => {
			enableAutoplay(false);
		};
	}, [autoplay, enableAutoplay]);
	const handleClick = (event) => {
		if (event.isDefaultPrevented()) return;
		const newValue = !autoplay;
		setAutoplay(newValue);
		onCheckedChange === null || onCheckedChange === void 0 || onCheckedChange(event, {
			event,
			type: "click",
			checked: newValue
		});
	};
	return { ...useToggleButton_unstable({
		icon: optional(props.icon, {
			defaultProps: { children: autoplay ? /* @__PURE__ */ import_react.createElement(PauseCircleRegular, null) : /* @__PURE__ */ import_react.createElement(PlayCircleRegular, null) },
			renderByDefault: true,
			elementType: "span"
		}),
		...props,
		checked: autoplay,
		onClick: useEventCallback(mergeCallbacks(handleClick, props.onClick))
	}, ref) };
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselAutoplayButton/renderCarouselAutoplayButton.js
/**
* Render the final JSX of CarouselAutoplayButton
*/ const renderCarouselAutoplayButton_unstable = (state) => {
	assertSlots(state);
	return renderButton_unstable(state);
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselAutoplayButton/useCarouselAutoplayButtonStyles.styles.js
const carouselAutoplayButtonClassNames = {
	root: "fui-CarouselAutoplayButton",
	icon: "fui-CarouselAutoplayButton__icon"
};
/**
* Styles for the root slot
*/
var useStyles$4 = /* @__PURE__ */ __styles({ root: {
	Bkecrkj: "fc5wo7j",
	B6of3ja: "fgr6219",
	jrapky: "f10jk5vf",
	g2u3we: "fghlq4f",
	h3c5rm: ["f1gn591s", "fjscplz"],
	B9xav0g: "fb073pr",
	zhjwy3: ["fjscplz", "f1gn591s"],
	sj55zd: "fkfq4zb",
	De3pzq: "fkfdr9r",
	eoavqd: "f8491dx"
} }, {
	d: [
		".fc5wo7j{pointer-events:all;}",
		".fgr6219{margin-top:auto;}",
		".f10jk5vf{margin-bottom:auto;}",
		".fghlq4f{border-top-color:var(--colorTransparentStroke);}",
		".f1gn591s{border-right-color:var(--colorTransparentStroke);}",
		".fjscplz{border-left-color:var(--colorTransparentStroke);}",
		".fb073pr{border-bottom-color:var(--colorTransparentStroke);}",
		".fkfq4zb{color:var(--colorNeutralForeground2);}",
		".fkfdr9r{background-color:var(--colorNeutralBackgroundAlpha);}"
	],
	h: [".f8491dx:hover{cursor:pointer;}"]
});
/**
* Apply styling to the CarouselAutoplayButton slots based on the state
*/
const useCarouselAutoplayButtonStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$4();
	useToggleButtonStyles_unstable(state);
	state.root.className = mergeClasses(carouselAutoplayButtonClassNames.root, styles.root, state.root.className);
	if (state.icon) state.icon.className = mergeClasses(carouselAutoplayButtonClassNames.icon, state.icon.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselAutoplayButton/CarouselAutoplayButton.js
/**
* If the Carousel is on auto-play, the user may opt into pausing the auto-play feature via the
* CarouselAutoplayButton which must be present for auto-play to be enabled.
*
* If CarouselAutoplayButton is present, auto-play will default to true on mount.
*/ const CarouselAutoplayButton = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselAutoplayButton_unstable(props, ref);
	useCarouselAutoplayButtonStyles_unstable(state);
	useCustomStyleHook("useCarouselAutoplayButtonStyles_unstable")(state);
	return renderCarouselAutoplayButton_unstable(state);
});
CarouselAutoplayButton.displayName = "CarouselAutoplayButton";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavImageButton/useCarouselNavImageButton.js
/**
* Create the state required to render CarouselNavImageButton.
*
* The returned state can be modified with hooks such as useCarouselNavImageButtonStyles_unstable,
* before being passed to renderCarouselNavImageButton_unstable.
*
* @param props - props from this instance of CarouselNavImageButton
* @param ref - reference to root HTMLButtonElement | HTMLAnchorElement of CarouselNavImageButton
*/ const useCarouselNavImageButton_unstable = (props, ref) => {
	const { onClick, as = "button" } = props;
	const index = useCarouselNavIndexContext();
	const selectPageByIndex = useCarouselContext_unstable((ctx) => ctx.selectPageByIndex);
	const selected = useCarouselContext_unstable((ctx) => ctx.activeIndex === index);
	const subscribeForValues = useCarouselContext_unstable((ctx) => ctx.subscribeForValues);
	const handleClick = useEventCallback((event) => {
		onClick === null || onClick === void 0 || onClick(event);
		if (!event.defaultPrevented && isHTMLElement(event.target)) selectPageByIndex(event, index);
	});
	const defaultTabProps = useTabsterAttributes({ focusable: { isDefault: selected } });
	const buttonRef = import_react.useRef(void 0);
	const _carouselButton = always(getIntrinsicElementProps(as, useARIAButtonProps(props.as, props)), {
		elementType: "button",
		defaultProps: {
			ref: useMergedRefs(ref, buttonRef),
			role: "tab",
			type: "button",
			"aria-selected": selected,
			...defaultTabProps
		}
	});
	useIsomorphicLayoutEffect(() => {
		return subscribeForValues((data) => {
			var _data_groupIndexList;
			var _data_groupIndexList_index;
			const _controlledSlideIds = ((_data_groupIndexList_index = (_data_groupIndexList = data.groupIndexList) === null || _data_groupIndexList === void 0 ? void 0 : _data_groupIndexList[index]) !== null && _data_groupIndexList_index !== void 0 ? _data_groupIndexList_index : []).map((slideIndex) => {
				return data.slideNodes[slideIndex].id;
			}).join(" ");
			if (buttonRef.current) buttonRef.current.setAttribute("aria-controls", _controlledSlideIds);
		});
	}, [subscribeForValues, index]);
	_carouselButton.onClick = handleClick;
	const image = always(getIntrinsicElementProps("img", {
		"aria-hidden": true,
		alt: "",
		role: "presentation",
		...props.image
	}), { elementType: "img" });
	return {
		components: {
			root: "button",
			image: "img"
		},
		root: _carouselButton,
		image,
		selected
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavImageButton/renderCarouselNavImageButton.js
/**
* Render the final JSX of CarouselNavImageButton
*/ const renderCarouselNavImageButton_unstable = (state) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(state.root, { children: /* @__PURE__ */ jsx(state.image, {}) });
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavImageButton/useCarouselNavImageButtonStyles.styles.js
const carouselNavImageButtonClassNames = {
	root: "fui-CarouselNavImageButton",
	image: "fui-CarouselNavImageButton__image"
};
/**
* Styles for the root slot
*/
var useStyles$3 = /* @__PURE__ */ __styles({
	root: {
		B7ck84d: "f1e4lqlz",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f1c5fvqg",
		jrapky: 0,
		Frg6f3: 0,
		t21cq0: 0,
		B6of3ja: 0,
		B74szlk: "f186qr3g",
		g2u3we: "fghlq4f",
		h3c5rm: ["f1gn591s", "fjscplz"],
		B9xav0g: "fb073pr",
		zhjwy3: ["fjscplz", "f1gn591s"],
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "fq9zq91",
		a9b677: "feqmc2u",
		Bqenvij: "fbhnoac",
		B68tc82: 0,
		Bmxbyg5: 0,
		Bpg54ce: "f1a3p1vp",
		eoavqd: "f8491dx"
	},
	image: {
		a9b677: "feqmc2u",
		Bqenvij: "fbhnoac",
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "fq9zq91"
	},
	selected: {
		a9b677: "f124akge",
		Bqenvij: "ff2sm71"
	}
}, {
	d: [
		".f1e4lqlz{box-sizing:content-box;}",
		[".f1c5fvqg{padding:0px;}", { p: -1 }],
		[".f186qr3g{margin:0 var(--spacingHorizontalXS);}", { p: -1 }],
		".fghlq4f{border-top-color:var(--colorTransparentStroke);}",
		".f1gn591s{border-right-color:var(--colorTransparentStroke);}",
		".fjscplz{border-left-color:var(--colorTransparentStroke);}",
		".fb073pr{border-bottom-color:var(--colorTransparentStroke);}",
		[".fq9zq91{border-radius:var(--borderRadiusSmall);}", { p: -1 }],
		".feqmc2u{width:40px;}",
		".fbhnoac{height:40px;}",
		[".f1a3p1vp{overflow:hidden;}", { p: -1 }],
		[".fq9zq91{border-radius:var(--borderRadiusSmall);}", { p: -1 }],
		".f124akge{width:48px;}",
		".ff2sm71{height:48px;}"
	],
	h: [".f8491dx:hover{cursor:pointer;}"]
});
/**
* Apply styling to the CarouselNavImageButton slots based on the state
*/
const useCarouselNavImageButtonStyles_unstable = (state) => {
	"use no memo";
	const { selected } = state;
	const styles = useStyles$3();
	state.root.className = mergeClasses(carouselNavImageButtonClassNames.root, styles.root, selected && styles.selected, state.root.className);
	if (state.image) {
		var _state_image;
		state.image.className = mergeClasses(carouselNavImageButtonClassNames.image, styles.image, selected && styles.selected, (_state_image = state.image) === null || _state_image === void 0 ? void 0 : _state_image.className);
	}
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavImageButton/CarouselNavImageButton.js
/**
* A variant child element of CarouselNav, a singular image button that displays a
* preview of card content and will set the carousels active value on click.
*/ const CarouselNavImageButton = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselNavImageButton_unstable(props, ref);
	useCarouselNavImageButtonStyles_unstable(state);
	useCustomStyleHook("useCarouselNavImageButtonStyles_unstable")(state);
	return renderCarouselNavImageButton_unstable(state);
});
CarouselNavImageButton.displayName = "CarouselNavImageButton";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselSlider/useCarouselSlider.js
/**
* Create the state required to render CarouselSlider.
*
* The returned state can be modified with hooks such as useCarouselSliderStyles_unstable,
* before being passed to renderCarouselSlider_unstable.
*
* @param props - props from this instance of CarouselSlider
* @param ref - reference to root HTMLDivElement of CarouselSlider
*/ const useCarouselSlider_unstable = (props, ref) => {
	const { cardFocus = false } = props;
	const circular = useCarouselContext_unstable((ctx) => ctx.circular);
	const focusableGroupAttr = useArrowNavigationGroup({
		circular,
		axis: "horizontal",
		memorizeCurrent: false,
		unstable_hasDefault: true
	});
	const focusProps = cardFocus ? focusableGroupAttr : {};
	return {
		cardFocus,
		components: { root: "div" },
		root: always(getIntrinsicElementProps("div", {
			ref,
			role: "group",
			...props,
			...focusProps
		}), { elementType: "div" })
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselSlider/renderCarouselSlider.js
/**
* Render the final JSX of CarouselSlider
*/ const renderCarouselSlider_unstable = (state, contextValues) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(CarouselSliderContextProvider, {
		value: contextValues.carouselSlider,
		children: /* @__PURE__ */ jsx(state.root, {})
	});
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselSlider/CarouselSlider.js
/**
* CarouselSlider component - The viewport window that CarouselCards are contained within.
*/ const CarouselSlider = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselSlider_unstable(props, ref);
	useCarouselSliderStyles_unstable(state);
	useCustomStyleHook("useCarouselSliderStyles_unstable")(state);
	const context = useCarouselSliderContextValues_unstable(state);
	return renderCarouselSlider_unstable(state, context);
});
CarouselSlider.displayName = "CarouselSlider";

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/constants.js
const DATA_POSITIONING_INTERSECTING = "data-popper-is-intersecting";
const DATA_POSITIONING_ESCAPED = "data-popper-escaped";
const DATA_POSITIONING_HIDDEN = "data-popper-reference-hidden";
const DATA_POSITIONING_PLACEMENT = "data-popper-placement";
const POSITIONING_END_EVENT = "fui-positioningend";

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/PositioningConfigurationContext.js
var DEFAULT_CONFIGURATION = ({ options }) => {
	return options;
};
var PositioningConfigurationContext = import_react.createContext(void 0);
/**
* A context provider for the positioning configuration.
*
* Accepts a function that takes the positioning options and returns them modified.
*/ const PositioningConfigurationProvider = PositioningConfigurationContext.Provider;
const usePositioningConfiguration = () => {
	var _React_useContext;
	return (_React_useContext = import_react.useContext(PositioningConfigurationContext)) !== null && _React_useContext !== void 0 ? _React_useContext : DEFAULT_CONFIGURATION;
};

//#endregion
//#region node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs
/**
* Custom positioning reference element.
* @see https://floating-ui.com/docs/virtual-elements
*/
var sides = [
	"top",
	"right",
	"bottom",
	"left"
];
var min = Math.min;
var max = Math.max;
var round = Math.round;
var createCoords = (v) => ({
	x: v,
	y: v
});
var oppositeSideMap = {
	left: "right",
	right: "left",
	bottom: "top",
	top: "bottom"
};
var oppositeAlignmentMap = {
	start: "end",
	end: "start"
};
function clamp(start, value, end) {
	return max(start, min(value, end));
}
function evaluate(value, param) {
	return typeof value === "function" ? value(param) : value;
}
function getSide(placement) {
	return placement.split("-")[0];
}
function getAlignment(placement) {
	return placement.split("-")[1];
}
function getOppositeAxis(axis) {
	return axis === "x" ? "y" : "x";
}
function getAxisLength(axis) {
	return axis === "y" ? "height" : "width";
}
var yAxisSides = /* @__PURE__ */ new Set(["top", "bottom"]);
function getSideAxis(placement) {
	return yAxisSides.has(getSide(placement)) ? "y" : "x";
}
function getAlignmentAxis(placement) {
	return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
	if (rtl === void 0) rtl = false;
	const alignment = getAlignment(placement);
	const alignmentAxis = getAlignmentAxis(placement);
	const length = getAxisLength(alignmentAxis);
	let mainAlignmentSide = alignmentAxis === "x" ? alignment === (rtl ? "end" : "start") ? "right" : "left" : alignment === "start" ? "bottom" : "top";
	if (rects.reference[length] > rects.floating[length]) mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
	return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
	const oppositePlacement = getOppositePlacement(placement);
	return [
		getOppositeAlignmentPlacement(placement),
		oppositePlacement,
		getOppositeAlignmentPlacement(oppositePlacement)
	];
}
function getOppositeAlignmentPlacement(placement) {
	return placement.replace(/start|end/g, (alignment) => oppositeAlignmentMap[alignment]);
}
var lrPlacement = ["left", "right"];
var rlPlacement = ["right", "left"];
var tbPlacement = ["top", "bottom"];
var btPlacement = ["bottom", "top"];
function getSideList(side, isStart, rtl) {
	switch (side) {
		case "top":
		case "bottom":
			if (rtl) return isStart ? rlPlacement : lrPlacement;
			return isStart ? lrPlacement : rlPlacement;
		case "left":
		case "right": return isStart ? tbPlacement : btPlacement;
		default: return [];
	}
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
	const alignment = getAlignment(placement);
	let list = getSideList(getSide(placement), direction === "start", rtl);
	if (alignment) {
		list = list.map((side) => side + "-" + alignment);
		if (flipAlignment) list = list.concat(list.map(getOppositeAlignmentPlacement));
	}
	return list;
}
function getOppositePlacement(placement) {
	return placement.replace(/left|right|bottom|top/g, (side) => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
	return {
		top: 0,
		right: 0,
		bottom: 0,
		left: 0,
		...padding
	};
}
function getPaddingObject(padding) {
	return typeof padding !== "number" ? expandPaddingObject(padding) : {
		top: padding,
		right: padding,
		bottom: padding,
		left: padding
	};
}
function rectToClientRect(rect) {
	const { x, y, width, height } = rect;
	return {
		width,
		height,
		top: y,
		left: x,
		right: x + width,
		bottom: y + height,
		x,
		y
	};
}

//#endregion
//#region node_modules/@floating-ui/core/dist/floating-ui.core.mjs
function computeCoordsFromPlacement(_ref, placement, rtl) {
	let { reference, floating } = _ref;
	const sideAxis = getSideAxis(placement);
	const alignmentAxis = getAlignmentAxis(placement);
	const alignLength = getAxisLength(alignmentAxis);
	const side = getSide(placement);
	const isVertical = sideAxis === "y";
	const commonX = reference.x + reference.width / 2 - floating.width / 2;
	const commonY = reference.y + reference.height / 2 - floating.height / 2;
	const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
	let coords;
	switch (side) {
		case "top":
			coords = {
				x: commonX,
				y: reference.y - floating.height
			};
			break;
		case "bottom":
			coords = {
				x: commonX,
				y: reference.y + reference.height
			};
			break;
		case "right":
			coords = {
				x: reference.x + reference.width,
				y: commonY
			};
			break;
		case "left":
			coords = {
				x: reference.x - floating.width,
				y: commonY
			};
			break;
		default: coords = {
			x: reference.x,
			y: reference.y
		};
	}
	switch (getAlignment(placement)) {
		case "start":
			coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
			break;
		case "end":
			coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
			break;
	}
	return coords;
}
/**
* Computes the `x` and `y` coordinates that will place the floating element
* next to a given reference element.
*
* This export does not have any `platform` interface logic. You will need to
* write one for the platform you are using Floating UI with.
*/
var computePosition$1 = async (reference, floating, config) => {
	const { placement = "bottom", strategy = "absolute", middleware = [], platform: platform$1 } = config;
	const validMiddleware = middleware.filter(Boolean);
	const rtl = await (platform$1.isRTL == null ? void 0 : platform$1.isRTL(floating));
	let rects = await platform$1.getElementRects({
		reference,
		floating,
		strategy
	});
	let { x, y } = computeCoordsFromPlacement(rects, placement, rtl);
	let statefulPlacement = placement;
	let middlewareData = {};
	let resetCount = 0;
	for (let i = 0; i < validMiddleware.length; i++) {
		const { name, fn } = validMiddleware[i];
		const { x: nextX, y: nextY, data, reset } = await fn({
			x,
			y,
			initialPlacement: placement,
			placement: statefulPlacement,
			strategy,
			middlewareData,
			rects,
			platform: platform$1,
			elements: {
				reference,
				floating
			}
		});
		x = nextX != null ? nextX : x;
		y = nextY != null ? nextY : y;
		middlewareData = {
			...middlewareData,
			[name]: {
				...middlewareData[name],
				...data
			}
		};
		if (reset && resetCount <= 50) {
			resetCount++;
			if (typeof reset === "object") {
				if (reset.placement) statefulPlacement = reset.placement;
				if (reset.rects) rects = reset.rects === true ? await platform$1.getElementRects({
					reference,
					floating,
					strategy
				}) : reset.rects;
				({x, y} = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
			}
			i = -1;
		}
	}
	return {
		x,
		y,
		placement: statefulPlacement,
		strategy,
		middlewareData
	};
};
/**
* Resolves with an object of overflow side offsets that determine how much the
* element is overflowing a given clipping boundary on each side.
* - positive = overflowing the boundary by that number of pixels
* - negative = how many pixels left before it will overflow
* - 0 = lies flush with the boundary
* @see https://floating-ui.com/docs/detectOverflow
*/
async function detectOverflow$1(state, options) {
	var _await$platform$isEle;
	if (options === void 0) options = {};
	const { x, y, platform: platform$1, rects, elements, strategy } = state;
	const { boundary = "clippingAncestors", rootBoundary = "viewport", elementContext = "floating", altBoundary = false, padding = 0 } = evaluate(options, state);
	const paddingObject = getPaddingObject(padding);
	const element = elements[altBoundary ? elementContext === "floating" ? "reference" : "floating" : elementContext];
	const clippingClientRect = rectToClientRect(await platform$1.getClippingRect({
		element: ((_await$platform$isEle = await (platform$1.isElement == null ? void 0 : platform$1.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || await (platform$1.getDocumentElement == null ? void 0 : platform$1.getDocumentElement(elements.floating)),
		boundary,
		rootBoundary,
		strategy
	}));
	const rect = elementContext === "floating" ? {
		x,
		y,
		width: rects.floating.width,
		height: rects.floating.height
	} : rects.reference;
	const offsetParent = await (platform$1.getOffsetParent == null ? void 0 : platform$1.getOffsetParent(elements.floating));
	const offsetScale = await (platform$1.isElement == null ? void 0 : platform$1.isElement(offsetParent)) ? await (platform$1.getScale == null ? void 0 : platform$1.getScale(offsetParent)) || {
		x: 1,
		y: 1
	} : {
		x: 1,
		y: 1
	};
	const elementClientRect = rectToClientRect(platform$1.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform$1.convertOffsetParentRelativeRectToViewportRelativeRect({
		elements,
		rect,
		offsetParent,
		strategy
	}) : rect);
	return {
		top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
		bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
		left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
		right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
	};
}
/**
* Provides data to position an inner element of the floating element so that it
* appears centered to the reference element.
* @see https://floating-ui.com/docs/arrow
*/
var arrow$1 = (options) => ({
	name: "arrow",
	options,
	async fn(state) {
		const { x, y, placement, rects, platform: platform$1, elements, middlewareData } = state;
		const { element, padding = 0 } = evaluate(options, state) || {};
		if (element == null) return {};
		const paddingObject = getPaddingObject(padding);
		const coords = {
			x,
			y
		};
		const axis = getAlignmentAxis(placement);
		const length = getAxisLength(axis);
		const arrowDimensions = await platform$1.getDimensions(element);
		const isYAxis = axis === "y";
		const minProp = isYAxis ? "top" : "left";
		const maxProp = isYAxis ? "bottom" : "right";
		const clientProp = isYAxis ? "clientHeight" : "clientWidth";
		const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
		const startDiff = coords[axis] - rects.reference[axis];
		const arrowOffsetParent = await (platform$1.getOffsetParent == null ? void 0 : platform$1.getOffsetParent(element));
		let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;
		if (!clientSize || !await (platform$1.isElement == null ? void 0 : platform$1.isElement(arrowOffsetParent))) clientSize = elements.floating[clientProp] || rects.floating[length];
		const centerToReference = endDiff / 2 - startDiff / 2;
		const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
		const minPadding = min(paddingObject[minProp], largestPossiblePadding);
		const maxPadding = min(paddingObject[maxProp], largestPossiblePadding);
		const min$1 = minPadding;
		const max$1 = clientSize - arrowDimensions[length] - maxPadding;
		const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
		const offset$3 = clamp(min$1, center, max$1);
		const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center !== offset$3 && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
		const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max$1 : 0;
		return {
			[axis]: coords[axis] + alignmentOffset,
			data: {
				[axis]: offset$3,
				centerOffset: center - offset$3 - alignmentOffset,
				...shouldAddOffset && { alignmentOffset }
			},
			reset: shouldAddOffset
		};
	}
});
/**
* Optimizes the visibility of the floating element by flipping the `placement`
* in order to keep it in view when the preferred placement(s) will overflow the
* clipping boundary. Alternative to `autoPlacement`.
* @see https://floating-ui.com/docs/flip
*/
var flip$2 = function(options) {
	if (options === void 0) options = {};
	return {
		name: "flip",
		options,
		async fn(state) {
			var _middlewareData$arrow, _middlewareData$flip;
			const { placement, middlewareData, rects, initialPlacement, platform: platform$1, elements } = state;
			const { mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = true, fallbackPlacements: specifiedFallbackPlacements, fallbackStrategy = "bestFit", fallbackAxisSideDirection = "none", flipAlignment = true,...detectOverflowOptions } = evaluate(options, state);
			if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) return {};
			const side = getSide(placement);
			const initialSideAxis = getSideAxis(initialPlacement);
			const isBasePlacement = getSide(initialPlacement) === initialPlacement;
			const rtl = await (platform$1.isRTL == null ? void 0 : platform$1.isRTL(elements.floating));
			const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
			const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== "none";
			if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
			const placements$1 = [initialPlacement, ...fallbackPlacements];
			const overflow = await detectOverflow$1(state, detectOverflowOptions);
			const overflows = [];
			let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
			if (checkMainAxis) overflows.push(overflow[side]);
			if (checkCrossAxis) {
				const sides$1 = getAlignmentSides(placement, rects, rtl);
				overflows.push(overflow[sides$1[0]], overflow[sides$1[1]]);
			}
			overflowsData = [...overflowsData, {
				placement,
				overflows
			}];
			if (!overflows.every((side$1) => side$1 <= 0)) {
				var _middlewareData$flip2, _overflowsData$filter;
				const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
				const nextPlacement = placements$1[nextIndex];
				if (nextPlacement) {
					if (!(checkCrossAxis === "alignment" ? initialSideAxis !== getSideAxis(nextPlacement) : false) || overflowsData.every((d) => getSideAxis(d.placement) === initialSideAxis ? d.overflows[0] > 0 : true)) return {
						data: {
							index: nextIndex,
							overflows: overflowsData
						},
						reset: { placement: nextPlacement }
					};
				}
				let resetPlacement = (_overflowsData$filter = overflowsData.filter((d) => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;
				if (!resetPlacement) switch (fallbackStrategy) {
					case "bestFit": {
						var _overflowsData$filter2;
						const placement$1 = (_overflowsData$filter2 = overflowsData.filter((d) => {
							if (hasFallbackAxisSideDirection) {
								const currentSideAxis = getSideAxis(d.placement);
								return currentSideAxis === initialSideAxis || currentSideAxis === "y";
							}
							return true;
						}).map((d) => [d.placement, d.overflows.filter((overflow$1) => overflow$1 > 0).reduce((acc, overflow$1) => acc + overflow$1, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
						if (placement$1) resetPlacement = placement$1;
						break;
					}
					case "initialPlacement":
						resetPlacement = initialPlacement;
						break;
				}
				if (placement !== resetPlacement) return { reset: { placement: resetPlacement } };
			}
			return {};
		}
	};
};
function getSideOffsets(overflow, rect) {
	return {
		top: overflow.top - rect.height,
		right: overflow.right - rect.width,
		bottom: overflow.bottom - rect.height,
		left: overflow.left - rect.width
	};
}
function isAnySideFullyClipped(overflow) {
	return sides.some((side) => overflow[side] >= 0);
}
/**
* Provides data to hide the floating element in applicable situations, such as
* when it is not in the same clipping context as the reference element.
* @see https://floating-ui.com/docs/hide
*/
var hide$1 = function(options) {
	if (options === void 0) options = {};
	return {
		name: "hide",
		options,
		async fn(state) {
			const { rects } = state;
			const { strategy = "referenceHidden",...detectOverflowOptions } = evaluate(options, state);
			switch (strategy) {
				case "referenceHidden": {
					const overflow = await detectOverflow$1(state, {
						...detectOverflowOptions,
						elementContext: "reference"
					});
					const offsets = getSideOffsets(overflow, rects.reference);
					return { data: {
						referenceHiddenOffsets: offsets,
						referenceHidden: isAnySideFullyClipped(offsets)
					} };
				}
				case "escaped": {
					const overflow = await detectOverflow$1(state, {
						...detectOverflowOptions,
						altBoundary: true
					});
					const offsets = getSideOffsets(overflow, rects.floating);
					return { data: {
						escapedOffsets: offsets,
						escaped: isAnySideFullyClipped(offsets)
					} };
				}
				default: return {};
			}
		}
	};
};
var originSides = /* @__PURE__ */ new Set(["left", "top"]);
async function convertValueToCoords(state, options) {
	const { placement, platform: platform$1, elements } = state;
	const rtl = await (platform$1.isRTL == null ? void 0 : platform$1.isRTL(elements.floating));
	const side = getSide(placement);
	const alignment = getAlignment(placement);
	const isVertical = getSideAxis(placement) === "y";
	const mainAxisMulti = originSides.has(side) ? -1 : 1;
	const crossAxisMulti = rtl && isVertical ? -1 : 1;
	const rawValue = evaluate(options, state);
	let { mainAxis, crossAxis, alignmentAxis } = typeof rawValue === "number" ? {
		mainAxis: rawValue,
		crossAxis: 0,
		alignmentAxis: null
	} : {
		mainAxis: rawValue.mainAxis || 0,
		crossAxis: rawValue.crossAxis || 0,
		alignmentAxis: rawValue.alignmentAxis
	};
	if (alignment && typeof alignmentAxis === "number") crossAxis = alignment === "end" ? alignmentAxis * -1 : alignmentAxis;
	return isVertical ? {
		x: crossAxis * crossAxisMulti,
		y: mainAxis * mainAxisMulti
	} : {
		x: mainAxis * mainAxisMulti,
		y: crossAxis * crossAxisMulti
	};
}
/**
* Modifies the placement by translating the floating element along the
* specified axes.
* A number (shorthand for `mainAxis` or distance), or an axes configuration
* object may be passed.
* @see https://floating-ui.com/docs/offset
*/
var offset$2 = function(options) {
	if (options === void 0) options = 0;
	return {
		name: "offset",
		options,
		async fn(state) {
			var _middlewareData$offse, _middlewareData$arrow;
			const { x, y, placement, middlewareData } = state;
			const diffCoords = await convertValueToCoords(state, options);
			if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) return {};
			return {
				x: x + diffCoords.x,
				y: y + diffCoords.y,
				data: {
					...diffCoords,
					placement
				}
			};
		}
	};
};
/**
* Optimizes the visibility of the floating element by shifting it in order to
* keep it in view when it will overflow the clipping boundary.
* @see https://floating-ui.com/docs/shift
*/
var shift$2 = function(options) {
	if (options === void 0) options = {};
	return {
		name: "shift",
		options,
		async fn(state) {
			const { x, y, placement } = state;
			const { mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = false, limiter = { fn: (_ref) => {
				let { x: x$1, y: y$1 } = _ref;
				return {
					x: x$1,
					y: y$1
				};
			} },...detectOverflowOptions } = evaluate(options, state);
			const coords = {
				x,
				y
			};
			const overflow = await detectOverflow$1(state, detectOverflowOptions);
			const crossAxis = getSideAxis(getSide(placement));
			const mainAxis = getOppositeAxis(crossAxis);
			let mainAxisCoord = coords[mainAxis];
			let crossAxisCoord = coords[crossAxis];
			if (checkMainAxis) {
				const minSide = mainAxis === "y" ? "top" : "left";
				const maxSide = mainAxis === "y" ? "bottom" : "right";
				const min$1 = mainAxisCoord + overflow[minSide];
				const max$1 = mainAxisCoord - overflow[maxSide];
				mainAxisCoord = clamp(min$1, mainAxisCoord, max$1);
			}
			if (checkCrossAxis) {
				const minSide = crossAxis === "y" ? "top" : "left";
				const maxSide = crossAxis === "y" ? "bottom" : "right";
				const min$1 = crossAxisCoord + overflow[minSide];
				const max$1 = crossAxisCoord - overflow[maxSide];
				crossAxisCoord = clamp(min$1, crossAxisCoord, max$1);
			}
			const limitedCoords = limiter.fn({
				...state,
				[mainAxis]: mainAxisCoord,
				[crossAxis]: crossAxisCoord
			});
			return {
				...limitedCoords,
				data: {
					x: limitedCoords.x - x,
					y: limitedCoords.y - y,
					enabled: {
						[mainAxis]: checkMainAxis,
						[crossAxis]: checkCrossAxis
					}
				}
			};
		}
	};
};
/**
* Built-in `limiter` that will stop `shift()` at a certain point.
*/
var limitShift$1 = function(options) {
	if (options === void 0) options = {};
	return {
		options,
		fn(state) {
			const { x, y, placement, rects, middlewareData } = state;
			const { offset: offset$3 = 0, mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = true } = evaluate(options, state);
			const coords = {
				x,
				y
			};
			const crossAxis = getSideAxis(placement);
			const mainAxis = getOppositeAxis(crossAxis);
			let mainAxisCoord = coords[mainAxis];
			let crossAxisCoord = coords[crossAxis];
			const rawOffset = evaluate(offset$3, state);
			const computedOffset = typeof rawOffset === "number" ? {
				mainAxis: rawOffset,
				crossAxis: 0
			} : {
				mainAxis: 0,
				crossAxis: 0,
				...rawOffset
			};
			if (checkMainAxis) {
				const len = mainAxis === "y" ? "height" : "width";
				const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
				const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
				if (mainAxisCoord < limitMin) mainAxisCoord = limitMin;
				else if (mainAxisCoord > limitMax) mainAxisCoord = limitMax;
			}
			if (checkCrossAxis) {
				var _middlewareData$offse, _middlewareData$offse2;
				const len = mainAxis === "y" ? "width" : "height";
				const isOriginSide = originSides.has(getSide(placement));
				const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
				const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
				if (crossAxisCoord < limitMin) crossAxisCoord = limitMin;
				else if (crossAxisCoord > limitMax) crossAxisCoord = limitMax;
			}
			return {
				[mainAxis]: mainAxisCoord,
				[crossAxis]: crossAxisCoord
			};
		}
	};
};
/**
* Provides data that allows you to change the size of the floating element —
* for instance, prevent it from overflowing the clipping boundary or match the
* width of the reference element.
* @see https://floating-ui.com/docs/size
*/
var size$1 = function(options) {
	if (options === void 0) options = {};
	return {
		name: "size",
		options,
		async fn(state) {
			var _state$middlewareData, _state$middlewareData2;
			const { placement, rects, platform: platform$1, elements } = state;
			const { apply = () => {},...detectOverflowOptions } = evaluate(options, state);
			const overflow = await detectOverflow$1(state, detectOverflowOptions);
			const side = getSide(placement);
			const alignment = getAlignment(placement);
			const isYAxis = getSideAxis(placement) === "y";
			const { width, height } = rects.floating;
			let heightSide;
			let widthSide;
			if (side === "top" || side === "bottom") {
				heightSide = side;
				widthSide = alignment === (await (platform$1.isRTL == null ? void 0 : platform$1.isRTL(elements.floating)) ? "start" : "end") ? "left" : "right";
			} else {
				widthSide = side;
				heightSide = alignment === "end" ? "top" : "bottom";
			}
			const maximumClippingHeight = height - overflow.top - overflow.bottom;
			const maximumClippingWidth = width - overflow.left - overflow.right;
			const overflowAvailableHeight = min(height - overflow[heightSide], maximumClippingHeight);
			const overflowAvailableWidth = min(width - overflow[widthSide], maximumClippingWidth);
			const noShift = !state.middlewareData.shift;
			let availableHeight = overflowAvailableHeight;
			let availableWidth = overflowAvailableWidth;
			if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) availableWidth = maximumClippingWidth;
			if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) availableHeight = maximumClippingHeight;
			if (noShift && !alignment) {
				const xMin = max(overflow.left, 0);
				const xMax = max(overflow.right, 0);
				const yMin = max(overflow.top, 0);
				const yMax = max(overflow.bottom, 0);
				if (isYAxis) availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
				else availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
			}
			await apply({
				...state,
				availableWidth,
				availableHeight
			});
			const nextDimensions = await platform$1.getDimensions(elements.floating);
			if (width !== nextDimensions.width || height !== nextDimensions.height) return { reset: { rects: true } };
			return {};
		}
	};
};

//#endregion
//#region node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs
function hasWindow() {
	return typeof window !== "undefined";
}
function getNodeName(node) {
	if (isNode(node)) return (node.nodeName || "").toLowerCase();
	return "#document";
}
function getWindow(node) {
	var _node$ownerDocument;
	return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
	var _ref;
	return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
	if (!hasWindow()) return false;
	return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
	if (!hasWindow()) return false;
	return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement$2(value) {
	if (!hasWindow()) return false;
	return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
	if (!hasWindow() || typeof ShadowRoot === "undefined") return false;
	return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
var invalidOverflowDisplayValues = /* @__PURE__ */ new Set(["inline", "contents"]);
function isOverflowElement(element) {
	const { overflow, overflowX, overflowY, display } = getComputedStyle$1(element);
	return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);
}
var tableElements = /* @__PURE__ */ new Set([
	"table",
	"td",
	"th"
]);
function isTableElement(element) {
	return tableElements.has(getNodeName(element));
}
var topLayerSelectors = [":popover-open", ":modal"];
function isTopLayer(element) {
	return topLayerSelectors.some((selector) => {
		try {
			return element.matches(selector);
		} catch (_e) {
			return false;
		}
	});
}
var transformProperties = [
	"transform",
	"translate",
	"scale",
	"rotate",
	"perspective"
];
var willChangeValues = [
	"transform",
	"translate",
	"scale",
	"rotate",
	"perspective",
	"filter"
];
var containValues = [
	"paint",
	"layout",
	"strict",
	"content"
];
function isContainingBlock(elementOrCss) {
	const webkit = isWebKit();
	const css = isElement(elementOrCss) ? getComputedStyle$1(elementOrCss) : elementOrCss;
	return transformProperties.some((value) => css[value] ? css[value] !== "none" : false) || (css.containerType ? css.containerType !== "normal" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== "none" : false) || !webkit && (css.filter ? css.filter !== "none" : false) || willChangeValues.some((value) => (css.willChange || "").includes(value)) || containValues.some((value) => (css.contain || "").includes(value));
}
function getContainingBlock(element) {
	let currentNode = getParentNode$1(element);
	while (isHTMLElement$2(currentNode) && !isLastTraversableNode(currentNode)) {
		if (isContainingBlock(currentNode)) return currentNode;
		else if (isTopLayer(currentNode)) return null;
		currentNode = getParentNode$1(currentNode);
	}
	return null;
}
function isWebKit() {
	if (typeof CSS === "undefined" || !CSS.supports) return false;
	return CSS.supports("-webkit-backdrop-filter", "none");
}
var lastTraversableNodeNames = /* @__PURE__ */ new Set([
	"html",
	"body",
	"#document"
]);
function isLastTraversableNode(node) {
	return lastTraversableNodeNames.has(getNodeName(node));
}
function getComputedStyle$1(element) {
	return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
	if (isElement(element)) return {
		scrollLeft: element.scrollLeft,
		scrollTop: element.scrollTop
	};
	return {
		scrollLeft: element.scrollX,
		scrollTop: element.scrollY
	};
}
function getParentNode$1(node) {
	if (getNodeName(node) === "html") return node;
	const result = node.assignedSlot || node.parentNode || isShadowRoot(node) && node.host || getDocumentElement(node);
	return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
	const parentNode = getParentNode$1(node);
	if (isLastTraversableNode(parentNode)) return node.ownerDocument ? node.ownerDocument.body : node.body;
	if (isHTMLElement$2(parentNode) && isOverflowElement(parentNode)) return parentNode;
	return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
	var _node$ownerDocument2;
	if (list === void 0) list = [];
	if (traverseIframes === void 0) traverseIframes = true;
	const scrollableAncestor = getNearestOverflowAncestor(node);
	const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
	const win = getWindow(scrollableAncestor);
	if (isBody) {
		const frameElement = getFrameElement(win);
		return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
	}
	return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
	return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}

//#endregion
//#region node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs
function getCssDimensions(element) {
	const css = getComputedStyle$1(element);
	let width = parseFloat(css.width) || 0;
	let height = parseFloat(css.height) || 0;
	const hasOffset = isHTMLElement$2(element);
	const offsetWidth = hasOffset ? element.offsetWidth : width;
	const offsetHeight = hasOffset ? element.offsetHeight : height;
	const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
	if (shouldFallback) {
		width = offsetWidth;
		height = offsetHeight;
	}
	return {
		width,
		height,
		$: shouldFallback
	};
}
function unwrapElement(element) {
	return !isElement(element) ? element.contextElement : element;
}
function getScale(element) {
	const domElement = unwrapElement(element);
	if (!isHTMLElement$2(domElement)) return createCoords(1);
	const rect = domElement.getBoundingClientRect();
	const { width, height, $ } = getCssDimensions(domElement);
	let x = ($ ? round(rect.width) : rect.width) / width;
	let y = ($ ? round(rect.height) : rect.height) / height;
	if (!x || !Number.isFinite(x)) x = 1;
	if (!y || !Number.isFinite(y)) y = 1;
	return {
		x,
		y
	};
}
var noOffsets = /* @__PURE__ */ createCoords(0);
function getVisualOffsets(element) {
	const win = getWindow(element);
	if (!isWebKit() || !win.visualViewport) return noOffsets;
	return {
		x: win.visualViewport.offsetLeft,
		y: win.visualViewport.offsetTop
	};
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
	if (isFixed === void 0) isFixed = false;
	if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow(element)) return false;
	return isFixed;
}
function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
	if (includeScale === void 0) includeScale = false;
	if (isFixedStrategy === void 0) isFixedStrategy = false;
	const clientRect = element.getBoundingClientRect();
	const domElement = unwrapElement(element);
	let scale = createCoords(1);
	if (includeScale) if (offsetParent) {
		if (isElement(offsetParent)) scale = getScale(offsetParent);
	} else scale = getScale(element);
	const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
	let x = (clientRect.left + visualOffsets.x) / scale.x;
	let y = (clientRect.top + visualOffsets.y) / scale.y;
	let width = clientRect.width / scale.x;
	let height = clientRect.height / scale.y;
	if (domElement) {
		const win = getWindow(domElement);
		const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
		let currentWin = win;
		let currentIFrame = getFrameElement(currentWin);
		while (currentIFrame && offsetParent && offsetWin !== currentWin) {
			const iframeScale = getScale(currentIFrame);
			const iframeRect = currentIFrame.getBoundingClientRect();
			const css = getComputedStyle$1(currentIFrame);
			const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
			const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
			x *= iframeScale.x;
			y *= iframeScale.y;
			width *= iframeScale.x;
			height *= iframeScale.y;
			x += left;
			y += top;
			currentWin = getWindow(currentIFrame);
			currentIFrame = getFrameElement(currentWin);
		}
	}
	return rectToClientRect({
		width,
		height,
		x,
		y
	});
}
function getWindowScrollBarX(element, rect) {
	const leftScroll = getNodeScroll(element).scrollLeft;
	if (!rect) return getBoundingClientRect(getDocumentElement(element)).left + leftScroll;
	return rect.left + leftScroll;
}
function getHTMLOffset(documentElement, scroll) {
	const htmlRect = documentElement.getBoundingClientRect();
	const x = htmlRect.left + scroll.scrollLeft - getWindowScrollBarX(documentElement, htmlRect);
	const y = htmlRect.top + scroll.scrollTop;
	return {
		x,
		y
	};
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
	let { elements, rect, offsetParent, strategy } = _ref;
	const isFixed = strategy === "fixed";
	const documentElement = getDocumentElement(offsetParent);
	const topLayer = elements ? isTopLayer(elements.floating) : false;
	if (offsetParent === documentElement || topLayer && isFixed) return rect;
	let scroll = {
		scrollLeft: 0,
		scrollTop: 0
	};
	let scale = createCoords(1);
	const offsets = createCoords(0);
	const isOffsetParentAnElement = isHTMLElement$2(offsetParent);
	if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
		if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) scroll = getNodeScroll(offsetParent);
		if (isHTMLElement$2(offsetParent)) {
			const offsetRect = getBoundingClientRect(offsetParent);
			scale = getScale(offsetParent);
			offsets.x = offsetRect.x + offsetParent.clientLeft;
			offsets.y = offsetRect.y + offsetParent.clientTop;
		}
	}
	const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : createCoords(0);
	return {
		width: rect.width * scale.x,
		height: rect.height * scale.y,
		x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,
		y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y
	};
}
function getClientRects(element) {
	return Array.from(element.getClientRects());
}
function getDocumentRect(element) {
	const html = getDocumentElement(element);
	const scroll = getNodeScroll(element);
	const body = element.ownerDocument.body;
	const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
	const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
	let x = -scroll.scrollLeft + getWindowScrollBarX(element);
	const y = -scroll.scrollTop;
	if (getComputedStyle$1(body).direction === "rtl") x += max(html.clientWidth, body.clientWidth) - width;
	return {
		width,
		height,
		x,
		y
	};
}
var SCROLLBAR_MAX = 25;
function getViewportRect(element, strategy) {
	const win = getWindow(element);
	const html = getDocumentElement(element);
	const visualViewport = win.visualViewport;
	let width = html.clientWidth;
	let height = html.clientHeight;
	let x = 0;
	let y = 0;
	if (visualViewport) {
		width = visualViewport.width;
		height = visualViewport.height;
		const visualViewportBased = isWebKit();
		if (!visualViewportBased || visualViewportBased && strategy === "fixed") {
			x = visualViewport.offsetLeft;
			y = visualViewport.offsetTop;
		}
	}
	const windowScrollbarX = getWindowScrollBarX(html);
	if (windowScrollbarX <= 0) {
		const doc = html.ownerDocument;
		const body = doc.body;
		const bodyStyles = getComputedStyle(body);
		const bodyMarginInline = doc.compatMode === "CSS1Compat" ? parseFloat(bodyStyles.marginLeft) + parseFloat(bodyStyles.marginRight) || 0 : 0;
		const clippingStableScrollbarWidth = Math.abs(html.clientWidth - body.clientWidth - bodyMarginInline);
		if (clippingStableScrollbarWidth <= SCROLLBAR_MAX) width -= clippingStableScrollbarWidth;
	} else if (windowScrollbarX <= SCROLLBAR_MAX) width += windowScrollbarX;
	return {
		width,
		height,
		x,
		y
	};
}
var absoluteOrFixed = /* @__PURE__ */ new Set(["absolute", "fixed"]);
function getInnerBoundingClientRect(element, strategy) {
	const clientRect = getBoundingClientRect(element, true, strategy === "fixed");
	const top = clientRect.top + element.clientTop;
	const left = clientRect.left + element.clientLeft;
	const scale = isHTMLElement$2(element) ? getScale(element) : createCoords(1);
	const width = element.clientWidth * scale.x;
	const height = element.clientHeight * scale.y;
	const x = left * scale.x;
	const y = top * scale.y;
	return {
		width,
		height,
		x,
		y
	};
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
	let rect;
	if (clippingAncestor === "viewport") rect = getViewportRect(element, strategy);
	else if (clippingAncestor === "document") rect = getDocumentRect(getDocumentElement(element));
	else if (isElement(clippingAncestor)) rect = getInnerBoundingClientRect(clippingAncestor, strategy);
	else {
		const visualOffsets = getVisualOffsets(element);
		rect = {
			x: clippingAncestor.x - visualOffsets.x,
			y: clippingAncestor.y - visualOffsets.y,
			width: clippingAncestor.width,
			height: clippingAncestor.height
		};
	}
	return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
	const parentNode = getParentNode$1(element);
	if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) return false;
	return getComputedStyle$1(parentNode).position === "fixed" || hasFixedPositionAncestor(parentNode, stopNode);
}
function getClippingElementAncestors(element, cache) {
	const cachedResult = cache.get(element);
	if (cachedResult) return cachedResult;
	let result = getOverflowAncestors(element, [], false).filter((el) => isElement(el) && getNodeName(el) !== "body");
	let currentContainingBlockComputedStyle = null;
	const elementIsFixed = getComputedStyle$1(element).position === "fixed";
	let currentNode = elementIsFixed ? getParentNode$1(element) : element;
	while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
		const computedStyle = getComputedStyle$1(currentNode);
		const currentNodeIsContaining = isContainingBlock(currentNode);
		if (!currentNodeIsContaining && computedStyle.position === "fixed") currentContainingBlockComputedStyle = null;
		if (elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === "static" && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode)) result = result.filter((ancestor) => ancestor !== currentNode);
		else currentContainingBlockComputedStyle = computedStyle;
		currentNode = getParentNode$1(currentNode);
	}
	cache.set(element, result);
	return result;
}
function getClippingRect(_ref) {
	let { element, boundary, rootBoundary, strategy } = _ref;
	const clippingAncestors = [...boundary === "clippingAncestors" ? isTopLayer(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary), rootBoundary];
	const firstClippingAncestor = clippingAncestors[0];
	const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
		const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
		accRect.top = max(rect.top, accRect.top);
		accRect.right = min(rect.right, accRect.right);
		accRect.bottom = min(rect.bottom, accRect.bottom);
		accRect.left = max(rect.left, accRect.left);
		return accRect;
	}, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
	return {
		width: clippingRect.right - clippingRect.left,
		height: clippingRect.bottom - clippingRect.top,
		x: clippingRect.left,
		y: clippingRect.top
	};
}
function getDimensions(element) {
	const { width, height } = getCssDimensions(element);
	return {
		width,
		height
	};
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
	const isOffsetParentAnElement = isHTMLElement$2(offsetParent);
	const documentElement = getDocumentElement(offsetParent);
	const isFixed = strategy === "fixed";
	const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
	let scroll = {
		scrollLeft: 0,
		scrollTop: 0
	};
	const offsets = createCoords(0);
	function setLeftRTLScrollbarOffset() {
		offsets.x = getWindowScrollBarX(documentElement);
	}
	if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
		if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) scroll = getNodeScroll(offsetParent);
		if (isOffsetParentAnElement) {
			const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
			offsets.x = offsetRect.x + offsetParent.clientLeft;
			offsets.y = offsetRect.y + offsetParent.clientTop;
		} else if (documentElement) setLeftRTLScrollbarOffset();
	}
	if (isFixed && !isOffsetParentAnElement && documentElement) setLeftRTLScrollbarOffset();
	const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : createCoords(0);
	const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;
	const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;
	return {
		x,
		y,
		width: rect.width,
		height: rect.height
	};
}
function isStaticPositioned(element) {
	return getComputedStyle$1(element).position === "static";
}
function getTrueOffsetParent(element, polyfill) {
	if (!isHTMLElement$2(element) || getComputedStyle$1(element).position === "fixed") return null;
	if (polyfill) return polyfill(element);
	let rawOffsetParent = element.offsetParent;
	if (getDocumentElement(element) === rawOffsetParent) rawOffsetParent = rawOffsetParent.ownerDocument.body;
	return rawOffsetParent;
}
function getOffsetParent(element, polyfill) {
	const win = getWindow(element);
	if (isTopLayer(element)) return win;
	if (!isHTMLElement$2(element)) {
		let svgOffsetParent = getParentNode$1(element);
		while (svgOffsetParent && !isLastTraversableNode(svgOffsetParent)) {
			if (isElement(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) return svgOffsetParent;
			svgOffsetParent = getParentNode$1(svgOffsetParent);
		}
		return win;
	}
	let offsetParent = getTrueOffsetParent(element, polyfill);
	while (offsetParent && isTableElement(offsetParent) && isStaticPositioned(offsetParent)) offsetParent = getTrueOffsetParent(offsetParent, polyfill);
	if (offsetParent && isLastTraversableNode(offsetParent) && isStaticPositioned(offsetParent) && !isContainingBlock(offsetParent)) return win;
	return offsetParent || getContainingBlock(element) || win;
}
var getElementRects = async function(data) {
	const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
	const getDimensionsFn = this.getDimensions;
	const floatingDimensions = await getDimensionsFn(data.floating);
	return {
		reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
		floating: {
			x: 0,
			y: 0,
			width: floatingDimensions.width,
			height: floatingDimensions.height
		}
	};
};
function isRTL(element) {
	return getComputedStyle$1(element).direction === "rtl";
}
var platform = {
	convertOffsetParentRelativeRectToViewportRelativeRect,
	getDocumentElement,
	getClippingRect,
	getOffsetParent,
	getElementRects,
	getClientRects,
	getDimensions,
	getScale,
	isElement,
	isRTL
};
/**
* Resolves with an object of overflow side offsets that determine how much the
* element is overflowing a given clipping boundary on each side.
* - positive = overflowing the boundary by that number of pixels
* - negative = how many pixels left before it will overflow
* - 0 = lies flush with the boundary
* @see https://floating-ui.com/docs/detectOverflow
*/
var detectOverflow = detectOverflow$1;
/**
* Modifies the placement by translating the floating element along the
* specified axes.
* A number (shorthand for `mainAxis` or distance), or an axes configuration
* object may be passed.
* @see https://floating-ui.com/docs/offset
*/
var offset$1 = offset$2;
/**
* Optimizes the visibility of the floating element by shifting it in order to
* keep it in view when it will overflow the clipping boundary.
* @see https://floating-ui.com/docs/shift
*/
var shift$1 = shift$2;
/**
* Optimizes the visibility of the floating element by flipping the `placement`
* in order to keep it in view when the preferred placement(s) will overflow the
* clipping boundary. Alternative to `autoPlacement`.
* @see https://floating-ui.com/docs/flip
*/
var flip$1 = flip$2;
/**
* Provides data that allows you to change the size of the floating element —
* for instance, prevent it from overflowing the clipping boundary or match the
* width of the reference element.
* @see https://floating-ui.com/docs/size
*/
var size = size$1;
/**
* Provides data to hide the floating element in applicable situations, such as
* when it is not in the same clipping context as the reference element.
* @see https://floating-ui.com/docs/hide
*/
var hide = hide$1;
/**
* Provides data to position an inner element of the floating element so that it
* appears centered to the reference element.
* @see https://floating-ui.com/docs/arrow
*/
var arrow = arrow$1;
/**
* Built-in `limiter` that will stop `shift()` at a certain point.
*/
var limitShift = limitShift$1;
/**
* Computes the `x` and `y` coordinates that will place the floating element
* next to a given reference element.
*/
var computePosition = (reference, floating, options) => {
	const cache = /* @__PURE__ */ new Map();
	const mergedOptions = {
		platform,
		...options
	};
	const platformWithCache = {
		...mergedOptions.platform,
		_c: cache
	};
	return computePosition$1(reference, floating, {
		...mergedOptions,
		platform: platformWithCache
	});
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/parseFloatingUIPlacement.js
/**
* Parses Floating UI placement and returns the different components
* @param placement - the floating ui placement (i.e. bottom-start)
*
* @returns side and alignment components of the placement
*/ function parseFloatingUIPlacement(placement) {
	const tokens$1 = placement.split("-");
	return {
		side: tokens$1[0],
		alignment: tokens$1[1]
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/getScrollParent.js
const getParentNode = (node) => {
	if (node.nodeName === "HTML") return node;
	return node.parentNode || node.host;
};
/**
* Returns CSS styles of the given node.
* @param node - DOM node.
* @returns - CSS styles.
*/ const getStyleComputedProperty = (node) => {
	var _node_ownerDocument;
	if (node.nodeType !== 1) return {};
	const targetWindow = (_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView;
	if (targetWindow) return targetWindow.getComputedStyle(node, null);
	return {};
};
/**
* Returns the first scrollable parent of the given element.
* @param node - DOM node.
* @returns - the first scrollable parent.
*/ const getScrollParent = (node) => {
	const parentNode = node && getParentNode(node);
	if (!parentNode) return document.body;
	switch (parentNode.nodeName) {
		case "HTML":
		case "BODY": return parentNode.ownerDocument.body;
		case "#document": return parentNode.body;
	}
	const { overflow, overflowX, overflowY } = getStyleComputedProperty(parentNode);
	if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) return parentNode;
	return getScrollParent(parentNode);
};
const hasScrollParent = (node) => {
	var _scrollParentElement_ownerDocument;
	const scrollParentElement = getScrollParent(node);
	return scrollParentElement ? scrollParentElement !== ((_scrollParentElement_ownerDocument = scrollParentElement.ownerDocument) === null || _scrollParentElement_ownerDocument === void 0 ? void 0 : _scrollParentElement_ownerDocument.body) : false;
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/getBoundary.js
/**
* Allows to mimic a behavior from V1 of Popper and accept `window` and `scrollParent` as strings.
*/ function getBoundary(element, boundary) {
	if (boundary === "window") return element === null || element === void 0 ? void 0 : element.ownerDocument.documentElement;
	if (boundary === "clippingParents") return "clippingAncestors";
	if (boundary === "scrollParent") {
		let boundariesNode = getScrollParent(element);
		if (boundariesNode.nodeName === "BODY") boundariesNode = element === null || element === void 0 ? void 0 : element.ownerDocument.documentElement;
		return boundariesNode;
	}
	return boundary;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/getReactFiberFromNode.js
function getReactFiberFromNode(elm) {
	if (!elm) return null;
	for (const k in elm) if (k.indexOf("__reactInternalInstance$") === 0 || k.indexOf("__reactFiber$") === 0) return elm[k];
	throw new Error("getReactFiber(): Failed to find a React Fiber on a node");
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/mergeArrowOffset.js
/**
* Generally when adding an arrow to popper, it's necessary to offset the position of the popper by the
* height of the arrow. A simple utility to merge a provided offset with an arrow height to return the final offset
*
* @internal
* @param userOffset - The offset provided by the user
* @param arrowHeight - The height of the arrow in px
* @returns User offset augmented with arrow height
*/ function mergeArrowOffset(userOffset, arrowHeight$1) {
	if (typeof userOffset === "number") return addArrowOffset(userOffset, arrowHeight$1);
	if (typeof userOffset === "object" && userOffset !== null) return addArrowOffset(userOffset, arrowHeight$1);
	if (typeof userOffset === "function") return (offsetParams) => {
		const offset$3 = userOffset(offsetParams);
		return addArrowOffset(offset$3, arrowHeight$1);
	};
	return { mainAxis: arrowHeight$1 };
}
var addArrowOffset = (offset$3, arrowHeight$1) => {
	if (typeof offset$3 === "number") return { mainAxis: offset$3 + arrowHeight$1 };
	var _offset_mainAxis;
	return {
		...offset$3,
		mainAxis: ((_offset_mainAxis = offset$3.mainAxis) !== null && _offset_mainAxis !== void 0 ? _offset_mainAxis : 0) + arrowHeight$1
	};
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/toFloatingUIPadding.js
function toFloatingUIPadding(padding, isRtl) {
	if (typeof padding === "number") return padding;
	const { start, end,...verticalPadding } = padding;
	const paddingObject = verticalPadding;
	const left = isRtl ? "end" : "start";
	const right = isRtl ? "start" : "end";
	if (padding[left]) paddingObject.left = padding[left];
	if (padding[right]) paddingObject.right = padding[right];
	return paddingObject;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/toFloatingUIPlacement.js
var getPositionMap$1 = (rtl) => ({
	above: "top",
	below: "bottom",
	before: rtl ? "right" : "left",
	after: rtl ? "left" : "right"
});
var getAlignmentMap$1 = () => ({
	start: "start",
	end: "end",
	top: "start",
	bottom: "end",
	center: void 0
});
var shouldAlignToCenter = (p, a) => {
	const positionedVertically = p === "above" || p === "below";
	const alignedVertically = a === "top" || a === "bottom";
	return positionedVertically && alignedVertically || !positionedVertically && !alignedVertically;
};
/**
* Maps internal positioning values to Floating UI placement
* @see positioningHelper.test.ts for expected placement values
*/ const toFloatingUIPlacement = (align, position, rtl) => {
	const alignment = shouldAlignToCenter(position, align) ? "center" : align;
	const computedPosition = position && getPositionMap$1(rtl)[position];
	const computedAlignment = alignment && getAlignmentMap$1()[alignment];
	if (computedPosition && computedAlignment) return `${computedPosition}-${computedAlignment}`;
	return computedPosition;
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/fromFloatingUIPlacement.js
var getPositionMap = () => ({
	top: "above",
	bottom: "below",
	right: "after",
	left: "before"
});
var getAlignmentMap = (position) => {
	if (position === "above" || position === "below") return {
		start: "start",
		end: "end"
	};
	return {
		start: "top",
		end: "bottom"
	};
};
/**
* Maps Floating UI placement to positioning values
* @see positioningHelper.test.ts for expected placement values
*/ const fromFloatingUIPlacement = (placement) => {
	const { side, alignment: floatingUIAlignment } = parseFloatingUIPlacement(placement);
	const position = getPositionMap()[side];
	const alignment = floatingUIAlignment && getAlignmentMap(position)[floatingUIAlignment];
	return {
		position,
		alignment
	};
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/resolvePositioningShorthand.js
var shorthandLookup = {
	above: {
		position: "above",
		align: "center"
	},
	"above-start": {
		position: "above",
		align: "start"
	},
	"above-end": {
		position: "above",
		align: "end"
	},
	below: {
		position: "below",
		align: "center"
	},
	"below-start": {
		position: "below",
		align: "start"
	},
	"below-end": {
		position: "below",
		align: "end"
	},
	before: {
		position: "before",
		align: "center"
	},
	"before-top": {
		position: "before",
		align: "top"
	},
	"before-bottom": {
		position: "before",
		align: "bottom"
	},
	after: {
		position: "after",
		align: "center"
	},
	"after-top": {
		position: "after",
		align: "top"
	},
	"after-bottom": {
		position: "after",
		align: "bottom"
	}
};
function resolvePositioningShorthand(shorthand) {
	if (shorthand === void 0 || shorthand === null) return {};
	if (typeof shorthand === "string") return shorthandLookup[shorthand];
	return shorthand;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/useCallbackRef.js
/**
* Creates a MutableRef with ref change callback. Is useful as React.useRef() doesn't notify you when its content
* changes and mutating the .current property doesn't cause a re-render. An opt-out will be use a callback ref via
* React.useState(), but it will cause re-renders always.
*
* https://reactjs.org/docs/hooks-reference.html#useref
* https://github.com/theKashey/use-callback-ref#usecallbackref---to-replace-reactuseref
*
* @param initialValue - initial ref value
* @param callback - a callback to run when value changes
* @param skipInitialResolve - a flag to skip an initial ref report
*
* @example
* const ref = useCallbackRef(0, (newValue, oldValue) => console.log(oldValue, '->', newValue);
* ref.current = 1;
* // prints 0 -> 1
*/ function useCallbackRef(initialValue, callback, skipInitialResolve) {
	const isFirst = import_react.useRef(true);
	const [ref] = import_react.useState(() => ({
		value: initialValue,
		callback,
		facade: {
			get current() {
				return ref.value;
			},
			set current(value) {
				const last = ref.value;
				if (last !== value) {
					ref.value = value;
					if (skipInitialResolve && isFirst.current) return;
					ref.callback(value, last);
				}
			}
		}
	}));
	useIsomorphicLayoutEffect(() => {
		isFirst.current = false;
	}, []);
	ref.callback = callback;
	return ref.facade;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/debounce.js
/**
* Promise microtask debouncer used by Popper.js v2
* This is no longer exported in Floating UI (Popper.js v3)
* https://github.com/floating-ui/floating-ui/blob/v2.x/src/utils/debounce.js
* @param fn function that will be debounced
*/ function debounce(fn) {
	let pending;
	return () => {
		if (!pending) pending = new Promise((resolve) => {
			Promise.resolve().then(() => {
				pending = void 0;
				resolve(fn());
			});
		});
		return pending;
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/hasAutoFocusFilter.js
/**
* Detects if a passed HTML node has "autoFocus" prop on a React's fiber. Is needed as React handles autofocus behavior
* in React DOM and will not pass "autoFocus" to an actual HTML.
*
* @param node
*/ function hasAutofocusProp(node) {
	if (node.nodeName === "BUTTON" || node.nodeName === "INPUT" || node.nodeName === "SELECT" || node.nodeName === "TEXTAREA") {
		var _getReactFiberFromNode;
		return !!((_getReactFiberFromNode = getReactFiberFromNode(node)) === null || _getReactFiberFromNode === void 0 ? void 0 : _getReactFiberFromNode.pendingProps.autoFocus);
	}
	return false;
}
function hasAutofocusFilter(node) {
	return hasAutofocusProp(node) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/writeArrowUpdates.js
/**
* Writes all DOM element updates after position is computed
*/ function writeArrowUpdates(options) {
	const { arrow: arrow$2, middlewareData } = options;
	if (!middlewareData.arrow || !arrow$2) return;
	const { x: arrowX, y: arrowY } = middlewareData.arrow;
	Object.assign(arrow$2.style, {
		left: arrowX !== null && arrowX !== void 0 ? `${arrowX}px` : "",
		top: arrowY !== null && arrowY !== void 0 ? `${arrowY}px` : ""
	});
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/writeContainerupdates.js
/**
* Writes all container element position updates after the position is computed
*/ function writeContainerUpdates(options) {
	var _middlewareData_hide, _middlewareData_hide1, _container_ownerDocument_defaultView;
	const { container, placement, middlewareData, strategy, lowPPI, coordinates, useTransform = true } = options;
	if (!container) return;
	container.setAttribute(DATA_POSITIONING_PLACEMENT, placement);
	container.removeAttribute(DATA_POSITIONING_INTERSECTING);
	if (middlewareData.intersectionObserver.intersecting) container.setAttribute(DATA_POSITIONING_INTERSECTING, "");
	container.removeAttribute(DATA_POSITIONING_ESCAPED);
	if ((_middlewareData_hide = middlewareData.hide) === null || _middlewareData_hide === void 0 ? void 0 : _middlewareData_hide.escaped) container.setAttribute(DATA_POSITIONING_ESCAPED, "");
	container.removeAttribute(DATA_POSITIONING_HIDDEN);
	if ((_middlewareData_hide1 = middlewareData.hide) === null || _middlewareData_hide1 === void 0 ? void 0 : _middlewareData_hide1.referenceHidden) container.setAttribute(DATA_POSITIONING_HIDDEN, "");
	const devicePixelRatio = ((_container_ownerDocument_defaultView = container.ownerDocument.defaultView) === null || _container_ownerDocument_defaultView === void 0 ? void 0 : _container_ownerDocument_defaultView.devicePixelRatio) || 1;
	const x = Math.round(coordinates.x * devicePixelRatio) / devicePixelRatio;
	const y = Math.round(coordinates.y * devicePixelRatio) / devicePixelRatio;
	Object.assign(container.style, { position: strategy });
	if (useTransform) {
		Object.assign(container.style, { transform: lowPPI ? `translate(${x}px, ${y}px)` : `translate3d(${x}px, ${y}px, 0)` });
		return;
	}
	Object.assign(container.style, {
		left: `${x}px`,
		top: `${y}px`
	});
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/normalizeAutoSize.js
/**
* AutoSizes contains many options from historic implementation.
* Now options 'always'/'height-always'/'width-always' are obsolete.
* This function maps them to true/'height'/'width'
*/ const normalizeAutoSize = (autoSize) => {
	switch (autoSize) {
		case "always":
		case true: return {
			applyMaxWidth: true,
			applyMaxHeight: true
		};
		case "width-always":
		case "width": return {
			applyMaxWidth: true,
			applyMaxHeight: false
		};
		case "height-always":
		case "height": return {
			applyMaxWidth: false,
			applyMaxHeight: true
		};
		default: return false;
	}
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/listScrollParents.js
function listScrollParents(node) {
	const scrollParents = [];
	let cur = node;
	while (cur) {
		const scrollParent = getScrollParent(cur);
		if (node.ownerDocument.body === scrollParent) {
			scrollParents.push(scrollParent);
			break;
		}
		if (scrollParent.nodeName === "BODY" && scrollParent !== node.ownerDocument.body) {
			console.error("@fluentui/react-positioning: You are comparing two different documents! This is an unexpected error, please report this as a bug to the Fluent UI team ");
			break;
		}
		scrollParents.push(scrollParent);
		cur = scrollParent;
	}
	return scrollParents;
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/createResizeObserver.js
function createResizeObserver(targetWindow, callback) {
	return new targetWindow.ResizeObserver(callback);
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/createPositionManager.js
/**
* @internal
* @returns manager that handles positioning out of the react lifecycle
*/ function createPositionManager(options) {
	let isDestroyed = false;
	const { container, target, arrow: arrow$2, strategy, middleware, placement, useTransform = true, disableUpdateOnResize = false } = options;
	const targetWindow = container.ownerDocument.defaultView;
	if (!target || !container || !targetWindow) return {
		updatePosition: () => void 0,
		dispose: () => void 0
	};
	const resizeObserver = disableUpdateOnResize ? null : createResizeObserver(targetWindow, (entries) => {
		if (entries.every((entry) => {
			return entry.contentRect.width > 0 && entry.contentRect.height > 0;
		})) updatePosition();
	});
	let isFirstUpdate = true;
	const scrollParents = /* @__PURE__ */ new Set();
	Object.assign(container.style, {
		position: "fixed",
		left: 0,
		top: 0,
		margin: 0
	});
	const forceUpdate = () => {
		if (isDestroyed) return;
		if (isFirstUpdate) {
			listScrollParents(container).forEach((scrollParent) => scrollParents.add(scrollParent));
			if (isHTMLElement(target)) listScrollParents(target).forEach((scrollParent) => scrollParents.add(scrollParent));
			scrollParents.forEach((scrollParent) => {
				scrollParent.addEventListener("scroll", updatePosition, { passive: true });
			});
			resizeObserver === null || resizeObserver === void 0 || resizeObserver.observe(container);
			if (isHTMLElement(target)) resizeObserver === null || resizeObserver === void 0 || resizeObserver.observe(target);
			isFirstUpdate = false;
		}
		Object.assign(container.style, { position: strategy });
		computePosition(target, container, {
			placement,
			middleware,
			strategy
		}).then(({ x, y, middlewareData, placement: computedPlacement }) => {
			if (isDestroyed) return;
			writeArrowUpdates({
				arrow: arrow$2,
				middlewareData
			});
			writeContainerUpdates({
				container,
				middlewareData,
				placement: computedPlacement,
				coordinates: {
					x,
					y
				},
				lowPPI: ((targetWindow === null || targetWindow === void 0 ? void 0 : targetWindow.devicePixelRatio) || 1) <= 1,
				strategy,
				useTransform
			});
			container.dispatchEvent(new CustomEvent(POSITIONING_END_EVENT));
		}).catch((err) => {
			console.error("[usePositioning]: Failed to calculate position", err);
		});
	};
	const updatePosition = debounce(() => forceUpdate());
	const dispose = () => {
		isDestroyed = true;
		if (targetWindow) {
			targetWindow.removeEventListener("scroll", updatePosition);
			targetWindow.removeEventListener("resize", updatePosition);
		}
		scrollParents.forEach((scrollParent) => {
			scrollParent.removeEventListener("scroll", updatePosition);
		});
		scrollParents.clear();
		resizeObserver === null || resizeObserver === void 0 || resizeObserver.disconnect();
	};
	if (targetWindow) {
		targetWindow.addEventListener("scroll", updatePosition, { passive: true });
		targetWindow.addEventListener("resize", updatePosition);
	}
	updatePosition();
	return {
		updatePosition,
		dispose
	};
}

//#endregion
//#region node_modules/@floating-ui/devtools/dist/floating-ui.devtools.mjs
/**
* @internal
*/
var CONTROLLER = "__FUIDT_CONTROLLER__";
/**
* @internal
*/
var ELEMENT_METADATA = "__FUIDT_ELEMENT_METADATA__";
/**
* @internal
*/
var HTML_ELEMENT_REFERENCE = "__FUIDT_HTML_ELEMENT_REFERENCE__";
/**
* @internal
*/
var SERIALIZED_DATA_CHANGE = "__FUIDT_SERIALIZED_DATA_CHANGE__";
/**
* Verifies if a given node is an HTMLElement,
* this method works seamlessly with frames and elements from different documents
*
* This is preferred over simply using `instanceof`.
* Since `instanceof` might be problematic while operating with [multiple realms](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof#instanceof_and_multiple_realms)
*
* @example
* ```ts
* isHTMLElement(event.target) && event.target.focus()
* isHTMLElement(event.target, {constructorName: 'HTMLInputElement'}) && event.target.value // some value
* ```
*
*/
function isHTMLElement$1(element, options) {
	var _typedElement$ownerDo, _options$constructorN;
	const typedElement = element;
	return Boolean((typedElement == null || (_typedElement$ownerDo = typedElement.ownerDocument) == null ? void 0 : _typedElement$ownerDo.defaultView) && typedElement instanceof typedElement.ownerDocument.defaultView[(_options$constructorN = void 0) != null ? _options$constructorN : "HTMLElement"]);
}
/**
* @internal
*/
var isHTMLElementWithMetadata = (element) => Boolean(isHTMLElement$1(element) && ELEMENT_METADATA in element && element.parentElement !== null);
var createController = (defaultView) => {
	let selectedElement = null;
	const observer = new MutationObserver((mutations) => {
		if (!selectedElement) return;
		for (const mutation of mutations) if (mutation.type === "childList" && Array.from(mutation.removedNodes).includes(selectedElement)) controller.withdraw();
	});
	const controller = {
		get selectedElement() {
			return selectedElement;
		},
		select: (nextSelectedElement) => {
			if (isHTMLElementWithMetadata(nextSelectedElement)) {
				selectedElement = nextSelectedElement;
				observer.observe(nextSelectedElement.parentElement, {
					childList: true,
					subtree: false
				});
			}
			if (selectedElement && nextSelectedElement) {
				if (selectedElement[ELEMENT_METADATA].references.has(nextSelectedElement)) return selectedElement;
			}
			controller.withdraw();
			return selectedElement;
		},
		withdraw: () => {
			selectedElement = null;
			observer.disconnect();
			defaultView.postMessage(SERIALIZED_DATA_CHANGE);
		}
	};
	return controller;
};
var injectController = (_ref) => {
	let { defaultView } = _ref;
	if (!defaultView) return;
	if (!defaultView[CONTROLLER]) defaultView[CONTROLLER] = createController(defaultView);
};
var getController = (targetDocument) => {
	var _targetDocument$defau, _targetDocument$defau2;
	injectController(targetDocument);
	return (_targetDocument$defau = (_targetDocument$defau2 = targetDocument.defaultView) == null ? void 0 : _targetDocument$defau2[CONTROLLER]) != null ? _targetDocument$defau : null;
};
var serialize = (data, references) => {
	return JSON.parse(JSON.stringify(data, (_, value) => {
		if (isHTMLElement$1(value)) return references.add(value);
		if (typeof value === "object" && value && Object.getPrototypeOf(value) !== Object.prototype && Object.getPrototypeOf(value) !== Array.prototype) {
			if ("toString" in value) return value.toString();
			return;
		}
		return value;
	}));
};
var counter = 0;
var generateReferenceId = () => HTML_ELEMENT_REFERENCE + ":" + counter++;
var createReferences = () => {
	const map = /* @__PURE__ */ new Map();
	const weakMap = /* @__PURE__ */ new WeakMap();
	return {
		add: (element) => {
			if (weakMap.has(element)) return weakMap.get(element);
			const id = generateReferenceId();
			map.set(id, element);
			weakMap.set(element, id);
			return id;
		},
		get: (id) => {
			const element = map.get(id);
			if (element && weakMap.has(element)) return element;
		},
		has: (element) => {
			return weakMap.has(element);
		}
	};
};
/**
* devtools middleware
* @public
*/
var devtools = function(targetDocument, middlewareDataCallback) {
	if (targetDocument === void 0) targetDocument = document;
	if (middlewareDataCallback === void 0) middlewareDataCallback = floatingUIMiddlewareDataCallback;
	return {
		name: "@floating-ui/devtools",
		fn: (state) => {
			const { [ELEMENT_METADATA]: metadata } = isHTMLElementWithMetadata(state.elements.floating) ? state.elements.floating : Object.assign(state.elements.floating, { [ELEMENT_METADATA]: {
				references: createReferences(),
				serializedData: []
			} });
			const serializedData = serialize(middlewareDataCallback(state), metadata.references);
			metadata.serializedData.unshift(serializedData);
			const controller = getController(targetDocument);
			if (metadata.serializedData.length > 1 && state.elements.floating === (controller == null ? void 0 : controller.selectedElement)) {
				var _targetDocument$defau;
				(_targetDocument$defau = targetDocument.defaultView) == null || _targetDocument$defau.postMessage(SERIALIZED_DATA_CHANGE);
			}
			return {};
		}
	};
};
var floatingUIMiddlewareDataCallback = (state) => ({
	...state,
	type: "FloatingUIMiddleware"
});

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/coverTarget.js
function coverTarget() {
	return {
		name: "coverTarget",
		fn: (middlewareArguments) => {
			const { placement, rects, x, y } = middlewareArguments;
			const basePlacement = parseFloatingUIPlacement(placement).side;
			const newCoords = {
				x,
				y
			};
			switch (basePlacement) {
				case "bottom":
					newCoords.y -= rects.reference.height;
					break;
				case "top":
					newCoords.y += rects.reference.height;
					break;
				case "left":
					newCoords.x += rects.reference.width;
					break;
				case "right":
					newCoords.x -= rects.reference.width;
					break;
			}
			return newCoords;
		}
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/flip.js
function flip(options) {
	const { hasScrollableElement, flipBoundary, container, fallbackPositions = [], isRtl } = options;
	const fallbackPlacements = fallbackPositions.reduce((acc, shorthand) => {
		const { position, align } = resolvePositioningShorthand(shorthand);
		const placement = toFloatingUIPlacement(align, position, isRtl);
		if (placement) acc.push(placement);
		return acc;
	}, []);
	return flip$1({
		...hasScrollableElement && { boundary: "clippingAncestors" },
		...flipBoundary && {
			altBoundary: true,
			boundary: getBoundary(container, flipBoundary)
		},
		fallbackStrategy: "bestFit",
		...fallbackPlacements.length && { fallbackPlacements }
	});
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/intersecting.js
function intersecting() {
	return {
		name: "intersectionObserver",
		fn: async (middlewareArguments) => {
			const floatingRect = middlewareArguments.rects.floating;
			const altOverflow = await detectOverflow(middlewareArguments, { altBoundary: true });
			const isIntersectingTop = altOverflow.top < floatingRect.height && altOverflow.top > 0;
			const isIntersectingBottom = altOverflow.bottom < floatingRect.height && altOverflow.bottom > 0;
			return { data: { intersecting: isIntersectingTop || isIntersectingBottom } };
		}
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/maxSize.js
/**
* floating-ui `size` middleware uses floating element's height/width to calculate available height/width.
* This middleware only runs once per lifecycle, resetting styles applied by maxSize from previous lifecycle.
* Then floating element's original size is restored and `size` middleware can calculate available height/width correctly.
*/ const resetMaxSize = (autoSize) => ({
	name: "resetMaxSize",
	fn({ middlewareData, elements }) {
		var _middlewareData_resetMaxSize;
		if ((_middlewareData_resetMaxSize = middlewareData.resetMaxSize) === null || _middlewareData_resetMaxSize === void 0 ? void 0 : _middlewareData_resetMaxSize.maxSizeAlreadyReset) return {};
		const { applyMaxWidth, applyMaxHeight } = autoSize;
		if (applyMaxWidth) {
			elements.floating.style.removeProperty("box-sizing");
			elements.floating.style.removeProperty("max-width");
			elements.floating.style.removeProperty("width");
		}
		if (applyMaxHeight) {
			elements.floating.style.removeProperty("box-sizing");
			elements.floating.style.removeProperty("max-height");
			elements.floating.style.removeProperty("height");
		}
		return {
			data: { maxSizeAlreadyReset: true },
			reset: { rects: true }
		};
	}
});
function maxSize(autoSize, options) {
	const { container, overflowBoundary, overflowBoundaryPadding, isRtl } = options;
	return size({
		...overflowBoundaryPadding && { padding: toFloatingUIPadding(overflowBoundaryPadding, isRtl) },
		...overflowBoundary && {
			altBoundary: true,
			boundary: getBoundary(container, overflowBoundary)
		},
		apply({ availableHeight, availableWidth, elements, rects }) {
			const applyMaxSizeStyles = (apply, dimension, availableSize) => {
				if (!apply) return;
				elements.floating.style.setProperty("box-sizing", "border-box");
				elements.floating.style.setProperty(`max-${dimension}`, `${availableSize}px`);
				if (rects.floating[dimension] > availableSize) {
					elements.floating.style.setProperty(dimension, `${availableSize}px`);
					const axis = dimension === "width" ? "x" : "y";
					if (!elements.floating.style.getPropertyValue(`overflow-${axis}`)) elements.floating.style.setProperty(`overflow-${axis}`, "auto");
				}
			};
			const { applyMaxWidth, applyMaxHeight } = autoSize;
			applyMaxSizeStyles(applyMaxWidth, "width", availableWidth);
			applyMaxSizeStyles(applyMaxHeight, "height", availableHeight);
		}
	});
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/getFloatingUIOffset.js
/**
* Shim to transform offset values from this library to Floating UI
* @param rawOffset Offset from this library
* @returns An offset value compatible with Floating UI
*/ function getFloatingUIOffset(rawOffset) {
	if (!rawOffset) return rawOffset;
	if (typeof rawOffset === "number" || typeof rawOffset === "object") return rawOffset;
	return ({ rects: { floating, reference }, placement }) => {
		const { position, alignment } = fromFloatingUIPlacement(placement);
		return rawOffset({
			positionedRect: floating,
			targetRect: reference,
			position,
			alignment
		});
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/offset.js
/**
* Wraps floating UI offset middleware to transform offset value.
*/ function offset(offsetValue) {
	const floatingUIOffset = getFloatingUIOffset(offsetValue);
	return offset$1(floatingUIOffset);
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/shift.js
/**
* Wraps the floating UI shift middleware for easier usage of our options
*/ function shift(options) {
	const { hasScrollableElement, shiftToCoverTarget, disableTether, overflowBoundary, container, overflowBoundaryPadding, isRtl } = options;
	return shift$1({
		...hasScrollableElement && { boundary: "clippingAncestors" },
		...shiftToCoverTarget && {
			crossAxis: true,
			limiter: limitShift({
				crossAxis: true,
				mainAxis: false
			})
		},
		...disableTether && {
			crossAxis: disableTether === "all",
			limiter: limitShift({
				crossAxis: disableTether !== "all",
				mainAxis: false
			})
		},
		...overflowBoundaryPadding && { padding: toFloatingUIPadding(overflowBoundaryPadding, isRtl) },
		...overflowBoundary && {
			altBoundary: true,
			boundary: getBoundary(container, overflowBoundary)
		}
	});
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/middleware/matchTargetSize.js
const matchTargetSizeCssVar = "--fui-match-target-size";
function matchTargetSize() {
	return {
		name: "matchTargetSize",
		fn: async (middlewareArguments) => {
			const { rects: { reference: referenceRect, floating: floatingRect }, elements: { floating: floatingElement }, middlewareData: { matchTargetSize: { matchTargetSizeAttempt = false } = {} } } = middlewareArguments;
			if (referenceRect.width === floatingRect.width || matchTargetSizeAttempt) return {};
			const { width } = referenceRect;
			floatingElement.style.setProperty(matchTargetSizeCssVar, `${width}px`);
			if (!floatingElement.style.width) floatingElement.style.width = `var(${matchTargetSizeCssVar})`;
			return {
				data: { matchTargetSizeAttempt: true },
				reset: { rects: true }
			};
		}
	};
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/utils/devtools.js
const devtoolsCallback = (options) => (middlewareState) => {
	const { elements: { floating, reference } } = middlewareState;
	const scrollParentsSet = /* @__PURE__ */ new Set();
	if (isHTMLElement(reference)) listScrollParents(reference).forEach((scrollParent) => scrollParentsSet.add(scrollParent));
	listScrollParents(floating).forEach((scrollParent) => scrollParentsSet.add(scrollParent));
	const flipBoundaries = Array.isArray(options.flipBoundary) ? options.flipBoundary : isHTMLElement(options.flipBoundary) ? [options.flipBoundary] : [];
	const overflowBoundaries = Array.isArray(options.overflowBoundary) ? options.overflowBoundary : isHTMLElement(options.overflowBoundary) ? [options.overflowBoundary] : [];
	return {
		type: "FluentUIMiddleware",
		middlewareState,
		options,
		initialPlacement: fromFloatingUIPlacement(middlewareState.initialPlacement),
		placement: fromFloatingUIPlacement(middlewareState.placement),
		flipBoundaries,
		overflowBoundaries,
		scrollParents: Array.from(scrollParentsSet)
	};
};

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/usePositioningOptions.js
/**
* @internal
*
* This is redundant and exists only to manage React dependencies properly & avoid leaking individual options to the
* scope of `usePositioningOptions`.
*/ function usePositioningConfigFn(configFn, options) {
	const { align, arrowPadding, autoSize, coverTarget: coverTarget$1, disableUpdateOnResize, flipBoundary, offset: offset$3, overflowBoundary, pinned, position, unstable_disableTether, strategy, overflowBoundaryPadding, fallbackPositions, useTransform, matchTargetSize: matchTargetSize$1, shiftToCoverTarget } = options;
	return import_react.useCallback((container, arrow$2) => {
		return configFn({
			container,
			arrow: arrow$2,
			options: {
				autoSize,
				disableUpdateOnResize,
				matchTargetSize: matchTargetSize$1,
				offset: offset$3,
				strategy,
				coverTarget: coverTarget$1,
				flipBoundary,
				overflowBoundary,
				useTransform,
				overflowBoundaryPadding,
				pinned,
				arrowPadding,
				align,
				fallbackPositions,
				shiftToCoverTarget,
				position,
				unstable_disableTether
			}
		});
	}, [
		autoSize,
		disableUpdateOnResize,
		matchTargetSize$1,
		offset$3,
		strategy,
		coverTarget$1,
		flipBoundary,
		overflowBoundary,
		useTransform,
		overflowBoundaryPadding,
		pinned,
		arrowPadding,
		align,
		fallbackPositions,
		shiftToCoverTarget,
		position,
		unstable_disableTether,
		configFn
	]);
}
/**
* @internal
*/ function usePositioningOptions(options) {
	const { dir, targetDocument } = useFluent();
	const isRtl = dir === "rtl";
	const configFn = usePositioningConfigFn(usePositioningConfiguration(), options);
	const { positionFixed } = options;
	return import_react.useCallback((container, arrow$2) => {
		const hasScrollableElement = hasScrollParent(container);
		const optionsAfterEnhancement = configFn(container, arrow$2);
		const { autoSize, disableUpdateOnResize, matchTargetSize: matchTargetSize$1, offset: offset$3, coverTarget: coverTarget$1, flipBoundary, overflowBoundary, useTransform, overflowBoundaryPadding, pinned, position, arrowPadding, strategy, align, fallbackPositions, shiftToCoverTarget, unstable_disableTether } = optionsAfterEnhancement;
		const normalizedAutoSize = normalizeAutoSize(autoSize);
		const middleware = [
			normalizedAutoSize && resetMaxSize(normalizedAutoSize),
			matchTargetSize$1 && matchTargetSize(),
			offset$3 && offset(offset$3),
			coverTarget$1 && coverTarget(),
			!pinned && flip({
				container,
				flipBoundary,
				hasScrollableElement,
				isRtl,
				fallbackPositions
			}),
			shift({
				container,
				hasScrollableElement,
				overflowBoundary,
				disableTether: unstable_disableTether,
				overflowBoundaryPadding,
				isRtl,
				shiftToCoverTarget
			}),
			normalizedAutoSize && maxSize(normalizedAutoSize, {
				container,
				overflowBoundary,
				overflowBoundaryPadding,
				isRtl
			}),
			intersecting(),
			arrow$2 && arrow({
				element: arrow$2,
				padding: arrowPadding
			}),
			hide({ strategy: "referenceHidden" }),
			hide({ strategy: "escaped" }),
			targetDocument && devtools(targetDocument, devtoolsCallback(optionsAfterEnhancement))
		].filter(Boolean);
		return {
			placement: toFloatingUIPlacement(align, position, isRtl),
			middleware,
			strategy: (strategy !== null && strategy !== void 0 ? strategy : positionFixed) ? "fixed" : "absolute",
			disableUpdateOnResize,
			useTransform
		};
	}, [
		configFn,
		isRtl,
		targetDocument,
		positionFixed
	]);
}

//#endregion
//#region node_modules/@fluentui/react-positioning/lib/usePositioning.js
/**
* @internal
*/ function usePositioning(options) {
	"use no memo";
	const managerRef = import_react.useRef(null);
	const targetRef = import_react.useRef(null);
	const overrideTargetRef = import_react.useRef(null);
	const containerRef = import_react.useRef(null);
	const arrowRef = import_react.useRef(null);
	const { enabled = true } = options;
	const resolvePositioningOptions = usePositioningOptions(options);
	const updatePositionManager = import_react.useCallback(() => {
		if (managerRef.current) managerRef.current.dispose();
		managerRef.current = null;
		var _overrideTargetRef_current;
		const target = (_overrideTargetRef_current = overrideTargetRef.current) !== null && _overrideTargetRef_current !== void 0 ? _overrideTargetRef_current : targetRef.current;
		if (enabled && canUseDOM() && target && containerRef.current) managerRef.current = createPositionManager({
			container: containerRef.current,
			target,
			arrow: arrowRef.current,
			...resolvePositioningOptions(containerRef.current, arrowRef.current)
		});
	}, [enabled, resolvePositioningOptions]);
	const setOverrideTarget = useEventCallback((target) => {
		overrideTargetRef.current = target;
		updatePositionManager();
	});
	import_react.useImperativeHandle(options.positioningRef, () => ({
		updatePosition: () => {
			var _managerRef_current;
			return (_managerRef_current = managerRef.current) === null || _managerRef_current === void 0 ? void 0 : _managerRef_current.updatePosition();
		},
		setTarget: (target) => {
			if (options.target && true) {
				const err = /* @__PURE__ */ new Error();
				console.warn("Imperative setTarget should not be used at the same time as target option");
				console.warn(err.stack);
			}
			setOverrideTarget(target);
		}
	}), [options.target, setOverrideTarget]);
	useIsomorphicLayoutEffect(() => {
		var _options_target;
		setOverrideTarget((_options_target = options.target) !== null && _options_target !== void 0 ? _options_target : null);
	}, [options.target, setOverrideTarget]);
	useIsomorphicLayoutEffect(() => {
		updatePositionManager();
	}, [updatePositionManager]);
	import_react.useEffect(() => {
		if (containerRef.current) {
			var _contentNode_ownerDocument;
			const contentNode = containerRef.current;
			const treeWalker = (_contentNode_ownerDocument = contentNode.ownerDocument) === null || _contentNode_ownerDocument === void 0 ? void 0 : _contentNode_ownerDocument.createTreeWalker(contentNode, NodeFilter.SHOW_ELEMENT, { acceptNode: hasAutofocusFilter });
			while (treeWalker.nextNode()) {
				const node = treeWalker.currentNode;
				console.warn("usePositioning():", node);
				console.warn([
					"usePositioning(): ^ this node contains \"autoFocus\" prop on a React element. This can break the initial",
					"positioning of an element and cause a window jump effect. This issue occurs because React polyfills",
					"\"autoFocus\" behavior to solve inconsistencies between different browsers:",
					"https://github.com/facebook/react/issues/11851#issuecomment-351787078",
					"\n",
					"However, \".focus()\" in this case occurs before any other React effects will be executed",
					"(React.useEffect(), componentDidMount(), etc.) and we can not prevent this behavior. If you really",
					"want to use \"autoFocus\" please add \"position: fixed\" to styles of the element that is wrapped by",
					"\"Popper\".",
					`In general, it's not recommended to use "autoFocus" as it may break accessibility aspects:`,
					"https://github.com/jsx-eslint/eslint-plugin-jsx-a11y/blob/master/docs/rules/no-autofocus.md",
					"\n",
					"We suggest to use the \"trapFocus\" prop on Fluent components or a catch \"ref\" and then use",
					"\"ref.current.focus\" in React.useEffect():",
					"https://reactjs.org/docs/refs-and-the-dom.html#adding-a-ref-to-a-dom-element"
				].join(" "));
			}
		}
	}, []);
	const setTarget = useCallbackRef(null, (target) => {
		if (targetRef.current !== target) {
			targetRef.current = target;
			updatePositionManager();
		}
	});
	const onPositioningEnd = useEventCallback(() => {
		var _options_onPositioningEnd;
		return (_options_onPositioningEnd = options.onPositioningEnd) === null || _options_onPositioningEnd === void 0 ? void 0 : _options_onPositioningEnd.call(options);
	});
	const setContainer = useCallbackRef(null, (container) => {
		if (containerRef.current !== container) {
			var _containerRef_current;
			(_containerRef_current = containerRef.current) === null || _containerRef_current === void 0 || _containerRef_current.removeEventListener(POSITIONING_END_EVENT, onPositioningEnd);
			container === null || container === void 0 || container.addEventListener(POSITIONING_END_EVENT, onPositioningEnd);
			containerRef.current = container;
			updatePositionManager();
		}
	});
	const setArrow = useCallbackRef(null, (arrow$2) => {
		if (arrowRef.current !== arrow$2) {
			arrowRef.current = arrow$2;
			updatePositionManager();
		}
	});
	return {
		targetRef: setTarget,
		containerRef: setContainer,
		arrowRef: setArrow
	};
}

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/private/constants.js
/**
* The height of the tooltip's arrow in pixels.
*/ const arrowHeight = 6;
/**
* The default value of the tooltip's border radius (borderRadiusMedium).
*
* Unfortunately, Popper requires it to be specified as a variable instead of using CSS.
* While we could use getComputedStyle, that adds a performance penalty for something that
* will likely never change.
*/ const tooltipBorderRadius = 4;

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/private/useTooltipTimeout.js
var setTimeoutNoop = (_callback) => -1;
var clearTimeoutNoop = (_handle) => void 0;
/**
* @internal
* @param triggerElementRef - Reference to the trigger element
* @returns A pair of [setTimeout, clearTimeout] that are stable between renders.
*/ function useTooltipTimeout(triggerElementRef) {
	const { targetDocument } = useFluent();
	const win = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
	const setTimerFn = win ? win.setTimeout : setTimeoutNoop;
	const clearTimerFn = win ? win.clearTimeout : clearTimeoutNoop;
	const id = import_react.useRef(void 0);
	const set = import_react.useCallback((fn, delay) => {
		if (id.current !== void 0) clearTimerFn(id.current);
		id.current = setTimerFn(fn, delay !== null && delay !== void 0 ? delay : 0);
		return id.current;
	}, [clearTimerFn, setTimerFn]);
	const cancel = import_react.useCallback(() => {
		if (id.current !== void 0) {
			clearTimerFn(id.current);
			id.current = void 0;
		}
	}, [clearTimerFn]);
	import_react.useEffect(() => {
		const el = triggerElementRef.current;
		return () => {
			if (!el || !el.isConnected) cancel();
		};
	}, [cancel, triggerElementRef]);
	return [set, cancel];
}

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/useTooltip.js
/**
* Create the state required to render Tooltip.
*
* The returned state can be modified with hooks such as useTooltipStyles_unstable,
* before being passed to renderTooltip_unstable.
*
* @param props - props from this instance of Tooltip
*/ const useTooltip_unstable = (props) => {
	"use no memo";
	var _child_props, _child_props1, _child_props2, _child_props3, _child_props4, _child_props5, _child_props6;
	const context = useTooltipVisibility();
	const isServerSideRender = useIsSSR();
	const { targetDocument } = useFluent();
	const [visible, setVisibleInternal] = useControllableState({
		state: props.visible,
		initialState: false
	});
	const { appearance = "normal", children, content, withArrow = false, positioning = "above", onVisibleChange, relationship, showDelay = 250, hideDelay = 250, mountNode } = props;
	const state = {
		withArrow,
		positioning,
		showDelay,
		hideDelay,
		relationship,
		visible,
		shouldRenderTooltip: visible,
		appearance,
		mountNode,
		components: { content: "div" },
		content: always(content, {
			defaultProps: { role: "tooltip" },
			elementType: "div"
		})
	};
	state.content.id = useId("tooltip-", state.content.id);
	const positioningOptions = {
		enabled: state.visible,
		arrowPadding: 2 * tooltipBorderRadius,
		position: "above",
		align: "center",
		offset: 4,
		...resolvePositioningShorthand(state.positioning)
	};
	if (state.withArrow) positioningOptions.offset = mergeArrowOffset(positioningOptions.offset, arrowHeight);
	const { targetRef, containerRef, arrowRef } = usePositioning(positioningOptions);
	const [setDelayTimeout, clearDelayTimeout] = useTooltipTimeout(containerRef);
	const setVisible = import_react.useCallback((ev, data) => {
		clearDelayTimeout();
		setVisibleInternal((oldVisible) => {
			if (data.visible !== oldVisible) onVisibleChange === null || onVisibleChange === void 0 || onVisibleChange(ev, data);
			return data.visible;
		});
	}, [
		clearDelayTimeout,
		setVisibleInternal,
		onVisibleChange
	]);
	state.content.ref = useMergedRefs(state.content.ref, containerRef);
	state.arrowRef = arrowRef;
	useIsomorphicLayoutEffect(() => {
		if (visible) {
			var _context_visibleTooltip;
			const thisTooltip = { hide: (ev) => setVisible(void 0, {
				visible: false,
				documentKeyboardEvent: ev
			}) };
			(_context_visibleTooltip = context.visibleTooltip) === null || _context_visibleTooltip === void 0 || _context_visibleTooltip.hide();
			context.visibleTooltip = thisTooltip;
			const onDocumentKeyDown = (ev) => {
				if (ev.key === Escape && !ev.defaultPrevented) {
					thisTooltip.hide(ev);
					ev.preventDefault();
				}
			};
			targetDocument === null || targetDocument === void 0 || targetDocument.addEventListener("keydown", onDocumentKeyDown, { capture: true });
			return () => {
				if (context.visibleTooltip === thisTooltip) context.visibleTooltip = void 0;
				targetDocument === null || targetDocument === void 0 || targetDocument.removeEventListener("keydown", onDocumentKeyDown, { capture: true });
			};
		}
	}, [
		context,
		targetDocument,
		visible,
		setVisible
	]);
	const ignoreNextFocusEventRef = import_react.useRef(false);
	const onEnterTrigger = import_react.useCallback((ev) => {
		if (ev.type === "focus" && ignoreNextFocusEventRef.current) {
			ignoreNextFocusEventRef.current = false;
			return;
		}
		const delay = context.visibleTooltip ? 0 : state.showDelay;
		setDelayTimeout(() => {
			setVisible(ev, { visible: true });
		}, delay);
		ev.persist();
	}, [
		setDelayTimeout,
		setVisible,
		state.showDelay,
		context
	]);
	const isNavigatingWithKeyboard = useIsNavigatingWithKeyboard();
	const [keyborgListenerCallbackRef] = import_react.useState(() => {
		const onKeyborgFocusIn = (ev) => {
			var _ev_detail;
			if (((_ev_detail = ev.detail) === null || _ev_detail === void 0 ? void 0 : _ev_detail.isFocusedProgrammatically) && !isNavigatingWithKeyboard()) ignoreNextFocusEventRef.current = true;
		};
		let current = null;
		return (element) => {
			current === null || current === void 0 || current.removeEventListener(KEYBORG_FOCUSIN, onKeyborgFocusIn);
			element === null || element === void 0 || element.addEventListener(KEYBORG_FOCUSIN, onKeyborgFocusIn);
			current = element;
		};
	});
	const onLeaveTrigger = import_react.useCallback((ev) => {
		let delay = state.hideDelay;
		if (ev.type === "blur") {
			delay = 0;
			ignoreNextFocusEventRef.current = (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement) === ev.target;
		}
		setDelayTimeout(() => {
			setVisible(ev, { visible: false });
		}, delay);
		ev.persist();
	}, [
		setDelayTimeout,
		setVisible,
		state.hideDelay,
		targetDocument
	]);
	state.content.onPointerEnter = mergeCallbacks(state.content.onPointerEnter, clearDelayTimeout);
	state.content.onPointerLeave = mergeCallbacks(state.content.onPointerLeave, onLeaveTrigger);
	state.content.onFocus = mergeCallbacks(state.content.onFocus, clearDelayTimeout);
	state.content.onBlur = mergeCallbacks(state.content.onBlur, onLeaveTrigger);
	const child = getTriggerChild(children);
	const triggerAriaProps = {};
	const isPopupExpanded = (child === null || child === void 0 ? void 0 : (_child_props = child.props) === null || _child_props === void 0 ? void 0 : _child_props["aria-haspopup"]) && ((child === null || child === void 0 ? void 0 : (_child_props1 = child.props) === null || _child_props1 === void 0 ? void 0 : _child_props1["aria-expanded"]) === true || (child === null || child === void 0 ? void 0 : (_child_props2 = child.props) === null || _child_props2 === void 0 ? void 0 : _child_props2["aria-expanded"]) === "true");
	if (relationship === "label") if (typeof state.content.children === "string") triggerAriaProps["aria-label"] = state.content.children;
	else {
		triggerAriaProps["aria-labelledby"] = state.content.id;
		state.shouldRenderTooltip = true;
	}
	else if (relationship === "description") {
		triggerAriaProps["aria-describedby"] = state.content.id;
		state.shouldRenderTooltip = true;
	}
	if (isServerSideRender || isPopupExpanded) state.shouldRenderTooltip = false;
	state.children = applyTriggerPropsToChildren(children, {
		...triggerAriaProps,
		...child === null || child === void 0 ? void 0 : child.props,
		ref: useMergedRefs(getReactElementRef(child), keyborgListenerCallbackRef, positioningOptions.target === void 0 ? targetRef : void 0),
		onPointerEnter: useEventCallback(mergeCallbacks(child === null || child === void 0 ? void 0 : (_child_props3 = child.props) === null || _child_props3 === void 0 ? void 0 : _child_props3.onPointerEnter, onEnterTrigger)),
		onPointerLeave: useEventCallback(mergeCallbacks(child === null || child === void 0 ? void 0 : (_child_props4 = child.props) === null || _child_props4 === void 0 ? void 0 : _child_props4.onPointerLeave, onLeaveTrigger)),
		onFocus: useEventCallback(mergeCallbacks(child === null || child === void 0 ? void 0 : (_child_props5 = child.props) === null || _child_props5 === void 0 ? void 0 : _child_props5.onFocus, onEnterTrigger)),
		onBlur: useEventCallback(mergeCallbacks(child === null || child === void 0 ? void 0 : (_child_props6 = child.props) === null || _child_props6 === void 0 ? void 0 : _child_props6.onBlur, onLeaveTrigger))
	});
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-portal/lib/utils/toMountNodeProps.js
/**
* The function that normalizes the `mountNode` prop into an object with element and className props.
*
* @param mountNode - an HTML element or an object with props
*/ function toMountNodeProps(mountNode) {
	if (isHTMLElement(mountNode)) return { element: mountNode };
	if (typeof mountNode === "object") {
		if (mountNode === null) return { element: null };
		return mountNode;
	}
	return {};
}

//#endregion
//#region node_modules/@fluentui/react-portal/lib/components/Portal/usePortalMountNodeStyles.styles.js
const usePortalMountNodeStylesStyles = /* @__PURE__ */ __styles({ root: {
	qhf8xq: "f1euv43f",
	Bhzewxz: "f15twtuk",
	oyh7mz: ["f1vgc2s3", "f1e31b4d"],
	j35jbq: ["f1e31b4d", "f1vgc2s3"],
	Bj3rh1h: "f494woh"
} }, { d: [
	".f1euv43f{position:absolute;}",
	".f15twtuk{top:0;}",
	".f1vgc2s3{left:0;}",
	".f1e31b4d{right:0;}",
	".f494woh{z-index:1000000;}"
] });

//#endregion
//#region node_modules/@fluentui/react-portal/lib/components/Portal/usePortalMountNode.js
var useInsertionEffect = import_react.useInsertionEffect;
/**
* Legacy element factory for React 17 and below. It's not safe for concurrent rendering.
*
* Creates a new element on a "document.body" to mount portals.
*/ var useLegacyElementFactory = (options) => {
	"use no memo";
	const { className, dir, focusVisibleRef, targetNode } = options;
	const targetElement = import_react.useMemo(() => {
		if (targetNode === void 0 || options.disabled) return null;
		const element = targetNode.ownerDocument.createElement("div");
		targetNode.appendChild(element);
		return element;
	}, [targetNode, options.disabled]);
	import_react.useMemo(() => {
		if (!targetElement) return;
		targetElement.className = className;
		targetElement.setAttribute("dir", dir);
		targetElement.setAttribute("data-portal-node", "true");
		focusVisibleRef.current = targetElement;
	}, [
		className,
		dir,
		targetElement,
		focusVisibleRef
	]);
	import_react.useEffect(() => {
		return () => {
			targetElement === null || targetElement === void 0 || targetElement.remove();
		};
	}, [targetElement]);
	return targetElement;
};
var initializeElementFactory = () => {
	let currentElement = void 0;
	function get(targetRoot, forceCreation) {
		if (currentElement) return currentElement;
		if (forceCreation) {
			currentElement = targetRoot.ownerDocument.createElement("div");
			targetRoot.appendChild(currentElement);
		}
		return currentElement;
	}
	function dispose() {
		if (currentElement) {
			currentElement.remove();
			currentElement = void 0;
		}
	}
	return {
		get,
		dispose
	};
};
/**
* This is a modern element factory for React 18 and above. It is safe for concurrent rendering.
*
* It abuses the fact that React will mount DOM once (unlike hooks), so by using a proxy we can intercept:
* - the `remove()` method (we call it in `useEffect()`) and remove the element only when the portal is unmounted
* - all other methods (and properties) will be called by React once a portal is mounted
*/ var useModernElementFactory = (options) => {
	"use no memo";
	const { className, dir, focusVisibleRef, targetNode } = options;
	const [elementFactory] = import_react.useState(initializeElementFactory);
	const elementProxy = import_react.useMemo(() => {
		if (targetNode === void 0 || options.disabled) return null;
		return new Proxy({}, {
			get(_, property) {
				if (property === "nodeType") return 1;
				if (property === "remove") {
					const targetElement$1 = elementFactory.get(targetNode, false);
					if (targetElement$1) {
						if (targetElement$1.childNodes.length === 0) elementFactory.dispose();
					}
					return () => {};
				}
				const targetElement = elementFactory.get(targetNode, true);
				const targetProperty = targetElement ? targetElement[property] : void 0;
				if (typeof targetProperty === "function") return targetProperty.bind(targetElement);
				return targetProperty;
			},
			set(_, property, value) {
				const ignoredProperty = property === "_virtual" || property === "focusVisible";
				const targetElement = ignoredProperty ? elementFactory.get(targetNode, false) : elementFactory.get(targetNode, true);
				if (ignoredProperty && !targetElement) return true;
				if (targetElement) {
					Object.assign(targetElement, { [property]: value });
					return true;
				}
				return false;
			}
		});
	}, [
		elementFactory,
		targetNode,
		options.disabled
	]);
	useInsertionEffect(() => {
		if (!elementProxy) return;
		const classesToApply = className.split(" ").filter(Boolean);
		elementProxy.classList.add(...classesToApply);
		elementProxy.setAttribute("dir", dir);
		elementProxy.setAttribute("data-portal-node", "true");
		focusVisibleRef.current = elementProxy;
		return () => {
			elementProxy.classList.remove(...classesToApply);
			elementProxy.removeAttribute("dir");
		};
	}, [
		className,
		dir,
		elementProxy,
		focusVisibleRef
	]);
	import_react.useEffect(() => {
		return () => {
			elementProxy === null || elementProxy === void 0 || elementProxy.remove();
		};
	}, [elementProxy]);
	return elementProxy;
};
/**
* Element factory based on the React version.
*
* React 17 and below:
* - useLegacyElementFactory
*
* React 18 and above:
* - useModernElementFactory
*/ var useElementFactory = useInsertionEffect ? useModernElementFactory : useLegacyElementFactory;
/**
* Creates a new element on a "document.body" to mount portals.
*/ const usePortalMountNode = (options) => {
	"use no memo";
	const { targetDocument, dir } = useFluent();
	const mountNode = usePortalMountNode$1();
	const focusVisibleRef = useFocusVisible();
	const classes = usePortalMountNodeStylesStyles();
	const themeClassName = useThemeClassName();
	const factoryOptions = {
		dir,
		disabled: options.disabled,
		focusVisibleRef,
		className: mergeClasses(themeClassName, classes.root, options.className),
		targetNode: mountNode !== null && mountNode !== void 0 ? mountNode : targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body
	};
	return useElementFactory(factoryOptions);
};

//#endregion
//#region node_modules/@fluentui/react-portal/lib/components/Portal/usePortal.js
/**
* Create the state required to render Portal.
*
* The returned state can be modified with hooks such as usePortalStyles, before being passed to renderPortal_unstable.
*
* @param props - props from this instance of Portal
*/ const usePortal_unstable = (props) => {
	const { element, className } = toMountNodeProps(props.mountNode);
	const virtualParentRootRef = import_react.useRef(null);
	const fallbackElement = usePortalMountNode({
		disabled: !!element,
		className
	});
	const mountNode = element !== null && element !== void 0 ? element : fallbackElement;
	const state = {
		children: props.children,
		mountNode,
		virtualParentRootRef
	};
	import_react.useEffect(() => {
		if (!mountNode) return;
		const virtualParent = virtualParentRootRef.current;
		const isVirtualParentInsideChild = mountNode.contains(virtualParent);
		if (virtualParent && !isVirtualParentInsideChild) {
			setVirtualParent(mountNode, virtualParent);
			return () => {
				setVirtualParent(mountNode, void 0);
			};
		}
	}, [virtualParentRootRef, mountNode]);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-portal/lib/components/Portal/renderPortal.js
var import_react_dom = /* @__PURE__ */ __toESM(require_react_dom());
/**
* Render the final JSX of Portal
*/ const renderPortal_unstable = (state) => {
	return /* @__PURE__ */ import_react.createElement("span", {
		hidden: true,
		ref: state.virtualParentRootRef
	}, state.mountNode && /* @__PURE__ */ import_react_dom.createPortal(/* @__PURE__ */ import_react.createElement(import_react.Fragment, null, state.children, /* @__PURE__ */ import_react.createElement("span", { hidden: true })), state.mountNode));
};

//#endregion
//#region node_modules/@fluentui/react-portal/lib/components/Portal/Portal.js
/**
* A portal provides a way to render children into a DOM node
* that exists outside the DOM hierarchy of the parent component.
*/ const Portal = (props) => {
	const state = usePortal_unstable(props);
	return renderPortal_unstable(state);
};
Portal.displayName = "Portal";

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/renderTooltip.js
/**
* Render the final JSX of Tooltip
*/ const renderTooltip_unstable = (state) => {
	assertSlots(state);
	return /* @__PURE__ */ jsxs(import_react.Fragment, { children: [state.children, state.shouldRenderTooltip && /* @__PURE__ */ jsx(Portal, {
		mountNode: state.mountNode,
		children: /* @__PURE__ */ jsxs(state.content, { children: [state.withArrow && /* @__PURE__ */ jsx("div", {
			ref: state.arrowRef,
			className: state.arrowClassName
		}), state.content.children] })
	})] });
};

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/useTooltipStyles.styles.js
const tooltipClassNames = { content: "fui-Tooltip__content" };
/**
* Styles for the tooltip
*/
var useStyles$2 = /* @__PURE__ */ __styles({
	root: {
		mc9l5x: "fjseox",
		B7ck84d: "f1ewtqcl",
		B2u0y6b: "f132xexn",
		Bceei9c: "f158kwzp",
		Bahqtrf: "fk6fouc",
		Be2twd7: "fy9rknc",
		Bg96gwp: "fwrc4pm",
		Btd35i7: "fokg9q4",
		Beyfa6y: 0,
		Bbmb7ep: 0,
		Btl43ni: 0,
		B7oj6ja: 0,
		Dimara: "ft85np5",
		Bgfg5da: 0,
		B9xav0g: 0,
		oivjwe: 0,
		Bn0qgzm: 0,
		B4g9neb: 0,
		zhjwy3: 0,
		wvpqe5: 0,
		ibv6hh: 0,
		u1mtju: 0,
		h3c5rm: 0,
		vrafjx: 0,
		Bekrc4i: 0,
		i8vvqc: 0,
		g2u3we: 0,
		icvyot: 0,
		B4j52fo: 0,
		irswps: "f9ggezi",
		Byoj8tv: 0,
		uwmqm3: 0,
		z189sj: 0,
		z8tnut: 0,
		B0ocmuz: "f1bzqsji",
		De3pzq: "fxugw4r",
		sj55zd: "f19n0e5",
		Bhu2qc9: "fxeb0a7"
	},
	visible: { mc9l5x: "ftgm304" },
	inverted: {
		De3pzq: "fg3r6xk",
		sj55zd: "fonrgv7"
	},
	arrow: {
		B7ck84d: "f1ewtqcl",
		qhf8xq: "f1euv43f",
		Bj3rh1h: "f1bsuimh",
		rhnwrx: "f1s3jn22",
		Bdy53xb: "fv40uqz",
		De3pzq: "f1u2r49w",
		B2eet1l: "fqhgnl",
		Beyfa6y: "f17bz04i",
		Bz10aip: "f36o3x3",
		Bqenvij: "fzofk8q",
		a9b677: "f1wbx1ie",
		Ftih45: "f1wl9k8s",
		Br0sdwz: "f1aocrix",
		cmx5o7: "f1ljr5q2",
		susq4k: 0,
		Biibvgv: 0,
		Bicfajf: 0,
		qehafq: 0,
		Brs5u8j: "f155f1qt",
		Ccq8qp: "f9mhzq7",
		Baz25je: "fr6rhvx",
		Bcgcnre: 0,
		Bqjgrrk: 0,
		qa3bma: 0,
		y0oebl: 0,
		Biqmznv: 0,
		Bm6vgfq: 0,
		Bbv0w2i: 0,
		uvfttm: 0,
		eqrjj: 0,
		Bk5zm6e: 0,
		m598lv: 0,
		B4f6apu: 0,
		ydt019: 0,
		Bq4z7u6: 0,
		Bdkvgpv: 0,
		B0qfbqy: 0,
		kj8mxx: "f1kc0wz4",
		r59vdv: "fgq90dz",
		Bkw5xw4: "fq0y47f",
		hl6cv3: "f1pwrbz6",
		aea9ga: "f1hxxcvm",
		yayu3t: "fw8rgyo",
		Bhsv975: "f1wnzycx",
		rhl9o9: "f1730wal",
		B7gxrvb: "f1fy4ixr",
		B6q6orb: "fobkauc",
		B0lu1f8: "f16bqv1l"
	}
}, { d: [
	".fjseox{display:none;}",
	".f1ewtqcl{box-sizing:border-box;}",
	".f132xexn{max-width:240px;}",
	".f158kwzp{cursor:default;}",
	".fk6fouc{font-family:var(--fontFamilyBase);}",
	".fy9rknc{font-size:var(--fontSizeBase200);}",
	".fwrc4pm{line-height:var(--lineHeightBase200);}",
	".fokg9q4{overflow-wrap:break-word;}",
	[".ft85np5{border-radius:var(--borderRadiusMedium);}", { p: -1 }],
	[".f9ggezi{border:1px solid var(--colorTransparentStroke);}", { p: -2 }],
	[".f1bzqsji{padding:4px 11px 6px 11px;}", { p: -1 }],
	".fxugw4r{background-color:var(--colorNeutralBackground1);}",
	".f19n0e5{color:var(--colorNeutralForeground1);}",
	".fxeb0a7{filter:drop-shadow(0 0 2px var(--colorNeutralShadowAmbient)) drop-shadow(0 4px 8px var(--colorNeutralShadowKey));}",
	".ftgm304{display:block;}",
	".fg3r6xk{background-color:var(--colorNeutralBackgroundStatic);}",
	".fonrgv7{color:var(--colorNeutralForegroundStaticInverted);}",
	".f1euv43f{position:absolute;}",
	".f1bsuimh{z-index:-1;}",
	".f1s3jn22{--fui-positioning-arrow-height:8.484px;}",
	".fv40uqz{--fui-positioning-arrow-offset:-4.242px;}",
	".f1u2r49w{background-color:inherit;}",
	".fqhgnl{background-clip:content-box;}",
	".f17bz04i{border-bottom-left-radius:var(--borderRadiusSmall);}",
	".f36o3x3{transform:rotate(var(--fui-positioning-arrow-angle));}",
	".fzofk8q{height:var(--fui-positioning-arrow-height);}",
	".f1wbx1ie{width:var(--fui-positioning-arrow-height);}",
	".f1wl9k8s::before{content:\"\";}",
	".f1aocrix::before{display:block;}",
	".f1ljr5q2::before{background-color:inherit;}",
	[".f155f1qt::before{margin:-1px;}", { p: -1 }],
	".f9mhzq7::before{width:100%;}",
	".fr6rhvx::before{height:100%;}",
	[".f1kc0wz4::before{border:1px solid var(--colorTransparentStroke);}", { p: -2 }],
	".fgq90dz::before{border-bottom-left-radius:var(--borderRadiusSmall);}",
	".fq0y47f::before{clip-path:polygon(0% 0%, 100% 100%, 0% 100%);}",
	"[data-popper-placement^=\"top\"] .f1pwrbz6{bottom:var(--fui-positioning-arrow-offset);}",
	"[data-popper-placement^=\"top\"] .f1hxxcvm{--fui-positioning-arrow-angle:-45deg;}",
	"[data-popper-placement^=\"right\"] .fw8rgyo{left:var(--fui-positioning-arrow-offset);}",
	"[data-popper-placement^=\"right\"] .f1wnzycx{--fui-positioning-arrow-angle:45deg;}",
	"[data-popper-placement^=\"bottom\"] .f1730wal{top:var(--fui-positioning-arrow-offset);}",
	"[data-popper-placement^=\"bottom\"] .f1fy4ixr{--fui-positioning-arrow-angle:135deg;}",
	"[data-popper-placement^=\"left\"] .fobkauc{right:var(--fui-positioning-arrow-offset);}",
	"[data-popper-placement^=\"left\"] .f16bqv1l{--fui-positioning-arrow-angle:225deg;}"
] });
/**
* Apply styling to the Tooltip slots based on the state
*/
const useTooltipStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles$2();
	state.content.className = mergeClasses(tooltipClassNames.content, styles.root, state.appearance === "inverted" && styles.inverted, state.visible && styles.visible, state.content.className);
	state.arrowClassName = styles.arrow;
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-tooltip/lib/components/Tooltip/Tooltip.js
/**
* A tooltip provides light weight contextual information on top of its target element.
*/ const Tooltip = (props) => {
	const state = useTooltip_unstable(props);
	useTooltipStyles_unstable(state);
	useCustomStyleHook("useTooltipStyles_unstable")(state);
	return renderTooltip_unstable(state);
};
Tooltip.displayName = "Tooltip";
Tooltip.isFluentTriggerComponent = true;

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavContainer/useCarouselNavContainer.js
/**
* Create the state required to render CarouselNavContainer.
*
* The returned state can be modified with hooks such as useCarouselNavContainerStyles_unstable,
* before being passed to renderCarouselNavContainer_unstable.
*
* @param props - props from this instance of CarouselNavContainer
* @param ref - reference to root HTMLDivElement of CarouselNavContainer
*/ const useCarouselNavContainer_unstable = (props, ref) => {
	const { layout } = props;
	const next = optional(props.next, {
		defaultProps: { navType: "next" },
		elementType: CarouselButton,
		renderByDefault: true
	});
	const prev = optional(props.prev, {
		defaultProps: { navType: "prev" },
		elementType: CarouselButton,
		renderByDefault: true
	});
	const autoplay = optional(props.autoplay, {
		elementType: CarouselAutoplayButton,
		renderByDefault: !!props.autoplay || !!props.autoplayTooltip
	});
	const nextTooltip = optional(props.nextTooltip, {
		defaultProps: {},
		elementType: Tooltip,
		renderByDefault: false
	});
	const prevTooltip = optional(props.prevTooltip, {
		defaultProps: {},
		elementType: Tooltip,
		renderByDefault: false
	});
	const autoplayTooltip = optional(props.autoplayTooltip, {
		defaultProps: {},
		elementType: Tooltip,
		renderByDefault: false
	});
	return {
		layout,
		components: {
			root: "div",
			next: CarouselButton,
			prev: CarouselButton,
			autoplay: CarouselAutoplayButton,
			nextTooltip: Tooltip,
			prevTooltip: Tooltip,
			autoplayTooltip: Tooltip
		},
		root: always(getIntrinsicElementProps("div", {
			ref,
			...props
		}), { elementType: "div" }),
		next,
		prev,
		autoplay,
		nextTooltip,
		prevTooltip,
		autoplayTooltip
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavContainer/renderCarouselNavContainer.js
/**
* Render the final JSX of CarouselNavContainer
*/ const renderCarouselNavContainer_unstable = (state) => {
	assertSlots(state);
	return /* @__PURE__ */ jsxs(state.root, { children: [
		!state.autoplayTooltip && state.autoplay && /* @__PURE__ */ jsx(state.autoplay, {}),
		state.autoplayTooltip && state.autoplay && /* @__PURE__ */ jsx(state.autoplayTooltip, { children: /* @__PURE__ */ jsx(state.autoplay, {}) }),
		!state.prevTooltip && state.prev && /* @__PURE__ */ jsx(state.prev, {}),
		state.prevTooltip && state.prev && /* @__PURE__ */ jsx(state.prevTooltip, { children: /* @__PURE__ */ jsx(state.prev, {}) }),
		state.root.children,
		!state.nextTooltip && state.next && /* @__PURE__ */ jsx(state.next, {}),
		state.nextTooltip && state.next && /* @__PURE__ */ jsx(state.nextTooltip, { children: /* @__PURE__ */ jsx(state.next, {}) })
	] });
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavContainer/useCarouselNavContainerStyles.styles.js
const carouselNavContainerClassNames = {
	root: "fui-CarouselNavContainer",
	next: "fui-CarouselNavContainer__next",
	prev: "fui-CarouselNavContainer__prev",
	autoplay: "fui-CarouselNavContainer__autoplay",
	nextTooltip: "fui-CarouselNavContainer__nextTooltip",
	prevTooltip: "fui-CarouselNavContainer__prevTooltip",
	autoplayTooltip: "fui-CarouselNavContainer__autoplayTooltip"
};
/**
* Styles for the root slot
*/
var useStyles$1 = /* @__PURE__ */ __styles({
	root: {
		mc9l5x: "f22iagw",
		Beiy3e4: "f1063pyq",
		Brf1p80: "f4d9j23",
		a9b677: "fly5x3f",
		Bkecrkj: "f1aehjj5"
	},
	next: {},
	prev: {},
	autoplay: {},
	inline: { B6of3ja: "f1mevb6" },
	overlay: {
		qhf8xq: "f1euv43f",
		B5kzvoi: "f1bu4tuc",
		B7ck84d: "f1ewtqcl"
	},
	overlayWide: { B5kzvoi: "f1bu4tuc" },
	nextWide: { Frg6f3: ["fcgxt0o", "f1ujusj6"] },
	prevWide: { t21cq0: ["f1ujusj6", "fcgxt0o"] },
	nextOverlayWide: { t21cq0: ["fkujibs", "f199hnxi"] },
	prevOverlayWide: { Frg6f3: ["f199hnxi", "fkujibs"] },
	autoplayOverlayWide: { Frg6f3: ["f199hnxi", "fkujibs"] },
	expanded: {
		a9b677: "fly5x3f",
		Bqenvij: "f1l02sjl",
		Bt984gj: "fgs5rwf",
		Brf1p80: "f4d9j23",
		B5kzvoi: "f1yab3r1",
		c7y7m3: "f1ok8cdc",
		yx0ijg: "fcq6x80",
		v4amzz: "f1gy9d85"
	},
	nextOverlayExpanded: {
		qhf8xq: "f1euv43f",
		j35jbq: ["f8b87gs", "fedtrts"],
		Bhzewxz: "f1i1t8d1",
		Bz10aip: "f188r07x"
	},
	prevOverlayExpanded: {
		qhf8xq: "f1euv43f",
		oyh7mz: ["fedtrts", "f8b87gs"],
		Bhzewxz: "f1i1t8d1",
		Bz10aip: "f188r07x"
	},
	autoplayExpanded: {
		qhf8xq: "f1euv43f",
		B5kzvoi: "f49tsn4",
		oyh7mz: ["fedtrts", "f8b87gs"],
		jrapky: "f18zxyen"
	}
}, { d: [
	".f22iagw{display:flex;}",
	".f1063pyq{flex-direction:row;}",
	".f4d9j23{justify-content:center;}",
	".fly5x3f{width:100%;}",
	".f1aehjj5{pointer-events:none;}",
	".f1mevb6{margin-top:var(--spacingVerticalM);}",
	".f1euv43f{position:absolute;}",
	".f1bu4tuc{bottom:var(--spacingVerticalM);}",
	".f1ewtqcl{box-sizing:border-box;}",
	".fcgxt0o{margin-left:auto;}",
	".f1ujusj6{margin-right:auto;}",
	".fkujibs{margin-right:var(--spacingHorizontalM);}",
	".f199hnxi{margin-left:var(--spacingHorizontalM);}",
	".f1l02sjl{height:100%;}",
	".fgs5rwf{align-items:flex-end;}",
	".f1yab3r1{bottom:0;}",
	".f1ok8cdc>div{position:relative;}",
	".fcq6x80>div{bottom:var(--spacingVerticalL);}",
	".f1gy9d85>div{margin-bottom:0;}",
	".f8b87gs{right:var(--spacingHorizontalM);}",
	".fedtrts{left:var(--spacingHorizontalM);}",
	".f1i1t8d1{top:50%;}",
	".f188r07x{transform:translateY(-50%);}",
	".f49tsn4{bottom:-var(--spacingHorizontalXS);}",
	".f18zxyen{margin-bottom:var(--spacingVerticalM);}"
] });
/**
* Apply styling to the CarouselNavContainer slots based on the state
*/
const useCarouselNavContainerStyles_unstable = (state) => {
	"use no memo";
	const { layout } = state;
	const isOverlay = layout === "overlay" || layout === "overlay-wide" || layout === "overlay-expanded";
	const isWide = layout === "inline-wide" || layout === "overlay-wide";
	const styles = useStyles$1();
	state.root.className = mergeClasses(carouselNavContainerClassNames.root, styles.root, isOverlay ? styles.overlay : styles.inline, isOverlay && isWide && styles.overlayWide, layout === "overlay-expanded" && styles.expanded, state.root.className);
	if (state.next) state.next.className = mergeClasses(carouselNavContainerClassNames.next, styles.next, isWide && styles.nextWide, isWide && isOverlay && styles.nextOverlayWide, layout === "overlay-expanded" && styles.nextOverlayExpanded, state.next.className);
	if (state.prev) state.prev.className = mergeClasses(carouselNavContainerClassNames.prev, styles.prev, isWide && styles.prevWide, !state.autoplay && isWide && isOverlay && styles.prevOverlayWide, layout === "overlay-expanded" && styles.prevOverlayExpanded, state.prev.className);
	if (state.autoplay) state.autoplay.className = mergeClasses(carouselNavContainerClassNames.autoplay, styles.autoplay, layout === "overlay-expanded" && styles.autoplayExpanded, isWide && isOverlay && styles.autoplayOverlayWide, state.autoplay.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselNavContainer/CarouselNavContainer.js
/**
* CarouselNavContainer component - This container will provide multiple valid layout options for the underlying carousel controls
*/ const CarouselNavContainer = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselNavContainer_unstable(props, ref);
	useCarouselNavContainerStyles_unstable(state);
	useCustomStyleHook("useCarouselNavContainerStyles_unstable")(state);
	return renderCarouselNavContainer_unstable(state);
});
CarouselNavContainer.displayName = "CarouselNavContainer";

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselViewport/useCarouselViewport.js
/**
* Create the state required to render CarouselViewport.
*
* The returned state can be modified with hooks such as useCarouselViewportStyles_unstable,
* before being passed to renderCarouselViewport_unstable.
*
* @param props - props from this instance of CarouselViewport
* @param ref - reference to root HTMLDivElement of CarouselViewport
*/ const useCarouselViewport_unstable = (props, ref) => {
	const hasFocus = import_react.useRef(false);
	const hasMouse = import_react.useRef(false);
	const viewportRef = useCarouselContext_unstable((ctx) => ctx.viewportRef);
	const enableAutoplay = useCarouselContext_unstable((ctx) => ctx.enableAutoplay);
	const handleFocusCapture = import_react.useCallback(() => {
		hasFocus.current = true;
		enableAutoplay(false, true);
	}, [enableAutoplay]);
	const handleBlurCapture = import_react.useCallback((e) => {
		if (!e.currentTarget.contains(e.relatedTarget)) {
			hasFocus.current = false;
			if (!hasMouse.current) enableAutoplay(true, true);
		}
	}, [enableAutoplay]);
	const handleMouseEnter = import_react.useCallback(() => {
		hasMouse.current = true;
		enableAutoplay(false, true);
	}, [enableAutoplay]);
	const handleMouseLeave = import_react.useCallback(() => {
		hasMouse.current = false;
		if (!hasFocus.current) enableAutoplay(true, true);
	}, [enableAutoplay]);
	const onFocusCapture = mergeCallbacks(props.onFocusCapture, handleFocusCapture);
	const onBlurCapture = mergeCallbacks(props.onBlurCapture, handleBlurCapture);
	const onMouseEnter = mergeCallbacks(props.onMouseEnter, handleMouseEnter);
	const onMouseLeave = mergeCallbacks(props.onMouseLeave, handleMouseLeave);
	return {
		components: { root: "div" },
		root: always(getIntrinsicElementProps("div", {
			ref: useMergedRefs(ref, viewportRef),
			role: "presentation",
			draggable: true,
			...props,
			onFocusCapture,
			onBlurCapture,
			onMouseEnter,
			onMouseLeave
		}), { elementType: "div" })
	};
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselViewport/renderCarouselViewport.js
/**
* Render the final JSX of CarouselViewport
*/ const renderCarouselViewport_unstable = (state, contextValues) => {
	assertSlots(state);
	return /* @__PURE__ */ jsx(CarouselSliderContextProvider, {
		value: contextValues.carouselSlider,
		children: /* @__PURE__ */ jsx(state.root, {})
	});
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselViewport/useCarouselViewportStyles.styles.js
const carouselViewportClassNames = { root: "fui-CarouselViewport" };
/**
* Styles for the root slot
*/
var useStyles = /* @__PURE__ */ __styles({ root: {
	B2u0y6b: "f6dzj5z",
	a9b677: "f14z66ap"
} }, { d: [".f6dzj5z{max-width:100%;}", ".f14z66ap{width:auto;}"] });
/**
* Apply styling to the CarouselViewport slots based on the state
*/
const useCarouselViewportStyles_unstable = (state) => {
	"use no memo";
	const styles = useStyles();
	state.root.className = mergeClasses(carouselViewportClassNames.root, styles.root, state.root.className);
	return state;
};

//#endregion
//#region node_modules/@fluentui/react-carousel/lib/components/CarouselViewport/CarouselViewport.js
/**
* CarouselViewport component - TODO: add more docs
*/ const CarouselViewport = /* @__PURE__ */ import_react.forwardRef((props, ref) => {
	const state = useCarouselViewport_unstable(props, ref);
	useCarouselViewportStyles_unstable(state);
	useCustomStyleHook("useCarouselViewportStyles_unstable")(state);
	const context = useCarouselSliderContextValues_unstable(state);
	return renderCarouselViewport_unstable(state, context);
});
CarouselViewport.displayName = "CarouselViewport";

//#endregion
export { AnnounceProvider, ArrowDown, ArrowLeft, ArrowRight, ArrowUp, Backspace, ButtonContextProvider, Carousel, CarouselAutoplayButton, CarouselButton, CarouselCard, CarouselNav, CarouselNavButton, CarouselNavContainer, CarouselNavImageButton, CarouselProvider, CarouselSlider, CarouselViewport, CustomStyleHooksContext, CustomStyleHooksProvider, Delete, End, Enter, Escape, FOCUS_VISIBLE_ATTR, FOCUS_WITHIN_ATTR, GroupperMoveFocusActions, GroupperMoveFocusEvent, Home, IdPrefixProvider, KEYBOARD_NAV_ATTRIBUTE, KEYBORG_FOCUSIN, MoverKeys, MoverMoveFocusEvent, PageDown, PageUp, Portal, PortalMountNodeProvider, PositioningConfigurationProvider, Provider, RestorerTypes, SLOT_CLASS_NAME_PROP_SYMBOL, SLOT_ELEMENT_TYPE_SYMBOL, SLOT_RENDER_FUNCTION_SYMBOL, SSRProvider, Shift, Space, TABSTER_ATTRIBUTE_NAME, Tab, TabsterMoveFocusEventName, ThemeClassNameProvider, Tooltip, TooltipVisibilityProvider, __resetStyles, always, applyTriggerPropsToChildren, assertSlots, buttonClassNames, canUseDOM, carouselAutoplayButtonClassNames, carouselButtonClassNames, carouselCardClassNames, carouselClassNames, carouselContextDefaultValue, carouselNavButtonClassNames, carouselNavClassNames, carouselNavContainerClassNames, carouselNavImageButtonClassNames, carouselSliderClassNames, carouselViewportClassNames, createContext, createKeyborg, createTabsterWithConfig, defaultOptions$2 as defaultOptions, disposeKeyborg, disposeTabster, getIntrinsicElementProps, getModalizer, getNativeElementProps, getObservedElement, getParent, getPartitionedNativeProps, getReactElementRef, getRestorer, getTabsterAttribute, getTriggerChild, import_react, isHTMLElement, isSlot, jsx, jsxs, mergeArrowOffset, mergeCallbacks, optional, renderButton_unstable, renderCarouselAutoplayButton_unstable, renderCarouselButton_unstable, renderCarouselCard_unstable, renderCarouselNavButton_unstable, renderCarouselNavContainer_unstable, renderCarouselNavImageButton_unstable, renderCarouselNav_unstable, renderCarouselSlider_unstable, renderCarouselViewport_unstable, renderCarousel_unstable, renderPortal_unstable, renderTooltip_unstable, resetIdsForTests, resolvePositioningShorthand, resolveShorthand, slot_exports, toMountNodeProps, toggleButtonClassNames, tokens, tooltipClassNames, useARIAButtonProps, useAnnounce, useArrowNavigationGroup, useButtonStyles_unstable, useButton_unstable, useCarouselAutoplayButtonStyles_unstable, useCarouselAutoplayButton_unstable, useCarouselButtonStyles_unstable, useCarouselButton_unstable, useCarouselCardStyles_unstable, useCarouselCard_unstable, useCarouselContext_unstable, useCarouselNavButtonStyles_unstable, useCarouselNavButton_unstable, useCarouselNavContainerStyles_unstable, useCarouselNavContainer_unstable, useCarouselNavImageButtonStyles_unstable, useCarouselNavImageButton_unstable, useCarouselNavStyles_unstable, useCarouselNav_unstable, useCarouselSliderStyles_unstable, useCarouselSlider_unstable, useCarouselStyles_unstable, useCarouselViewportStyles_unstable, useCarouselViewport_unstable, useCarousel_unstable, useContextSelector, useControllableState, useCustomStyleHook, useEventCallback, useFluent, useFocusVisible, useFocusableGroup, useId, useIsNavigatingWithKeyboard, useIsSSR, useIsomorphicLayoutEffect, useKeyborgRef, useMergedRefs, usePortalMountNode$1 as usePortalMountNode, usePortal_unstable, usePositioning, useTabster, useTabsterAttributes, useThemeClassName, useToggleButtonStyles_unstable, useToggleButton_unstable, useToggleState, useTooltipStyles_unstable, useTooltipVisibility, useTooltip_unstable };
//# sourceMappingURL=lib-BzfiAYFf.js.map